/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.KenaiProjectsListRenderer;
import org.netbeans.modules.kenai.ui.NewKenaiProjectAction;
import org.netbeans.modules.kenai.ui.treelist.TreeListUI;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class KenaiSearchPanel
extends JPanel {
    private final JLabel noSearchResultsLabel = new JLabel(NbBundle.getMessage(KenaiSearchPanel.class, (String)"NoSearchResults.label.text"));
    private final JLabel noMatchingResultsLabel = new JLabel(NbBundle.getMessage(KenaiSearchPanel.class, (String)"NoResultsMatching.label.text"));
    private final JLabel badRequest = new JLabel(NbBundle.getMessage(KenaiSearchPanel.class, (String)"BadRequest.label.text"));
    private JPanel noSearchLabelPanel;
    private JPanel noMatchingLabelPanel;
    private JPanel badRequestPanel;
    private PanelType panelType;
    private ProgressHandle progressHandle;
    private boolean progressRunning;
    private boolean multiSelection;
    private KenaiProjectsListModel listModel;
    private JPanel createButtonPanel;
    private JButton createNewProjectButton;
    private JList kenaiProjectsList;
    private JLabel projectsLabel;
    private JScrollPane scrollPane;
    private JButton searchButton;
    private JPanel searchButtonPanel;
    private JLabel searchInfoLabel;
    private JLabel searchLabel;
    private JTextField searchTextField;

    public KenaiSearchPanel(PanelType panelType, boolean bl) {
        this.panelType = panelType;
        this.multiSelection = bl;
        this.initComponents();
        this.kenaiProjectsList.setUI(new TreeListUI());
        this.noSearchLabelPanel = this.createLabelPanel(this.noSearchResultsLabel);
        this.noMatchingLabelPanel = this.createLabelPanel(this.noMatchingResultsLabel);
        this.badRequestPanel = this.createLabelPanel(this.badRequest);
        this.remove(this.scrollPane);
        this.add("Center", this.noSearchLabelPanel);
        if (this.panelType == PanelType.BROWSE) {
            this.remove(this.createButtonPanel);
        }
        final ListSelectionModel listSelectionModel = this.kenaiProjectsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (listSelectionModel.isSelectionEmpty()) {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.FALSE);
                    } else {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.TRUE);
                    }
                }
            }
        });
    }

    public KenaiProject getSelectedProject() {
        KenaiProjectSearchInfo kenaiProjectSearchInfo = (KenaiProjectSearchInfo)this.kenaiProjectsList.getSelectedValue();
        return kenaiProjectSearchInfo != null ? kenaiProjectSearchInfo.kenaiProject : null;
    }

    public KenaiProjectSearchInfo getSelectedProjectSearchInfo() {
        KenaiProjectSearchInfo kenaiProjectSearchInfo = (KenaiProjectSearchInfo)this.kenaiProjectsList.getSelectedValue();
        return kenaiProjectSearchInfo != null ? kenaiProjectSearchInfo : null;
    }

    public KenaiProject[] getSelectedProjects() {
        Object[] objectArray = this.kenaiProjectsList.getSelectedValues();
        KenaiProject[] kenaiProjectArray = new KenaiProject[objectArray.length];
        int n = 0;
        for (Object object : objectArray) {
            kenaiProjectArray[n++] = ((KenaiProjectSearchInfo)object).kenaiProject;
        }
        return objectArray.length > 0 ? kenaiProjectArray : null;
    }

    private int getListSelMode() {
        if (!this.multiSelection) {
            return 0;
        }
        return 2;
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.kenaiProjectsList = new JList();
        this.searchButtonPanel = new JPanel();
        this.searchLabel = new JLabel();
        this.searchButton = new JButton();
        this.searchInfoLabel = new JLabel();
        this.projectsLabel = new JLabel();
        this.searchTextField = new JTextField();
        this.createButtonPanel = new JPanel();
        this.createNewProjectButton = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.setPreferredSize(new Dimension(700, 500));
        this.setLayout(new BorderLayout());
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.kenaiProjectsList.setSelectionMode(this.getListSelMode());
        this.kenaiProjectsList.setCellRenderer(new KenaiProjectsListRenderer2());
        this.scrollPane.setViewportView(this.kenaiProjectsList);
        this.kenaiProjectsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.kenaiProjectsList.AccessibleContext.accessibleName"));
        this.kenaiProjectsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.kenaiProjectsList.AccessibleContext.accessibleDescription"));
        this.add((Component)this.scrollPane, "Center");
        this.searchButtonPanel.setLayout(new GridBagLayout());
        this.searchLabel.setLabelFor(this.searchTextField);
        Mnemonics.setLocalizedText((JLabel)this.searchLabel, (String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.searchButtonPanel.add((Component)this.searchLabel, gridBagConstraints);
        this.searchLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchLabel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KenaiSearchPanel.this.searchButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.searchButtonPanel.add((Component)this.searchButton, gridBagConstraints);
        this.searchButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchButton.AccessibleContext.accessibleDescription"));
        this.searchInfoLabel.setText(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchInfoLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.searchButtonPanel.add((Component)this.searchInfoLabel, gridBagConstraints);
        this.searchInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchInfoLabel.AccessibleContext.accessibleDescription"));
        this.projectsLabel.setText(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.projectsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 4, 0);
        this.searchButtonPanel.add((Component)this.projectsLabel, gridBagConstraints);
        this.projectsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.projectsLabel.AccessibleContext.accessibleDescription"));
        this.searchTextField.setText(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchTextField.text"));
        this.searchTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KenaiSearchPanel.this.searchTextFieldActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.searchButtonPanel.add((Component)this.searchTextField, gridBagConstraints);
        this.searchTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchTextField.AccessibleContext.accessibleName"));
        this.searchTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchTextField.AccessibleContext.accessibleDescription"));
        this.add((Component)this.searchButtonPanel, "North");
        this.createButtonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.createNewProjectButton, (String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.createNewProjectButton.text"));
        this.createNewProjectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KenaiSearchPanel.this.createNewProjectButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.createButtonPanel.add((Component)this.createNewProjectButton, gridBagConstraints);
        this.createNewProjectButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.createNewProjectButton.AccessibleContext.accessibleDescription"));
        this.add((Component)this.createButtonPanel, "South");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.AccessibleContext.accessibleDescription"));
    }

    private void searchButtonActionPerformed(ActionEvent actionEvent) {
        this.invokeSearch();
    }

    private void searchTextFieldActionPerformed(ActionEvent actionEvent) {
        this.invokeSearch();
    }

    private void createNewProjectButtonActionPerformed(ActionEvent actionEvent) {
        new NewKenaiProjectAction().actionPerformed(actionEvent);
    }

    private void invokeSearch() {
        if (this.getListModel() != null) {
            this.getListModel().stopLoading();
        }
        this.searchButton.setEnabled(false);
        this.searchTextField.setEnabled(false);
        boolean bl = false;
        final JPanel jPanel = this.createProgressPanel();
        if (this.scrollPane.isShowing()) {
            this.remove(this.scrollPane);
            bl = true;
        } else if (this.noSearchLabelPanel != null && this.noSearchLabelPanel.isShowing()) {
            this.remove(this.noSearchLabelPanel);
            bl = true;
        } else if (this.noMatchingLabelPanel != null && this.noMatchingLabelPanel.isShowing()) {
            this.remove(this.noMatchingLabelPanel);
            bl = true;
        } else if (this.badRequestPanel != null && this.badRequestPanel.isShowing()) {
            this.remove(this.badRequestPanel);
            bl = true;
        }
        if (bl) {
            this.add("Center", jPanel);
            this.startProgress();
            this.revalidate();
            this.repaint();
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Iterator<KenaiProject> iterator = null;
                String string = KenaiSearchPanel.this.searchTextField.getText();
                try {
                    iterator = Kenai.getDefault().searchProjects(string).iterator();
                }
                catch (KenaiException kenaiException) {
                    if ("400 Bad Request".equals(kenaiException.getStatus())) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                KenaiSearchPanel.this.finishProgress();
                                KenaiSearchPanel.this.remove(jPanel);
                                KenaiSearchPanel.this.searchButton.setEnabled(true);
                                KenaiSearchPanel.this.searchTextField.setEnabled(true);
                                KenaiSearchPanel.this.add("Center", KenaiSearchPanel.this.badRequestPanel);
                                KenaiSearchPanel.this.revalidate();
                                KenaiSearchPanel.this.repaint();
                            }
                        });
                        return;
                    }
                    Exceptions.printStackTrace((Throwable)kenaiException);
                }
                if (iterator != null && iterator.hasNext()) {
                    final KenaiProjectsListModel kenaiProjectsListModel = new KenaiProjectsListModel(iterator, string);
                    KenaiSearchPanel.this.setListModel(kenaiProjectsListModel);
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            KenaiSearchPanel.this.kenaiProjectsList.setModel(kenaiProjectsListModel);
                            KenaiSearchPanel.this.finishProgress();
                            KenaiSearchPanel.this.remove(jPanel);
                            KenaiSearchPanel.this.searchButton.setEnabled(true);
                            KenaiSearchPanel.this.searchTextField.setEnabled(true);
                            KenaiSearchPanel.this.add("Center", KenaiSearchPanel.this.scrollPane);
                            KenaiSearchPanel.this.revalidate();
                            KenaiSearchPanel.this.repaint();
                        }
                    });
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            KenaiSearchPanel.this.finishProgress();
                            KenaiSearchPanel.this.remove(jPanel);
                            KenaiSearchPanel.this.searchButton.setEnabled(true);
                            KenaiSearchPanel.this.searchTextField.setEnabled(true);
                            KenaiSearchPanel.this.add("Center", KenaiSearchPanel.this.noMatchingLabelPanel);
                            KenaiSearchPanel.this.revalidate();
                            KenaiSearchPanel.this.repaint();
                        }
                    });
                }
            }
        });
    }

    private synchronized void setListModel(KenaiProjectsListModel kenaiProjectsListModel) {
        this.listModel = kenaiProjectsListModel;
    }

    private synchronized KenaiProjectsListModel getListModel() {
        return this.listModel;
    }

    private synchronized void startProgress() {
        if (!this.progressRunning && this.progressHandle != null) {
            this.progressHandle.start();
            this.progressRunning = true;
        }
    }

    private synchronized void finishProgress() {
        if (this.progressRunning && this.progressHandle != null) {
            this.progressHandle.finish();
            this.progressRunning = false;
        }
    }

    public void removeNotify() {
        super.removeNotify();
        KenaiProjectsListModel kenaiProjectsListModel = this.getListModel();
        if (kenaiProjectsListModel != null) {
            kenaiProjectsListModel.stopLoading();
        }
    }

    private JPanel createLabelPanel(JLabel jLabel) {
        JPanel jPanel = this.preparePanel();
        jLabel.setEnabled(false);
        jLabel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        return jPanel2;
    }

    private JPanel createProgressPanel() {
        JPanel jPanel = this.preparePanel();
        this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.progressLabel"));
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progressHandle);
        JLabel jLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)this.progressHandle);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 40, 0, 40);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 40, 20, 40);
        jPanel.add((Component)jComponent, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        return jPanel2;
    }

    private JPanel preparePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Color color = UIManager.getColor("window");
        jPanel.setBackground(color != null ? color : Color.WHITE);
        return jPanel;
    }

    public static class KenaiProjectSearchInfo {
        public KenaiProject kenaiProject;
        public KenaiFeature kenaiFeature;
        public String searchPattern;

        public KenaiProjectSearchInfo(KenaiProject kenaiProject, String string) {
            this.kenaiProject = kenaiProject;
            this.searchPattern = string;
            this.kenaiFeature = null;
        }

        public KenaiProjectSearchInfo(KenaiProject kenaiProject, KenaiFeature kenaiFeature, String string) {
            this.kenaiProject = kenaiProject;
            this.kenaiFeature = kenaiFeature;
            this.searchPattern = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KenaiProjectsListModel
    extends DefaultListModel
    implements Runnable {
        private Iterator<KenaiProject> projects;
        private String pattern;
        private boolean stopLoading;

        public KenaiProjectsListModel(Iterator<KenaiProject> iterator, String string) {
            this.projects = iterator;
            this.pattern = string;
            RequestProcessor.getDefault().post((Runnable)this);
        }

        @Override
        public void run() {
            if (this.projects != null) {
                while (this.projects.hasNext()) {
                    KenaiProject kenaiProject = this.projects.next();
                    if (PanelType.OPEN.equals((Object)KenaiSearchPanel.this.panelType)) {
                        this.addElementLater(new KenaiProjectSearchInfo(kenaiProject, this.pattern));
                    } else if (PanelType.BROWSE.equals((Object)KenaiSearchPanel.this.panelType)) {
                        try {
                            KenaiFeature[] kenaiFeatureArray;
                            for (KenaiFeature kenaiFeature : kenaiFeatureArray = kenaiProject.getFeatures(KenaiService.Type.SOURCE)) {
                                if (!"subversion".equals(kenaiFeature.getService()) && !"mercurial".equals(kenaiFeature.getService())) continue;
                                this.addElementLater(new KenaiProjectSearchInfo(kenaiProject, kenaiFeature, this.pattern));
                            }
                        }
                        catch (KenaiException kenaiException) {
                            Exceptions.printStackTrace((Throwable)kenaiException);
                        }
                    }
                    Thread.yield();
                    if (!this.stopLoading) continue;
                    return;
                }
            }
        }

        public synchronized void stopLoading() {
            this.stopLoading = true;
        }

        private void addElementLater(final KenaiProjectSearchInfo kenaiProjectSearchInfo) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    KenaiProjectsListModel.this.addElement(kenaiProjectSearchInfo);
                }
            });
        }
    }

    private class KenaiProjectsListRenderer2
    implements ListCellRenderer {
        private KenaiProjectsListRenderer2() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return new KenaiProjectsListRenderer(jList, object, n, bl, bl2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PanelType {
        OPEN,
        BROWSE;

    }
}

