/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Mutex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenFileOwnerQueryImpl
implements FileOwnerQueryImplementation {
    private Set<NbMavenProjectImpl> set;
    private final Object lock = new Object();
    private final Object cacheLock = new Object();
    private final List<ChangeListener> listeners;
    private Set<NbMavenProjectImpl> cachedProjects = null;
    private PropertyChangeListener projectListener;
    private static final Logger LOG = Logger.getLogger(MavenFileOwnerQueryImpl.class.getName());

    public MavenFileOwnerQueryImpl() {
        this.set = new HashSet<NbMavenProjectImpl>();
        this.listeners = new ArrayList<ChangeListener>();
        this.projectListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                    Object object = MavenFileOwnerQueryImpl.this.cacheLock;
                    synchronized (object) {
                        MavenFileOwnerQueryImpl.this.cachedProjects = null;
                    }
                }
            }
        };
    }

    public static MavenFileOwnerQueryImpl getInstance() {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(FileOwnerQueryImplementation.class));
        for (FileOwnerQueryImplementation fileOwnerQueryImplementation : result.allInstances()) {
            if (!(fileOwnerQueryImplementation instanceof MavenFileOwnerQueryImpl)) continue;
            return (MavenFileOwnerQueryImpl)fileOwnerQueryImplementation;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMavenProject(NbMavenProjectImpl nbMavenProjectImpl) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.set.contains(nbMavenProjectImpl)) {
                LOG.fine("Adding Maven project:" + nbMavenProjectImpl.getArtifactRelativeRepositoryPath());
                this.set.add(nbMavenProjectImpl);
                NbMavenProject.addPropertyChangeListener(nbMavenProjectImpl, this.projectListener);
            }
        }
        object = this.cacheLock;
        synchronized (object) {
            this.cachedProjects = null;
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMavenProject(NbMavenProjectImpl nbMavenProjectImpl) {
        Object object = this.lock;
        synchronized (object) {
            if (this.set.contains(nbMavenProjectImpl)) {
                LOG.fine("Removing Maven project:" + nbMavenProjectImpl.getArtifactRelativeRepositoryPath());
                this.set.remove(nbMavenProjectImpl);
                NbMavenProject.removePropertyChangeListener(nbMavenProjectImpl, this.projectListener);
            }
        }
        object = this.cacheLock;
        synchronized (object) {
            this.cachedProjects = null;
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>();
        Object object = this.listeners;
        synchronized (object) {
            arrayList.addAll(this.listeners);
        }
        object = new ChangeEvent(this);
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged((ChangeEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Project> getOpenedProjects() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet<Project>(this.set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<FileObject> getOpenedProjectRoots() {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        Object object = this.lock;
        synchronized (object) {
            for (NbMavenProjectImpl nbMavenProjectImpl : this.set) {
                hashSet.add(nbMavenProjectImpl.getProjectDirectory());
            }
        }
        return hashSet;
    }

    public Project getOwner(URI uRI) {
        LOG.finest("getOwner of uri=" + uRI);
        if (uRI.getScheme() != null && "file".equals(uRI.getScheme())) {
            File file = new File(uRI);
            return this.getOwner(file);
        }
        return null;
    }

    public Project getOwner(FileObject fileObject) {
        LOG.finest("getOwner of fileobject=" + fileObject);
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file != null) {
            return this.getOwner(file);
        }
        return null;
    }

    private Project getOwner(File file) {
        Object object;
        LOG.fine("Looking for owner of " + file.getAbsolutePath());
        boolean bl = false;
        String string = file.getName();
        File file2 = file.getParentFile();
        if (file2 != null && (object = file2.getParentFile()) != null && string.startsWith(((File)object).getName() + "-" + file2.getName())) {
            bl = true;
        }
        if (!bl) {
            LOG.fine(" exiting early, not from local repository.");
            return null;
        }
        object = this.getAllKnownProjects();
        Iterator iterator = object.iterator();
        String string2 = file.getAbsolutePath().replace('\\', '/');
        while (iterator.hasNext()) {
            NbMavenProjectImpl nbMavenProjectImpl = (NbMavenProjectImpl)iterator.next();
            String string3 = nbMavenProjectImpl.getArtifactRelativeRepositoryPath();
            LOG.finest("matching againts known project " + string3);
            if (string2.endsWith(string3)) {
                return nbMavenProjectImpl;
            }
            string3 = nbMavenProjectImpl.getTestArtifactRelativeRepositoryPath();
            LOG.finest("matching againts known project's test " + string3);
            if (!string2.endsWith(string3)) continue;
            return nbMavenProjectImpl;
        }
        return null;
    }

    private Set<NbMavenProjectImpl> getAllKnownProjects() {
        return (Set)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Set<NbMavenProjectImpl>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Set<NbMavenProjectImpl> run() {
                Object object = MavenFileOwnerQueryImpl.this.cacheLock;
                synchronized (object) {
                    ArrayList<NbMavenProjectImpl> arrayList;
                    HashSet<NbMavenProjectImpl> hashSet;
                    if (MavenFileOwnerQueryImpl.this.cachedProjects != null) {
                        return new HashSet<NbMavenProjectImpl>(MavenFileOwnerQueryImpl.this.cachedProjects);
                    }
                    Object object2 = MavenFileOwnerQueryImpl.this.lock;
                    synchronized (object2) {
                        hashSet = new HashSet<NbMavenProjectImpl>(MavenFileOwnerQueryImpl.this.set);
                        arrayList = new ArrayList<NbMavenProjectImpl>(MavenFileOwnerQueryImpl.this.set);
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        NbMavenProjectImpl nbMavenProjectImpl = (NbMavenProjectImpl)arrayList.get(i);
                        SubprojectProvider subprojectProvider = (SubprojectProvider)nbMavenProjectImpl.getLookup().lookup(SubprojectProvider.class);
                        if (subprojectProvider == null) continue;
                        Set set = subprojectProvider.getSubprojects();
                        set.removeAll(hashSet);
                        for (Project project : set) {
                            if (!(project instanceof NbMavenProjectImpl)) continue;
                            hashSet.add((NbMavenProjectImpl)project);
                            arrayList.add((NbMavenProjectImpl)project);
                        }
                    }
                    MavenFileOwnerQueryImpl.this.cachedProjects = hashSet;
                    return new HashSet<NbMavenProjectImpl>(MavenFileOwnerQueryImpl.this.cachedProjects);
                }
            }
        });
    }
}

