/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.maven.project.MavenProject;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class MavenFileEncodingQueryImpl
extends FileEncodingQueryImplementation {
    private NbMavenProjectImpl project;
    private static final String ENCODING_PARAM = "encoding";

    public MavenFileEncodingQueryImpl(NbMavenProjectImpl nbMavenProjectImpl) {
        this.project = nbMavenProjectImpl;
    }

    public Charset getEncoding(FileObject fileObject) {
        String string;
        Object object;
        MavenProject mavenProject = this.project.getOriginalMavenProject();
        if (mavenProject == null) {
            return Charset.defaultCharset();
        }
        String string2 = mavenProject.getProperties().getProperty("project.build.sourceEncoding");
        FileObject fileObject2 = FileUtilities.convertStringToFileObject(mavenProject.getBuild().getSourceDirectory());
        if (fileObject2 != null && (fileObject2.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject))) {
            object = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", ENCODING_PARAM, "compile");
            if (object != null && ((String)object).indexOf("${") == -1) {
                return Charset.forName((String)object);
            }
            if (string2 != null) {
                return Charset.forName(string2);
            }
        }
        if ((object = FileUtilities.convertStringToFileObject(mavenProject.getBuild().getTestSourceDirectory())) != null && (object.equals(fileObject) || FileUtil.isParentOf((FileObject)object, (FileObject)fileObject))) {
            string = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", ENCODING_PARAM, "testCompile");
            if (string != null && string.indexOf("${") == -1) {
                return Charset.forName(string);
            }
            if (string2 != null) {
                return Charset.forName(string2);
            }
        }
        try {
            if (this.isWithin(this.project.getResources(false), fileObject)) {
                string = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-resources-plugin", ENCODING_PARAM, "resources");
                if (string != null && string.indexOf("${") == -1) {
                    return Charset.forName(string);
                }
                if (string2 != null) {
                    return Charset.forName(string2);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
        try {
            if (this.isWithin(this.project.getResources(true), fileObject)) {
                string = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-resources-plugin", ENCODING_PARAM, "testResources");
                if (string != null && string.indexOf("${") == -1) {
                    return Charset.forName(string);
                }
                if (string2 != null) {
                    return Charset.forName(string2);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
        try {
            if (this.isWithin(new URI[]{this.project.getSiteDirectory()}, fileObject)) {
                string = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-site-plugin", "inputEncoding", "site");
                if (string != null && string.indexOf("${") == -1) {
                    return Charset.forName(string);
                }
                if (string2 != null) {
                    return Charset.forName(string2);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
        if (string2 != null) {
            return Charset.forName(string2);
        }
        return Charset.defaultCharset();
    }

    private boolean isWithin(URI[] uRIArray, FileObject fileObject) throws MalformedURLException {
        for (URI uRI : uRIArray) {
            FileObject fileObject2 = URLMapper.findFileObject((URL)uRI.toURL());
            if (fileObject2 == null || !fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return true;
        }
        return false;
    }
}

