/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class MavenBinaryForSourceQueryImpl
implements BinaryForSourceQueryImplementation {
    private NbMavenProjectImpl project;
    private HashMap<URL, Res> results;

    public MavenBinaryForSourceQueryImpl(NbMavenProjectImpl nbMavenProjectImpl) {
        this.project = nbMavenProjectImpl;
        this.results = new HashMap();
    }

    public BinaryForSourceQuery.Result findBinaryRoots(URL uRL) {
        if (this.results.containsKey(uRL)) {
            return this.results.get(uRL);
        }
        if ("file".equals(uRL.getProtocol())) {
            try {
                Res res = null;
                File file = new File(uRL.toURI());
                file = FileUtil.normalizeFile((File)file);
                MavenProject mavenProject = this.project.getOriginalMavenProject();
                String string = mavenProject.getBuild() != null ? mavenProject.getBuild().getSourceDirectory() : null;
                String string2 = mavenProject.getBuild() != null ? mavenProject.getBuild().getTestSourceDirectory() : null;
                File file2 = FileUtil.normalizeFile((File)new File(string));
                File file3 = FileUtil.normalizeFile((File)new File(string2));
                if (file2.equals(file) || file3.equals(file)) {
                    res = new Res(file3.equals(file), this.project);
                } else {
                    URI[] uRIArray;
                    for (URI uRI : uRIArray = this.project.getGeneratedSourceRoots()) {
                        File file4 = new File(uRI);
                        if (!(file4 = FileUtil.normalizeFile((File)file4)).equals(file)) continue;
                        res = new Res(false, this.project);
                        break;
                    }
                }
                if (res != null) {
                    this.results.put(uRL, res);
                }
                return res;
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
        }
        return null;
    }

    private static class Res
    implements BinaryForSourceQuery.Result {
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private NbMavenProjectImpl project;
        private boolean isTest;

        Res(boolean bl, NbMavenProjectImpl nbMavenProjectImpl) {
            this.isTest = bl;
            this.project = nbMavenProjectImpl;
        }

        public URL[] getRoots() {
            try {
                String string = this.isTest ? this.project.getOriginalMavenProject().getBuild().getTestOutputDirectory() : this.project.getOriginalMavenProject().getBuild().getOutputDirectory();
                File file = FileUtil.normalizeFile((File)new File(string));
                return new URL[]{file.toURI().toURL()};
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
                return new URL[0];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireChanged() {
            ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>();
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                arrayList.addAll(this.listeners);
            }
            for (ChangeListener changeListener : arrayList) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }
    }
}

