/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ModulesNode
extends AbstractNode {
    public ModulesNode(NbMavenProjectImpl nbMavenProjectImpl) {
        super((Children)new ModulesChildren(nbMavenProjectImpl));
        this.setName("Modules");
        this.setDisplayName(NbBundle.getMessage(ModulesNode.class, (String)"LBL_Modules"));
    }

    public Action[] getActions(boolean bl) {
        return new Action[0];
    }

    private Image getIcon(boolean bl) {
        Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/modules-badge.png", (boolean)true);
        return ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(bl), (Image)image, (int)8, (int)8);
    }

    public Image getIcon(int n) {
        return this.getIcon(false);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(true);
    }

    private static class OpenProjectAction
    extends AbstractAction
    implements Runnable {
        private NbMavenProjectImpl project;

        public OpenProjectAction(NbMavenProjectImpl nbMavenProjectImpl) {
            this.putValue("Name", NbBundle.getMessage(ModulesNode.class, (String)"BTN_Open_Project"));
            this.project = nbMavenProjectImpl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        public void run() {
            OpenProjects.getDefault().open(new Project[]{this.project}, false);
        }
    }

    private static class RemoveModuleAction
    extends AbstractAction {
        private NbMavenProjectImpl project;
        private NbMavenProjectImpl parent;

        public RemoveModuleAction(NbMavenProjectImpl nbMavenProjectImpl, NbMavenProjectImpl nbMavenProjectImpl2) {
            this.putValue("Name", NbBundle.getMessage(ModulesNode.class, (String)"BTN_Remove_Module"));
            this.project = nbMavenProjectImpl2;
            this.parent = nbMavenProjectImpl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ModulesNode.class, (String)"MSG_Remove_Module"), 0);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (object == NotifyDescriptor.YES_OPTION) {
                FileObject fileObject = FileUtil.toFileObject((File)this.parent.getPOMFile());
                ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

                    public void performOperation(POMModel pOMModel) {
                        List list = pOMModel.getProject().getModules();
                        if (list != null) {
                            for (String string : list) {
                                File file = new File(RemoveModuleAction.this.parent.getPOMFile().getParent(), string);
                                File file2 = FileUtil.normalizeFile((File)file);
                                FileObject fileObject = FileUtil.toFileObject((File)file2);
                                if (fileObject == null || !fileObject.equals(RemoveModuleAction.this.project.getProjectDirectory())) continue;
                                pOMModel.startTransaction();
                                pOMModel.getProject().removeModule(string);
                                break;
                            }
                        }
                    }
                };
                Utilities.performPOMModelOperations((FileObject)fileObject, Collections.singletonList(modelOperation));
                NbMavenProject.fireMavenProjectReload(this.project);
            }
        }
    }

    private static class ProjectFilterNode
    extends FilterNode {
        private NbMavenProjectImpl project;
        private NbMavenProjectImpl parent;

        ProjectFilterNode(NbMavenProjectImpl nbMavenProjectImpl, NbMavenProjectImpl nbMavenProjectImpl2, Node node, boolean bl) {
            super(node, (Children)(bl ? new ModulesChildren(nbMavenProjectImpl2) : FilterNode.Children.LEAF));
            this.project = nbMavenProjectImpl2;
            this.parent = nbMavenProjectImpl;
        }

        public Action[] getActions(boolean bl) {
            ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
            arrayList.add(new OpenProjectAction(this.project));
            arrayList.add(new RemoveModuleAction(this.parent, this.project));
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        public Action getPreferredAction() {
            return new OpenProjectAction(this.project);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ModulesChildren
    extends Children.Keys<NbMavenProjectImpl> {
        private NbMavenProjectImpl project;
        private PropertyChangeListener listener;

        ModulesChildren(NbMavenProjectImpl nbMavenProjectImpl) {
            this.project = nbMavenProjectImpl;
            this.listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                        ModulesChildren.this.loadModules();
                    }
                }
            };
        }

        public void addNotify() {
            this.setKeys(Collections.emptyList());
            this.loadModules();
            NbMavenProject.addPropertyChangeListener(this.project, this.listener);
        }

        public void removeNotify() {
            NbMavenProject.removePropertyChangeListener(this.project, this.listener);
            this.setKeys(Collections.emptyList());
        }

        protected Node[] createNodes(NbMavenProjectImpl nbMavenProjectImpl) {
            boolean bl = "pom".equals(nbMavenProjectImpl.getOriginalMavenProject().getPackaging());
            LogicalViewProvider logicalViewProvider = (LogicalViewProvider)nbMavenProjectImpl.getLookup().lookup(LogicalViewProvider.class);
            return new Node[]{new ProjectFilterNode(this.project, nbMavenProjectImpl, logicalViewProvider.createLogicalView(), bl)};
        }

        private void loadModules() {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ArrayList<NbMavenProjectImpl> arrayList = new ArrayList<NbMavenProjectImpl>();
                    File file = ModulesChildren.this.project.getOriginalMavenProject().getBasedir();
                    for (String string : ModulesChildren.this.project.getOriginalMavenProject().getModules()) {
                        File file2 = FileUtil.normalizeFile((File)new File(file, string));
                        FileObject fileObject = FileUtil.toFileObject((File)file2);
                        if (fileObject == null) continue;
                        try {
                            Project project = ProjectManager.getDefault().findProject(fileObject);
                            if (project == null || project.getLookup().lookup(NbMavenProjectImpl.class) == null) continue;
                            arrayList.add((NbMavenProjectImpl)project);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            illegalArgumentException.printStackTrace();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    ModulesChildren.this.setKeys(arrayList);
                }
            });
        }
    }
}

