/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import hidden.org.codehaus.plexus.util.FileUtils;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.CommonArtifactActions;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.dependencies.DependencyExcludeNodeVisitor;
import org.netbeans.modules.maven.dependencies.ExcludeDependencyPanel;
import org.netbeans.modules.maven.embedder.DependencyTreeFactory;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.NbArtifact;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.Exclusion;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.maven.nodes.InstallDocSourcePanel;
import org.netbeans.modules.maven.nodes.InstallPanel;
import org.netbeans.modules.maven.queries.MavenFileOwnerQueryImpl;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.EditAction;
import org.openide.actions.FindAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class DependencyNode
extends AbstractNode {
    private static final String JAVADOC_BADGE_ICON = "org/netbeans/modules/maven/DependencyJavadocIncluded.png";
    private static final String MISSING_BADGE_ICON = "org/netbeans/modules/maven/ResourceNotIncluded.gif";
    private static final String SOURCE_BADGE_ICON = "org/netbeans/modules/maven/DependencySrcIncluded.png";
    private Artifact art;
    private NbMavenProjectImpl project;
    private boolean longLiving;
    private PropertyChangeListener listener;
    private ChangeListener listener2;
    private static String toolTipJavadoc = "<img src=\"" + DependencyNode.class.getClassLoader().getResource("org/netbeans/modules/maven/DependencyJavadocIncluded.png") + "\">&nbsp;" + NbBundle.getMessage(DependencyNode.class, (String)"ICON_JavadocBadge");
    private static String toolTipSource = "<img src=\"" + DependencyNode.class.getClassLoader().getResource("org/netbeans/modules/maven/DependencySrcIncluded.png") + "\">&nbsp;" + NbBundle.getMessage(DependencyNode.class, (String)"ICON_SourceBadge");
    private static String toolTipMissing = "<img src=\"" + DependencyNode.class.getClassLoader().getResource("org/netbeans/modules/maven/ResourceNotIncluded.gif") + "\">&nbsp;" + NbBundle.getMessage(DependencyNode.class, (String)"ICON_MissingBadge");

    public static Children createChildren(Lookup lookup, boolean bl) {
        FileObject fileObject;
        if (!bl) {
            return Children.LEAF;
        }
        Artifact artifact = (Artifact)lookup.lookup(Artifact.class);
        if (artifact.getFile() != null && (fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)artifact.getFile()))) != null && FileUtil.isArchiveFile((FileObject)fileObject)) {
            return new JarContentFilterChildren(PackageView.createPackageView((SourceGroup)new ArtifactSourceGroup(artifact)));
        }
        return Children.LEAF;
    }

    public DependencyNode(Lookup lookup, boolean bl) {
        super(DependencyNode.createChildren(lookup, bl), lookup);
        this.project = (NbMavenProjectImpl)lookup.lookup(NbMavenProjectImpl.class);
        this.art = (Artifact)lookup.lookup(Artifact.class);
        assert (this.art != null);
        if (this.art.getFile() == null) {
            throw new IllegalStateException("Artifact " + this.art.getId() + " is not resolved and is missing the file association in local repository. Please report at issue #140253.");
        }
        this.longLiving = bl;
        if (this.longLiving) {
            this.listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                        DependencyNode.this.refreshNode();
                    }
                }
            };
            NbMavenProject.addPropertyChangeListener(this.project, WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.project.getProjectWatcher()));
            this.listener2 = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    DependencyNode.this.refreshNode();
                }
            };
            MavenFileOwnerQueryImpl.getInstance().addChangeListener(WeakListeners.change((ChangeListener)this.listener2, (Object)MavenFileOwnerQueryImpl.getInstance()));
        }
        this.setDisplayName(this.createName());
        this.setIconBase();
    }

    public boolean isTransitive() {
        List list = this.art.getDependencyTrail();
        return list != null && list.size() > 2;
    }

    private void setIconBase() {
        if (this.longLiving && this.isDependencyProjectOpen() && this.isTransitive()) {
            this.setIconBaseWithExtension("org/netbeans/modules/maven/TransitiveMaven2Icon.gif");
        } else if (this.longLiving && this.isDependencyProjectOpen()) {
            this.setIconBaseWithExtension("org/netbeans/modules/maven/Maven2Icon.gif");
        } else if (this.isTransitive()) {
            if (this.isAddedToCP()) {
                this.setIconBaseWithExtension("org/netbeans/modules/maven/TransitiveDependencyIcon.png");
            } else {
                this.setIconBaseWithExtension("org/netbeans/modules/maven/TransitiveArtifactIcon.png");
            }
        } else if (this.isAddedToCP()) {
            this.setIconBaseWithExtension("org/netbeans/modules/maven/DependencyIcon.png");
        } else {
            this.setIconBaseWithExtension("org/netbeans/modules/maven/ArtifactIcon.png");
        }
    }

    public String getShortDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><i>").append(NbBundle.getMessage(DependencyNode.class, (String)"DESC_Dep1")).append("</i><b> ").append(this.art.getGroupId()).append("</b><br><i>");
        stringBuffer.append(NbBundle.getMessage(DependencyNode.class, (String)"DESC_Dep2")).append("</i><b> ").append(this.art.getArtifactId()).append("</b><br><i>");
        stringBuffer.append(NbBundle.getMessage(DependencyNode.class, (String)"DESC_Dep3")).append("</i><b> ").append(this.art.getVersion()).append("</b><br><i>");
        stringBuffer.append(NbBundle.getMessage(DependencyNode.class, (String)"DESC_Dep4")).append("</i><b> ").append(this.art.getType()).append("</b><br>");
        if (this.art.getClassifier() != null) {
            stringBuffer.append("<i>").append(NbBundle.getMessage(DependencyNode.class, (String)"DESC_Dep5")).append("</i><b> ").append(this.art.getClassifier()).append("</b><br>");
        }
        return stringBuffer.toString();
    }

    private boolean isAddedToCP() {
        return this.art.getArtifactHandler().isAddedToClasspath();
    }

    boolean isDependencyProjectOpen() {
        if (Artifact.SCOPE_SYSTEM.equals(this.art.getScope())) {
            return false;
        }
        URI uRI = this.art.getFile().toURI();
        Project project = MavenFileOwnerQueryImpl.getInstance().getOwner(uRI);
        return project != null;
    }

    public void refreshNode() {
        Children children;
        this.setDisplayName(this.createName());
        this.setIconBase();
        this.fireIconChange();
        this.fireDisplayNameChange(null, this.getDisplayName());
        if (this.longLiving && Children.LEAF == this.getChildren() && (children = DependencyNode.createChildren(this.getLookup(), true)) != Children.LEAF) {
            this.setChildren(children);
        }
    }

    public String getHtmlDisplayName() {
        String string = "";
        if (ArtifactUtils.isSnapshot((String)this.art.getVersion()) && this.art.getVersion().indexOf("SNAPSHOT") < 0) {
            string = " <b>[" + this.art.getVersion() + "]</b>";
        }
        return "<html>" + this.getDisplayName() + string + ("compile".equalsIgnoreCase(this.art.getScope()) ? "" : "  <i>[" + this.art.getScope() + "]</i>") + "</html>";
    }

    private String createName() {
        if (this.art instanceof NbArtifact) {
            NbArtifact nbArtifact = (NbArtifact)this.art;
            if (nbArtifact.isFakedSystemDependency()) {
                return nbArtifact.getNonFakedFile().getName();
            }
            if (nbArtifact.isFakedPomDependency()) {
                return nbArtifact.getNonFakedFile().getName();
            }
        }
        return this.art.getFile().getName();
    }

    public Action[] getActions(boolean bl) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        if (this.isAddedToCP()) {
            InstallLocalArtifactAction installLocalArtifactAction = new InstallLocalArtifactAction();
            arrayList.add(installLocalArtifactAction);
            if (!this.isLocal()) {
                installLocalArtifactAction.setEnabled(true);
            }
        }
        if (this.isAddedToCP() && !this.hasJavadocInRepository()) {
            arrayList.add(new InstallLocalJavadocAction());
        }
        if (this.isAddedToCP() && !this.hasSourceInRepository()) {
            arrayList.add(new InstallLocalSourcesAction());
        }
        if (this.isTransitive()) {
            arrayList.add(new ExcludeTransitiveAction());
        } else {
            arrayList.add(new RemoveDependencyAction());
        }
        arrayList.add(null);
        arrayList.add(CommonArtifactActions.createViewArtifactDetails(this.art, this.project.getOriginalMavenProject().getRemoteArtifactRepositories()));
        arrayList.add(CommonArtifactActions.createFindUsages(this.art));
        arrayList.add(null);
        arrayList.add(CommonArtifactActions.createViewJavadocAction(this.art));
        arrayList.add(CommonArtifactActions.createViewProjectHomeAction(this.art, this.project.getOriginalMavenProject().getRemoteArtifactRepositories()));
        arrayList.add(CommonArtifactActions.createViewBugTrackerAction(this.art, this.project.getOriginalMavenProject().getRemoteArtifactRepositories()));
        arrayList.add(CommonArtifactActions.createSCMActions(this.art, this.project.getOriginalMavenProject().getRemoteArtifactRepositories()));
        arrayList.add(null);
        arrayList.add((Action)PropertiesAction.get(PropertiesAction.class));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public boolean canDestroy() {
        return true;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canCopy() {
        return false;
    }

    public boolean hasCustomizer() {
        return false;
    }

    public boolean isLocal() {
        NbArtifact nbArtifact;
        if (this.art instanceof NbArtifact && (nbArtifact = (NbArtifact)this.art).isFakedSystemDependency()) {
            return false;
        }
        return this.art.getFile().exists();
    }

    public boolean hasJavadocInRepository() {
        return !Artifact.SCOPE_SYSTEM.equals(this.art.getScope()) && this.getJavadocFile().exists();
    }

    public File getJavadocFile() {
        return DependencyNode.getJavadocFile(this.art.getFile());
    }

    private static File getJavadocFile(File file) {
        String string = file.getParentFile().getName();
        String string2 = file.getParentFile().getParentFile().getName();
        return new File(file.getParentFile(), string2 + "-" + string + "-javadoc.jar");
    }

    public File getSourceFile() {
        return DependencyNode.getSourceFile(this.art.getFile());
    }

    private static File getSourceFile(File file) {
        String string = file.getParentFile().getName();
        String string2 = file.getParentFile().getParentFile().getName();
        return new File(file.getParentFile(), string2 + "-" + string + "-sources.jar");
    }

    public boolean hasSourceInRepository() {
        if (Artifact.SCOPE_SYSTEM.equals(this.art.getScope())) {
            return false;
        }
        return this.getSourceFile().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void downloadJavadocSources(MavenEmbedder mavenEmbedder, ProgressContributor progressContributor, boolean bl) {
        progressContributor.start(2);
        if (Artifact.SCOPE_SYSTEM.equals(this.art.getScope())) {
            progressContributor.finish();
            return;
        }
        try {
            if (bl) {
                Artifact artifact = this.project.getEmbedder().createArtifactWithClassifier(this.art.getGroupId(), this.art.getArtifactId(), this.art.getVersion(), this.art.getType(), "javadoc");
                progressContributor.progress(NbBundle.getMessage(DependencyNode.class, (String)"MSG_Checking_Javadoc", (Object)this.art.getId()), 1);
                mavenEmbedder.resolve(artifact, this.project.getOriginalMavenProject().getRemoteArtifactRepositories(), this.project.getEmbedder().getLocalRepository());
            } else {
                Artifact artifact = this.project.getEmbedder().createArtifactWithClassifier(this.art.getGroupId(), this.art.getArtifactId(), this.art.getVersion(), this.art.getType(), "sources");
                progressContributor.progress(NbBundle.getMessage(DependencyNode.class, (String)"MSG_Checking_Sources", (Object)this.art.getId()), 1);
                mavenEmbedder.resolve(artifact, this.project.getOriginalMavenProject().getRemoteArtifactRepositories(), this.project.getEmbedder().getLocalRepository());
            }
        }
        catch (ArtifactNotFoundException artifactNotFoundException) {
        }
        catch (ArtifactResolutionException artifactResolutionException) {
        }
        finally {
            progressContributor.finish();
        }
        this.refreshNode();
    }

    public Image getIcon(int n) {
        Image image = super.getIcon(n);
        if (this.isLocal()) {
            Image image2;
            if (this.hasJavadocInRepository()) {
                image2 = ImageUtilities.loadImage((String)JAVADOC_BADGE_ICON);
                image2 = ImageUtilities.addToolTipToImage((Image)image2, (String)toolTipJavadoc);
                image = ImageUtilities.mergeImages((Image)image, (Image)image2, (int)12, (int)0);
            }
            if (this.hasSourceInRepository()) {
                image2 = ImageUtilities.loadImage((String)SOURCE_BADGE_ICON);
                image2 = ImageUtilities.addToolTipToImage((Image)image2, (String)toolTipSource);
                image = ImageUtilities.mergeImages((Image)image, (Image)image2, (int)12, (int)8);
            }
            return image;
        }
        Image image3 = ImageUtilities.loadImage((String)MISSING_BADGE_ICON);
        image3 = ImageUtilities.addToolTipToImage((Image)image3, (String)toolTipMissing);
        return ImageUtilities.mergeImages((Image)image, (Image)image3, (int)0, (int)0);
    }

    public Image getOpenedIcon(int n) {
        Image image = super.getOpenedIcon(n);
        if (this.isLocal()) {
            Image image2;
            if (this.hasJavadocInRepository()) {
                image2 = ImageUtilities.loadImage((String)JAVADOC_BADGE_ICON);
                image2 = ImageUtilities.addToolTipToImage((Image)image2, (String)toolTipJavadoc);
                image = ImageUtilities.mergeImages((Image)image, (Image)image2, (int)12, (int)0);
            }
            if (this.hasSourceInRepository()) {
                image2 = ImageUtilities.loadImage((String)SOURCE_BADGE_ICON);
                image2 = ImageUtilities.addToolTipToImage((Image)image2, (String)toolTipSource);
                image = ImageUtilities.mergeImages((Image)image, (Image)image2, (int)12, (int)8);
            }
            return image;
        }
        Image image3 = ImageUtilities.loadImage((String)MISSING_BADGE_ICON);
        image3 = ImageUtilities.addToolTipToImage((Image)image3, (String)toolTipMissing);
        return ImageUtilities.mergeImages((Image)image, (Image)image3, (int)0, (int)0);
    }

    public Component getCustomizer() {
        return null;
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        try {
            PropertySupport.Reflection reflection = new PropertySupport.Reflection((Object)this.art, String.class, "getArtifactId", null);
            reflection.setName("artifactId");
            reflection.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Artifact"));
            reflection.setShortDescription("");
            PropertySupport.Reflection reflection2 = new PropertySupport.Reflection((Object)this.art, String.class, "getGroupId", null);
            reflection2.setName("groupId");
            reflection2.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Group"));
            reflection2.setShortDescription("");
            PropertySupport.Reflection reflection3 = new PropertySupport.Reflection((Object)this.art, String.class, "getVersion", null);
            reflection3.setName("version");
            reflection3.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Version"));
            reflection3.setShortDescription(NbBundle.getMessage(DependencyNode.class, (String)"HINT_Version"));
            PropertySupport.Reflection reflection4 = new PropertySupport.Reflection((Object)this.art, String.class, "getType", null);
            reflection4.setName("type");
            reflection4.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Type"));
            PropertySupport.Reflection reflection5 = new PropertySupport.Reflection((Object)this.art, String.class, "getScope", null);
            reflection5.setName("scope");
            reflection5.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Scope"));
            PropertySupport.Reflection reflection6 = new PropertySupport.Reflection((Object)this.art, String.class, "getClassifier", null);
            reflection6.setName("classifier");
            reflection6.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Classifier"));
            PropertySupport.Reflection reflection7 = new PropertySupport.Reflection((Object)this, Boolean.TYPE, "hasJavadocInRepository", null);
            reflection7.setName("javadoc");
            reflection7.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Javadoc_Locally"));
            PropertySupport.Reflection reflection8 = new PropertySupport.Reflection((Object)this, Boolean.TYPE, "hasSourceInRepository", null);
            reflection8.setName("sources");
            reflection8.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Sources_Locally"));
            PropertySupport.Reflection reflection9 = new PropertySupport.Reflection((Object)this, Boolean.TYPE, "isTransitive", null);
            reflection9.setName("transitive");
            reflection9.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Transitive"));
            set.put(new Node.Property[]{reflection, reflection2, reflection3, reflection4, reflection5, reflection6, reflection9, reflection7, reflection8});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return sheet;
    }

    private static class JarFilterNode
    extends FilterNode {
        JarFilterNode(Node node) {
            super(node, (Children)(FilterNode.Children.LEAF == node.getChildren() ? FilterNode.Children.LEAF : new JarContentFilterChildren(node)));
        }

        public Action[] getActions(boolean bl) {
            DataObject dataObject = (DataObject)this.getOriginal().getLookup().lookup(DataObject.class);
            ArrayList<Action> arrayList = new ArrayList<Action>();
            Action[] actionArray = super.getActions(false);
            boolean bl2 = false;
            for (int i = 0; i < actionArray.length; ++i) {
                if ((actionArray[i] instanceof OpenAction || actionArray[i] instanceof EditAction) && dataObject != null && !dataObject.getClass().getName().contains("ClassDataObject")) {
                    arrayList.add(actionArray[i]);
                    bl2 = true;
                }
                if (dataObject == null || !dataObject.getPrimaryFile().isFolder() || !(actionArray[i] instanceof FindAction)) continue;
                arrayList.add(actionArray[i]);
            }
            if (!bl2) {
                arrayList.add(new OpenSrcAction(false));
            }
            arrayList.add(new OpenSrcAction(true));
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        public Action getPreferredAction() {
            return new OpenSrcAction(false);
        }

        private class OpenSrcAction
        extends AbstractAction {
            private boolean javadoc;

            private OpenSrcAction(boolean bl) {
                this.javadoc = bl;
                if (bl) {
                    this.putValue("Name", NbBundle.getMessage(DependencyNode.class, (String)"BTN_View_Javadoc"));
                } else {
                    this.putValue("Name", NbBundle.getMessage(DependencyNode.class, (String)"BTN_View_Source"));
                }
            }

            public void actionPerformed(ActionEvent actionEvent) {
                DataObject dataObject = (DataObject)JarFilterNode.this.getOriginal().getLookup().lookup(DataObject.class);
                if (dataObject != null && (this.javadoc || !dataObject.getPrimaryFile().isFolder())) {
                    try {
                        FileObject fileObject = dataObject.getPrimaryFile();
                        FileObject fileObject2 = FileUtil.getArchiveFile((FileObject)fileObject);
                        FileObject fileObject3 = FileUtil.getArchiveRoot((FileObject)fileObject2);
                        String string = FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject);
                        if (string.endsWith(".class")) {
                            string = string.replaceAll("class$", this.javadoc ? "html" : "java");
                        }
                        if (this.javadoc) {
                            URL uRL;
                            JavadocForBinaryQuery.Result result = JavadocForBinaryQuery.findJavadoc((URL)fileObject3.getURL());
                            if (fileObject.isFolder()) {
                                string = string + "/package-summary.html";
                            }
                            if ((uRL = this.findJavadoc(string, result.getRoots())) != null) {
                                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
                            } else {
                                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DependencyNode.class, (String)"ERR_No_Javadoc_Found", (Object)fileObject.getPath()));
                            }
                            return;
                        }
                        SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)fileObject3.getURL());
                        for (FileObject fileObject4 : result.getRoots()) {
                            DataObject dataObject2;
                            FileObject fileObject5 = fileObject4.getFileObject(string);
                            if (fileObject5 == null || !this.tryOpen(dataObject2 = DataObject.find((FileObject)fileObject5))) continue;
                            return;
                        }
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                    }
                    this.tryOpen(dataObject);
                }
            }

            URL findJavadoc(String string, URL[] uRLArray) {
                for (int i = 0; i < uRLArray.length; ++i) {
                    String string2 = uRLArray[i].toExternalForm();
                    if (!string2.endsWith("/")) {
                        string2 = string2 + "/";
                    }
                    try {
                        URL uRL = new URL(string2 + string);
                        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                        if (fileObject == null) continue;
                        return uRL;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                return null;
            }

            private boolean tryOpen(DataObject dataObject) {
                EditCookie editCookie = (EditCookie)dataObject.getLookup().lookup(EditCookie.class);
                if (editCookie != null) {
                    editCookie.edit();
                    return true;
                }
                OpenCookie openCookie = (OpenCookie)dataObject.getLookup().lookup(OpenCookie.class);
                if (openCookie != null) {
                    openCookie.open();
                    return true;
                }
                return false;
            }
        }
    }

    private static class JarContentFilterChildren
    extends FilterNode.Children {
        JarContentFilterChildren(Node node) {
            super(node);
        }

        protected Node copyNode(Node node) {
            return new JarFilterNode(node);
        }
    }

    private static class ArtifactSourceGroup
    implements SourceGroup {
        private Artifact art;

        public ArtifactSourceGroup(Artifact artifact) {
            this.art = artifact;
        }

        public FileObject getRootFolder() {
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.art.getFile()));
            if (fileObject != null) {
                return FileUtil.getArchiveRoot((FileObject)fileObject);
            }
            return null;
        }

        public String getName() {
            return this.art.getId();
        }

        public String getDisplayName() {
            return this.art.getId();
        }

        public Icon getIcon(boolean bl) {
            return null;
        }

        public boolean contains(FileObject fileObject) throws IllegalArgumentException {
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }
    }

    private class InstallLocalSourcesAction
    extends AbstractAction
    implements Runnable {
        private File source;

        public InstallLocalSourcesAction() {
            this.putValue("Name", NbBundle.getMessage(DependencyNode.class, (String)"BTN_Add_sources"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.source = InstallDocSourcePanel.showInstallDialog(false);
            if (this.source != null) {
                RequestProcessor.getDefault().post((Runnable)this);
            }
        }

        public void run() {
            File file = DependencyNode.this.getSourceFile();
            try {
                FileUtils.copyFile((File)this.source, (File)file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                file.delete();
            }
            DependencyNode.this.refreshNode();
        }
    }

    private class InstallLocalJavadocAction
    extends AbstractAction
    implements Runnable {
        private File source;

        public InstallLocalJavadocAction() {
            this.putValue("Name", NbBundle.getMessage(DependencyNode.class, (String)"BTN_Add_javadoc"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.source = InstallDocSourcePanel.showInstallDialog(true);
            if (this.source != null) {
                RequestProcessor.getDefault().post((Runnable)this);
            }
        }

        public void run() {
            File file = DependencyNode.this.getJavadocFile();
            try {
                FileUtils.copyFile((File)this.source, (File)file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                file.delete();
            }
            DependencyNode.this.refreshNode();
        }
    }

    private class InstallLocalArtifactAction
    extends AbstractAction {
        public InstallLocalArtifactAction() {
            this.putValue("Name", NbBundle.getMessage(DependencyNode.class, (String)"BTN_Manually_install"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = InstallPanel.showInstallDialog(DependencyNode.this.art);
            if (file != null) {
                InstallPanel.runInstallGoal(DependencyNode.this.project, file, DependencyNode.this.art);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExcludeTransitiveAction
    extends AbstractAction {
        public ExcludeTransitiveAction() {
            this.putValue("Name", NbBundle.getMessage(DependencyNode.class, (String)"BTN_Exclude_Dependency"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void run() {
                    void var4_9;
                    org.apache.maven.shared.dependency.tree.DependencyNode dependencyNode = DependencyTreeFactory.createDependencyTree((MavenProject)DependencyNode.this.project.getOriginalMavenProject(), (MavenEmbedder)EmbedderFactory.getOnlineEmbedder(), (String)Artifact.SCOPE_TEST);
                    DependencyExcludeNodeVisitor dependencyExcludeNodeVisitor = new DependencyExcludeNodeVisitor(DependencyNode.this.art.getGroupId(), DependencyNode.this.art.getArtifactId(), DependencyNode.this.art.getType());
                    dependencyNode.accept((DependencyNodeVisitor)dependencyExcludeNodeVisitor);
                    Set<org.apache.maven.shared.dependency.tree.DependencyNode> set = dependencyExcludeNodeVisitor.getDirectDependencies();
                    if (set.size() > 1) {
                        ExcludeDependencyPanel excludeDependencyPanel = new ExcludeDependencyPanel(DependencyNode.this.project.getOriginalMavenProject(), DependencyNode.this.art, set, dependencyNode);
                        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)excludeDependencyPanel, NbBundle.getBundle(DependencyNode.class).getString("TIT_Exclude"));
                        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                        if (object != DialogDescriptor.OK_OPTION) return;
                        Collection collection = excludeDependencyPanel.getDependencyExcludes().get(DependencyNode.this.art);
                    } else {
                        Set<org.apache.maven.shared.dependency.tree.DependencyNode> set2 = set;
                    }
                    ExcludeTransitiveAction.this.runModifyExclusions(DependencyNode.this.art, (Collection)var4_9);
                }
            });
        }

        private void runModifyExclusions(final Artifact artifact, final Collection<org.apache.maven.shared.dependency.tree.DependencyNode> collection) {
            ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel pOMModel) {
                    for (org.apache.maven.shared.dependency.tree.DependencyNode dependencyNode : collection) {
                        Exclusion exclusion;
                        Artifact artifact2 = dependencyNode.getArtifact();
                        Dependency dependency = pOMModel.getProject().findDependencyById(artifact2.getGroupId(), artifact2.getArtifactId(), null);
                        if (dependency == null) {
                            org.apache.maven.model.Profile profile2;
                            exclusion = new ArrayList();
                            for (org.apache.maven.model.Profile profile2 : DependencyNode.this.project.getOriginalMavenProject().getActiveProfiles()) {
                                exclusion.add(profile2.getId());
                            }
                            profile2 = exclusion.iterator();
                            while (profile2.hasNext()) {
                                String string = (String)profile2.next();
                                Profile profile3 = pOMModel.getProject().findProfileById(string);
                                if (profile3 == null || (dependency = profile3.findDependencyById(artifact2.getGroupId(), artifact2.getArtifactId(), null)) == null) continue;
                                break;
                            }
                        }
                        if (dependency == null) {
                            dependency = pOMModel.getFactory().createDependency();
                            dependency.setArtifactId(artifact2.getArtifactId());
                            dependency.setGroupId(artifact2.getGroupId());
                            dependency.setType(artifact2.getType());
                            dependency.setVersion(artifact2.getVersion());
                            pOMModel.getProject().addDependency(dependency);
                        }
                        if ((exclusion = dependency.findExclusionById(artifact.getGroupId(), artifact.getArtifactId())) != null) continue;
                        Exclusion exclusion2 = pOMModel.getFactory().createExclusion();
                        exclusion2.setArtifactId(artifact.getArtifactId());
                        exclusion2.setGroupId(artifact.getGroupId());
                        dependency.addExclusion(exclusion2);
                    }
                }
            };
            FileObject fileObject = FileUtil.toFileObject((File)DependencyNode.this.project.getPOMFile());
            Utilities.performPOMModelOperations((FileObject)fileObject, Collections.singletonList(modelOperation));
        }
    }

    private class RemoveDependencyAction
    extends AbstractAction {
        public RemoveDependencyAction() {
            this.putValue("Name", NbBundle.getMessage(DependencyNode.class, (String)"BTN_Remove_Dependency"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            org.apache.maven.model.Dependency dependency2;
            MavenProject mavenProject;
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DependencyNode.class, (String)"MSG_Remove_Dependency", (Object)(DependencyNode.this.art.getGroupId() + ":" + DependencyNode.this.art.getArtifactId())), NbBundle.getMessage(DependencyNode.class, (String)"TIT_Remove_Dependency"));
            confirmation.setOptionType(0);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (object != NotifyDescriptor.YES_OPTION) {
                return;
            }
            boolean bl = false;
            for (mavenProject = DependencyNode.this.project.getOriginalMavenProject(); mavenProject != null; mavenProject = mavenProject.getParent()) {
                if (mavenProject.getDependencies() != null) {
                    for (org.apache.maven.model.Dependency dependency2 : mavenProject.getDependencies()) {
                        if (!DependencyNode.this.art.getArtifactId().equals(dependency2.getArtifactId()) || !DependencyNode.this.art.getGroupId().equals(dependency2.getGroupId())) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) break;
            }
            if (mavenProject == null) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DependencyNode.class, (String)"ERR_Cannot_Locate_Dep"));
                return;
            }
            if (mavenProject != DependencyNode.this.project.getOriginalMavenProject()) {
                confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DependencyNode.class, (String)"MSG_Located_In_Parent"), NbBundle.getMessage(DependencyNode.class, (String)"TIT_Located_In_Parent"));
                confirmation.setOptionType(0);
                object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (object != NotifyDescriptor.YES_OPTION) {
                    return;
                }
            }
            ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel pOMModel) {
                    Dependency dependency = pOMModel.getProject().findDependencyById(DependencyNode.this.art.getGroupId(), DependencyNode.this.art.getArtifactId(), null);
                    if (dependency != null) {
                        pOMModel.getProject().removeDependency(dependency);
                    }
                }
            };
            dependency2 = FileUtil.toFileObject((File)DependencyNode.this.project.getPOMFile());
            Utilities.performPOMModelOperations((FileObject)dependency2, Collections.singletonList(modelOperation));
        }
    }
}

