/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharConversionException;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.newproject.ArchetypeWizardUtils;
import org.netbeans.modules.maven.newproject.BasicPanelVisual;
import org.netbeans.modules.maven.newproject.EAWizardPanel;
import org.netbeans.modules.maven.newproject.ProjectInfo;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public final class EAVisualPanel
extends JPanel
implements DocumentListener {
    private static final String ERROR_MSG = "WizardPanel_errorMessage";
    private EAWizardPanel panel;
    private Color origEarC;
    private Color origWebC;
    private Color origEjbC;
    private JCheckBox chkEjb;
    private JCheckBox chkWeb;
    private JComboBox cmbEEVersion;
    private JLabel lblEEVersion;
    private JLabel lblEar;
    private JTextField tfEar;
    private JTextField tfEjb;
    private JTextField tfWeb;

    public EAVisualPanel(EAWizardPanel eAWizardPanel) {
        this.panel = eAWizardPanel;
        this.initComponents();
        this.origEarC = this.tfEar.getForeground();
        this.origEjbC = this.tfEjb.getForeground();
        this.origWebC = this.tfWeb.getForeground();
        this.tfEar.getDocument().addDocumentListener(this);
        this.tfEjb.getDocument().addDocumentListener(this);
        this.tfWeb.getDocument().addDocumentListener(this);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"LBL_EESettings"));
    }

    public String getName() {
        return NbBundle.getMessage(EAWizardPanel.class, (String)"LBL_EESettings");
    }

    void readSettings(WizardDescriptor wizardDescriptor) {
        this.fillTextFields(wizardDescriptor);
    }

    void storeSettings(WizardDescriptor wizardDescriptor) {
        String string;
        int n = Math.max(this.cmbEEVersion.getSelectedIndex(), 0);
        File file = (File)wizardDescriptor.getProperty("projdir");
        String string2 = this.tfEar.getText().trim();
        wizardDescriptor.putProperty("ear_projdir", (Object)new File(file, string2));
        ProjectInfo projectInfo = new ProjectInfo();
        projectInfo.groupId = (String)wizardDescriptor.getProperty("groupId");
        projectInfo.artifactId = string2;
        projectInfo.version = (String)wizardDescriptor.getProperty("version");
        wizardDescriptor.putProperty("ear_versionInfo", (Object)projectInfo);
        wizardDescriptor.putProperty("ear_archetype", (Object)ArchetypeWizardUtils.EAR_ARCHS[n]);
        if (this.chkEjb.isSelected()) {
            string = this.tfEjb.getText().trim();
            wizardDescriptor.putProperty("ejb_projdir", (Object)new File(file, string));
            projectInfo = new ProjectInfo();
            projectInfo.groupId = (String)wizardDescriptor.getProperty("groupId");
            projectInfo.artifactId = string;
            projectInfo.version = (String)wizardDescriptor.getProperty("version");
            wizardDescriptor.putProperty("ejb_versionInfo", (Object)projectInfo);
            wizardDescriptor.putProperty("ejb_archetype", (Object)ArchetypeWizardUtils.EJB_ARCHS[n]);
        } else {
            wizardDescriptor.putProperty("ejb_projdir", null);
            wizardDescriptor.putProperty("ejb_versionInfo", null);
            wizardDescriptor.putProperty("ejb_archetype", null);
        }
        if (this.chkWeb.isSelected()) {
            string = this.tfWeb.getText().trim();
            wizardDescriptor.putProperty("web_projdir", (Object)new File(file, string));
            projectInfo = new ProjectInfo();
            projectInfo.groupId = (String)wizardDescriptor.getProperty("groupId");
            projectInfo.artifactId = string;
            projectInfo.version = (String)wizardDescriptor.getProperty("version");
            wizardDescriptor.putProperty("web_versionInfo", (Object)projectInfo);
            wizardDescriptor.putProperty("web_archetype", (Object)ArchetypeWizardUtils.WEB_APP_ARCHS[n]);
        } else {
            wizardDescriptor.putProperty("web_projdir", null);
            wizardDescriptor.putProperty("web_versionInfo", null);
            wizardDescriptor.putProperty("web_archetype", null);
        }
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        String string;
        this.tfEar.setForeground(this.origEarC);
        this.tfEjb.setForeground(this.origEjbC);
        this.tfWeb.setForeground(this.origWebC);
        String string2 = this.tfEar.getText();
        if (!EAVisualPanel.validateProjDir(string2, wizardDescriptor) || !EAVisualPanel.validateCoordinate(string2, wizardDescriptor) || BasicPanelVisual.containsMultiByte(string2, wizardDescriptor)) {
            this.tfEar.setForeground(Color.RED);
            return false;
        }
        if (this.chkEjb.isSelected() && (!EAVisualPanel.validateProjDir(string = this.tfEjb.getText(), wizardDescriptor) || !EAVisualPanel.validateCoordinate(string, wizardDescriptor) || BasicPanelVisual.containsMultiByte(string, wizardDescriptor))) {
            this.tfEjb.setForeground(Color.RED);
            return false;
        }
        if (this.chkWeb.isSelected() && (!EAVisualPanel.validateProjDir(string = this.tfWeb.getText(), wizardDescriptor) || !EAVisualPanel.validateCoordinate(string, wizardDescriptor) || BasicPanelVisual.containsMultiByte(string, wizardDescriptor))) {
            this.tfWeb.setForeground(Color.RED);
            return false;
        }
        wizardDescriptor.putProperty(ERROR_MSG, (Object)"");
        return true;
    }

    private static boolean validateProjDir(String string, WizardDescriptor wizardDescriptor) {
        File file;
        File file2;
        if (string.length() == 0) {
            wizardDescriptor.putProperty(ERROR_MSG, (Object)NbBundle.getMessage(EAVisualPanel.class, (String)"ERR_Project_Name_is_not_valid"));
            return false;
        }
        if (string.indexOf(File.separatorChar) != -1) {
            wizardDescriptor.putProperty(ERROR_MSG, (Object)NbBundle.getMessage(EAVisualPanel.class, (String)"ERR_Project_Name_has_slash"));
            return false;
        }
        File file3 = (File)wizardDescriptor.getProperty("projdir");
        for (file2 = file = FileUtil.normalizeFile((File)new File(file3, string)); file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
        }
        if (file2 == null || !file2.canWrite()) {
            wizardDescriptor.putProperty(ERROR_MSG, (Object)NbBundle.getMessage(EAVisualPanel.class, (String)"ERR_Project_Folder_cannot_be_created"));
            return false;
        }
        if (FileUtil.toFileObject((File)file2) == null) {
            String string2 = NbBundle.getMessage(EAVisualPanel.class, (String)"ERR_Project_Folder_is_not_valid_path");
            wizardDescriptor.putProperty(ERROR_MSG, (Object)string2);
            return false;
        }
        File[] fileArray = file.listFiles();
        if (file.exists() && fileArray != null && fileArray.length > 0) {
            wizardDescriptor.putProperty(ERROR_MSG, (Object)NbBundle.getMessage(EAVisualPanel.class, (String)"ERR_Project_Folder_exists"));
            return false;
        }
        wizardDescriptor.putProperty(ERROR_MSG, null);
        return true;
    }

    static boolean validateCoordinate(String string, WizardDescriptor wizardDescriptor) {
        boolean bl = false;
        try {
            String string2 = XMLUtil.toAttributeValue((String)string);
            bl = string2.length() == string.length() && string.indexOf(">") == -1 && string.indexOf(" ") == -1;
        }
        catch (CharConversionException charConversionException) {
            // empty catch block
        }
        wizardDescriptor.putProperty(ERROR_MSG, bl ? null : NbBundle.getMessage(EAVisualPanel.class, (String)"ERR_Coord_breaks_pom"));
        return bl;
    }

    private void fillTextFields(WizardDescriptor wizardDescriptor) {
        String string = (String)wizardDescriptor.getProperty("artifactId");
        this.tfEar.setText(string + "-ear");
        this.tfWeb.setText(string + "-web");
        this.tfEjb.setText(string + "-ejb");
    }

    private void initComponents() {
        this.cmbEEVersion = new JComboBox();
        this.lblEEVersion = new JLabel();
        this.chkEjb = new JCheckBox();
        this.chkWeb = new JCheckBox();
        this.lblEar = new JLabel();
        this.tfWeb = new JTextField();
        this.tfEjb = new JTextField();
        this.tfEar = new JTextField();
        this.cmbEEVersion.setModel(new DefaultComboBoxModel<String>(ArchetypeWizardUtils.EE_LEVELS));
        this.lblEEVersion.setLabelFor(this.cmbEEVersion);
        Mnemonics.setLocalizedText((JLabel)this.lblEEVersion, (String)NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.lblEEVersion.text"));
        this.chkEjb.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkEjb, (String)NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.chkEjb.text"));
        this.chkEjb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EAVisualPanel.this.chkEjbActionPerformed(actionEvent);
            }
        });
        this.chkWeb.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkWeb, (String)NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.chkWeb.text"));
        this.chkWeb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EAVisualPanel.this.chkWebActionPerformed(actionEvent);
            }
        });
        this.lblEar.setLabelFor(this.tfEar);
        Mnemonics.setLocalizedText((JLabel)this.lblEar, (String)NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.lblEar.text"));
        this.tfWeb.setText(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfWeb.text"));
        this.tfEjb.setText(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfEjb.text"));
        this.tfEar.setText(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfEar.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblEEVersion).addPreferredGap(0).add((Component)this.cmbEEVersion, -2, -1, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.chkWeb).add((Component)this.chkEjb).add((Component)this.lblEar)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.tfEjb, -1, 201, Short.MAX_VALUE).add((Component)this.tfWeb, -1, 201, Short.MAX_VALUE).add((Component)this.tfEar, -1, 201, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblEEVersion).add((Component)this.cmbEEVersion, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.tfEjb, -2, -1, -2).add((Component)this.chkEjb)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.chkWeb).add((Component)this.tfWeb, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.tfEar, -2, -1, -2).add((Component)this.lblEar)).addContainerGap(174, Short.MAX_VALUE)));
        this.cmbEEVersion.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.cmbEEVersion.AccessibleContext.accessibleDescription"));
        this.chkEjb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.chkEjb.AccessibleContext.accessibleDescription"));
        this.chkWeb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.chkWeb.AccessibleContext.accessibleDescription"));
        this.tfWeb.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfWeb.AccessibleContext.accessibleName"));
        this.tfWeb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfWeb.AccessibleContext.accessibleDescription"));
        this.tfEjb.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfEjb.AccessibleContext.accessibleName"));
        this.tfEjb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfEjb.AccessibleContext.accessibleDescription"));
        this.tfEar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfEar.AccessibleContext.accessibleDescription"));
    }

    private void chkEjbActionPerformed(ActionEvent actionEvent) {
        this.tfEjb.setEnabled(this.chkEjb.isSelected());
        this.panel.fireChangeEvent();
    }

    private void chkWebActionPerformed(ActionEvent actionEvent) {
        this.tfWeb.setEnabled(this.chkWeb.isSelected());
        this.panel.fireChangeEvent();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.panel.fireChangeEvent();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.panel.fireChangeEvent();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.panel.fireChangeEvent();
    }
}

