/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute.ui;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.TextValueCompleter;
import org.netbeans.modules.maven.api.ProjectProfileHandler;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.customizer.PropertySplitter;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.spi.grammar.GoalsProvider;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RunGoalsPanel
extends JPanel {
    private List<NetbeansActionMapping> historyMappings;
    private int historyIndex = 0;
    private TextValueCompleter goalcompleter;
    private TextValueCompleter profilecompleter;
    private JButton btnNext;
    private JButton btnPrev;
    private JCheckBox cbDebug;
    private JCheckBox cbOffline;
    private JCheckBox cbRecursive;
    private JCheckBox cbRemember;
    private JCheckBox cbSkipTests;
    private JCheckBox cbUpdateSnapshots;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblGoals;
    private JLabel lblProfiles;
    private JTextArea taProperties;
    private JTextField txtGoals;
    private JTextField txtProfiles;
    private JTextField txtRemember;

    public RunGoalsPanel() {
        this.initComponents();
        this.historyMappings = new ArrayList<NetbeansActionMapping>();
        this.btnPrev.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/back.png", (boolean)false));
        this.btnNext.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/forward.png", (boolean)false));
        this.goalcompleter = new TextValueCompleter(new ArrayList<String>(0), this.txtGoals, " ");
        this.goalcompleter.setLoading(true);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                GoalsProvider goalsProvider = (GoalsProvider)Lookup.getDefault().lookup(GoalsProvider.class);
                if (goalsProvider != null) {
                    final Set<String> set = goalsProvider.getAvailableGoals();
                    try {
                        List list = EmbedderFactory.getProjectEmbedder().getLifecyclePhases();
                        set.addAll(list);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            RunGoalsPanel.this.goalcompleter.setValueList(set);
                        }
                    });
                }
            }
        });
        this.profilecompleter = new TextValueCompleter(new ArrayList<String>(0), this.txtProfiles, " ");
    }

    public void addNotify() {
        super.addNotify();
        this.txtGoals.requestFocus();
    }

    private void readProfiles(final Project project) {
        this.profilecompleter.setLoading(true);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ProjectProfileHandler projectProfileHandler = (ProjectProfileHandler)project.getLookup().lookup(ProjectProfileHandler.class);
                final List<String> list = projectProfileHandler.getAllProfiles();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RunGoalsPanel.this.profilecompleter.setValueList(list);
                    }
                });
            }
        });
    }

    private String createSpaceSeparatedList(List list) {
        String string = "";
        if (list != null) {
            for (String string2 : list) {
                string = string + string2 + " ";
            }
        }
        return string;
    }

    public void readMapping(NetbeansActionMapping netbeansActionMapping, NbMavenProjectImpl nbMavenProjectImpl, ActionToGoalMapping actionToGoalMapping) {
        this.historyMappings.clear();
        this.historyMappings.addAll(actionToGoalMapping.getActions());
        this.historyMappings.add(netbeansActionMapping);
        this.historyIndex = this.historyMappings.size();
        this.readProfiles(nbMavenProjectImpl);
        this.moveHistory(-1);
    }

    public void readConfig(RunConfig runConfig) {
        Object object;
        this.historyMappings.clear();
        this.btnNext.setVisible(false);
        this.btnPrev.setVisible(false);
        this.txtGoals.setText(this.createSpaceSeparatedList(runConfig.getGoals()));
        if (runConfig.getProperties() != null) {
            object = new StringBuffer();
            for (Object object2 : runConfig.getProperties().keySet()) {
                ((StringBuffer)object).append((String)object2).append("=").append("\"").append(runConfig.getProperties().getProperty((String)object2)).append("\"").append("\n");
            }
            this.taProperties.setText(((StringBuffer)object).toString());
            if (((StringBuffer)object).toString().matches(".*maven\\.test\\.skip\\s*=\\s*true\\s*.*")) {
                this.cbSkipTests.setSelected(true);
            }
        } else {
            this.taProperties.setText("");
        }
        object = runConfig.getActivatedProfiles();
        if (runConfig.getProject() != null) {
            Object object2;
            ProjectProfileHandler projectProfileHandler = (ProjectProfileHandler)runConfig.getProject().getLookup().lookup(ProjectProfileHandler.class);
            object2 = projectProfileHandler.getMergedActiveProfiles(false);
            this.txtProfiles.setText(this.createSpaceSeparatedList((List)object2));
        } else {
            this.txtProfiles.setText(this.createSpaceSeparatedList((List)object));
        }
        this.setUpdateSnapshots(runConfig.isUpdateSnapshots());
        this.setOffline(runConfig.isOffline() != null ? runConfig.isOffline() : false);
        this.setRecursive(runConfig.isRecursive());
        this.setShowDebug(runConfig.isShowDebug());
        if (runConfig.getProject() != null) {
            this.readProfiles(runConfig.getProject());
        }
    }

    private void readMapping(NetbeansActionMapping netbeansActionMapping) {
        this.txtGoals.setText(this.createSpaceSeparatedList(netbeansActionMapping.getGoals()));
        if (netbeansActionMapping.getProperties() != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : netbeansActionMapping.getProperties().keySet()) {
                stringBuffer.append(string).append("=").append(netbeansActionMapping.getProperties().getProperty(string)).append("\n");
            }
            this.taProperties.setText(stringBuffer.toString());
            if (stringBuffer.toString().matches(".*maven\\.test\\.skip\\s*=\\s*true\\s*.*")) {
                this.cbSkipTests.setSelected(true);
            }
        } else {
            this.taProperties.setText("");
        }
        this.txtProfiles.setText(this.createSpaceSeparatedList(netbeansActionMapping.getActivatedProfiles()));
    }

    public void applyValues(NetbeansActionMapping netbeansActionMapping) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.txtGoals.getText().trim());
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        netbeansActionMapping.setGoals(arrayList.size() > 0 ? arrayList : null);
        PropertySplitter propertySplitter = new PropertySplitter(this.taProperties.getText());
        String string = propertySplitter.nextPair();
        Properties properties = new Properties();
        while (string != null) {
            String[] stringArray = StringUtils.split((String)string, (String)"=", (int)2);
            if (stringArray.length == 2) {
                String string2 = stringArray[0];
                if (string2.startsWith("-D")) {
                    string2 = string2.substring("-D".length());
                }
                if (string2.startsWith("-")) {
                    string2 = string2.substring(1);
                }
                properties.setProperty(string2, stringArray[1]);
            }
            string = propertySplitter.nextPair();
        }
        if (this.cbSkipTests.isSelected()) {
            properties.setProperty("maven.test.skip", "true");
        }
        netbeansActionMapping.setProperties(properties);
        stringTokenizer = new StringTokenizer(this.txtProfiles.getText().trim());
        arrayList = new ArrayList();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        netbeansActionMapping.setActivatedProfiles(arrayList);
        netbeansActionMapping.setRecursive(this.cbRecursive.isSelected());
    }

    public void applyValues(BeanRunConfig beanRunConfig) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.txtGoals.getText().trim());
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        beanRunConfig.setGoals(arrayList.size() > 0 ? arrayList : Collections.singletonList("install"));
        stringTokenizer = new StringTokenizer(this.txtProfiles.getText().trim());
        arrayList = new ArrayList();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        beanRunConfig.setActivatedProfiles(arrayList);
        PropertySplitter propertySplitter = new PropertySplitter(this.taProperties.getText());
        String string = propertySplitter.nextPair();
        Properties properties = new Properties();
        while (string != null) {
            String[] stringArray = StringUtils.split((String)string, (String)"=", (int)2);
            if (stringArray.length == 2) {
                properties.setProperty(stringArray[0], stringArray[1]);
            }
            string = propertySplitter.nextPair();
        }
        if (this.cbSkipTests.isSelected()) {
            properties.setProperty("maven.test.skip", "true");
        }
        beanRunConfig.setProperties(properties);
        beanRunConfig.setRecursive(this.isRecursive());
        beanRunConfig.setShowDebug(this.isShowDebug());
        beanRunConfig.setUpdateSnapshots(this.isUpdateSnapshots());
        beanRunConfig.setOffline(this.isOffline());
    }

    private void initComponents() {
        this.lblGoals = new JLabel();
        this.txtGoals = new JTextField();
        this.lblProfiles = new JLabel();
        this.txtProfiles = new JTextField();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.taProperties = new JTextArea();
        this.cbRecursive = new JCheckBox();
        this.cbOffline = new JCheckBox();
        this.cbDebug = new JCheckBox();
        this.cbUpdateSnapshots = new JCheckBox();
        this.cbSkipTests = new JCheckBox();
        this.btnNext = new JButton();
        this.btnPrev = new JButton();
        this.cbRemember = new JCheckBox();
        this.txtRemember = new JTextField();
        this.jSeparator1 = new JSeparator();
        Mnemonics.setLocalizedText((JLabel)this.lblGoals, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Goals"));
        Mnemonics.setLocalizedText((JLabel)this.lblProfiles, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Profiles"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Properties"));
        this.taProperties.setColumns(20);
        this.taProperties.setRows(5);
        this.jScrollPane1.setViewportView(this.taProperties);
        Mnemonics.setLocalizedText((AbstractButton)this.cbRecursive, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Recursive"));
        this.cbRecursive.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbRecursive.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.cbOffline, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Offline"));
        this.cbOffline.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbOffline.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.cbDebug, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Debug"));
        this.cbDebug.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbDebug.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.cbUpdateSnapshots, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Update_Snapshots"));
        this.cbUpdateSnapshots.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbUpdateSnapshots.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSkipTests, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Skip_Tests"));
        this.cbSkipTests.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbSkipTests.setMargin(new Insets(0, 0, 0, 0));
        this.cbSkipTests.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunGoalsPanel.this.cbSkipTestsActionPerformed(actionEvent);
            }
        });
        this.btnNext.setToolTipText(NbBundle.getMessage(RunGoalsPanel.class, (String)"TIP_Next"));
        this.btnNext.setMargin(new Insets(2, 2, 2, 2));
        this.btnNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunGoalsPanel.this.btnNextActionPerformed(actionEvent);
            }
        });
        this.btnPrev.setToolTipText(NbBundle.getMessage(RunGoalsPanel.class, (String)"TIP_Prev"));
        this.btnPrev.setMargin(new Insets(2, 2, 2, 2));
        this.btnPrev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunGoalsPanel.this.btnPrevActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbRemember, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Remember"));
        this.cbRemember.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbRemember.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbRecursive).add((Component)this.cbOffline)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbDebug).add((Component)this.cbUpdateSnapshots))).add((Component)this.cbSkipTests).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblGoals).add((Component)this.lblProfiles).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 364, Short.MAX_VALUE).add((Component)this.txtGoals, -1, 364, Short.MAX_VALUE).add((Component)this.txtProfiles, -1, 364, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.btnPrev).addPreferredGap(0).add((Component)this.btnNext).add(52, 52, 52).add((Component)this.cbRemember).addPreferredGap(0).add((Component)this.txtRemember, -1, 254, Short.MAX_VALUE)).add((Component)this.jSeparator1, -1, 442, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblGoals).add((Component)this.txtGoals, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblProfiles).add((Component)this.txtProfiles, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jScrollPane1, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cbRecursive).add((Component)this.cbUpdateSnapshots)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cbOffline).add((Component)this.cbDebug)).addPreferredGap(0).add((Component)this.cbSkipTests).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.btnPrev).add((Component)this.btnNext).add((Component)this.cbRemember).add((Component)this.txtRemember, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void cbSkipTestsActionPerformed(ActionEvent actionEvent) {
        String string = this.taProperties.getText();
        if (string.contains("maven.test.skip")) {
            this.taProperties.setText(string.replaceAll(".*maven\\.test\\.skip\\s*=\\s*[a-z]*\\s*.*", "maven.test.skip=" + (this.cbSkipTests.isSelected() ? "true" : "false")));
        } else if (this.cbSkipTests.isSelected()) {
            this.taProperties.setText(this.taProperties.getText() + "\nmaven.test.skip=true");
        }
    }

    private void btnNextActionPerformed(ActionEvent actionEvent) {
        this.moveHistory(1);
    }

    private void moveHistory(int n) {
        this.historyIndex += n;
        this.readMapping(this.historyMappings.get(this.historyIndex));
        this.btnPrev.setEnabled(this.historyIndex != 0);
        this.btnNext.setEnabled(this.historyIndex != this.historyMappings.size() - 1);
    }

    private void btnPrevActionPerformed(ActionEvent actionEvent) {
        this.moveHistory(-1);
    }

    public boolean isOffline() {
        return this.cbOffline.isSelected();
    }

    public boolean isShowDebug() {
        return this.cbDebug.isSelected();
    }

    public void setOffline(boolean bl) {
        this.cbOffline.setSelected(bl);
    }

    public void setShowDebug(boolean bl) {
        this.cbDebug.setSelected(bl);
    }

    public void setUpdateSnapshots(boolean bl) {
        this.cbUpdateSnapshots.setSelected(bl);
    }

    public void setSkipTests(boolean bl) {
        this.cbSkipTests.setSelected(bl);
    }

    public void setRecursive(boolean bl) {
        this.cbRecursive.setSelected(bl);
    }

    public boolean isSkipTests() {
        return this.cbSkipTests.isSelected();
    }

    public boolean isRecursive() {
        return this.cbRecursive.isSelected();
    }

    public boolean isUpdateSnapshots() {
        return this.cbUpdateSnapshots.isSelected();
    }

    public String isRememberedAs() {
        String string;
        if (this.cbRemember.isSelected() && (string = this.txtRemember.getText().trim()).length() > 0) {
            return string;
        }
        return null;
    }
}

