/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute.precache;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.queries.MavenFileOwnerQueryImpl;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class ExecutionPrecacheManager
implements PropertyChangeListener,
ChangeListener {
    private final RequestProcessor REQ = new RequestProcessor("Maven Execution Caching", 1);
    private Project mainMavenProject;
    private Set<FileObject> roots = new HashSet<FileObject>();
    private final Set<FileSystem> filesystems = new HashSet<FileSystem>();
    private final FileChangeListener listener = new FileObjectListener();
    private static ExecutionPrecacheManager instance;

    public static ExecutionPrecacheManager getInstance() {
        if (instance == null) {
            instance = new ExecutionPrecacheManager();
        }
        return instance;
    }

    public void startMonitoring() {
        this.checkMainProject();
        this.checkMavenProjectRoots();
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        MavenFileOwnerQueryImpl.getInstance().addChangeListener(this);
    }

    public void stopMonitoring() {
        MavenFileOwnerQueryImpl.getInstance().removeChangeListener(this);
        OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
        if (this.mainMavenProject != null) {
            NbMavenProject nbMavenProject = (NbMavenProject)this.mainMavenProject.getLookup().lookup(NbMavenProject.class);
            nbMavenProject.removePropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("MainProject".equals(propertyChangeEvent.getPropertyName())) {
            this.checkMainProject();
        }
        if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
            this.doPrepareProject((Project)propertyChangeEvent.getSource(), true);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.checkMavenProjectRoots();
    }

    private void checkMainProject() {
        NbMavenProject nbMavenProject;
        boolean bl = false;
        Project project = OpenProjects.getDefault().getMainProject();
        if (project != null) {
            nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            if (nbMavenProject != null && project != this.mainMavenProject) {
                bl = true;
            }
        } else if (this.mainMavenProject != null) {
            bl = true;
        }
        if (bl) {
            if (this.mainMavenProject != null) {
                nbMavenProject = (NbMavenProject)this.mainMavenProject.getLookup().lookup(NbMavenProject.class);
                nbMavenProject.removePropertyChangeListener(this);
            }
            this.mainMavenProject = project;
            if (this.mainMavenProject != null) {
                nbMavenProject = (NbMavenProject)this.mainMavenProject.getLookup().lookup(NbMavenProject.class);
                nbMavenProject.addPropertyChangeListener(this);
            }
        }
    }

    private void checkMavenProjectRoots() {
        this.roots = MavenFileOwnerQueryImpl.getInstance().getOpenedProjectRoots();
        HashSet<FileSystem> hashSet = new HashSet<FileSystem>();
        HashSet<FileSystem> hashSet2 = new HashSet<FileSystem>();
        hashSet2.addAll(this.filesystems);
        for (FileObject fileObject : this.roots) {
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                hashSet.add(fileSystem);
                if (this.filesystems.contains(fileSystem)) continue;
                this.filesystems.add(fileSystem);
                fileSystem.addFileChangeListener(this.listener);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
        hashSet2.removeAll(hashSet);
        for (FileSystem fileSystem : hashSet2) {
            fileSystem.removeFileChangeListener(this.listener);
        }
    }

    private void doPrepareProject(Project project, boolean bl) {
        System.out.println("preparing project=" + project.getProjectDirectory() + " reset=" + bl);
    }

    private class FileObjectListener
    implements FileChangeListener {
        private FileObjectListener() {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.checkBuildTrigger(fileEvent.getFile());
        }

        public void fileChanged(FileEvent fileEvent) {
            this.checkBuildTrigger(fileEvent.getFile());
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.checkBuildTrigger(fileEvent.getFile());
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        private void checkBuildTrigger(FileObject fileObject) {
            NbMavenProject nbMavenProject;
            Project project;
            if (this.checkRoots(fileObject) && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null && (nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class)) != null) {
                SubprojectProvider subprojectProvider;
                String string = fileObject.getNameExt();
                boolean bl = "pom.xml".equals(string) || "profiles.xml".equals(string) || "nbactions.xml".equals(string);
                ExecutionPrecacheManager.this.doPrepareProject(project, bl);
                if (ExecutionPrecacheManager.this.mainMavenProject != null && (subprojectProvider = (SubprojectProvider)ExecutionPrecacheManager.this.mainMavenProject.getLookup().lookup(SubprojectProvider.class)).getSubprojects().contains(project)) {
                    ExecutionPrecacheManager.this.doPrepareProject(ExecutionPrecacheManager.this.mainMavenProject, bl);
                }
            }
        }

        private boolean checkRoots(FileObject fileObject) {
            HashSet hashSet = new HashSet();
            hashSet.addAll(ExecutionPrecacheManager.this.roots);
            for (FileObject fileObject2 : hashSet) {
                if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
                return true;
            }
            return false;
        }
    }
}

