/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.maven.project.MavenProject;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.api.customizer.support.ReflectionTextComponentUpdater;
import org.netbeans.modules.maven.api.customizer.support.TextComponentUpdater;
import org.netbeans.modules.maven.model.pom.Project;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public class BasicInfoPanel
extends JPanel
implements DocumentListener {
    private ModelHandle handle;
    private List<TextComponentUpdater> listeners;
    private final ProjectCustomizer.Category category;
    private JScrollPane jScrollPane1;
    private JLabel lblArtifactId;
    private JLabel lblDescription;
    private JLabel lblGroupId;
    private JLabel lblName;
    private JLabel lblPackaging;
    private JLabel lblVersion;
    private JTextArea taDescription;
    private JTextField txtArtifactId;
    private JTextField txtGroupId;
    private JTextField txtName;
    private JTextField txtPackaging;
    private JTextField txtVersion;

    public BasicInfoPanel(ModelHandle modelHandle, ProjectCustomizer.Category category) {
        this.initComponents();
        this.handle = modelHandle;
        this.category = category;
        this.initValues();
    }

    private void initValues() {
        Project project = this.handle.getPOMModel().getProject();
        MavenProject mavenProject = this.handle.getProject().getParent();
        this.listeners = new ArrayList<TextComponentUpdater>();
        try {
            this.listeners.add(new ReflectionTextComponentUpdater("getGroupId", "setGroupId", project, mavenProject, this.txtGroupId, this.lblGroupId, this.handle));
            this.listeners.add(new ReflectionTextComponentUpdater("getArtifactId", "setArtifactId", project, mavenProject, this.txtArtifactId, this.lblArtifactId, this.handle));
            this.listeners.add(new ReflectionTextComponentUpdater("getVersion", "setVersion", project, mavenProject, this.txtVersion, this.lblVersion, this.handle));
            this.listeners.add(new ReflectionTextComponentUpdater("getName", "setName", project, mavenProject, this.txtName, this.lblName, this.handle));
            this.listeners.add(new ReflectionTextComponentUpdater("getPackaging", "setPackaging", project, mavenProject, this.txtPackaging, this.lblPackaging, this.handle));
            this.listeners.add(new ReflectionTextComponentUpdater("getDescription", "setDescription", project, mavenProject, this.taDescription, this.lblDescription, this.handle));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        this.txtGroupId.getDocument().addDocumentListener(this);
        this.txtArtifactId.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.lblGroupId = new JLabel();
        this.txtGroupId = new JTextField();
        this.lblArtifactId = new JLabel();
        this.txtArtifactId = new JTextField();
        this.lblVersion = new JLabel();
        this.txtVersion = new JTextField();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblPackaging = new JLabel();
        this.txtPackaging = new JTextField();
        this.lblDescription = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.taDescription = new JTextArea();
        this.lblGroupId.setLabelFor(this.txtGroupId);
        Mnemonics.setLocalizedText((JLabel)this.lblGroupId, (String)NbBundle.getMessage(BasicInfoPanel.class, (String)"LBL_GroupId"));
        this.lblArtifactId.setLabelFor(this.txtArtifactId);
        Mnemonics.setLocalizedText((JLabel)this.lblArtifactId, (String)NbBundle.getMessage(BasicInfoPanel.class, (String)"LBL_ArtifactId"));
        this.lblVersion.setLabelFor(this.txtVersion);
        Mnemonics.setLocalizedText((JLabel)this.lblVersion, (String)NbBundle.getMessage(BasicInfoPanel.class, (String)"LBL_Version"));
        this.lblName.setLabelFor(this.txtName);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(BasicInfoPanel.class, (String)"LBL_Name"));
        this.lblPackaging.setLabelFor(this.txtPackaging);
        Mnemonics.setLocalizedText((JLabel)this.lblPackaging, (String)NbBundle.getMessage(BasicInfoPanel.class, (String)"LBL_Packaging"));
        this.lblDescription.setLabelFor(this.taDescription);
        Mnemonics.setLocalizedText((JLabel)this.lblDescription, (String)NbBundle.getMessage(BasicInfoPanel.class, (String)"LBL_Description"));
        this.taDescription.setColumns(20);
        this.taDescription.setRows(5);
        this.jScrollPane1.setViewportView(this.taDescription);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblGroupId).add((Component)this.lblArtifactId).add((Component)this.lblVersion).add((Component)this.lblPackaging).add((Component)this.lblName).add((Component)this.lblDescription)).add(40, 40, 40).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.jScrollPane1, -1, 302, Short.MAX_VALUE).add(1, (Component)this.txtVersion, -1, 302, Short.MAX_VALUE).add(1, (Component)this.txtArtifactId, -1, 302, Short.MAX_VALUE).add(1, (Component)this.txtGroupId, -1, 302, Short.MAX_VALUE).add(1, (Component)this.txtName, -1, 302, Short.MAX_VALUE).add(1, (Component)this.txtPackaging, -1, 302, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.txtGroupId, -2, -1, -2).add((Component)this.lblGroupId, -2, 15, -2)).add(8, 8, 8).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.txtArtifactId, -2, -1, -2).add((Component)this.lblArtifactId)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.txtVersion, -2, -1, -2).add((Component)this.lblVersion)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.txtPackaging, -2, -1, -2).add((Component)this.lblPackaging)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.txtName, -2, -1, -2).add((Component)this.lblName)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 250, Short.MAX_VALUE).add((Component)this.lblDescription)).addContainerGap()));
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkCoords();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkCoords();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkCoords();
    }

    private void checkCoords() {
        boolean bl = this.checkCoord(this.txtGroupId);
        if (bl) {
            bl = this.checkCoord(this.txtArtifactId);
        }
        this.category.setValid(bl);
    }

    private boolean checkCoord(JTextField jTextField) {
        String string = jTextField.getText();
        boolean bl = false;
        try {
            String string2 = XMLUtil.toAttributeValue((String)string);
            bl = string2.length() == string.length() && string.indexOf(">") == -1 && string.indexOf(" ") == -1;
        }
        catch (CharConversionException charConversionException) {
            // empty catch block
        }
        if (bl) {
            bl = !this.containsMultiByte(string);
        } else {
            this.category.setErrorMessage(NbBundle.getMessage(BasicInfoPanel.class, (String)"ERR_Coord_breaks_pom"));
        }
        if (bl) {
            this.category.setErrorMessage(null);
        }
        return bl;
    }

    boolean containsMultiByte(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] <= '\u00ff') continue;
            this.category.setErrorMessage(NbBundle.getMessage(BasicInfoPanel.class, (String)"ERR_multibyte"));
            return true;
        }
        return false;
    }
}

