/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.cos;

import hidden.org.codehaus.plexus.util.DirectoryScanner;
import hidden.org.codehaus.plexus.util.IOUtil;
import hidden.org.codehaus.plexus.util.cli.CommandLineUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.model.Build;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.runner.JavaRunner;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.classpath.AbstractProjectClassPathImpl;
import org.netbeans.modules.maven.classpath.ClassPathProviderImpl;
import org.netbeans.modules.maven.classpath.RuntimeClassPathImpl;
import org.netbeans.modules.maven.classpath.TestRuntimeClassPathImpl;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.customizer.RunJarPanel;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CosChecker
implements PrerequisitesChecker {
    private static final String NB_COS = ".netbeans_automatic_build";
    private static final String MAVEN_MAIN_COS = ".netbeans_CoS_timestamp_main";
    private static final String MAVEN_TEST_COS = ".netbeans_CoS_timestamp_test";
    private static final String RUN_MAIN = "run.single.main";
    private static final String DEBUG_MAIN = "debug.single.main";
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};

    public static ExecutionResultChecker createResultChecker() {
        return new COSExChecker();
    }

    @Override
    public boolean checkRunConfig(RunConfig runConfig) {
        if (runConfig.getProject() == null) {
            return true;
        }
        if (!this.checkRunMainClass(runConfig)) {
            return false;
        }
        if (!this.checkRunTest(runConfig)) {
            return false;
        }
        long l = this.getLastCoSLastTouch(runConfig, true);
        long l2 = this.getLastCoSLastTouch(runConfig, false);
        if (l != 0L && l != Long.MAX_VALUE || l2 != 0L && l2 != Long.MAX_VALUE) {
            try {
                CosChecker.cleanGeneratedClassfiles(runConfig);
            }
            catch (IOException iOException) {
                if (!"clean".equals(runConfig.getGoals().get(0))) {
                    runConfig.getGoals().add(0, "clean");
                }
                Logger.getLogger(CosChecker.class.getName()).log(Level.INFO, "Compile on Save Clean failed", iOException);
            }
        }
        return true;
    }

    private boolean checkAndCopyResources(boolean bl, long l, RunConfig runConfig) {
        Resource resource;
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        ArrayList<Resource> arrayList2 = new ArrayList<Resource>();
        List list = runConfig.getMavenProject().getResources();
        Object object = list.iterator();
        while (object.hasNext()) {
            resource = (Resource)object.next();
            if (resource.isFiltering()) {
                if (!this.checkResource(resource, null, l)) continue;
                return false;
            }
            arrayList.add(resource);
        }
        if (bl) {
            list = runConfig.getMavenProject().getTestResources();
            object = list.iterator();
            while (object.hasNext()) {
                resource = (Resource)object.next();
                if (resource.isFiltering()) {
                    if (this.checkResource(resource, null, l)) continue;
                    return false;
                }
                arrayList2.add(resource);
            }
        }
        if ((resource = FileUtilities.convertStringToFileObject(object = runConfig.getMavenProject().getBuild().getOutputDirectory())) == null) {
            return false;
        }
        for (Resource resource2 : arrayList) {
            this.checkResource(resource2, (FileObject)resource, l);
        }
        if (bl) {
            object = runConfig.getMavenProject().getBuild().getTestOutputDirectory();
            resource = FileUtilities.convertStringToFileObject((String)object);
            if (resource == null) {
                return false;
            }
            for (Resource resource2 : arrayList2) {
                this.checkResource(resource2, (FileObject)resource, l);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkResource(Resource resource, FileObject fileObject, long l) {
        String string = resource.getDirectory();
        File file = FileUtil.normalizeFile((File)new File(string));
        if (file.exists()) {
            File file2;
            ArrayList<File> arrayList = new ArrayList<File>();
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(file);
            String[] stringArray = resource.getIncludes().toArray(new String[0]);
            if (stringArray != null && stringArray.length > 0) {
                directoryScanner.setIncludes(stringArray);
            } else {
                directoryScanner.setIncludes(DEFAULT_INCLUDES);
            }
            String[] stringArray2 = resource.getExcludes().toArray(new String[0]);
            if (stringArray2 != null && stringArray2.length > 0) {
                directoryScanner.setExcludes(stringArray2);
            }
            directoryScanner.addDefaultExcludes();
            directoryScanner.scan();
            String[] stringArray3 = directoryScanner.getIncludedFiles();
            for (String string2 : stringArray3) {
                file2 = new File(file, string2);
                if (file2.lastModified() < 0L) continue;
                arrayList.add(FileUtil.normalizeFile((File)file2));
            }
            if (arrayList.size() > 0) {
                if (fileObject != null) {
                    for (File file3 : arrayList) {
                        Object object;
                        String string2;
                        String string3 = FileUtilities.getRelativePath(file, file3);
                        if (string3 == null) {
                            return false;
                        }
                        string2 = resource.getTargetPath();
                        if (string2 != null && string2.trim().length() > 0) {
                            if (!string2.endsWith("/")) {
                                string2 = string2 + "/";
                            }
                            string3 = string2 + string3;
                        }
                        if ((file2 = fileObject.getFileObject(string3)) == null) {
                            object = FileUtil.normalizeFile((File)new File(FileUtil.toFile((FileObject)fileObject), string3));
                            try {
                                file2 = FileUtil.createData((File)object);
                            }
                            catch (IOException iOException) {
                                Logger.getLogger(CosChecker.class.getName()).log(Level.INFO, "Cannot create file " + file3 + ", skipping copying of resource for Compile on Save.", iOException);
                            }
                        }
                        if (file2 == null) continue;
                        object = FileUtil.toFileObject((File)file3);
                        InputStream inputStream = null;
                        OutputStream outputStream = null;
                        try {
                            inputStream = object.getInputStream();
                            outputStream = file2.getOutputStream();
                            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                        finally {
                            IOUtil.close((InputStream)inputStream);
                            IOUtil.close((OutputStream)outputStream);
                        }
                    }
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkRunMainClass(RunConfig runConfig) {
        String string = runConfig.getActionName();
        if (RunUtils.hasApplicationCompileOnSaveEnabled(runConfig) && ("jar".equals(((NbMavenProject)runConfig.getProject().getLookup().lookup(NbMavenProject.class)).getPackagingType()) && ("run".equals(string) || "debug".equals(string)) || RUN_MAIN.equals(string) || DEBUG_MAIN.equals(string))) {
            boolean bl;
            Object object;
            long l = this.getLastCoSLastTouch(runConfig, true);
            if (this.checkImportantFiles(l, runConfig)) {
                return true;
            }
            if (!this.checkAndCopyResources(false, l, runConfig)) {
                return true;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("project.name", runConfig.getExecutionName());
            hashMap.put("work.dir", runConfig.getExecutionDirectory());
            if (RUN_MAIN.equals(string) || DEBUG_MAIN.equals(string)) {
                hashMap.put("execute.file", runConfig.getSelectedFileObject());
            } else {
                hashMap.put("execute.classpath", this.createRuntimeClassPath(runConfig.getMavenProject(), false));
            }
            String string2 = runConfig.getProperties().getProperty("exec.args");
            if (string2 != null) {
                object = RunJarPanel.splitAll(string2);
                if (hashMap.get("execute.file") == null) {
                    hashMap.put("classname", object[1]);
                }
                String[] stringArray = object[2].split(" ");
                hashMap.put("application.args", Arrays.asList(stringArray));
                try {
                    hashMap.put("run.jvmargs", CosChecker.extractDebugJVMOptions(object[2]));
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
            if ((hashMap.get("execute.file") != null || hashMap.get("classname") != null) && (bl = JavaRunner.isSupported((String)(object = this.action2Quick(string)), hashMap))) {
                try {
                    JavaRunner.execute((String)object, hashMap);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    Exceptions.printStackTrace((Throwable)unsupportedOperationException);
                }
                finally {
                    this.touchCoSTimeStamp(runConfig, false);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkRunTest(RunConfig runConfig) {
        String string = runConfig.getActionName();
        if (RunUtils.hasTestCompileOnSaveEnabled(runConfig) && ("test.single".equals(string) || "debug.test.single".equals(string))) {
            ExecutorTask executorTask;
            Object object;
            ExecutorTask executorTask2;
            Object object2;
            Object object3;
            Object object4;
            ClassPath[] classPathArray;
            Object object5;
            Object object62;
            String string2 = PluginPropertyUtils.getPluginProperty(runConfig.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "testNGArtifactName", "test");
            if (string2 == null) {
                string2 = "org.testng:testng";
            }
            List list = runConfig.getMavenProject().getTestDependencies();
            for (Object object62 : list) {
                if (!string2.equals(object62.getManagementKey())) continue;
                return true;
            }
            HashMap hashMap = new HashMap();
            object62 = runConfig.getProperties().getProperty("test");
            if (object62 == null) {
                return true;
            }
            long l = this.getLastCoSLastTouch(runConfig, true);
            if (this.checkImportantFiles(l, runConfig)) {
                return true;
            }
            if (!this.checkAndCopyResources(true, l, runConfig)) {
                return true;
            }
            FileObject fileObject = runConfig.getSelectedFileObject();
            ClassPathProviderImpl classPathProviderImpl = (ClassPathProviderImpl)runConfig.getProject().getLookup().lookup(ClassPathProviderImpl.class);
            ClassPath classPath = classPathProviderImpl.getProjectSourcesClassPath("classpath/source");
            String string3 = classPath.getResourceName(fileObject);
            if (string3 != null) {
                object5 = fileObject.getNameExt().replace(".java", "Test.java");
                string3 = string3.replace(fileObject.getNameExt(), (CharSequence)object5);
                classPathArray = classPathProviderImpl.getProjectClassPaths("classpath/source");
                object4 = ClassPathSupport.createProxyClassPath((ClassPath[])classPathArray);
                object3 = object4.findResource(string3);
                if (object3 != null) {
                    fileObject = object3;
                }
            }
            hashMap.put("execute.file", fileObject);
            object5 = new ArrayList();
            classPathArray = new HashSet();
            hashMap.put("project.name", runConfig.getExecutionName());
            object4 = PluginPropertyUtils.getPluginProperty(runConfig.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "basedir", "test");
            classPathArray.add("basedir");
            if (object4 != null) {
                hashMap.put("work.dir", object4);
                object5.add("-Dbasedir=\"" + (String)object4 + "\"");
            } else {
                hashMap.put("work.dir", runConfig.getExecutionDirectory());
                object5.add("-Dbasedir=\"" + runConfig.getExecutionDirectory().getAbsolutePath() + "\"");
            }
            object3 = PluginPropertyUtils.getPluginPropertyParameter(runConfig.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "systemProperties", "test");
            if (object3 != null) {
                object2 = ((Properties)object3).entrySet().iterator();
                while (object2.hasNext()) {
                    executorTask2 = object2.next();
                    object5.add("-D" + executorTask2.getKey() + "=" + executorTask2.getValue());
                    classPathArray.add((String)executorTask2.getKey());
                }
            }
            if (runConfig.getProperties() != null) {
                object2 = runConfig.getProperties().entrySet().iterator();
                while (object2.hasNext()) {
                    executorTask2 = (ExecutorTask)object2.next();
                    if ("maven.surefire.debug".equals(executorTask2.getKey()) || "jpda.listen".equals(executorTask2.getKey()) || "jpda.stopclass".equals(executorTask2.getKey())) continue;
                    if ("nb.single.run.methodName".equals(executorTask2.getKey())) {
                        hashMap.put("methodname", executorTask2.getValue());
                        string = "test.single".equals(string) ? "run.single.method" : "debug.single.method";
                        continue;
                    }
                    if (classPathArray.contains((String)executorTask2.getKey())) continue;
                    object5.add("-D" + executorTask2.getKey() + "=" + executorTask2.getValue());
                    classPathArray.add((String)executorTask2.getKey());
                }
            }
            if ((object2 = PluginPropertyUtils.getPluginProperty(runConfig.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "argLine", "test")) != null) {
                try {
                    executorTask2 = CommandLineUtils.translateCommandline((String)object2);
                    object5.addAll(Arrays.asList(executorTask2));
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            } else {
                object2 = runConfig.getProperties().getProperty("argLine");
                if (object2 != null) {
                    try {
                        object5.addAll(CosChecker.extractDebugJVMOptions((String)object2));
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                }
            }
            executorTask2 = PluginPropertyUtils.getPluginPropertyList(runConfig.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "additionalClasspathElements", "additionalClasspathElement", "test");
            ClassPath classPath2 = this.createRuntimeClassPath(runConfig.getMavenProject(), true);
            if (executorTask2 != null) {
                object = new ArrayList();
                File file = FileUtil.toFile((FileObject)runConfig.getProject().getProjectDirectory());
                for (String string4 : executorTask2) {
                    File file2 = FileUtilities.resolveFilePath(file, string4);
                    if (file2 != null) {
                        try {
                            object.add(file2.toURI().toURL());
                        }
                        catch (MalformedURLException malformedURLException) {
                            Logger.getLogger(CosChecker.class.getName()).info("Cannot convert '" + string4 + "' to URL");
                        }
                        continue;
                    }
                    Logger.getLogger(CosChecker.class.getName()).info("Cannot convert '" + string4 + "' to URL.");
                }
                executorTask = ClassPathSupport.createClassPath((URL[])object.toArray(new URL[object.size()]));
                classPath2 = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath2, executorTask});
            }
            hashMap.put("execute.classpath", classPath2);
            hashMap.put("run.jvmargs", object5);
            object = this.action2Quick(string);
            boolean bl = JavaRunner.isSupported((String)object, (Map)hashMap);
            if (bl) {
                try {
                    executorTask = JavaRunner.execute((String)object, (Map)hashMap);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    Exceptions.printStackTrace((Throwable)unsupportedOperationException);
                }
                finally {
                    this.touchCoSTimeStamp(runConfig, true);
                    this.touchCoSTimeStamp(runConfig, false);
                }
                return false;
            }
        }
        return true;
    }

    static void cleanGeneratedClassfiles(RunConfig runConfig) throws IOException {
        CosChecker.deleteCoSTimeStamp(runConfig, true);
        CosChecker.deleteCoSTimeStamp(runConfig, false);
        Project project = runConfig.getProject();
        ArrayList<ClassPath> arrayList = new ArrayList<ClassPath>();
        for (SourceGroup sourceGroup : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            FileObject fileObject = sourceGroup.getRootFolder();
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
            if (classPath == null) continue;
            arrayList.add(classPath);
        }
        int n = JavaRunner.execute((String)"clean", Collections.singletonMap("execute.classpath", ClassPathSupport.createProxyClassPath((ClassPath[])arrayList.toArray(new ClassPath[0])))).result();
        if (n != 0) {
            throw new IOException("Failed to clean NetBeans-generated classes");
        }
    }

    private boolean checkImportantFiles(long l, RunConfig runConfig) {
        String string;
        M2Configuration m2Configuration;
        assert (runConfig.getProject() != null);
        FileObject fileObject = runConfig.getProject().getProjectDirectory();
        if (this.isNewer(l, fileObject.getFileObject("pom.xml"))) {
            return true;
        }
        if (this.isNewer(l, fileObject.getFileObject("profiles.xml"))) {
            return true;
        }
        if (this.isNewer(l, fileObject.getFileObject("nbactions.xml"))) {
            return true;
        }
        M2ConfigProvider m2ConfigProvider = (M2ConfigProvider)runConfig.getProject().getLookup().lookup(M2ConfigProvider.class);
        return m2ConfigProvider != null && (m2Configuration = m2ConfigProvider.getActiveConfiguration()) != null && this.isNewer(l, fileObject.getFileObject(string = M2Configuration.getFileNameExt(m2Configuration.getId())));
    }

    private boolean isNewer(long l, FileObject fileObject) {
        File file;
        return fileObject != null && (file = FileUtil.toFile((FileObject)fileObject)).lastModified() >= l;
    }

    private ClassPath createRuntimeClassPath(MavenProject mavenProject, boolean bl) {
        List<URI> list = bl ? TestRuntimeClassPathImpl.createPath(mavenProject) : RuntimeClassPathImpl.createPath(mavenProject);
        return ClassPathSupport.createClassPath(AbstractProjectClassPathImpl.getPath(list.toArray(new URI[0])));
    }

    private long getLastCoSLastTouch(RunConfig runConfig, boolean bl) {
        if (runConfig.getProject() == null) {
            return 0L;
        }
        Build build = runConfig.getMavenProject().getBuild();
        if (build == null || build.getDirectory() == null) {
            return 0L;
        }
        File file = new File(build.getDirectory());
        if (!(file = FileUtil.normalizeFile((File)file)).exists()) {
            return 0L;
        }
        File file2 = new File(file, bl ? MAVEN_TEST_COS : MAVEN_MAIN_COS);
        if (!file2.exists()) {
            return Long.MAX_VALUE;
        }
        return file2.lastModified();
    }

    private boolean touchCoSTimeStamp(RunConfig runConfig, boolean bl) {
        return this.touchCoSTimeStamp(runConfig, bl, System.currentTimeMillis());
    }

    private boolean touchCoSTimeStamp(RunConfig runConfig, boolean bl, long l) {
        if (runConfig.getProject() == null) {
            return false;
        }
        Build build = runConfig.getMavenProject().getBuild();
        if (build == null || build.getDirectory() == null) {
            return false;
        }
        File file = new File(build.getDirectory());
        if (!(file = FileUtil.normalizeFile((File)file)).exists()) {
            return false;
        }
        File file2 = new File(file, bl ? MAVEN_TEST_COS : MAVEN_MAIN_COS);
        if (!file2.exists()) {
            try {
                return file2.createNewFile();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return file2.setLastModified(l);
    }

    private static void deleteCoSTimeStamp(RunConfig runConfig, boolean bl) {
        if (runConfig.getProject() == null) {
            return;
        }
        Build build = runConfig.getMavenProject().getBuild();
        if (build == null || build.getDirectory() == null) {
            return;
        }
        File file = new File(build.getDirectory());
        if (!(file = FileUtil.normalizeFile((File)file)).exists()) {
            return;
        }
        File file2 = new File(file, bl ? MAVEN_TEST_COS : MAVEN_MAIN_COS);
        if (file2.exists()) {
            file2.delete();
        }
    }

    static List<String> extractDebugJVMOptions(String string) throws Exception {
        String[] stringArray = CommandLineUtils.translateCommandline((String)string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            if ("-Xdebug".equals(string2) || "-Djava.compiler=none".equals(string2) || "-Xnoagent".equals(string2) || string2.startsWith("-Xrunjdwp") || string2.trim().length() == 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private String action2Quick(String string) {
        if ("clean".equals(string)) {
            return "clean";
        }
        if ("run".equals(string) || RUN_MAIN.equals(string)) {
            return "run";
        }
        if ("debug".equals(string) || DEBUG_MAIN.equals(string)) {
            return "debug";
        }
        if ("test".equals(string) || "test.single".equals(string) || "run.single.method".equals(string)) {
            return "junit";
        }
        if ("debug.test.single".equals(string) || "debug.single.method".equals(string)) {
            return "junit-debug";
        }
        assert (false) : "Cannot convert " + string + " to quick actions.";
        return null;
    }

    private static class COSExChecker
    implements ExecutionResultChecker {
        private COSExChecker() {
        }

        public void executionResult(RunConfig runConfig, ExecutionContext executionContext, int n) {
            if (n == 0) {
                CosChecker.deleteCoSTimeStamp(runConfig, false);
                CosChecker.deleteCoSTimeStamp(runConfig, true);
            }
        }
    }
}

