/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.actions;

import hidden.org.codehaus.plexus.util.FileUtils;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.maven.actions.CreateLibraryPanel;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateLibraryAction
extends AbstractAction
implements LookupListener {
    private Lookup lookup;
    private Lookup.Result<DependencyNode> result;
    private int TYPE_BINARY = 0;
    private int TYPE_JAVADOC = 1;
    private int TYPE_SOURCE = 2;

    public CreateLibraryAction(Lookup lookup) {
        this.lookup = lookup;
        this.putValue("Name", NbBundle.getMessage(CreateLibraryAction.class, (String)"ACT_Library"));
        this.putValue("SmallIcon", ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/actions/libraries.gif", (boolean)true)));
        this.putValue("iconBase", "org/netbeans/modules/maven/actions/libraries.gif");
        this.result = this.lookup.lookupResult(DependencyNode.class);
        this.setEnabled(this.result.allInstances().size() > 0);
        this.result.addLookupListener((LookupListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Iterator iterator = this.result.allInstances().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        DependencyNode dependencyNode = (DependencyNode)iterator.next();
        final MavenProject mavenProject = (MavenProject)this.lookup.lookup(MavenProject.class);
        final CreateLibraryPanel createLibraryPanel = new CreateLibraryPanel(dependencyNode);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)createLibraryPanel, NbBundle.getMessage(CreateLibraryPanel.class, (String)"LBL_CreateLibrary"));
        createLibraryPanel.setLineSupport(dialogDescriptor.createNotificationLineSupport());
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == DialogDescriptor.OK_OPTION) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    Library library = CreateLibraryAction.this.createLibrary(createLibraryPanel.getLibraryManager(), createLibraryPanel.getLibraryName(), createLibraryPanel.getIncludeArtifacts(), createLibraryPanel.isAllSourceAndJavadoc(), mavenProject, createLibraryPanel.getCopyDirectory());
                    if (library != null) {
                        LibrariesCustomizer.showCustomizer((Library)library, (LibraryManager)createLibraryPanel.getLibraryManager());
                    }
                }
            });
        }
    }

    public void resultChanged(LookupEvent lookupEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CreateLibraryAction.this.setEnabled(CreateLibraryAction.this.result.allInstances().size() > 0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Library createLibrary(LibraryManager libraryManager, String string, List<Artifact> list, boolean bl, MavenProject mavenProject, String string2) {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CreateLibraryAction.class, (String)"MSG_Create_Library"));
        int n = list.size() * (bl ? 3 : 1) + 5;
        progressHandle.start(n);
        try {
            Object object;
            MavenEmbedder mavenEmbedder = EmbedderFactory.getOnlineEmbedder();
            int n2 = 1;
            ArrayList<Artifact> arrayList = new ArrayList<Artifact>();
            ArrayList<URI> arrayList2 = new ArrayList<URI>();
            ArrayList<URI> arrayList3 = new ArrayList<URI>();
            ArrayList<URI> arrayList4 = new ArrayList<URI>();
            HashMap<String, ArrayList<URI>> hashMap = new HashMap<String, ArrayList<URI>>();
            File file = null;
            File file2 = null;
            if (string2 != null) {
                void var19_25;
                object = libraryManager.getLocation();
                Object file3 = null;
                if (object != null) {
                    try {
                        File file4;
                        File file5 = new File(((URL)object).toURI());
                        file2 = file4 = file5.getParentFile();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        Exceptions.printStackTrace((Throwable)uRISyntaxException);
                        File file6 = new File(System.getProperty("netbeans.user"), "libraries");
                    }
                } else {
                    File file7 = new File(System.getProperty("netbeans.user"), "libraries");
                }
                File file8 = FileUtil.normalizeFile((File)var19_25);
                file = FileUtilities.resolveFilePath(file8, string2);
                file.mkdirs();
            }
            hashMap.put("classpath", arrayList2);
            if (bl) {
                hashMap.put("javadoc", arrayList3);
                hashMap.put("src", arrayList4);
            }
            for (Artifact artifact : list) {
                progressHandle.progress(NbBundle.getMessage(CreateLibraryAction.class, (String)"MSG_Downloading", (Object)artifact.getId()), n2);
                try {
                    mavenEmbedder.resolve(artifact, mavenProject.getRemoteArtifactRepositories(), mavenEmbedder.getLocalRepository());
                    arrayList2.add(this.getJarUri(artifact, file, file2, this.TYPE_BINARY));
                    try {
                        if (bl) {
                            URI uRI;
                            progressHandle.progress(NbBundle.getMessage(CreateLibraryAction.class, (String)"MSG_Downloading_javadoc", (Object)artifact.getId()), n2 + 1);
                            Artifact artifact2 = mavenEmbedder.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), "javadoc");
                            mavenEmbedder.resolve(artifact2, mavenProject.getRemoteArtifactRepositories(), mavenEmbedder.getLocalRepository());
                            if (artifact2.getFile().exists()) {
                                uRI = this.getJarUri(artifact2, file, file2, this.TYPE_JAVADOC);
                                arrayList3.add(uRI);
                            }
                            progressHandle.progress(NbBundle.getMessage(CreateLibraryAction.class, (String)"MSG_Downloading_sources", (Object)artifact.getId()), n2 + 2);
                            uRI = mavenEmbedder.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), "sources");
                            mavenEmbedder.resolve((Artifact)uRI, mavenProject.getRemoteArtifactRepositories(), mavenEmbedder.getLocalRepository());
                            if (uRI.getFile().exists()) {
                                arrayList4.add(this.getJarUri((Artifact)uRI, file, file2, this.TYPE_SOURCE));
                            }
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(CreateLibraryAction.class.getName()).log(Level.FINE, "Failed to download artifact", exception);
                    }
                }
                catch (Exception exception) {
                    arrayList.add(artifact);
                    Logger.getLogger(CreateLibraryAction.class.getName()).log(Level.FINE, "Failed to download artifact", exception);
                }
                n2 += bl ? 3 : 1;
            }
            try {
                progressHandle.progress("Adding library", n2 + 4);
                object = libraryManager.createURILibrary("j2se", string, hashMap);
                return object;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                progressHandle.finish();
            }
        }
        finally {
            progressHandle.finish();
        }
        return null;
    }

    private static URI appendJarFolder(URI uRI, String string) {
        try {
            if (uRI.isAbsolute()) {
                return new URI("jar:" + uRI.toString() + "!/" + (string == null ? "" : string.replace('\\', '/')));
            }
            return new URI(uRI.toString() + "!/" + (string == null ? "" : string.replace('\\', '/')));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
    }

    URI getJarUri(Artifact artifact, File file, File file2, int n) throws IOException {
        FileObject fileObject;
        Object object;
        File file3 = artifact.getFile();
        URI uRI = file3.toURI();
        String string = null;
        if (file != null) {
            file3 = new File(file, artifact.getFile().getName());
            FileUtils.copyFile((File)artifact.getFile(), (File)file3);
            if (file2 != null && (object = FileUtilities.getRelativePath(file2, file3)) != null) {
                uRI = LibrariesSupport.convertFilePathToURI((String)object);
            }
        }
        FileUtil.refreshFor((File[])new File[]{file3});
        object = FileUtil.toFileObject((File)file3);
        if (n == this.TYPE_JAVADOC && FileUtil.isArchiveFile((FileObject)object)) {
            FileObject fileObject2 = JavadocAndSourceRootDetection.findJavadocRoot((FileObject)(object = FileUtil.getArchiveRoot((FileObject)object)));
            if (fileObject2 != null) {
                string = FileUtil.getRelativePath((FileObject)object, (FileObject)fileObject2);
            }
        } else if (n == this.TYPE_SOURCE && FileUtil.isArchiveFile((FileObject)object) && (fileObject = JavadocAndSourceRootDetection.findSourceRoot((FileObject)(object = FileUtil.getArchiveRoot((FileObject)object)))) != null) {
            string = FileUtil.getRelativePath((FileObject)object, (FileObject)fileObject);
        }
        return CreateLibraryAction.appendJarFolder(uRI, string);
    }
}

