/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.nodes.MavenProjectNode;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;

public class LogicalViewProviderImpl
implements LogicalViewProvider {
    private NbMavenProjectImpl project;

    public LogicalViewProviderImpl(NbMavenProjectImpl nbMavenProjectImpl) {
        this.project = nbMavenProjectImpl;
    }

    public Node createLogicalView() {
        return new MavenProjectNode(LogicalViewProviderImpl.createLookup(this.project), this.project);
    }

    private static Lookup createLookup(NbMavenProjectImpl nbMavenProjectImpl) {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)nbMavenProjectImpl.getProjectDirectory());
        SearchInfo searchInfo = SearchInfoFactory.createSearchInfo((FileObject)dataFolder.getPrimaryFile(), (boolean)true, (FileObjectFilter[])new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER, SearchInfoFactory.SHARABILITY_FILTER});
        return Lookups.fixed((Object[])new Object[]{nbMavenProjectImpl, dataFolder, searchInfo});
    }

    public Node findPath(Node node, Object object) {
        NbMavenProjectImpl nbMavenProjectImpl = (NbMavenProjectImpl)node.getLookup().lookup(NbMavenProjectImpl.class);
        if (nbMavenProjectImpl == null) {
            return null;
        }
        if (object instanceof FileObject) {
            Object object2;
            int n;
            FileObject fileObject = (FileObject)object;
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (!nbMavenProjectImpl.equals(project)) {
                return null;
            }
            Node[] nodeArray = node.getChildren().getNodes(true);
            for (n = 0; n < nodeArray.length; ++n) {
                object2 = PackageView.findPath((Node)nodeArray[n], (Object)object);
                if (object2 == null) continue;
                return object2;
            }
            for (n = 0; n < nodeArray.length; ++n) {
                object2 = (FindDelegate)nodeArray[n].getLookup().lookup(FindDelegate.class);
                if (object2 != null) {
                    for (Node node2 : object2.getDelegates(nodeArray[n])) {
                        Node node3 = PackageView.findPath((Node)node2, (Object)fileObject);
                        if (node3 != null) {
                            return node3;
                        }
                        Node node4 = this.findNodeByFileDataObject(node2, fileObject);
                        if (node4 == null) continue;
                        return node4;
                    }
                    continue;
                }
                Node node5 = this.findNodeByFileDataObject(nodeArray[n], fileObject);
                if (node5 == null) continue;
                return node5;
            }
        }
        return null;
    }

    private Node findNodeByFileDataObject(Node node, FileObject fileObject) {
        DataObject dataObject;
        FileObject fileObject2 = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject2 == null && (dataObject = (DataObject)node.getLookup().lookup(DataObject.class)) != null) {
            fileObject2 = dataObject.getPrimaryFile();
        }
        if (fileObject2 != null) {
            if (fileObject2.equals(fileObject)) {
                return node;
            }
            if (FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) {
                String string;
                dataObject = fileObject.isFolder() ? fileObject : fileObject.getParent();
                String string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)dataObject);
                ArrayList<String> arrayList = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    arrayList.add(string);
                }
                try {
                    Object object = string = dataObject.equals(fileObject2) ? node : NodeOp.findPath((Node)node, Collections.enumeration(arrayList));
                    if (fileObject.isFolder()) {
                        return string;
                    }
                    Node[] nodeArray = string.getChildren().getNodes(true);
                    for (int i = 0; i < nodeArray.length; ++i) {
                        DataObject dataObject2 = (DataObject)nodeArray[i].getLookup().lookup(DataObject.class);
                        if (dataObject2 == null || !dataObject2.getPrimaryFile().getNameExt().equals(fileObject.getNameExt())) continue;
                        return nodeArray[i];
                    }
                }
                catch (NodeNotFoundException nodeNotFoundException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static interface FindDelegate {
        public Node[] getDelegates(Node var1);
    }
}

