/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Repository;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class CPExtender
extends ProjectClassPathModifierImplementation
implements ProjectClassPathExtender {
    private NbMavenProjectImpl project;
    private static final String POM_XML = "pom.xml";
    static Pattern DEFAULT = Pattern.compile("(.+)[/]{1}(.+)[/]{1}(.+)[/]{1}(.+)\\.pom");
    static Pattern LEGACY = Pattern.compile("(.+)[/]{1}poms[/]{1}([a-zA-Z0-9_]+[a-zA-Z\\-_]+)[\\-]{1}([0-9]{1}.+)\\.pom");

    public CPExtender(NbMavenProjectImpl nbMavenProjectImpl) {
        this.project = nbMavenProjectImpl;
    }

    public boolean addLibrary(final Library library) throws IOException {
        final Boolean[] booleanArray = new Boolean[1];
        ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel pOMModel) {
                try {
                    booleanArray[0] = CPExtender.this.addLibrary(library, pOMModel, null);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    booleanArray[0] = Boolean.FALSE;
                }
            }
        };
        FileObject fileObject = this.project.getProjectDirectory().getFileObject(POM_XML);
        Utilities.performPOMModelOperations((FileObject)fileObject, Collections.singletonList(modelOperation));
        if (booleanArray[0].booleanValue()) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
        }
        return booleanArray[0];
    }

    public boolean addArchiveFile(FileObject fileObject) throws IOException {
        final FileObject fileObject2 = FileUtil.getArchiveFile((FileObject)fileObject);
        if (fileObject2.isFolder()) {
            throw new IOException("Cannot add folders to Maven projects as dependencies: " + fileObject2.getURL());
        }
        final Boolean[] booleanArray = new Boolean[1];
        ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel pOMModel) {
                try {
                    booleanArray[0] = CPExtender.this.addArchiveFile(fileObject2, pOMModel, null);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    booleanArray[0] = Boolean.FALSE;
                }
            }
        };
        FileObject fileObject3 = this.project.getProjectDirectory().getFileObject(POM_XML);
        Utilities.performPOMModelOperations((FileObject)fileObject3, Collections.singletonList(modelOperation));
        if (booleanArray[0].booleanValue()) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
        }
        return booleanArray[0];
    }

    private boolean addLibrary(Library library, POMModel pOMModel, String string) throws IOException {
        boolean bl = this.checkLibraryForPoms(library, pOMModel, string);
        if (!bl) {
            List list = library.getContent("classpath");
            boolean bl2 = bl = list.size() > 0;
            assert (pOMModel != null);
            for (URL uRL : list) {
                FileObject fileObject = URLMapper.findFileObject((URL)FileUtil.getArchiveFile((URL)uRL));
                assert (fileObject != null);
                if (fileObject.isFolder()) {
                    throw new IOException("Cannot add folders to Maven projects as dependencies: " + fileObject.getURL());
                }
                bl = bl && this.addArchiveFile(fileObject, pOMModel, string);
            }
        }
        return bl;
    }

    private boolean addArchiveFile(FileObject fileObject, POMModel pOMModel, String string) throws IOException {
        String[] stringArray = this.checkRepositoryIndices(FileUtil.toFile((FileObject)fileObject));
        if (stringArray == null || "unknown.binary".equals(stringArray[0])) {
            stringArray = new String[]{"unknown.binary", fileObject.getName(), "SNAPSHOT"};
            this.addJarToPrivateRepo(fileObject, pOMModel, stringArray);
        }
        if (stringArray != null) {
            Dependency dependency = ModelUtils.checkModelDependency(pOMModel, stringArray[0], stringArray[1], true);
            dependency.setVersion(stringArray[2]);
            if (string != null) {
                dependency.setScope(string);
            }
            return true;
        }
        return false;
    }

    private String[] checkRepositoryIndices(File file) {
        List list = RepositoryQueries.findBySHA1((File)file, (RepositoryInfo[])new RepositoryInfo[0]);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            NBVersionInfo nBVersionInfo = (NBVersionInfo)iterator.next();
            String[] stringArray = new String[]{nBVersionInfo.getGroupId(), nBVersionInfo.getArtifactId(), nBVersionInfo.getVersion()};
            return stringArray;
        }
        return null;
    }

    private URL[] getRepoURLs() {
        HashSet<URL> hashSet = new HashSet<URL>();
        List list = RepositoryPreferences.getInstance().getRepositoryInfos();
        for (RepositoryInfo repositoryInfo : list) {
            if (repositoryInfo.getRepositoryUrl() == null) continue;
            try {
                hashSet.add(new URL(repositoryInfo.getRepositoryUrl()));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        try {
            hashSet.add(new URL("http://repo1.maven.org/maven2"));
            hashSet.add(new URL("http://download.java.net/maven/2"));
            hashSet.add(new URL("http://download.java.net/maven/1"));
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
        return hashSet.toArray(new URL[0]);
    }

    private boolean checkLibraryForPoms(Library library, POMModel pOMModel, String string) {
        if (!"j2se".equals(library.getType())) {
            return false;
        }
        List list = library.getContent("maven-pom");
        boolean bl = false;
        if (list != null && list.size() > 0) {
            for (URL uRL : list) {
                Repository repository;
                URL[] uRLArray;
                String[] stringArray = CPExtender.checkLibrary(uRL, uRLArray = this.getRepoURLs());
                if (stringArray == null) continue;
                bl = true;
                Dependency dependency = ModelUtils.checkModelDependency(pOMModel, stringArray[2], stringArray[3], true);
                dependency.setVersion(stringArray[4]);
                if (string != null) {
                    dependency.setScope(string);
                }
                if (stringArray.length == 6) {
                    dependency.setClassifier(stringArray[5]);
                }
                if ((repository = ModelUtils.addModelRepository(this.project.getOriginalMavenProject(), pOMModel, stringArray[1])) == null) continue;
                repository.setId(library.getName());
                repository.setLayout(stringArray[0]);
                repository.setName("Repository for library " + library);
            }
        }
        return bl;
    }

    static String[] checkLibrary(URL uRL, URL[] uRLArray) {
        String string = uRL.getPath();
        Matcher matcher = LEGACY.matcher(string);
        boolean bl = false;
        if (!matcher.matches()) {
            matcher = DEFAULT.matcher(string);
            bl = true;
        }
        if (matcher.matches()) {
            String[] stringArray;
            if (uRL.getRef() != null) {
                stringArray = new String[6];
                stringArray[5] = uRL.getRef();
            } else {
                stringArray = new String[]{bl ? "default" : "legacy", uRL.getProtocol() + "://" + uRL.getHost() + (uRL.getPort() != -1 ? ":" + uRL.getPort() : ""), matcher.group(1), matcher.group(2), matcher.group(3)};
            }
            for (URL uRL2 : uRLArray) {
                String string2 = uRL2.getProtocol() + "://" + uRL2.getHost() + (uRL2.getPort() != -1 ? ":" + uRL2.getPort() : "");
                if (!string2.equals(stringArray[1]) || !stringArray[2].startsWith(uRL2.getPath())) continue;
                stringArray[1] = stringArray[1] + uRL2.getPath();
                stringArray[2] = stringArray[2].substring(uRL2.getPath().length());
                break;
            }
            if (stringArray[2].startsWith("/")) {
                stringArray[2] = stringArray[2].substring(1);
            }
            if (stringArray[2].startsWith("maven/")) {
                stringArray[1] = stringArray[1] + "/maven";
                stringArray[2] = stringArray[2].substring("maven/".length());
            }
            if (stringArray[2].startsWith("maven2/")) {
                stringArray[1] = stringArray[1] + "/maven2";
                stringArray[2] = stringArray[2].substring("maven2/".length());
            }
            stringArray[2] = stringArray[2].replace('/', '.');
            return stringArray;
        }
        return null;
    }

    public boolean addAntArtifact(AntArtifact antArtifact, URI uRI) throws IOException {
        throw new IOException("Cannot add Ant based projects as subprojecs to Maven projects.");
    }

    public SourceGroup[] getExtensibleSourceGroups() {
        SourceGroup[] sourceGroupArray;
        SourceGroup[] sourceGroupArray2;
        Sources sources = (Sources)this.project.getLookup().lookup(Sources.class);
        assert (sources != null);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        SourceGroup[] sourceGroupArray3 = sources.getSourceGroups("java");
        if (sourceGroupArray3 != null) {
            arrayList.addAll(Arrays.asList(sourceGroupArray3));
        }
        if ((sourceGroupArray2 = sources.getSourceGroups("resources")) != null) {
            arrayList.addAll(Arrays.asList(sourceGroupArray2));
        }
        if ((sourceGroupArray = sources.getSourceGroups("doc_root")) != null) {
            arrayList.addAll(Arrays.asList(sourceGroupArray));
        }
        return arrayList.toArray(new SourceGroup[0]);
    }

    public String[] getExtensibleClassPathTypes(SourceGroup sourceGroup) {
        return new String[]{"classpath/compile", "classpath/execute"};
    }

    public boolean addLibraries(final Library[] libraryArray, SourceGroup sourceGroup, String string) throws IOException {
        final Boolean[] booleanArray = new Boolean[]{libraryArray.length > 0};
        String string2 = "classpath/execute".equals(string) ? Artifact.SCOPE_RUNTIME : null;
        String string3 = sourceGroup.getName();
        if ("2TestSourceRoot".equals(string3)) {
            string2 = "test";
        }
        final String string4 = string2;
        ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel pOMModel) {
                for (Library library : libraryArray) {
                    try {
                        booleanArray[0] = booleanArray[0] != false && CPExtender.this.addLibrary(library, pOMModel, string4);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                        booleanArray[0] = Boolean.FALSE;
                    }
                }
            }
        };
        FileObject fileObject = this.project.getProjectDirectory().getFileObject(POM_XML);
        Utilities.performPOMModelOperations((FileObject)fileObject, Collections.singletonList(modelOperation));
        if (booleanArray[0].booleanValue()) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
        }
        return booleanArray[0];
    }

    public boolean removeLibraries(Library[] libraryArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported in maven projects.");
    }

    public boolean addRoots(final URL[] uRLArray, SourceGroup sourceGroup, String string) throws IOException {
        final Boolean[] booleanArray = new Boolean[]{uRLArray.length > 0};
        String string2 = "classpath/execute".equals(string) ? Artifact.SCOPE_RUNTIME : null;
        String string3 = sourceGroup.getName();
        if ("2TestSourceRoot".equals(string3)) {
            string2 = "test";
        }
        final String string4 = string2;
        ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel pOMModel) {
                for (URL uRL : uRLArray) {
                    URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
                    if (uRL2 != null) {
                        FileObject fileObject = URLMapper.findFileObject((URL)uRL2);
                        assert (fileObject != null);
                        try {
                            booleanArray[0] = booleanArray[0] != false && CPExtender.this.addArchiveFile(fileObject, pOMModel, string4);
                        }
                        catch (IOException iOException) {
                            booleanArray[0] = Boolean.FALSE;
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                        continue;
                    }
                    Logger.getLogger(CPExtender.class.getName()).info("Adding non-jar root to Maven projects makes no sense. (" + uRL + ")");
                }
            }
        };
        FileObject fileObject = this.project.getProjectDirectory().getFileObject(POM_XML);
        Utilities.performPOMModelOperations((FileObject)fileObject, Collections.singletonList(modelOperation));
        if (booleanArray[0].booleanValue()) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
        }
        return booleanArray[0];
    }

    protected boolean addProjects(final Project[] projectArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        final Boolean[] booleanArray = new Boolean[]{false, false};
        String string2 = "classpath/execute".equals(string) ? Artifact.SCOPE_RUNTIME : null;
        String string3 = sourceGroup.getName();
        if ("2TestSourceRoot".equals(string3)) {
            string2 = "test";
        }
        final String string4 = string2;
        ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel pOMModel) {
                Set set = CPExtender.this.project.getOriginalMavenProject().getArtifacts();
                for (Project project : projectArray) {
                    NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
                    if (nbMavenProject != null) {
                        MavenProject mavenProject = nbMavenProject.getMavenProject();
                        String string = mavenProject.getArtifact().getId();
                        for (Artifact artifact : set) {
                            if (!artifact.getId().equals(string)) continue;
                        }
                        Dependency dependency = ModelUtils.checkModelDependency(pOMModel, mavenProject.getGroupId(), mavenProject.getArtifactId(), true);
                        dependency.setVersion(mavenProject.getVersion());
                        if (string4 != null) {
                            dependency.setScope(string4);
                        }
                        booleanArray[0] = true;
                        continue;
                    }
                    booleanArray[1] = true;
                }
            }
        };
        FileObject fileObject = this.project.getProjectDirectory().getFileObject(POM_XML);
        Utilities.performPOMModelOperations((FileObject)fileObject, Collections.singletonList(modelOperation));
        if (booleanArray[1].booleanValue()) {
            throw new UnsupportedOperationException("Attempting to add a non-Maven project dependency to a Maven project, not supported.");
        }
        return booleanArray[0];
    }

    public boolean removeRoots(URL[] uRLArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Removing binary dependencies is not supported by Maven projects.");
    }

    public boolean addAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot add Ant based projects as subprojects to Maven projects.");
    }

    public boolean removeAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot remove Ant based projects as subprojects from Maven projects.");
    }

    private void addJarToPrivateRepo(FileObject fileObject, POMModel pOMModel, String[] stringArray) throws IOException {
        String string;
        Repository repository;
        String string2;
        Repository repository22;
        List list = pOMModel.getProject().getRepositories();
        boolean bl = false;
        String string3 = null;
        if (list != null) {
            for (Repository repository22 : list) {
                if (!"unknown-jars-temp-repo".equals(repository22.getId())) continue;
                bl = true;
                string2 = repository22.getUrl();
                if (string2.startsWith("file:${project.basedir}/")) {
                    string3 = string2.substring("file:${project.basedir}/".length());
                    break;
                }
                string3 = "lib";
                break;
            }
        }
        if (!bl) {
            repository = pOMModel.getFactory().createRepository();
            repository.setId("unknown-jars-temp-repo");
            repository.setName("A temporary repository created by NetBeans for libraries and jars it could not identify. Please replace the dependencies in this repository with correct ones and delete this repository.");
            repository.setUrl("file:${project.basedir}/lib");
            pOMModel.getProject().addRepository(repository);
            string3 = "lib";
        }
        assert (string3 != null);
        repository = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), string3);
        repository22 = FileUtil.createFolder((FileObject)repository, (String)stringArray[0].replace('.', '/'));
        string2 = FileUtil.createFolder((FileObject)repository22, (String)stringArray[1]);
        FileObject fileObject2 = FileUtil.createFolder((FileObject)string2, (String)stringArray[2]);
        if (fileObject2.getFileObject(string = stringArray[1] + "-" + stringArray[2], fileObject.getExt()) == null) {
            FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)(stringArray[1] + "-" + stringArray[2]), (String)fileObject.getExt());
        }
    }
}

