/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.VariableScopeVisitor;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyOccurrencesFinder
extends OccurrencesFinder<GroovyParserResult> {
    private boolean cancelled;
    private int caretPosition;
    private Map<OffsetRange, ColoringAttributes> occurrences;
    private FileObject file;
    private static final Logger LOG = Logger.getLogger(GroovyOccurrencesFinder.class.getName());

    public Map<OffsetRange, ColoringAttributes> getOccurrences() {
        LOG.log(Level.FINEST, "getOccurrences()\n");
        return this.occurrences;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public final synchronized void cancel() {
        this.cancelled = true;
    }

    public int getPriority() {
        return 200;
    }

    public final Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void run(GroovyParserResult groovyParserResult, SchedulerEvent schedulerEvent) {
        ModuleNode moduleNode;
        LOG.log(Level.FINEST, "run()");
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        FileObject fileObject = groovyParserResult.getSnapshot().getSource().getFileObject();
        if (fileObject != this.file) {
            this.occurrences = null;
            this.file = fileObject;
        }
        if ((moduleNode = AstUtilities.getRoot(groovyParserResult)) == null) {
            return;
        }
        int n = AstUtilities.getAstOffset((Parser.Result)groovyParserResult, this.caretPosition);
        if (n == -1) {
            return;
        }
        BaseDocument baseDocument = LexUtilities.getDocument(groovyParserResult, false);
        if (baseDocument == null) {
            LOG.log(Level.FINEST, "Could not get BaseDocument. It's null");
            return;
        }
        AstPath astPath = new AstPath((ASTNode)moduleNode, n, baseDocument);
        ASTNode aSTNode = astPath.leaf();
        LOG.log(Level.FINEST, "path = {0}", astPath);
        LOG.log(Level.FINEST, "closest: {0}", aSTNode);
        if (aSTNode == null) {
            return;
        }
        HashMap<OffsetRange, Object> hashMap = new HashMap<OffsetRange, ColoringAttributes>(100);
        GroovyOccurrencesFinder.highlight(astPath, hashMap, baseDocument, this.caretPosition);
        if (this.isCancelled()) {
            return;
        }
        if (hashMap.size() > 0) {
            HashMap hashMap2 = new HashMap(2 * hashMap.size());
            for (Map.Entry entry : hashMap.entrySet()) {
                OffsetRange offsetRange = LexUtilities.getLexerOffsets(groovyParserResult, (OffsetRange)entry.getKey());
                if (offsetRange == OffsetRange.NONE) continue;
                hashMap2.put(offsetRange, entry.getValue());
            }
            hashMap = hashMap2;
            this.occurrences = hashMap;
        } else {
            this.occurrences = null;
        }
    }

    public void setCaretPosition(int n) {
        this.caretPosition = n;
        LOG.log(Level.FINEST, "\n\nsetCaretPosition() = {0}\n", n);
    }

    private static void highlight(AstPath astPath, Map<OffsetRange, ColoringAttributes> map, BaseDocument baseDocument, int n) {
        ASTNode aSTNode = astPath.root();
        assert (aSTNode instanceof ModuleNode);
        ModuleNode moduleNode = (ModuleNode)aSTNode;
        VariableScopeVisitor variableScopeVisitor = new VariableScopeVisitor(moduleNode.getContext(), astPath, baseDocument, n);
        variableScopeVisitor.collect();
        for (ASTNode aSTNode2 : variableScopeVisitor.getOccurrences()) {
            OffsetRange offsetRange;
            if (aSTNode2 instanceof AstUtilities.FakeASTNode) {
                String string = aSTNode2.getText();
                ASTNode aSTNode3 = ((AstUtilities.FakeASTNode)aSTNode2).getOriginalNode();
                int n2 = aSTNode3.getLineNumber();
                int n3 = aSTNode3.getColumnNumber();
                if (n2 > 0 && n3 > 0) {
                    int n4 = AstUtilities.getOffset(baseDocument, n2, n3);
                    offsetRange = AstUtilities.getNextIdentifierByName(baseDocument, string, n4);
                } else {
                    offsetRange = OffsetRange.NONE;
                }
            } else {
                offsetRange = AstUtilities.getRange(aSTNode2, baseDocument);
            }
            if (offsetRange == OffsetRange.NONE) continue;
            map.put(offsetRange, ColoringAttributes.MARK_OCCURRENCES);
        }
    }
}

