/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.parser;

import groovy.lang.GroovyClassLoader;
import java.io.IOException;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CancellationException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParser;
import org.netbeans.modules.groovy.editor.java.Utilities;
import org.openide.util.Exceptions;

final class CompilationUnit
extends org.codehaus.groovy.control.CompilationUnit {
    public CompilationUnit(GroovyParser groovyParser, CompilerConfiguration compilerConfiguration, CodeSource codeSource, GroovyClassLoader groovyClassLoader, JavaSource javaSource, boolean bl) {
        super(compilerConfiguration, codeSource, groovyClassLoader);
        this.ast = new CompileUnit(groovyParser, this.classLoader, codeSource, this.configuration, javaSource, bl);
    }

    private static class CompileUnit
    extends org.codehaus.groovy.ast.CompileUnit {
        private final GroovyParser parser;
        private final JavaSource javaSource;
        private final boolean waitScanFinished;
        private final Map<String, ClassNode> cache = new HashMap<String, ClassNode>();

        public CompileUnit(GroovyParser groovyParser, GroovyClassLoader groovyClassLoader, CodeSource codeSource, CompilerConfiguration compilerConfiguration, JavaSource javaSource, boolean bl) {
            super(groovyClassLoader, codeSource, compilerConfiguration);
            this.parser = groovyParser;
            this.javaSource = javaSource;
            this.waitScanFinished = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClassNode getClass(final String string) {
            ClassNode classNode;
            if (this.parser.isCancelled()) {
                throw new CancellationException();
            }
            Object object = this.cache;
            synchronized (object) {
                classNode = this.cache.get(string);
                if (classNode != null) {
                    return this.cache.get(string);
                }
            }
            classNode = super.getClass(string);
            if (classNode != null) {
                return classNode;
            }
            object = this.cache;
            synchronized (object) {
                if (this.cache.containsKey(string)) {
                    return null;
                }
            }
            try {
                if (this.getClassLoader().getResourceLoader().loadGroovySource(string) != null) {
                    return null;
                }
                object = new Task<CompilationController>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(CompilationController compilationController) throws Exception {
                        TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                        Map map = CompileUnit.this.cache;
                        synchronized (map) {
                            if (typeElement != null) {
                                CompileUnit.this.cache.put(string, CompileUnit.this.createClassNode(string, typeElement));
                            } else if (!CompileUnit.this.cache.containsKey(string)) {
                                CompileUnit.this.cache.put(string, null);
                            }
                        }
                    }
                };
                this.javaSource.runUserActionTask((Task)object, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            object = this.cache;
            synchronized (object) {
                return this.cache.get(string);
            }
        }

        private ClassNode createClassNode(String string, TypeElement typeElement) {
            int n = 0;
            ClassNode classNode = null;
            if (typeElement.getKind().isInterface()) {
                n = 512;
            } else {
                TypeMirror typeMirror;
                Stack<DeclaredType> stack = new Stack<DeclaredType>();
                while (typeElement != null && typeElement.asType().getKind() != TypeKind.NONE && (typeMirror = typeElement.getSuperclass()).getKind() == TypeKind.DECLARED) {
                    DeclaredType declaredType = (DeclaredType)typeElement.getSuperclass();
                    stack.push(declaredType);
                    Element element = declaredType.asElement();
                    if ((element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.ENUM) && element instanceof TypeElement) {
                        typeElement = (TypeElement)element;
                        continue;
                    }
                    typeElement = null;
                }
                while (!stack.empty()) {
                    classNode = this.createClassNode(((Object)Utilities.getClassName((TypeMirror)stack.pop())).toString(), 0, classNode);
                }
            }
            return this.createClassNode(string, n, classNode);
        }

        private ClassNode createClassNode(String string, int n, ClassNode classNode) {
            if ("java.lang.Object".equals(string) && classNode == null) {
                return ClassHelper.OBJECT_TYPE;
            }
            return new ClassNode(string, n, classNode);
        }
    }
}

