/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.codehaus.groovy.ast.ASTNode;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.IndexSearcher;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.elements.IndexedClass;
import org.netbeans.modules.groovy.editor.api.elements.IndexedElement;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyTypeSearcher
implements IndexSearcher {
    private static final Logger LOGGER = Logger.getLogger(GroovyTypeSearcher.class.getName());
    private static Pattern camelCasePattern = Pattern.compile("(?:\\p{javaUpperCase}(?:\\p{javaLowerCase}|\\p{Digit}|\\:|\\.|\\$)*){2,}");
    private QuerySupport.Kind cachedKind;
    private String cachedString = "/";

    public Set<? extends IndexSearcher.Descriptor> getSymbols(Project project, String string, QuerySupport.Kind kind, IndexSearcher.Helper helper) {
        return this.getTypes(project, string, kind, helper);
    }

    public Set<? extends IndexSearcher.Descriptor> getTypes(Project project, String string, QuerySupport.Kind kind, IndexSearcher.Helper helper) {
        GroovyIndex groovyIndex = GroovyIndex.get(QuerySupport.findRoots((Project)project, Collections.singleton("classpath/source"), Collections.emptySet(), Collections.emptySet()));
        if ((kind = this.adjustKind(kind, string)) == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        Set<IndexedClass> set = null;
        if (string.length() <= 0) {
            return Collections.emptySet();
        }
        set = groovyIndex.getClasses(string, kind, true, false, false, null);
        HashSet<GroovyTypeDescriptor> hashSet = new HashSet<GroovyTypeDescriptor>();
        for (IndexedClass indexedClass : set) {
            hashSet.add(new GroovyTypeDescriptor(indexedClass, helper));
        }
        return hashSet;
    }

    private static boolean isAllUpper(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c) || c == ':') continue;
            return false;
        }
        return true;
    }

    private static boolean isCamelCase(String string) {
        return camelCasePattern.matcher(string).matches();
    }

    private QuerySupport.Kind adjustKind(QuerySupport.Kind kind, String string) {
        if (string.equals(this.cachedString)) {
            return this.cachedKind;
        }
        if (kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && (GroovyTypeSearcher.isAllUpper(string) && string.length() > 1 || GroovyTypeSearcher.isCamelCase(string))) {
            kind = QuerySupport.Kind.CAMEL_CASE;
        }
        this.cachedString = string;
        this.cachedKind = kind;
        return kind;
    }

    private class GroovyTypeDescriptor
    extends IndexSearcher.Descriptor {
        private final IndexedElement element;
        private String projectName;
        private Icon projectIcon;
        private final IndexSearcher.Helper helper;
        private boolean isLibrary;

        public GroovyTypeDescriptor(IndexedElement indexedElement, IndexSearcher.Helper helper) {
            this.element = indexedElement;
            this.helper = helper;
        }

        public Icon getIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.helper.getIcon((ElementHandle)this.element);
        }

        public String getTypeName() {
            return this.element.getName();
        }

        public String getProjectName() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        private void initProjectInfo() {
            FileObject fileObject = this.element.getFileObject();
            if (fileObject != null) {
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                if (project != null) {
                    ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                    this.projectName = projectInformation.getDisplayName();
                    this.projectIcon = projectInformation.getIcon();
                }
            } else {
                this.isLibrary = true;
                LOGGER.log(Level.FINE, "No fileobject for " + this.element.toString());
            }
            if (this.projectName == null) {
                this.projectName = "";
            }
        }

        public Icon getProjectIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            if (this.isLibrary) {
                return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/groovy/support/resources/GroovyFile16x16.png", (boolean)false);
            }
            return this.projectIcon;
        }

        public FileObject getFileObject() {
            return this.element.getFileObject();
        }

        public void open() {
            ASTNode aSTNode = AstUtilities.getForeignNode(this.element);
            if (aSTNode != null) {
                try {
                    int n = AstUtilities.getRange(aSTNode, (BaseDocument)this.element.getDocument()).getStart();
                    GsfUtilities.open((FileObject)this.element.getFileObject(), (int)n, (String)this.element.getName());
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                return;
            }
            FileObject fileObject = this.element.getFileObject();
            if (fileObject == null) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(GroovyTypeSearcher.class, (String)"FileDeleted"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            this.helper.open(fileObject, (ElementHandle)this.element);
        }

        public String getContextName() {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = string = this.element.getIn() != null ? this.element.getIn() + "." + this.element.getName() : this.element.getName();
            if (this.element.getName().equals(string)) {
                string = null;
            }
            if (string != null) {
                if (string != null) {
                    stringBuilder.append(string);
                }
                return stringBuilder.toString();
            }
            return null;
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public int getOffset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getSimpleName() {
            return this.element.getName();
        }

        public String getOuterName() {
            return null;
        }
    }
}

