/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.StructureAnalyzer;
import org.netbeans.modules.groovy.editor.api.elements.AstClassElement;
import org.netbeans.modules.groovy.editor.api.elements.AstElement;
import org.netbeans.modules.groovy.editor.api.elements.AstFieldElement;
import org.netbeans.modules.groovy.editor.api.elements.AstMethodElement;
import org.netbeans.modules.groovy.editor.api.elements.IndexedElement;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.groovy.editor.java.Utilities;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyIndexer
extends EmbeddingIndexer {
    static final String FQN_NAME = "fqn";
    static final String CLASS_NAME = "class";
    static final String CASE_INSENSITIVE_CLASS_NAME = "class-ig";
    static final String IN = "in";
    static final String CLASS_ATTRS = "attrs";
    static final String METHOD_NAME = "method";
    static final String FIELD_NAME = "field";
    private static FileObject preindexedDb;
    private static long indexerRunTime;
    private static long indexerFirstRun;
    private static long filesIndexed;
    private static final Logger LOG;

    protected void index(Indexable indexable, Parser.Result result, Context context) {
        IndexingSupport indexingSupport;
        GroovyParserResult groovyParserResult;
        ModuleNode moduleNode;
        long l = System.currentTimeMillis();
        if (indexerFirstRun == 0L) {
            indexerFirstRun = l;
        }
        if ((moduleNode = AstUtilities.getRoot(groovyParserResult = AstUtilities.getParseResult(result))) == null) {
            return;
        }
        try {
            indexingSupport = IndexingSupport.getInstance((Context)context);
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
            return;
        }
        TreeAnalyzer treeAnalyzer = new TreeAnalyzer(groovyParserResult, indexingSupport, indexable);
        treeAnalyzer.analyze();
        for (IndexDocument indexDocument : treeAnalyzer.getDocuments()) {
            indexingSupport.addDocument(indexDocument);
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        LOG.log(Level.FINEST, "Indexed File                : {0}", groovyParserResult.getSnapshot().getSource().getFileObject());
        LOG.log(Level.FINEST, "Indexing time (ms)          : {0}", l3);
        LOG.log(Level.FINEST, "Number of files indexed     : {0}", ++filesIndexed);
        LOG.log(Level.FINEST, "Time spend indexing (ms)    : {0}", indexerRunTime += l3);
        LOG.log(Level.FINEST, "Avg indexing time/file (ms) : {0}", indexerRunTime / filesIndexed);
        LOG.log(Level.FINEST, "Time betw. 1st and Last idx : {0}", l2 - indexerFirstRun);
        LOG.log(Level.FINEST, "---------------------------------------------------------------------------------");
    }

    public FileObject getPreindexedDb() {
        return preindexedDb;
    }

    private static int getFieldModifiersFlag(Set<Modifier> set) {
        int n;
        int n2 = n = set.contains(Modifier.STATIC) ? 8 : 0;
        if (set.contains(Modifier.PUBLIC)) {
            n |= 1;
        } else if (set.contains(Modifier.PROTECTED)) {
            n |= 4;
        }
        return n;
    }

    private static int getMethodModifiersFlag(Set<Modifier> set) {
        int n;
        int n2 = n = set.contains(Modifier.STATIC) ? 8 : 0;
        if (set.contains(Modifier.PRIVATE)) {
            n |= 2;
        } else if (set.contains(Modifier.PROTECTED)) {
            n |= 4;
        }
        return n;
    }

    static {
        indexerRunTime = 0L;
        indexerFirstRun = 0L;
        filesIndexed = 0L;
        LOG = Logger.getLogger(GroovyIndexer.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeAnalyzer {
        private final FileObject file;
        private final IndexingSupport support;
        private final Indexable indexable;
        private final GroovyParserResult result;
        private final List<IndexDocument> documents = new ArrayList<IndexDocument>();
        private String url;
        private BaseDocument doc;

        private TreeAnalyzer(GroovyParserResult groovyParserResult, IndexingSupport indexingSupport, Indexable indexable) {
            this.result = groovyParserResult;
            this.file = groovyParserResult.getSnapshot().getSource().getFileObject();
            this.support = indexingSupport;
            this.indexable = indexable;
        }

        List<IndexDocument> getDocuments() {
            return this.documents;
        }

        public void analyze() {
            this.doc = LexUtilities.getDocument(this.result, true);
            try {
                this.url = this.file.getURL().toExternalForm();
                this.url = GroovyIndex.getPreindexUrl(this.url);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            StructureAnalyzer.AnalysisResult analysisResult = this.result.getStructure();
            List<? extends AstElement> list = analysisResult.getElements();
            if (list == null || list.size() == 0) {
                return;
            }
            for (AstElement astElement : list) {
                switch (astElement.getKind()) {
                    case CLASS: {
                        this.analyzeClass((AstClassElement)astElement);
                    }
                }
            }
        }

        private void analyzeClass(AstClassElement astClassElement) {
            IndexDocument indexDocument = this.support.createDocument(this.indexable);
            this.documents.add(indexDocument);
            this.indexClass(astClassElement, indexDocument);
            for (AstElement astElement : astClassElement.getChildren()) {
                switch (astElement.getKind()) {
                    case METHOD: {
                        this.indexMethod((AstMethodElement)astElement, indexDocument);
                        break;
                    }
                    case FIELD: {
                        this.indexField((AstFieldElement)astElement, indexDocument);
                    }
                }
            }
        }

        private void indexClass(AstClassElement astClassElement, IndexDocument indexDocument) {
            String string = astClassElement.getName();
            indexDocument.addPair(GroovyIndexer.FQN_NAME, astClassElement.getFqn(), true, true);
            indexDocument.addPair(GroovyIndexer.CLASS_NAME, string, true, true);
            indexDocument.addPair(GroovyIndexer.CASE_INSENSITIVE_CLASS_NAME, string.toLowerCase(), true, true);
        }

        private void indexField(AstFieldElement astFieldElement, IndexDocument indexDocument) {
            StringBuilder stringBuilder = new StringBuilder(astFieldElement.getName());
            FieldNode fieldNode = (FieldNode)astFieldElement.getNode();
            stringBuilder.append(';').append(Utilities.translateClassLoaderTypeName(fieldNode.getType().getName()));
            int n = GroovyIndexer.getFieldModifiersFlag(astFieldElement.getModifiers());
            if (n != 0 || astFieldElement.isProperty()) {
                stringBuilder.append(';');
                stringBuilder.append(IndexedElement.flagToFirstChar(n));
                stringBuilder.append(IndexedElement.flagToSecondChar(n));
            }
            if (astFieldElement.isProperty()) {
                stringBuilder.append(';');
                stringBuilder.append(astFieldElement.isProperty());
            }
            indexDocument.addPair(GroovyIndexer.FIELD_NAME, stringBuilder.toString(), true, true);
        }

        private void indexMethod(AstMethodElement astMethodElement, IndexDocument indexDocument) {
            MethodNode methodNode = (MethodNode)astMethodElement.getNode();
            StringBuilder stringBuilder = new StringBuilder(AstUtilities.getDefSignature(methodNode));
            stringBuilder.append(';').append(Utilities.translateClassLoaderTypeName(methodNode.getReturnType().getName()));
            Set<Modifier> set = astMethodElement.getModifiers();
            int n = GroovyIndexer.getMethodModifiersFlag(set);
            if (n != 0) {
                stringBuilder.append(';');
                stringBuilder.append(IndexedElement.flagToFirstChar(n));
                stringBuilder.append(IndexedElement.flagToSecondChar(n));
            }
            indexDocument.addPair(GroovyIndexer.METHOD_NAME, stringBuilder.toString(), true, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends EmbeddingIndexerFactory {
        public static final String NAME = "groovy";
        public static final int VERSION = 8;

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (this.isIndexable(indexable, snapshot)) {
                return new GroovyIndexer();
            }
            return null;
        }

        public int getIndexVersion() {
            return 8;
        }

        public String getIndexerName() {
            return NAME;
        }

        private boolean isIndexable(Indexable indexable, Snapshot snapshot) {
            String string = snapshot.getSource().getFileObject().getExt();
            return string.equals(NAME);
        }

        public void filesDeleted(Collection<? extends Indexable> collection, Context context) {
            try {
                IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : collection) {
                    indexingSupport.removeDocuments(indexable);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        public void filesDirty(Collection<? extends Indexable> collection, Context context) {
            try {
                IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : collection) {
                    indexingSupport.markDirtyDocuments(indexable);
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
        }
    }
}

