/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.Methods;
import org.netbeans.modules.groovy.editor.api.NbUtilities;
import org.netbeans.modules.groovy.editor.api.TypeVisitor;
import org.netbeans.modules.groovy.editor.api.VariableScopeVisitor;
import org.netbeans.modules.groovy.editor.api.elements.IndexedClass;
import org.netbeans.modules.groovy.editor.api.elements.IndexedMethod;
import org.netbeans.modules.groovy.editor.api.lexer.Call;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyDeclarationFinder
implements DeclarationFinder {
    private final Logger LOG = Logger.getLogger(GroovyDeclarationFinder.class.getName());
    Token<? extends GroovyTokenId> tok;
    Document lastDoc = null;
    int lastOffset = -1;
    OffsetRange lastRange = OffsetRange.NONE;

    public GroovyDeclarationFinder() {
        this.LOG.setLevel(Level.OFF);
    }

    public OffsetRange getReferenceSpan(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n);
        if (tokenSequence == null) {
            return OffsetRange.NONE;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return OffsetRange.NONE;
        }
        boolean bl = n == tokenSequence.offset();
        OffsetRange offsetRange = this.getReferenceSpan(tokenSequence, (TokenHierarchy<Document>)tokenHierarchy, n);
        if (offsetRange == OffsetRange.NONE && bl && tokenSequence.movePrevious()) {
            offsetRange = this.getReferenceSpan(tokenSequence, (TokenHierarchy<Document>)tokenHierarchy, n);
        }
        return offsetRange;
    }

    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult parserResult, int n) {
        block41: {
            GroovyParserResult groovyParserResult = AstUtilities.getParseResult((Parser.Result)parserResult);
            try {
                ASTNode aSTNode;
                BaseDocument baseDocument = LexUtilities.getDocument(groovyParserResult, false);
                if (baseDocument == null) {
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                BaseDocument baseDocument2 = baseDocument;
                int n2 = AstUtilities.getAstOffset((Parser.Result)parserResult, n);
                if (n2 == -1) {
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                OffsetRange offsetRange = this.getReferenceSpan((Document)baseDocument2, n);
                if (offsetRange == OffsetRange.NONE) {
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                boolean bl = offsetRange.getEnd() <= n;
                ModuleNode moduleNode = AstUtilities.getRoot(parserResult);
                GroovyIndex groovyIndex = GroovyIndex.get(QuerySupport.findRoots((FileObject)parserResult.getSnapshot().getSource().getFileObject(), Collections.singleton("classpath/source"), null, null));
                if (moduleNode == null) {
                    String string = baseDocument2.getText(offsetRange.getStart(), offsetRange.getLength());
                    if (groovyIndex == null || string.length() == 0) {
                        return DeclarationFinder.DeclarationLocation.NONE;
                    }
                    if (Character.isUpperCase(string.charAt(0))) {
                        Set<IndexedClass> set = groovyIndex.getClasses(string, QuerySupport.Kind.EXACT, true, false, false);
                        if (set.size() == 0) {
                            return DeclarationFinder.DeclarationLocation.NONE;
                        }
                        DeclarationFinder.DeclarationLocation declarationLocation = this.getClassDeclaration(groovyParserResult, set, null, null, groovyIndex, baseDocument2);
                        if (declarationLocation != null) {
                            return declarationLocation;
                        }
                    } else {
                        Set<IndexedMethod> set = groovyIndex.getMethods(string, null, QuerySupport.Kind.EXACT);
                        DeclarationFinder.DeclarationLocation declarationLocation = this.getMethodDeclaration(groovyParserResult, string, set, null, null, groovyIndex, n2, n);
                        if (declarationLocation != null) {
                            return declarationLocation;
                        }
                    }
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                int n3 = n;
                if (bl && n3 > 0) {
                    --n3;
                }
                AstPath astPath = new AstPath((ASTNode)moduleNode, n2, baseDocument2);
                ASTNode aSTNode2 = astPath.leaf();
                ASTNode aSTNode3 = astPath.leafParent();
                if (aSTNode2 instanceof ConstantExpression && aSTNode3 instanceof MethodCallExpression) {
                    Object object;
                    Object object2;
                    String string = ((ConstantExpression)aSTNode2).getText();
                    Call call = Call.getCallType(baseDocument2, (TokenHierarchy<Document>)tokenHierarchy, n);
                    String string2 = call.getType();
                    String string3 = call.getLhs();
                    MethodCallExpression methodCallExpression = (MethodCallExpression)aSTNode3;
                    Expression expression = methodCallExpression.getObjectExpression();
                    if (expression instanceof VariableExpression) {
                        ClasspathInfo classpathInfo;
                        DeclarationFinder.DeclarationLocation declarationLocation;
                        object2 = (VariableExpression)expression;
                        object = ((VariableExpression)object2).getType().getName();
                        FileObject fileObject = groovyParserResult.getSnapshot().getSource().getFileObject();
                        if (fileObject != null && (declarationLocation = GroovyDeclarationFinder.findJavaMethod(classpathInfo = ClasspathInfo.create((FileObject)fileObject), (String)object, methodCallExpression)) != DeclarationFinder.DeclarationLocation.NONE) {
                            return declarationLocation;
                        }
                    }
                    if (string2 == null && string3 != null && aSTNode2 != null && call.isSimpleIdentifier()) {
                        assert (moduleNode instanceof ModuleNode);
                        object2 = moduleNode;
                        object = new VariableScopeVisitor(((ModuleNode)object2).getContext(), astPath, baseDocument2, n);
                        ((TypeVisitor)object).collect();
                    }
                    if (string2 == null) {
                        object2 = AstUtilities.getFqnName(astPath);
                        if (call == Call.LOCAL && object2 != null && ((String)object2).length() == 0) {
                            object2 = "java.lang.Object";
                        }
                        return this.findMethod(string, (String)object2, string2, call, groovyParserResult, n2, n, astPath, aSTNode2, groovyIndex);
                    }
                    break block41;
                }
                if (aSTNode2 instanceof VariableExpression) {
                    ASTNode aSTNode4;
                    VariableExpression variableExpression = (VariableExpression)aSTNode2;
                    ASTNode aSTNode5 = AstUtilities.getScope(astPath, variableExpression);
                    if (aSTNode5 != null && (aSTNode4 = AstUtilities.getVariable(aSTNode5, variableExpression.getName(), astPath, baseDocument2, n)) != null) {
                        int n4 = AstUtilities.getRange(aSTNode4, baseDocument2).getStart();
                        return new DeclarationFinder.DeclarationLocation(parserResult.getSnapshot().getSource().getFileObject(), n4);
                    }
                    break block41;
                }
                if (aSTNode2 instanceof ConstantExpression && aSTNode3 instanceof PropertyExpression) {
                    PropertyExpression propertyExpression = (PropertyExpression)aSTNode3;
                    Expression expression = propertyExpression.getObjectExpression();
                    Expression expression2 = propertyExpression.getProperty();
                    if (expression instanceof VariableExpression && expression2 instanceof ConstantExpression) {
                        VariableExpression variableExpression = (VariableExpression)expression;
                        if ("this".equals(variableExpression.getName())) {
                            ASTNode aSTNode6;
                            ASTNode aSTNode7 = AstUtilities.getOwningClass(astPath);
                            if (aSTNode7 == null) {
                                aSTNode7 = (ModuleNode)astPath.root();
                            }
                            if ((aSTNode6 = AstUtilities.getVariable(aSTNode7, ((ConstantExpression)expression2).getText(), astPath, baseDocument2, n)) != null) {
                                int n5 = AstUtilities.getOffset(baseDocument2, aSTNode6.getLineNumber(), aSTNode6.getColumnNumber());
                                return new DeclarationFinder.DeclarationLocation(parserResult.getSnapshot().getSource().getFileObject(), n5);
                            }
                        } else {
                            ClasspathInfo classpathInfo;
                            DeclarationFinder.DeclarationLocation declarationLocation;
                            ClassNode classNode = variableExpression.getType();
                            String string = classNode.getName();
                            String string4 = ((ConstantExpression)aSTNode2).getText();
                            FileObject fileObject = groovyParserResult.getSnapshot().getSource().getFileObject();
                            if (fileObject != null && (declarationLocation = GroovyDeclarationFinder.findJavaField(classpathInfo = ClasspathInfo.create((FileObject)fileObject), string, string4)) != DeclarationFinder.DeclarationLocation.NONE) {
                                return declarationLocation;
                            }
                        }
                    }
                    break block41;
                }
                if (!(aSTNode2 instanceof DeclarationExpression) && !(aSTNode2 instanceof ConstructorCallExpression) && !(aSTNode2 instanceof ClassExpression) && !(aSTNode2 instanceof FieldNode)) break block41;
                String string = this.getFqNameForNode(aSTNode2);
                this.LOG.log(Level.FINEST, "Looking for type: {0}", string);
                if (baseDocument2 == null || offsetRange == null) break block41;
                String string5 = baseDocument2.getText(offsetRange.getStart(), offsetRange.getLength());
                Set<IndexedClass> set = groovyIndex.getClasses(string5, QuerySupport.Kind.EXACT, true, false, false);
                for (IndexedClass indexedClass : set) {
                    aSTNode = AstUtilities.getForeignNode(indexedClass);
                    if (aSTNode == null) continue;
                    OffsetRange offsetRange2 = null;
                    try {
                        offsetRange2 = AstUtilities.getRange(aSTNode, (BaseDocument)indexedClass.getDocument());
                    }
                    catch (IOException iOException) {
                        this.LOG.log(Level.FINEST, "IOException while getting destination range : {0}", iOException.getMessage());
                    }
                    if (offsetRange2 == null) continue;
                    this.LOG.log(Level.FINEST, "Found decl. for : {0}", string5);
                    this.LOG.log(Level.FINEST, "Foreign Node    : {0}", aSTNode);
                    this.LOG.log(Level.FINEST, "Range start     : {0}", offsetRange2.getStart());
                    return new DeclarationFinder.DeclarationLocation(indexedClass.getFileObject(), offsetRange2.getStart());
                }
                if (!NbUtilities.stripPackage(string).equals(string5)) {
                    this.LOG.log(Level.FINEST, "fqName != text");
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                FileObject fileObject = parserResult.getSnapshot().getSource().getFileObject();
                if (fileObject != null) {
                    IndexedClass indexedClass;
                    indexedClass = ClasspathInfo.create((FileObject)fileObject);
                    if (indexedClass != null) {
                        aSTNode = JavaSource.create((ClasspathInfo)indexedClass, (FileObject[])new FileObject[0]);
                        if (aSTNode != null) {
                            try {
                                aSTNode.runUserActionTask(new SourceLocator(string, (ClasspathInfo)indexedClass), false);
                            }
                            catch (IOException iOException) {
                                this.LOG.log(Level.FINEST, "Problem in runUserActionTask :  {0}", iOException.getMessage());
                                return null;
                            }
                        } else {
                            this.LOG.log(Level.FINEST, "javaSource == null");
                        }
                    } else {
                        this.LOG.log(Level.FINEST, "classpathinfo == null");
                    }
                } else {
                    this.LOG.log(Level.FINEST, "fileObject == null");
                }
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private String getFqNameForNode(ASTNode aSTNode) {
        if (aSTNode instanceof DeclarationExpression) {
            return ((BinaryExpression)aSTNode).getLeftExpression().getType().getName();
        }
        if (aSTNode instanceof Expression) {
            return ((Expression)aSTNode).getType().getName();
        }
        if (aSTNode instanceof FieldNode) {
            return ((FieldNode)aSTNode).getType().getName();
        }
        return "";
    }

    private OffsetRange getReferenceSpan(TokenSequence<?> tokenSequence, TokenHierarchy<Document> tokenHierarchy, int n) {
        Token token = tokenSequence.token();
        TokenId tokenId = token.id();
        if (tokenId == GroovyTokenId.IDENTIFIER && token.length() == 1 && tokenId == GroovyTokenId.IDENTIFIER && ((Object)token.text()).toString().equals(",")) {
            assert (false) : "Never planned to be here";
            return OffsetRange.NONE;
        }
        if (tokenId == GroovyTokenId.IDENTIFIER) {
            return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
        }
        return OffsetRange.NONE;
    }

    private DeclarationFinder.DeclarationLocation getClassDeclaration(GroovyParserResult groovyParserResult, Set<IndexedClass> set, AstPath astPath, ASTNode aSTNode, GroovyIndex groovyIndex, BaseDocument baseDocument) {
        IndexedClass indexedClass = this.findBestClassMatch(set, astPath, aSTNode, groovyIndex);
        if (indexedClass != null) {
            IndexedClass indexedClass2 = indexedClass;
            ASTNode aSTNode2 = AstUtilities.getForeignNode(indexedClass2);
            DeclarationFinder.DeclarationLocation declarationLocation = new DeclarationFinder.DeclarationLocation(indexedClass2.getFileObject(), AstUtilities.getOffset(baseDocument, aSTNode2.getLineNumber(), aSTNode2.getColumnNumber()), (org.netbeans.modules.csl.api.ElementHandle)indexedClass2);
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findMethod(String string, String string2, String string3, Call call, GroovyParserResult groovyParserResult, int n, int n2, AstPath astPath, ASTNode aSTNode, GroovyIndex groovyIndex) {
        Set<IndexedMethod> set = this.getApplicableMethods(string, string2, string3, call, groovyIndex);
        int n3 = n;
        DeclarationFinder.DeclarationLocation declarationLocation = this.getMethodDeclaration(groovyParserResult, string, set, astPath, aSTNode, groovyIndex, n3, n2);
        return declarationLocation;
    }

    private Set<IndexedMethod> getApplicableMethods(String string, String string2, String string3, Call call, GroovyIndex groovyIndex) {
        Set<IndexedMethod> set = new HashSet<IndexedMethod>();
        String string4 = string2;
        if (string3 == null && string2 != null && call.getLhs() == null && call != Call.UNKNOWN) {
            string4 = string2;
            if (set.size() == 0) {
                set = groovyIndex.getMethods(string, string4, QuerySupport.Kind.EXACT);
            }
            set = groovyIndex.getInheritedMethods(string4, string, QuerySupport.Kind.EXACT);
        }
        if (string3 != null && set.size() == 0) {
            string4 = string2;
            if (set.size() == 0) {
                set = groovyIndex.getInheritedMethods(string4 + "." + string3, string, QuerySupport.Kind.EXACT);
            }
            if (set.size() == 0 && (set = groovyIndex.getInheritedMethods(string3, string, QuerySupport.Kind.EXACT)).size() == 0 && string3.indexOf(".") == -1) {
                Set<IndexedClass> set2 = groovyIndex.getClasses(string3, QuerySupport.Kind.EXACT, false, false, false);
                HashSet<String> hashSet = new HashSet<String>();
                for (IndexedClass object : set2) {
                    String string5 = object.getFqn();
                    if (string5 == null) continue;
                    hashSet.add(string5);
                }
                for (String string6 : hashSet) {
                    if (string6.equals(string3)) continue;
                    set.addAll(groovyIndex.getInheritedMethods(string6, string, QuerySupport.Kind.EXACT));
                }
            }
            if (set.size() == 0) {
                int n;
                for (string4 = string2; set.size() == 0 && string4 != null && string4.length() > 0; string4 = string4.substring(0, n)) {
                    set = groovyIndex.getMethods(string, string4 + "." + string3, QuerySupport.Kind.EXACT);
                    n = string4.lastIndexOf(".");
                    if (n == -1) break;
                }
            }
        }
        if (set.size() == 0 && (set = groovyIndex.getMethods(string, string3, QuerySupport.Kind.EXACT)).size() == 0 && string3 != null) {
            set = groovyIndex.getMethods(string, null, QuerySupport.Kind.EXACT);
        }
        return set;
    }

    private DeclarationFinder.DeclarationLocation getMethodDeclaration(GroovyParserResult groovyParserResult, String string, Set<IndexedMethod> set, AstPath astPath, ASTNode aSTNode, GroovyIndex groovyIndex, int n, int n2) {
        BaseDocument baseDocument = LexUtilities.getDocument(groovyParserResult, false);
        if (baseDocument == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        IndexedMethod indexedMethod = this.findBestMethodMatch(string, set, baseDocument, n, n2, astPath, aSTNode, groovyIndex);
        if (indexedMethod != null) {
            FileObject fileObject = indexedMethod.getFileObject();
            if (fileObject == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            ASTNode aSTNode2 = AstUtilities.getForeignNode(indexedMethod);
            int n3 = aSTNode2 != null && aSTNode2.getLineNumber() > 0 && aSTNode2.getColumnNumber() > 0 ? AstUtilities.getOffset(baseDocument, aSTNode2.getLineNumber(), aSTNode2.getColumnNumber()) : 0;
            DeclarationFinder.DeclarationLocation declarationLocation = new DeclarationFinder.DeclarationLocation(fileObject, n3, (org.netbeans.modules.csl.api.ElementHandle)indexedMethod);
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    IndexedClass findBestClassMatch(Set<IndexedClass> set, AstPath astPath, ASTNode aSTNode, GroovyIndex groovyIndex) {
        HashSet<IndexedClass> hashSet = new HashSet<IndexedClass>(set);
        while (!hashSet.isEmpty()) {
            IndexedClass indexedClass = this.findBestClassMatchHelper(hashSet, astPath, aSTNode, groovyIndex);
            if (indexedClass == null) {
                return null;
            }
            ASTNode aSTNode2 = AstUtilities.getForeignNode(indexedClass);
            if (aSTNode2 != null) {
                return indexedClass;
            }
            if (!hashSet.contains(indexedClass)) {
                hashSet.remove(hashSet.iterator().next());
                continue;
            }
            hashSet.remove(indexedClass);
        }
        return null;
    }

    private IndexedClass findBestClassMatchHelper(Set<IndexedClass> set, AstPath astPath, ASTNode aSTNode, GroovyIndex groovyIndex) {
        return null;
    }

    IndexedMethod findBestMethodMatch(String string, Set<IndexedMethod> set, BaseDocument baseDocument, int n, int n2, AstPath astPath, ASTNode aSTNode, GroovyIndex groovyIndex) {
        HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>(set);
        while (!hashSet.isEmpty()) {
            ASTNode aSTNode2;
            IndexedMethod indexedMethod = this.findBestMethodMatchHelper(string, hashSet, baseDocument, n, n2, astPath, aSTNode, groovyIndex);
            ASTNode aSTNode3 = aSTNode2 = indexedMethod == null ? null : AstUtilities.getForeignNode(indexedMethod);
            if (aSTNode2 != null) {
                return indexedMethod;
            }
            if (!hashSet.contains(indexedMethod)) {
                hashSet.remove(hashSet.iterator().next());
                continue;
            }
            hashSet.remove(indexedMethod);
        }
        if (set.size() > 0) {
            return set.iterator().next();
        }
        return null;
    }

    private IndexedMethod findBestMethodMatchHelper(String string, Set<IndexedMethod> set, BaseDocument baseDocument, int n, int n2, AstPath astPath, ASTNode aSTNode, GroovyIndex groovyIndex) {
        HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>();
        if (astPath == null) {
            return null;
        }
        ASTNode aSTNode2 = astPath.leafParent();
        if (aSTNode instanceof ConstantExpression && aSTNode2 instanceof MethodCallExpression) {
            String string2 = null;
            MethodCallExpression methodCallExpression = (MethodCallExpression)aSTNode2;
            Expression expression = methodCallExpression.getObjectExpression();
            if (expression instanceof VariableExpression) {
                VariableExpression variableExpression = (VariableExpression)expression;
                string2 = "this".equals(variableExpression.getName()) ? AstUtilities.getFqnName(astPath) : variableExpression.getType().getName();
            }
            if (string2 != null) {
                for (IndexedMethod indexedMethod : set) {
                    if (!string2.equals(indexedMethod.getIn())) continue;
                    hashSet.add(indexedMethod);
                }
            }
        }
        if (hashSet.size() == 1) {
            return (IndexedMethod)hashSet.iterator().next();
        }
        if (!hashSet.isEmpty()) {
            set = hashSet;
        }
        return null;
    }

    private static DeclarationFinder.DeclarationLocation findJavaField(ClasspathInfo classpathInfo, final String string, final String string2) {
        final ElementHandle[] elementHandleArray = new ElementHandle[1];
        final int[] nArray = new int[1];
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            FileObject fileObject;
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                    if (typeElement != null) {
                        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
                            if (!variableElement.getSimpleName().contentEquals(string2)) continue;
                            elementHandleArray[0] = ElementHandle.create((Element)variableElement);
                        }
                    }
                }
            }, true);
            if (elementHandleArray[0] != null && (fileObject = SourceUtils.getFile((ElementHandle)elementHandleArray[0], (ClasspathInfo)classpathInfo)) != null) {
                javaSource = JavaSource.forFileObject((FileObject)fileObject);
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Element element = elementHandleArray[0].resolve((CompilationInfo)compilationController);
                        Trees trees = compilationController.getTrees();
                        Tree tree = trees.getTree(element);
                        SourcePositions sourcePositions = trees.getSourcePositions();
                        nArray[0] = (int)sourcePositions.getStartPosition(compilationController.getCompilationUnit(), tree);
                    }
                }, true);
                return new DeclarationFinder.DeclarationLocation(fileObject, nArray[0]);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private static DeclarationFinder.DeclarationLocation findJavaMethod(ClasspathInfo classpathInfo, final String string, final MethodCallExpression methodCallExpression) {
        final ElementHandle[] elementHandleArray = new ElementHandle[1];
        final int[] nArray = new int[1];
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            FileObject fileObject;
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                    if (typeElement != null) {
                        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                            if (!Methods.isSameMethod(executableElement, methodCallExpression)) continue;
                            elementHandleArray[0] = ElementHandle.create((Element)executableElement);
                        }
                    }
                }
            }, true);
            if (elementHandleArray[0] != null && (fileObject = SourceUtils.getFile((ElementHandle)elementHandleArray[0], (ClasspathInfo)classpathInfo)) != null) {
                javaSource = JavaSource.forFileObject((FileObject)fileObject);
                if (javaSource != null) {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            Element element = elementHandleArray[0].resolve((CompilationInfo)compilationController);
                            Trees trees = compilationController.getTrees();
                            Tree tree = trees.getTree(element);
                            SourcePositions sourcePositions = trees.getSourcePositions();
                            nArray[0] = (int)sourcePositions.getStartPosition(compilationController.getCompilationUnit(), tree);
                        }
                    }, true);
                }
                return new DeclarationFinder.DeclarationLocation(fileObject, nArray[0]);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SourceLocator
    implements Task<CompilationController> {
        String fqName;
        ClasspathInfo cpi;

        public SourceLocator(String string, ClasspathInfo classpathInfo) {
            this.fqName = string;
            this.cpi = classpathInfo;
        }

        public void run(CompilationController compilationController) throws Exception {
            Elements elements = compilationController.getElements();
            if (elements != null) {
                final TypeElement typeElement = elements.getTypeElement(this.fqName);
                if (typeElement != null) {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ElementOpen.open((ClasspathInfo)SourceLocator.this.cpi, (Element)typeElement);
                            }
                        });
                    } else {
                        ElementOpen.open((ClasspathInfo)this.cpi, (Element)typeElement);
                    }
                } else {
                    GroovyDeclarationFinder.this.LOG.log(Level.FINEST, "typeElement == null");
                }
            } else {
                GroovyDeclarationFinder.this.LOG.log(Level.FINEST, "elements == null");
            }
        }
    }
}

