/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.AstChildrenSupport;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.VariableScopeVisitor;
import org.netbeans.modules.groovy.editor.api.elements.AstElement;
import org.netbeans.modules.groovy.editor.api.elements.IndexedElement;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstUtilities {
    private static final Logger LOGGER = Logger.getLogger(AstUtilities.class.getName());

    public static int getAstOffset(Parser.Result result, int n) {
        GroovyParserResult groovyParserResult = AstUtilities.getParseResult(result);
        if (groovyParserResult != null) {
            return groovyParserResult.getSnapshot().getEmbeddedOffset(n);
        }
        return n;
    }

    public static GroovyParserResult getParseResult(Parser.Result result) {
        assert (result instanceof GroovyParserResult) : "Expecting GroovyParseResult, but have " + result;
        return (GroovyParserResult)result;
    }

    public static ModuleNode getRoot(ParserResult parserResult) {
        assert (parserResult instanceof GroovyParserResult);
        GroovyParserResult groovyParserResult = (GroovyParserResult)parserResult;
        if (groovyParserResult.getRootElement() == null) {
            return null;
        }
        return groovyParserResult.getRootElement().getModuleNode();
    }

    public static OffsetRange getRangeFull(ASTNode aSTNode, BaseDocument baseDocument) {
        int n;
        if (aSTNode.getLineNumber() < 0 || aSTNode.getColumnNumber() < 0 || aSTNode.getLastLineNumber() < 0 || aSTNode.getLastColumnNumber() < 0) {
            return OffsetRange.NONE;
        }
        int n2 = AstUtilities.getOffset(baseDocument, aSTNode.getLineNumber(), aSTNode.getColumnNumber());
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = AstUtilities.getOffset(baseDocument, aSTNode.getLastLineNumber(), aSTNode.getLastColumnNumber())) < 0) {
            n = 0;
        }
        if (n2 > n) {
            return OffsetRange.NONE;
        }
        return new OffsetRange(n2, n);
    }

    @NonNull
    public static OffsetRange getRange(ASTNode aSTNode, BaseDocument baseDocument) {
        int n = aSTNode.getLineNumber();
        int n2 = aSTNode.getColumnNumber();
        if (n < 1 || n2 < 1) {
            return OffsetRange.NONE;
        }
        if (baseDocument == null) {
            LOGGER.log(Level.INFO, "Null document in getRange()");
            return OffsetRange.NONE;
        }
        if (aSTNode instanceof FieldNode) {
            int n3 = AstUtilities.getOffset(baseDocument, n, n2);
            FieldNode fieldNode = (FieldNode)aSTNode;
            return AstUtilities.getNextIdentifierByName(baseDocument, fieldNode.getName(), n3);
        }
        if (aSTNode instanceof ClassNode) {
            if (baseDocument != null) {
                ClassNode classNode;
                int n4;
                int n5;
                int n6 = AstUtilities.getOffset(baseDocument, n, n2);
                int n7 = baseDocument.getLength();
                int n8 = n5 = aSTNode.getLastLineNumber() > 0 && aSTNode.getLastColumnNumber() > 0 ? AstUtilities.getOffset(baseDocument, aSTNode.getLastLineNumber(), aSTNode.getLastColumnNumber()) : n7;
                if (n5 > n7) {
                    n5 = n7;
                }
                try {
                    n6 = baseDocument.find((Finder)new FinderFactory.StringFwdFinder("class", true), n6, n5) + "class".length();
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
                if (n6 > n7) {
                    n6 = n7;
                }
                try {
                    n6 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n6);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                if ((n4 = n6 + (classNode = (ClassNode)aSTNode).getNameWithoutPackage().length()) > n7) {
                    n4 = n7;
                }
                if (n6 == n4) {
                    return OffsetRange.NONE;
                }
                return new OffsetRange(n6, n4);
            }
        } else {
            if (aSTNode instanceof ConstructorNode) {
                int n9 = AstUtilities.getOffset(baseDocument, n, n2);
                ConstructorNode constructorNode = (ConstructorNode)aSTNode;
                return AstUtilities.getNextIdentifierByName(baseDocument, constructorNode.getDeclaringClass().getNameWithoutPackage(), n9);
            }
            if (aSTNode instanceof MethodNode) {
                int n10 = AstUtilities.getOffset(baseDocument, n, n2);
                MethodNode methodNode = (MethodNode)aSTNode;
                return AstUtilities.getNextIdentifierByName(baseDocument, methodNode.getName(), n10);
            }
            if (aSTNode instanceof VariableExpression) {
                int n11 = AstUtilities.getOffset(baseDocument, n, n2);
                VariableExpression variableExpression = (VariableExpression)aSTNode;
                return AstUtilities.getNextIdentifierByName(baseDocument, variableExpression.getName(), n11);
            }
            if (aSTNode instanceof Parameter) {
                Parameter parameter;
                String string;
                int n12 = AstUtilities.getOffset(baseDocument, aSTNode.getLastLineNumber(), aSTNode.getLastColumnNumber());
                if (n12 - (string = (parameter = (Parameter)aSTNode).getName()).length() < 0) {
                    return OffsetRange.NONE;
                }
                return new OffsetRange(n12 - string.length(), n12);
            }
            if (aSTNode instanceof MethodCallExpression) {
                MethodCallExpression methodCallExpression = (MethodCallExpression)aSTNode;
                Expression expression = methodCallExpression.getMethod();
                n = expression.getLineNumber();
                n2 = expression.getColumnNumber();
                if (n < 1 || n2 < 1) {
                    n = 1;
                    n2 = 1;
                }
                int n13 = AstUtilities.getOffset(baseDocument, n, n2);
                return new OffsetRange(n13, n13 + methodCallExpression.getMethodAsString().length());
            }
            if (aSTNode instanceof ConstructorCallExpression) {
                ConstructorCallExpression constructorCallExpression = (ConstructorCallExpression)aSTNode;
                String string = constructorCallExpression.getType().getNameWithoutPackage();
                int n14 = AstUtilities.getOffset(baseDocument, n, n2);
                return AstUtilities.getNextIdentifierByName(baseDocument, string, n14);
            }
            if (aSTNode instanceof ClassExpression) {
                ClassExpression classExpression = (ClassExpression)aSTNode;
                String string = classExpression.getType().getNameWithoutPackage();
                int n15 = AstUtilities.getOffset(baseDocument, n, n2);
                return AstUtilities.getNextIdentifierByName(baseDocument, string, n15);
            }
            if (aSTNode instanceof ConstantExpression) {
                ConstantExpression constantExpression = (ConstantExpression)aSTNode;
                int n16 = AstUtilities.getOffset(baseDocument, n, n2);
                return new OffsetRange(n16, n16 + constantExpression.getText().length());
            }
        }
        return OffsetRange.NONE;
    }

    public static List<ASTNode> children(ASTNode aSTNode) {
        List<ASTNode> list = new ArrayList<ASTNode>();
        if (aSTNode instanceof ModuleNode) {
            ModuleNode moduleNode = (ModuleNode)aSTNode;
            list.addAll(moduleNode.getClasses());
            list.add(moduleNode.getStatementBlock());
        } else if (aSTNode instanceof ClassNode) {
            AnnotatedNode annotatedNode;
            ClassNode classNode = (ClassNode)aSTNode;
            HashSet<String> hashSet = new HashSet<String>();
            for (Object e : classNode.getProperties()) {
                annotatedNode = (PropertyNode)e;
                if (annotatedNode.getLineNumber() < 0) continue;
                list.add(annotatedNode);
                FieldNode fieldNode = ((PropertyNode)annotatedNode).getField();
                String string = fieldNode.getName();
                if (string.length() <= 0 || (fieldNode.getModifiers() & 8) != 0 || (fieldNode.getModifiers() & 2) == 0) continue;
                string = string.substring(0, 1).toUpperCase() + string.substring(1, string.length());
                if ((fieldNode.getModifiers() & 0x10) == 0) {
                    hashSet.add("set" + string);
                }
                hashSet.add("get" + string);
            }
            for (Object e : classNode.getFields()) {
                annotatedNode = (FieldNode)e;
                if (annotatedNode.getLineNumber() < 0) continue;
                list.add(annotatedNode);
            }
            for (Object e : classNode.getMethods()) {
                annotatedNode = (MethodNode)e;
                if (annotatedNode.getLineNumber() < 0 && (!annotatedNode.isSynthetic() || !hashSet.contains(((MethodNode)annotatedNode).getName()))) continue;
                list.add(annotatedNode);
            }
            for (Object e : classNode.getDeclaredConstructors()) {
                annotatedNode = (ConstructorNode)e;
                if (annotatedNode.getLineNumber() < 0) continue;
                list.add(annotatedNode);
            }
        } else if (aSTNode instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)aSTNode;
            list.add(methodNode.getCode());
            for (Parameter parameter : methodNode.getParameters()) {
                list.add(parameter);
            }
        } else if (!(aSTNode instanceof Parameter)) {
            if (aSTNode instanceof FieldNode) {
                FieldNode fieldNode = (FieldNode)aSTNode;
                Expression expression = fieldNode.getInitialExpression();
                if (expression != null) {
                    list.add(expression);
                }
            } else if (!(aSTNode instanceof PropertyNode) && aSTNode != null) {
                AstChildrenSupport astChildrenSupport = new AstChildrenSupport();
                aSTNode.visit(astChildrenSupport);
                list = astChildrenSupport.children();
            }
        }
        return list;
    }

    public static int getOffset(BaseDocument baseDocument, int n, int n2) {
        assert (n > 0) : "Line number must be at least 1 and was: " + n;
        assert (n2 > 0) : "Column number must be at least 1 ans was: " + n2;
        int n3 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n - 1));
        if ((n3 += n2 - 1) < 0) {
            n3 = 0;
        }
        return n3;
    }

    public static ASTNode getForeignNode(final IndexedElement indexedElement) {
        final ASTNode[] aSTNodeArray = new ASTNode[1];
        FileObject fileObject = indexedElement.getFileObject();
        assert (fileObject != null) : "null FileObject for IndexedElement " + indexedElement;
        try {
            Source source = Source.create((FileObject)fileObject);
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    GroovyParserResult groovyParserResult = AstUtilities.getParseResult(resultIterator.getParserResult());
                    String string = indexedElement.getSignature();
                    if (string == null) {
                        return;
                    }
                    int n = string.indexOf(35);
                    if (n != -1) {
                        string = string.substring(n + 1);
                    }
                    for (AstElement astElement : groovyParserResult.getStructure().getElements()) {
                        ASTNode aSTNode = AstUtilities.findBySignature(astElement, string);
                        if (aSTNode == null) continue;
                        aSTNodeArray[0] = aSTNode;
                        return;
                    }
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
        return aSTNodeArray[0];
    }

    private static ASTNode findBySignature(AstElement astElement, String string) {
        if (string.equals(astElement.getSignature())) {
            return astElement.getNode();
        }
        for (AstElement astElement2 : astElement.getChildren()) {
            ASTNode aSTNode = AstUtilities.findBySignature(astElement2, string);
            if (aSTNode == null) continue;
            return aSTNode;
        }
        return null;
    }

    public static String getDefSignature(MethodNode methodNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(methodNode.getName());
        Parameter[] parameterArray = methodNode.getParameters();
        if (parameterArray.length > 0) {
            stringBuilder.append('(');
            Iterator<Parameter> iterator = Arrays.asList(parameterArray).iterator();
            stringBuilder.append(org.netbeans.modules.groovy.editor.java.Utilities.translateClassLoaderTypeName(iterator.next().getType().getName()));
            while (iterator.hasNext()) {
                stringBuilder.append(',');
                stringBuilder.append(org.netbeans.modules.groovy.editor.java.Utilities.translateClassLoaderTypeName(iterator.next().getType().getName()));
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public static OffsetRange getNextIdentifierByName(final BaseDocument baseDocument, final String string, final int n) {
        final OffsetRange[] offsetRangeArray = new OffsetRange[]{OffsetRange.NONE};
        baseDocument.render(new Runnable(){

            public void run() {
                TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n);
                if (tokenSequence != null) {
                    Token token = tokenSequence.token();
                    if (token != null && token.id() == GroovyTokenId.IDENTIFIER && TokenUtilities.equals((CharSequence)token.text(), (Object)string)) {
                        int n2 = tokenSequence.offset();
                        offsetRangeArray[0] = new OffsetRange(n2, n2 + string.length());
                        return;
                    }
                    while (tokenSequence.moveNext()) {
                        token = tokenSequence.token();
                        if (token == null || token.id() != GroovyTokenId.IDENTIFIER || !TokenUtilities.equals((CharSequence)token.text(), (Object)string)) continue;
                        int n3 = tokenSequence.offset();
                        offsetRangeArray[0] = new OffsetRange(n3, n3 + string.length());
                        return;
                    }
                }
            }
        });
        return offsetRangeArray[0];
    }

    public static String getFqnName(AstPath astPath) {
        ClassNode classNode = AstUtilities.getOwningClass(astPath);
        return classNode == null ? "" : classNode.getName();
    }

    public static ClassNode getOwningClass(AstPath astPath) {
        ListIterator<ASTNode> listIterator = astPath.rootToLeaf();
        while (listIterator.hasNext()) {
            ASTNode aSTNode = (ASTNode)listIterator.next();
            if (!(aSTNode instanceof ClassNode)) continue;
            return (ClassNode)aSTNode;
        }
        return null;
    }

    public static ASTNode getScope(AstPath astPath, Variable variable) {
        for (ASTNode aSTNode : astPath) {
            Statement statement;
            Object object;
            if (aSTNode instanceof ClosureExpression) {
                object = ((ClosureExpression)aSTNode).getVariableScope();
                if (((VariableScope)object).getDeclaredVariable(variable.getName()) != null) {
                    return aSTNode;
                }
                statement = ((ClosureExpression)aSTNode).getCode();
                if (!(statement instanceof BlockStatement) || ((VariableScope)(object = ((BlockStatement)statement).getVariableScope())).getDeclaredVariable(variable.getName()) == null) continue;
                return aSTNode;
            }
            if (aSTNode instanceof MethodNode || aSTNode instanceof ConstructorNode) {
                object = ((MethodNode)aSTNode).getVariableScope();
                if (((VariableScope)object).getDeclaredVariable(variable.getName()) != null) {
                    return aSTNode;
                }
                statement = ((MethodNode)aSTNode).getCode();
                if (!(statement instanceof BlockStatement) || ((VariableScope)(object = ((BlockStatement)statement).getVariableScope())).getDeclaredVariable(variable.getName()) == null) continue;
                return aSTNode;
            }
            if (aSTNode instanceof ForStatement) {
                object = ((ForStatement)aSTNode).getVariableScope();
                if (((VariableScope)object).getDeclaredVariable(variable.getName()) == null) continue;
                return aSTNode;
            }
            if (aSTNode instanceof BlockStatement) {
                object = ((BlockStatement)aSTNode).getVariableScope();
                if (((VariableScope)object).getDeclaredVariable(variable.getName()) == null) continue;
                return aSTNode;
            }
            if (aSTNode instanceof ClosureListExpression) {
                object = ((ClosureListExpression)aSTNode).getVariableScope();
                if (((VariableScope)object).getDeclaredVariable(variable.getName()) == null) continue;
                return aSTNode;
            }
            if (aSTNode instanceof ClassNode) {
                object = (ClassNode)aSTNode;
                if (((ClassNode)object).getField(variable.getName()) == null) continue;
                return aSTNode;
            }
            if (!(aSTNode instanceof ModuleNode)) continue;
            object = (ModuleNode)aSTNode;
            statement = ((ModuleNode)object).getStatementBlock();
            VariableScope variableScope = ((BlockStatement)statement).getVariableScope();
            if (variableScope.getDeclaredVariable(variable.getName()) != null) {
                return statement;
            }
            Variable variable2 = variableScope.getReferencedClassVariable(variable.getName());
            if (variable2 == null) continue;
            return object;
        }
        return null;
    }

    public static ASTNode getVariable(ASTNode aSTNode, String string, AstPath astPath, BaseDocument baseDocument, int n) {
        if (aSTNode instanceof ClosureExpression) {
            ClosureExpression closureExpression = (ClosureExpression)aSTNode;
            for (Parameter aSTNode2 : closureExpression.getParameters()) {
                if (!string.equals(aSTNode2.getName())) continue;
                return aSTNode2;
            }
            Statement object = closureExpression.getCode();
            if (object instanceof BlockStatement) {
                return AstUtilities.getVariableInBlockStatement((BlockStatement)object, string);
            }
        } else if (aSTNode instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)aSTNode;
            for (Parameter variableScopeVisitor : methodNode.getParameters()) {
                if (!string.equals(variableScopeVisitor.getName())) continue;
                return variableScopeVisitor;
            }
            Statement parameter = methodNode.getCode();
            if (parameter instanceof BlockStatement) {
                return AstUtilities.getVariableInBlockStatement((BlockStatement)parameter, string);
            }
        } else if (aSTNode instanceof ConstructorNode) {
            ConstructorNode constructorNode = (ConstructorNode)aSTNode;
            for (Parameter parameter : constructorNode.getParameters()) {
                if (!string.equals(parameter.getName())) continue;
                return parameter;
            }
            Statement statement = constructorNode.getCode();
            if (statement instanceof BlockStatement) {
                return AstUtilities.getVariableInBlockStatement((BlockStatement)statement, string);
            }
        } else if (aSTNode instanceof ForStatement) {
            ASTNode aSTNode2;
            ASTNode aSTNode3;
            ForStatement forStatement = (ForStatement)aSTNode;
            Parameter parameter = forStatement.getVariable();
            if (string.equals(parameter.getName())) {
                return parameter;
            }
            Expression expression = forStatement.getCollectionExpression();
            if (expression instanceof ClosureListExpression && (aSTNode3 = AstUtilities.getVariableInClosureList((ClosureListExpression)expression, string)) != null) {
                return aSTNode3;
            }
            aSTNode3 = forStatement.getLoopBlock();
            if (aSTNode3 instanceof BlockStatement && (aSTNode2 = AstUtilities.getVariableInBlockStatement((BlockStatement)aSTNode3, string)) != null) {
                return aSTNode2;
            }
        } else {
            if (aSTNode instanceof BlockStatement) {
                return AstUtilities.getVariableInBlockStatement((BlockStatement)aSTNode, string);
            }
            if (aSTNode instanceof ClosureListExpression) {
                return AstUtilities.getVariableInClosureList((ClosureListExpression)aSTNode, string);
            }
            if (aSTNode instanceof ClassNode) {
                return ((ClassNode)aSTNode).getField(string);
            }
            if (aSTNode instanceof ModuleNode) {
                VariableScope variableScope;
                ModuleNode moduleNode = (ModuleNode)aSTNode;
                BlockStatement blockStatement = moduleNode.getStatementBlock();
                ASTNode aSTNode4 = AstUtilities.getVariableInBlockStatement(blockStatement, string);
                if (aSTNode4 == null && (variableScope = blockStatement.getVariableScope()).getReferencedClassVariable(string) != null) {
                    VariableScopeVisitor variableScopeVisitor = new VariableScopeVisitor(moduleNode.getContext(), astPath, baseDocument, n);
                    variableScopeVisitor.collect();
                    Set<ASTNode> set = variableScopeVisitor.getOccurrences();
                    if (!set.isEmpty()) {
                        aSTNode4 = set.iterator().next();
                    }
                }
                return aSTNode4;
            }
        }
        return null;
    }

    private static ASTNode getVariableInBlockStatement(BlockStatement blockStatement, String string) {
        for (Object e : blockStatement.getStatements()) {
            DeclarationExpression declarationExpression;
            ExpressionStatement expressionStatement;
            Expression expression;
            if (!(e instanceof ExpressionStatement) || !((expression = (expressionStatement = (ExpressionStatement)e).getExpression()) instanceof DeclarationExpression) || !string.equals((declarationExpression = (DeclarationExpression)expression).getVariableExpression().getName())) continue;
            return declarationExpression.getVariableExpression();
        }
        return null;
    }

    private static ASTNode getVariableInClosureList(ClosureListExpression closureListExpression, String string) {
        for (Object e : closureListExpression.getExpressions()) {
            DeclarationExpression declarationExpression;
            if (!(e instanceof DeclarationExpression) || !string.equals((declarationExpression = (DeclarationExpression)e).getVariableExpression().getName())) continue;
            return declarationExpression.getVariableExpression();
        }
        return null;
    }

    public static final class FakeASTNode
    extends ASTNode {
        private final String text;
        private final ASTNode orig;

        public FakeASTNode(ASTNode aSTNode, String string) {
            this.orig = aSTNode;
            this.text = string;
        }

        public ASTNode getOriginalNode() {
            return this.orig;
        }

        public String getText() {
            return this.text;
        }

        public void visit(GroovyCodeVisitor groovyCodeVisitor) {
        }
    }
}

