/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.errorstripe;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.errorstripe.AnnotationMark;
import org.netbeans.modules.editor.errorstripe.AnnotationView;
import org.netbeans.modules.editor.errorstripe.AnnotationViewData;
import org.netbeans.modules.editor.errorstripe.apimodule.SPIAccessor;
import org.netbeans.modules.editor.errorstripe.privatespi.Mark;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProviderCreator;
import org.netbeans.modules.editor.errorstripe.privatespi.Status;
import org.netbeans.spi.editor.errorstripe.UpToDateStatus;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProvider;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProviderFactory;
import org.netbeans.spi.editor.mimelookup.Class2LayerFolder;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AnnotationViewDataImpl
implements PropertyChangeListener,
AnnotationViewData,
Annotations.AnnotationsListener {
    private static final Logger LOG = Logger.getLogger(AnnotationViewDataImpl.class.getName());
    private static final String UP_TO_DATE_STATUS_PROVIDER_FOLDER_NAME = "UpToDateStatusProvider";
    private static final String TEXT_BASE_PATH = "Editors/text/base/";
    private AnnotationView view;
    private JTextComponent pane;
    private BaseDocument document;
    private List<MarkProvider> markProviders = new ArrayList<MarkProvider>();
    private List<UpToDateStatusProvider> statusProviders = new ArrayList<UpToDateStatusProvider>();
    private Collection<Mark> currentMarks = null;
    private SortedMap<Integer, List<Mark>> marksMap = null;

    public AnnotationViewDataImpl(AnnotationView annotationView, JTextComponent jTextComponent) {
        this.view = annotationView;
        this.pane = jTextComponent;
        this.document = null;
    }

    @Override
    public void register(BaseDocument baseDocument) {
        this.document = baseDocument;
        this.gatherProviders(this.pane);
        this.addListenersToProviders();
        if (baseDocument != null) {
            baseDocument.getAnnotations().addAnnotationsListener((Annotations.AnnotationsListener)this);
        }
        this.clear();
    }

    @Override
    public void unregister() {
        if (this.document != null) {
            this.document.getAnnotations().removeAnnotationsListener((Annotations.AnnotationsListener)this);
        }
        this.removeListenersFromProviders();
        this.document = null;
    }

    private void gatherProviders(JTextComponent jTextComponent) {
        long l = System.currentTimeMillis();
        MimePath mimePath = MimePath.parse((String)"text/base");
        LegacyCrapProvider legacyCrapProvider = (LegacyCrapProvider)MimeLookup.getLookup((MimePath)mimePath).lookup(LegacyCrapProvider.class);
        ArrayList<MarkProvider> arrayList = new ArrayList<MarkProvider>();
        if (legacyCrapProvider != null) {
            AnnotationViewDataImpl.createMarkProviders(legacyCrapProvider.getMarkProviderCreators(), arrayList, jTextComponent);
        }
        String string = jTextComponent.getUI().getEditorKit(jTextComponent).getContentType();
        MimePath mimePath2 = MimePath.parse((String)string);
        Collection collection = MimeLookup.getLookup((MimePath)mimePath2).lookupAll(MarkProviderCreator.class);
        AnnotationViewDataImpl.createMarkProviders(collection, arrayList, jTextComponent);
        this.markProviders = arrayList;
        ArrayList<UpToDateStatusProvider> arrayList2 = new ArrayList<UpToDateStatusProvider>();
        if (legacyCrapProvider != null) {
            AnnotationViewDataImpl.createStatusProviders(legacyCrapProvider.getUpToDateStatusProviderFactories(), arrayList2, jTextComponent);
        }
        Collection collection2 = MimeLookup.getLookup((MimePath)mimePath2).lookupAll(UpToDateStatusProviderFactory.class);
        AnnotationViewDataImpl.createStatusProviders(collection2, arrayList2, jTextComponent);
        this.statusProviders = arrayList2;
        long l2 = System.currentTimeMillis();
        if (AnnotationView.TIMING_ERR.isLoggable(1)) {
            AnnotationView.TIMING_ERR.log(1, "gather providers took: " + (l2 - l));
        }
    }

    private static void createMarkProviders(Collection<? extends MarkProviderCreator> collection, List<MarkProvider> list, JTextComponent jTextComponent) {
        for (MarkProviderCreator markProviderCreator : collection) {
            MarkProvider markProvider;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("creator = " + markProviderCreator);
            }
            if ((markProvider = markProviderCreator.createMarkProvider(jTextComponent)) == null) continue;
            list.add(markProvider);
        }
    }

    private static void createStatusProviders(Collection<? extends UpToDateStatusProviderFactory> collection, List<UpToDateStatusProvider> list, JTextComponent jTextComponent) {
        for (UpToDateStatusProviderFactory upToDateStatusProviderFactory : collection) {
            UpToDateStatusProvider upToDateStatusProvider;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("factory = " + upToDateStatusProviderFactory);
            }
            if ((upToDateStatusProvider = upToDateStatusProviderFactory.createUpToDateStatusProvider(jTextComponent.getDocument())) == null) continue;
            list.add(upToDateStatusProvider);
        }
    }

    private void addListenersToProviders() {
        for (UpToDateStatusProvider object : this.statusProviders) {
            SPIAccessor.getDefault().addPropertyChangeListener(object, (PropertyChangeListener)this);
        }
        for (MarkProvider markProvider : this.markProviders) {
            markProvider.addPropertyChangeListener(this);
        }
    }

    private void removeListenersFromProviders() {
        for (UpToDateStatusProvider object : this.statusProviders) {
            SPIAccessor.getDefault().removePropertyChangeListener(object, (PropertyChangeListener)this);
        }
        for (MarkProvider markProvider : this.markProviders) {
            markProvider.removePropertyChangeListener(this);
        }
    }

    static Collection<Mark> createMergedMarks(List<MarkProvider> list) {
        LinkedHashSet<Mark> linkedHashSet = new LinkedHashSet<Mark>();
        for (MarkProvider markProvider : list) {
            linkedHashSet.addAll(markProvider.getMarks());
        }
        return linkedHashSet;
    }

    synchronized Collection<Mark> getMergedMarks() {
        if (this.currentMarks == null) {
            this.currentMarks = AnnotationViewDataImpl.createMergedMarks(this.markProviders);
        }
        return this.currentMarks;
    }

    static List<Mark> getStatusesForLineImpl(int n, SortedMap<Integer, List<Mark>> sortedMap) {
        List list = (List)sortedMap.get(n);
        return list == null ? Collections.emptyList() : list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mark getMainMarkForBlock(int n, int n2) {
        Mark mark;
        Object object = this;
        synchronized (object) {
            mark = AnnotationViewDataImpl.getMainMarkForBlockImpl(n, n2, this.getMarkMap());
        }
        object = this.getMainMarkForBlockAnnotations(n, n2);
        if (mark == null) {
            return object;
        }
        if (object == null) {
            return mark;
        }
        if (AnnotationViewDataImpl.isMoreImportant(mark, (Mark)object)) {
            return mark;
        }
        return object;
    }

    static Mark getMainMarkForBlockImpl(int n, int n2, SortedMap<Integer, List<Mark>> sortedMap) {
        int n3 = n - 1;
        Mark mark = null;
        while ((n3 = AnnotationViewDataImpl.findNextUsedLine(n3, sortedMap)) != Integer.MAX_VALUE && n3 <= n2) {
            for (Mark mark2 : AnnotationViewDataImpl.getStatusesForLineImpl(n3, sortedMap)) {
                if (mark != null && !AnnotationViewDataImpl.isMoreImportant(mark2, mark)) continue;
                mark = mark2;
            }
        }
        return mark;
    }

    private static boolean isMoreImportant(Mark mark, Mark mark2) {
        int n = mark.getStatus().compareTo(mark2.getStatus());
        if (n == 0) {
            return mark.getPriority() < mark2.getPriority();
        }
        return n > 0;
    }

    private boolean isMoreImportant(AnnotationDesc annotationDesc, AnnotationDesc annotationDesc2) {
        AnnotationType annotationType = annotationDesc.getAnnotationTypeInstance();
        AnnotationType annotationType2 = annotationDesc2.getAnnotationTypeInstance();
        int n = annotationType.getSeverity().compareTo((Object)annotationType2.getSeverity());
        if (n == 0) {
            return annotationType.getPriority() < annotationType2.getPriority();
        }
        return n > 0;
    }

    private boolean isValidForErrorStripe(AnnotationDesc annotationDesc) {
        return annotationDesc.getAnnotationTypeInstance().getSeverity() != AnnotationType.Severity.STATUS_NONE;
    }

    private Mark getMainMarkForBlockAnnotations(int n, int n2) {
        int n3 = n;
        AnnotationDesc annotationDesc = null;
        Annotations annotations = this.document.getAnnotations();
        while ((n3 = annotations.getNextLineWithAnnotation(n3)) <= n2 && n3 != -1) {
            AnnotationDesc annotationDesc2 = annotations.getActiveAnnotation(n3);
            if (annotationDesc2 != null && (annotationDesc == null || this.isMoreImportant(annotationDesc2, annotationDesc)) && this.isValidForErrorStripe(annotationDesc2)) {
                annotationDesc = annotationDesc2;
            }
            if (annotations.getNumberOfAnnotations(n3) > 1) {
                AnnotationDesc[] annotationDescArray = annotations.getPasiveAnnotations(n3);
                for (int i = 0; i < annotationDescArray.length; ++i) {
                    if (annotationDesc != null && !this.isMoreImportant(annotationDescArray[i], annotationDesc) || !this.isValidForErrorStripe(annotationDescArray[i])) continue;
                    annotationDesc = annotationDescArray[i];
                }
            }
            ++n3;
        }
        if (annotationDesc != null) {
            return new AnnotationMark(annotationDesc);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findNextUsedLine(int n) {
        int n2;
        AnnotationViewDataImpl annotationViewDataImpl = this;
        synchronized (annotationViewDataImpl) {
            n2 = AnnotationViewDataImpl.findNextUsedLine(n, this.getMarkMap());
        }
        int n3 = this.document.getAnnotations().getNextLineWithAnnotation(n + 1);
        if (n3 == -1) {
            n3 = Integer.MAX_VALUE;
        }
        return n2 < n3 ? n2 : n3;
    }

    static int findNextUsedLine(int n, SortedMap<Integer, List<Mark>> sortedMap) {
        SortedMap<Integer, List<Mark>> sortedMap2 = sortedMap.tailMap(n + 1);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("AnnotationView.findNextUsedLine from: " + n + "; marks: " + sortedMap + "; next: " + sortedMap2);
        }
        if (sortedMap2.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        return sortedMap2.firstKey();
    }

    private void registerMark(Mark mark) {
        int[] nArray = mark.getAssignedLines();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("AnnotationView.registerMark mark: " + mark + "; from-to: " + nArray[0] + "-" + nArray[1]);
        }
        for (int i = nArray[0]; i <= nArray[1]; ++i) {
            ArrayList<Mark> arrayList = (ArrayList<Mark>)this.marksMap.get(i);
            if (arrayList == null) {
                arrayList = new ArrayList<Mark>();
                this.marksMap.put(i, arrayList);
            }
            arrayList.add(mark);
        }
    }

    private void unregisterMark(Mark mark) {
        int[] nArray = mark.getAssignedLines();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("AnnotationView.unregisterMark mark: " + mark + "; from-to: " + nArray[0] + "-" + nArray[1]);
        }
        for (int i = nArray[0]; i <= nArray[1]; ++i) {
            List list = (List)this.marksMap.get(i);
            if (list == null) continue;
            list.remove(mark);
            if (list.size() != 0) continue;
            this.marksMap.remove(i);
        }
    }

    synchronized SortedMap<Integer, List<Mark>> getMarkMap() {
        if (this.marksMap == null) {
            Collection<Mark> collection = this.getMergedMarks();
            this.marksMap = new TreeMap<Integer, List<Mark>>();
            for (Mark mark : collection) {
                this.registerMark(mark);
            }
        }
        return this.marksMap;
    }

    @Override
    public Status computeTotalStatus() {
        Status status;
        Status status2 = Status.STATUS_OK;
        Collection<Mark> collection = this.getMergedMarks();
        for (Mark mark : collection) {
            status = mark.getStatus();
            status2 = Status.getCompoundStatus(status, status2);
        }
        Annotations annotations = this.document.getAnnotations();
        int n = -1;
        while ((n = annotations.getNextLineWithAnnotation(n)) != -1) {
            AnnotationDesc[] annotationDescArray;
            status = annotations.getActiveAnnotation(n);
            if (status != null && (annotationDescArray = AnnotationViewDataImpl.get(status.getAnnotationTypeInstance())) != null) {
                status2 = Status.getCompoundStatus((Status)annotationDescArray, status2);
            }
            if ((annotationDescArray = annotations.getPasiveAnnotations(n)) != null) {
                for (int i = 0; i < annotationDescArray.length; ++i) {
                    Status status3 = AnnotationViewDataImpl.get(annotationDescArray[i].getAnnotationTypeInstance());
                    if (status3 == null) continue;
                    status2 = Status.getCompoundStatus(status3, status2);
                }
            }
            ++n;
        }
        return status2;
    }

    @Override
    public UpToDateStatus computeTotalStatusType() {
        if (this.statusProviders.isEmpty()) {
            return UpToDateStatus.UP_TO_DATE_DIRTY;
        }
        UpToDateStatus upToDateStatus = UpToDateStatus.UP_TO_DATE_OK;
        for (UpToDateStatusProvider upToDateStatusProvider : this.statusProviders) {
            UpToDateStatus upToDateStatus2 = upToDateStatusProvider.getUpToDate();
            if (upToDateStatus2.compareTo((Object)upToDateStatus) <= 0) continue;
            upToDateStatus = upToDateStatus2;
        }
        return upToDateStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("marks".equals(propertyChangeEvent.getPropertyName())) {
            AnnotationViewDataImpl annotationViewDataImpl = this;
            synchronized (annotationViewDataImpl) {
                List<Mark> list = (List<Mark>)propertyChangeEvent.getNewValue();
                Collection collection = (Collection)propertyChangeEvent.getOldValue();
                if (list == null && propertyChangeEvent.getSource() instanceof MarkProvider) {
                    list = ((MarkProvider)propertyChangeEvent.getSource()).getMarks();
                }
                if (collection != null && list != null) {
                    LinkedHashSet linkedHashSet = new LinkedHashSet(list);
                    LinkedHashSet linkedHashSet2 = new LinkedHashSet(collection);
                    linkedHashSet.removeAll(collection);
                    linkedHashSet2.removeAll(list);
                    if (this.marksMap != null) {
                        for (Mark mark : linkedHashSet2) {
                            this.unregisterMark(mark);
                        }
                        for (Mark mark : linkedHashSet) {
                            this.registerMark(mark);
                        }
                    }
                    if (this.currentMarks != null) {
                        this.currentMarks.removeAll(linkedHashSet2);
                        this.currentMarks.addAll(linkedHashSet);
                    }
                    this.view.fullRepaint();
                } else {
                    LOG.warning("For performance reasons, the providers should fill both old and new value in property changes. Problematic event: " + propertyChangeEvent);
                    this.clear();
                    this.view.fullRepaint();
                }
                return;
            }
        }
        if ("upToDate".equals(propertyChangeEvent.getPropertyName())) {
            this.view.fullRepaint(false);
            return;
        }
    }

    @Override
    public synchronized void clear() {
        this.currentMarks = null;
        this.marksMap = null;
    }

    @Override
    public int[] computeErrorsAndWarnings() {
        Status status;
        int n = 0;
        int n2 = 0;
        Collection<Mark> collection = this.getMergedMarks();
        for (Mark mark : collection) {
            status = mark.getStatus();
            n += status == Status.STATUS_ERROR ? 1 : 0;
            n2 += status == Status.STATUS_WARNING ? 1 : 0;
        }
        Annotations annotations = this.document.getAnnotations();
        int n3 = -1;
        while ((n3 = annotations.getNextLineWithAnnotation(n3)) != -1) {
            AnnotationDesc[] annotationDescArray;
            status = annotations.getActiveAnnotation(n3);
            if (status != null && (annotationDescArray = AnnotationViewDataImpl.get(status.getAnnotationTypeInstance())) != null) {
                n += annotationDescArray == Status.STATUS_ERROR ? 1 : 0;
                n2 += annotationDescArray == Status.STATUS_WARNING ? 1 : 0;
            }
            if (annotations.getNumberOfAnnotations(n3) > 1) {
                annotationDescArray = annotations.getPasiveAnnotations(n3);
                for (int i = 0; i < annotationDescArray.length; ++i) {
                    Status status2 = AnnotationViewDataImpl.get(annotationDescArray[i].getAnnotationTypeInstance());
                    if (status2 == null) continue;
                    n += status2 == Status.STATUS_ERROR ? 1 : 0;
                    n2 += status2 == Status.STATUS_WARNING ? 1 : 0;
                }
            }
            ++n3;
        }
        return new int[]{n, n2};
    }

    public void changedLine(int n) {
        this.changedAll();
    }

    public void changedAll() {
        this.view.fullRepaint(false);
    }

    static Status get(AnnotationType.Severity severity) {
        if (severity == AnnotationType.Severity.STATUS_ERROR) {
            return Status.STATUS_ERROR;
        }
        if (severity == AnnotationType.Severity.STATUS_WARNING) {
            return Status.STATUS_WARNING;
        }
        if (severity == AnnotationType.Severity.STATUS_OK) {
            return Status.STATUS_OK;
        }
        return null;
    }

    static Status get(AnnotationType annotationType) {
        return AnnotationViewDataImpl.get(annotationType.getSeverity());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LegacyCrapProvider
    implements Class2LayerFolder,
    InstanceProvider {
        private final List<FileObject> instanceFiles;
        private List<MarkProviderCreator> creators;
        private List<UpToDateStatusProviderFactory> factories;

        public LegacyCrapProvider() {
            this(null);
        }

        public LegacyCrapProvider(List<FileObject> list) {
            this.instanceFiles = list;
        }

        public Collection<? extends MarkProviderCreator> getMarkProviderCreators() {
            if (this.creators == null) {
                this.computeInstances();
            }
            return this.creators;
        }

        public Collection<? extends UpToDateStatusProviderFactory> getUpToDateStatusProviderFactories() {
            if (this.factories == null) {
                this.computeInstances();
            }
            return this.factories;
        }

        public Class getClazz() {
            return LegacyCrapProvider.class;
        }

        public String getLayerFolderName() {
            return AnnotationViewDataImpl.UP_TO_DATE_STATUS_PROVIDER_FOLDER_NAME;
        }

        public InstanceProvider getInstanceProvider() {
            return new LegacyCrapProvider();
        }

        public Object createInstance(List list) {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (Object e : list) {
                FileObject fileObject = null;
                if (!(e instanceof FileObject)) continue;
                fileObject = (FileObject)e;
                String string = fileObject.getPath();
                int n = string.lastIndexOf(AnnotationViewDataImpl.UP_TO_DATE_STATUS_PROVIDER_FOLDER_NAME);
                assert (n != -1) : "Expecting files with 'UpToDateStatusProvider' in the path: " + string;
                String string2 = string.substring(0, n);
                if (!AnnotationViewDataImpl.TEXT_BASE_PATH.equals(string2)) continue;
                arrayList.add(fileObject);
                if (!LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("The 'text/base' mime type is deprecated, please move your file to the root. Offending file: " + string);
            }
            return new LegacyCrapProvider(arrayList);
        }

        private void computeInstances() {
            ArrayList<MarkProviderCreator> arrayList = new ArrayList<MarkProviderCreator>();
            ArrayList<UpToDateStatusProviderFactory> arrayList2 = new ArrayList<UpToDateStatusProviderFactory>();
            for (FileObject fileObject : this.instanceFiles) {
                if (!fileObject.isValid() || !fileObject.isData()) continue;
                try {
                    MarkProviderCreator markProviderCreator;
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    InstanceCookie instanceCookie = (InstanceCookie)dataObject.getLookup().lookup(InstanceCookie.class);
                    if (instanceCookie == null) continue;
                    if (MarkProviderCreator.class.isAssignableFrom(instanceCookie.instanceClass())) {
                        markProviderCreator = (MarkProviderCreator)instanceCookie.instanceCreate();
                        arrayList.add(markProviderCreator);
                        continue;
                    }
                    if (!UpToDateStatusProviderFactory.class.isAssignableFrom(instanceCookie.instanceClass())) continue;
                    markProviderCreator = (UpToDateStatusProviderFactory)instanceCookie.instanceCreate();
                    arrayList2.add((UpToDateStatusProviderFactory)markProviderCreator);
                }
                catch (Exception exception) {
                    LOG.log(Level.WARNING, null, exception);
                }
            }
            this.creators = arrayList;
            this.factories = arrayList2;
        }
    }

    public static final class MarkProviderCreatorsProvider
    implements Class2LayerFolder {
        public Class getClazz() {
            return MarkProviderCreator.class;
        }

        public String getLayerFolderName() {
            return AnnotationViewDataImpl.UP_TO_DATE_STATUS_PROVIDER_FOLDER_NAME;
        }

        public InstanceProvider getInstanceProvider() {
            return null;
        }
    }

    public static final class UpToDateStatusProviderFactoriesProvider
    implements Class2LayerFolder {
        public Class getClazz() {
            return UpToDateStatusProviderFactory.class;
        }

        public String getLayerFolderName() {
            return AnnotationViewDataImpl.UP_TO_DATE_STATUS_PROVIDER_FOLDER_NAME;
        }

        public InstanceProvider getInstanceProvider() {
            return null;
        }
    }
}

