/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.vcs.FormatPanel;
import org.netbeans.modules.bugtracking.vcs.HookPanel;
import org.netbeans.modules.bugtracking.vcs.VCSHooksConfig;
import org.netbeans.modules.mercurial.hooks.spi.HgHook;
import org.netbeans.modules.mercurial.hooks.spi.HgHookContext;
import org.openide.util.NbBundle;

public class HgHookImpl
extends HgHook {
    private HookPanel panel;
    private final String name = NbBundle.getMessage(HgHookImpl.class, (String)"LBL_VCSHook");
    private static Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.vcshooks.HgHook");
    private static final SimpleDateFormat CC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public HgHookContext beforeCommit(HgHookContext hgHookContext) throws IOException {
        Repository repository = this.panel.getSelectedRepository();
        if (hgHookContext.getFiles().length == 0) {
            if (repository != null) {
                BugtrackingOwnerSupport.getInstance().setLooseAssociation(BugtrackingOwnerSupport.ContextType.MAIN_OR_SINGLE_PROJECT, repository);
            }
            LOG.warning("calling hg beforeCommit for zero files");
            return null;
        }
        if (repository != null) {
            BugtrackingOwnerSupport.getInstance().setFirmAssociations(hgHookContext.getFiles(), repository);
        }
        File file = hgHookContext.getFiles()[0];
        LOG.log(Level.FINE, "hg beforeCommit start for " + file);
        if (this.panel.addIssueCheckBox.isSelected()) {
            String string = hgHookContext.getMessage();
            VCSHooksConfig.Format format = VCSHooksConfig.getInstance().getHgIssueFormat();
            String string2 = format.getFormat();
            string2 = string2.replaceAll("\\{id\\}", "\\{0\\}");
            string2 = string2.replaceAll("\\{summary\\}", "\\{1\\}");
            Issue issue = this.panel.getIssue();
            if (issue == null) {
                LOG.log(Level.FINE, " no issue set for " + file);
                return null;
            }
            String string3 = new MessageFormat(string2).format(new Object[]{issue.getID(), issue.getSummary()}, new StringBuffer(), (FieldPosition)null).toString();
            LOG.log(Level.FINER, " svn commit hook issue info '" + string3 + "'");
            string = format.isAbove() ? string3 + "\n" + string : string + "\n" + string3;
            hgHookContext = new HgHookContext(hgHookContext.getFiles(), string, hgHookContext.getLogEntries());
            return hgHookContext;
        }
        return super.beforeCommit(hgHookContext);
    }

    public void afterCommit(HgHookContext hgHookContext) {
        if (hgHookContext.getFiles().length == 0) {
            LOG.warning("calling hg afterCommit for zero files");
            return;
        }
        File file = hgHookContext.getFiles()[0];
        LOG.log(Level.FINE, "hg afterCommit start for " + file);
        if (!(this.panel.addCommentCheckBox.isSelected() || this.panel.addRevisionCheckBox.isSelected() || this.panel.resolveCheckBox.isSelected())) {
            LOG.log(Level.FINER, " nothing to do in hg afterCommit for " + file);
            return;
        }
        Issue issue = this.panel.getIssue();
        if (issue == null) {
            LOG.log(Level.FINE, " no issue set for " + file);
            return;
        }
        String string = hgHookContext.getMessage();
        if (!this.panel.addCommentCheckBox.isSelected() || string == null || string.trim().equals("")) {
            string = null;
        }
        if (this.panel.addRevisionCheckBox.isSelected()) {
            String string2 = hgHookContext.getLogEntries()[0].getAuthor();
            String string3 = hgHookContext.getLogEntries()[0].getChangeset();
            Date date = hgHookContext.getLogEntries()[0].getDate();
            String string4 = hgHookContext.getLogEntries()[0].getMessage();
            String string5 = VCSHooksConfig.getInstance().getHgCommentFormat().getFormat();
            string5 = string5.replaceAll("\\{changeset\\}", "\\{0\\}");
            string5 = string5.replaceAll("\\{author\\}", "\\{1\\}");
            string5 = string5.replaceAll("\\{date\\}", "\\{2\\}");
            string5 = string5.replaceAll("\\{message\\}", "\\{3\\}");
            string = new MessageFormat(string5).format(new Object[]{string3, string2, date != null ? CC_DATE_FORMAT.format(date) : "", string4}, new StringBuffer(), (FieldPosition)null).toString();
            LOG.log(Level.FINER, " hg afterCommit message '" + string + "'");
        }
        if (this.panel.commitRadioButton.isSelected()) {
            issue.addComment(string, this.panel.resolveCheckBox.isSelected());
            issue.open();
        } else {
            VCSHooksConfig.getInstance().setHgPushAction(hgHookContext.getLogEntries()[0].getChangeset(), new VCSHooksConfig.PushAction(issue.getID(), string, this.panel.resolveCheckBox.isSelected()));
            LOG.log(Level.FINE, "schedulig issue  " + file);
        }
        LOG.log(Level.FINE, "hg afterCommit end for " + file);
    }

    public HgHookContext beforePush(HgHookContext hgHookContext) throws IOException {
        return super.beforePush(hgHookContext);
    }

    public void afterPush(HgHookContext hgHookContext) {
        HgHookContext.LogEntry[] logEntryArray;
        if (hgHookContext.getFiles().length == 0) {
            LOG.warning("calling after push for zero files");
            return;
        }
        File file = hgHookContext.getFiles()[0];
        LOG.log(Level.FINE, "push hook start for " + file);
        Repository repository = BugtrackingOwnerSupport.getInstance().getRepository(file, true);
        if (repository == null) {
            LOG.log(Level.FINE, " could not find issue tracker for " + file);
            return;
        }
        for (HgHookContext.LogEntry logEntry : logEntryArray = hgHookContext.getLogEntries()) {
            VCSHooksConfig.PushAction pushAction = VCSHooksConfig.getInstance().popHGPushAction(logEntry.getChangeset());
            if (pushAction == null) {
                LOG.log(Level.FINE, " no push hook scheduled for " + file);
                continue;
            }
            Issue issue = repository.getIssue(pushAction.getIssueID());
            if (issue == null) {
                LOG.log(Level.FINE, " no issue found with id " + pushAction.getIssueID());
                continue;
            }
            issue.addComment(pushAction.getMsg(), this.panel.resolveCheckBox.isSelected());
        }
        LOG.log(Level.FINE, "push hook end for " + file);
    }

    public JPanel createComponent(HgHookContext hgHookContext) {
        Repository[] repositoryArray = BugtrackingUtil.getKnownRepositories();
        if (hgHookContext.getFiles().length == 0) {
            LOG.warning("creating hg hook component for zero files");
            Repository repository = BugtrackingOwnerSupport.getInstance().getRepository(BugtrackingOwnerSupport.ContextType.ALL_PROJECTS);
            this.panel = new HookPanel(repositoryArray, repository);
        } else {
            File file = hgHookContext.getFiles()[0];
            Repository repository = BugtrackingOwnerSupport.getInstance().getRepository(file, false);
            if (repository == null) {
                LOG.log(Level.FINE, " could not find issue tracker for " + file);
            }
            this.panel = new HookPanel(repositoryArray, repository);
        }
        this.panel.changeRevisionFormatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HgHookImpl.this.onShowRevisionFormat();
            }
        });
        this.panel.changeIssueFormatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HgHookImpl.this.onShowIssueFormat();
            }
        });
        return this.panel;
    }

    public String getDisplayName() {
        return this.name;
    }

    private void onShowRevisionFormat() {
        FormatPanel formatPanel = new FormatPanel(VCSHooksConfig.getInstance().getHgCommentFormat());
        if (BugtrackingUtil.show((JPanel)formatPanel, (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_FormatTitle"), (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_OK"))) {
            VCSHooksConfig.getInstance().setHgCommentFormat(formatPanel.getFormat());
        }
    }

    private void onShowIssueFormat() {
        FormatPanel formatPanel = new FormatPanel(VCSHooksConfig.getInstance().getHgIssueFormat());
        if (BugtrackingUtil.show((JPanel)formatPanel, (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_FormatTitle"), (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_OK"))) {
            VCSHooksConfig.getInstance().setHgIssueFormat(formatPanel.getFormat());
        }
    }
}

