/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.bridge.exportdiff;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchComboBar;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.versioning.util.WideButton;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AttachPanel
extends JPanel
implements ItemListener,
PropertyChangeListener {
    private QuickSearchComboBar qs;
    private PropertyChangeListener issueListener;
    private ButtonGroup buttonGroup1;
    private JLabel descriptionLabel;
    final JTextField descriptionTextField = new JTextField();
    private JLabel issueLabel;
    private JPanel issuePanel;
    private WideButton jButton2;
    private JLabel jLabel2;
    private JPanel jPanel1;
    final JComboBox repositoryComboBox = new JComboBox();
    private JLabel repositoryLabel;

    public AttachPanel(PropertyChangeListener propertyChangeListener) {
        this.initComponents();
        this.issueListener = propertyChangeListener;
        this.qs = new QuickSearchComboBar((JPanel)this);
        this.issuePanel.add((Component)this.qs, "North");
        this.issueLabel.setLabelFor(this.qs.getCommand());
    }

    void init(Repository[] repositoryArray, Repository repository) {
        this.repositoryComboBox.setModel(new DefaultComboBoxModel<Repository>(repositoryArray != null ? repositoryArray : new Repository[]{}));
        this.repositoryComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object != null) {
                    Repository repository = (Repository)object;
                    object = repository.getDisplayName();
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        this.repositoryComboBox.addItemListener(this);
        if (repository != null) {
            this.repositoryComboBox.setSelectedItem(repository);
            this.qs.setRepository(repository);
        } else if (this.repositoryComboBox.getItemCount() > 0) {
            Repository repository2 = (Repository)this.repositoryComboBox.getItemAt(0);
            this.repositoryComboBox.setSelectedItem(repository2);
            this.qs.setRepository(repository2);
        }
        this.enableFields();
    }

    Issue getIssue() {
        return this.qs.getIssue();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.repositoryLabel = new JLabel();
        this.jButton2 = new WideButton();
        this.issueLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.issuePanel = new JPanel();
        this.descriptionLabel = new JLabel();
        this.repositoryLabel.setLabelFor(this.repositoryComboBox);
        Mnemonics.setLocalizedText((JLabel)this.repositoryLabel, (String)NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.repositoryLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.jButton2.text"));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttachPanel.this.jButton2ActionPerformed(actionEvent);
            }
        });
        this.repositoryComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((JLabel)this.issueLabel, (String)NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.issueLabel.text"));
        this.jLabel2.setForeground(UIManager.getDefaults().getColor("Button.disabledText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.jLabel2.text"));
        this.issuePanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.issuePanel, -1, -1, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.issuePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jLabel2)));
        this.descriptionLabel.setLabelFor(this.descriptionTextField);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.descriptionLabel.text"));
        this.descriptionTextField.setColumns(30);
        this.descriptionTextField.setText(NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.descriptionTextField.text"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.repositoryLabel).add((Component)this.issueLabel).add((Component)this.descriptionLabel)).add(8, 8, 8).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.repositoryComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jButton2, -2, -1, -2).add(0, 0, 0)).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addPreferredGap(0).add((Component)this.descriptionTextField)))));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.repositoryLabel).add((Component)this.repositoryComboBox, -2, -1, -2).add((Component)this.jButton2, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.issueLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.descriptionTextField, -2, -1, -2).add((Component)this.descriptionLabel))));
        this.jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.jButton2.AccessibleContext.accessibleDescription"));
        this.repositoryComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.repositoryComboBox.AccessibleContext.accessibleDescription"));
        this.descriptionTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.descriptionTextField.AccessibleContext.accessibleDescription"));
    }

    private void jButton2ActionPerformed(ActionEvent actionEvent) {
        Repository repository = BugtrackingUtil.createRepository();
        if (repository == null) {
            return;
        }
        this.repositoryComboBox.addItem(repository);
        this.repositoryComboBox.setSelectedItem(repository);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Repository repository;
        this.enableFields();
        if (itemEvent.getStateChange() == 1 && (repository = (Repository)itemEvent.getItem()) != null) {
            this.qs.setRepository(repository);
        }
    }

    public void addNotify() {
        this.qs.addPropertyChangeListener((PropertyChangeListener)this);
        this.qs.addPropertyChangeListener(this.issueListener);
        super.addNotify();
    }

    public void removeNotify() {
        this.qs.removePropertyChangeListener((PropertyChangeListener)this);
        this.qs.removePropertyChangeListener(this.issueListener);
        super.removeNotify();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(QuickSearchComboBar.EVT_ISSUE_CHANGED)) {
            this.enableFields();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.enableFields(bl);
        this.repositoryLabel.setEnabled(bl);
        this.repositoryComboBox.setEnabled(bl);
    }

    private void enableFields() {
        this.enableFields(true);
    }

    private void enableFields(boolean bl) {
        boolean bl2 = this.repositoryComboBox.getSelectedItem() != null;
        boolean bl3 = this.getIssue() != null && bl2;
        this.descriptionTextField.setEnabled(bl3 && bl);
        this.descriptionLabel.setEnabled(bl3 && bl);
        this.issueLabel.setEnabled(bl2 && bl);
        this.qs.enableFields(bl2 && bl);
    }
}

