/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.editor.CssHelpResolver;
import org.netbeans.modules.css.editor.CssPropertyValue;
import org.netbeans.modules.css.editor.LexerUtils;
import org.netbeans.modules.css.editor.Property;
import org.netbeans.modules.css.editor.PropertyModel;
import org.netbeans.modules.css.editor.model.HtmlTags;
import org.netbeans.modules.css.gsf.CssElement;
import org.netbeans.modules.css.gsf.CssPropertyElement;
import org.netbeans.modules.css.gsf.CssValueElement;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.lexer.api.CssTokenId;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.util.ImageUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssCompletion
implements CodeCompletionHandler {
    private final PropertyModel PROPERTIES = PropertyModel.instance();
    private static final Collection<String> AT_RULES = Arrays.asList("@media", "@page", "@import", "@charset", "@font-face");
    private final HashMap<String, String> colors = new HashMap(20);

    public CodeCompletionResult complete(CodeCompletionContext codeCompletionContext) {
        CssParserResult cssParserResult = (CssParserResult)codeCompletionContext.getParserResult();
        Snapshot snapshot = cssParserResult.getSnapshot();
        int n = codeCompletionContext.getCaretOffset();
        String string = codeCompletionContext.getPrefix() != null ? codeCompletionContext.getPrefix() : "";
        TokenHierarchy tokenHierarchy = snapshot.getTokenHierarchy();
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(CssTokenId.language());
        assert (tokenSequence != null);
        int n2 = n - string.length();
        int n3 = snapshot.getEmbeddedOffset(n2);
        if (n3 == -1) {
            return null;
        }
        tokenSequence.move(n3);
        boolean bl = tokenSequence.moveNext();
        SimpleNode simpleNode = cssParserResult.root();
        if (simpleNode == null) {
            return CodeCompletionResult.NONE;
        }
        int n4 = snapshot.getEmbeddedOffset(n);
        SimpleNode simpleNode2 = SimpleNodeUtil.findDescendant(simpleNode, n4);
        if (simpleNode2 == null) {
            if (bl && tokenSequence.token().text().charAt(0) == '@') {
                return this.wrapRAWValues(AT_RULES, CompletionItemKind.VALUE, tokenSequence.offset());
            }
            return CodeCompletionResult.NONE;
        }
        if (simpleNode2.kind() == 36 && (simpleNode2 = (SimpleNode)simpleNode2.jjtGetParent()) == null) {
            return CodeCompletionResult.NONE;
        }
        if (simpleNode2.kind() == 1) {
            ArrayList<CompletionProposal> arrayList = new ArrayList<CompletionProposal>();
            arrayList.addAll(this.wrapRAWValues(AT_RULES, CompletionItemKind.VALUE, n).getItems());
            arrayList.addAll(this.completeHtmlSelectors(string, n));
            return new DefaultCompletionResult(arrayList, false);
        }
        if (simpleNode2.kind() == 7) {
            return new DefaultCompletionResult(this.completeHtmlSelectors(string, n), false);
        }
        if (simpleNode2.kind() == 38) {
            SimpleNode simpleNode3 = (SimpleNode)simpleNode2.jjtGetParent();
            if (simpleNode3 != null && simpleNode3.kind() == 5) {
                Collection<String> collection = this.filterStrings(AT_RULES, string);
                return this.wrapRAWValues(collection, CompletionItemKind.VALUE, snapshot.getOriginalOffset(simpleNode3.startOffset()));
            }
        } else if (simpleNode2.kind() == 6 || simpleNode2.kind() == 7 || simpleNode2.kind() == 12 || simpleNode2.kind() == 4 || simpleNode2.kind() == 14) {
            TokenId tokenId;
            if (bl && ((tokenId = tokenSequence.token().id()) == CssTokenId.IMPORT_SYM || tokenId == CssTokenId.MEDIA_SYM || tokenId == CssTokenId.PAGE_SYM || tokenId == CssTokenId.CHARSET_SYM || tokenId == CssTokenId.FONT_FACE_SYM)) {
                Collection<String> collection = this.filterStrings(AT_RULES, string);
                return this.wrapRAWValues(collection, CompletionItemKind.VALUE, snapshot.getOriginalOffset(simpleNode2.startOffset()));
            }
        } else {
            if (simpleNode2.kind() == 18 && (string.length() > 0 || n4 == simpleNode2.startOffset())) {
                Collection<Property> collection = this.filterProperties(this.PROPERTIES.properties(), string);
                return this.wrapProperties(collection, CompletionItemKind.PROPERTY, snapshot.getOriginalOffset(simpleNode2.startOffset()));
            }
            if (simpleNode2.kind() == 19) {
                return this.wrapProperties(this.PROPERTIES.properties(), CompletionItemKind.PROPERTY, n);
            }
            if (simpleNode2.kind() == 29) {
                Object object;
                final SimpleNode[] simpleNodeArray = new SimpleNode[2];
                NodeVisitor nodeVisitor = new NodeVisitor(){

                    public void visit(SimpleNode simpleNode) {
                        if (simpleNode.kind() == 18) {
                            simpleNodeArray[0] = simpleNode;
                        } else if (simpleNode.kind() == 40) {
                            simpleNodeArray[1] = simpleNode;
                        }
                    }
                };
                simpleNode2.visitChildren(nodeVisitor);
                SimpleNode simpleNode4 = simpleNodeArray[0];
                String string2 = "";
                if (simpleNodeArray[1] != null) {
                    int n5;
                    int n6;
                    object = simpleNode2.image().trim();
                    if (((String)object).endsWith("}")) {
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                    }
                    if ((n6 = ((String)object).indexOf(58)) >= 0) {
                        string2 = ((String)object).substring(n6 + 1);
                    }
                    if ((n5 = string2.indexOf(10)) > 0) {
                        string2 = string2.substring(0, n5);
                    }
                }
                if ((object = this.PROPERTIES.getProperty(simpleNode4.image().trim())) != null) {
                    int n7;
                    CssPropertyValue cssPropertyValue = new CssPropertyValue((Property)object, string2);
                    Set<PropertyModel.Element> set = cssPropertyValue.alternatives();
                    Collection<PropertyModel.Element> collection = this.filterElements(set, string);
                    int n8 = n7 = string.trim().length() == 0 ? n : snapshot.getOriginalOffset(simpleNode2.startOffset());
                    if (set.size() > 0 && collection.size() == 0) {
                        n7 = n;
                        collection = set;
                    }
                    return this.wrapPropertyValues((Property)object, collection, CompletionItemKind.VALUE, n7, false);
                }
            } else {
                List<CompletionProposal> list;
                if (simpleNode2.kind() == 32) {
                    int n9;
                    final SimpleNode[] simpleNodeArray = new SimpleNode[1];
                    NodeVisitor nodeVisitor = new NodeVisitor(){

                        public void visit(SimpleNode simpleNode) {
                            if (simpleNode.kind() == 29) {
                                simpleNodeArray[0] = simpleNode;
                            }
                        }
                    };
                    SimpleNodeUtil.visitAncestors(simpleNode2, nodeVisitor);
                    SimpleNode simpleNode5 = simpleNodeArray[0];
                    simpleNodeArray[0] = null;
                    NodeVisitor nodeVisitor2 = new NodeVisitor(){

                        public void visit(SimpleNode simpleNode) {
                            if (simpleNode.kind() == 18) {
                                simpleNodeArray[0] = simpleNode;
                            }
                        }
                    };
                    SimpleNodeUtil.visitChildren(simpleNode5, nodeVisitor2);
                    SimpleNode simpleNode6 = simpleNodeArray[0];
                    Property property = this.PROPERTIES.getProperty(simpleNode6.image());
                    if (property == null) {
                        return CodeCompletionResult.NONE;
                    }
                    SimpleNode simpleNode7 = (SimpleNode)simpleNode2.jjtGetParent();
                    String string3 = simpleNode7.image();
                    int n10 = string3.indexOf(10);
                    if (n10 > 0) {
                        string3 = string3.substring(0, n10);
                    }
                    CssPropertyValue cssPropertyValue = new CssPropertyValue(property, string3);
                    Set<PropertyModel.Element> set = cssPropertyValue.alternatives();
                    Collection<PropertyModel.Element> collection = this.filterElements(set, string);
                    int n11 = n9 = string.trim().length() == 0 ? n : snapshot.getOriginalOffset(simpleNode2.startOffset());
                    if (set.size() > 0 && collection.size() == 0) {
                        n9 = n;
                        collection = set;
                    }
                    return this.wrapPropertyValues(property, collection, CompletionItemKind.VALUE, n9, false);
                }
                if (simpleNode2.kind() == 24) {
                    List<CompletionProposal> list2 = this.completeHtmlSelectors(string, snapshot.getOriginalOffset(simpleNode2.startOffset()));
                    if (list2.size() > 0) {
                        return new DefaultCompletionResult(list2, false);
                    }
                } else if ((simpleNode2.kind() == 20 || simpleNode2.kind() == 16 || simpleNode2.kind() == 21) && (list = this.completeHtmlSelectors(string, n)).size() > 0) {
                    return new DefaultCompletionResult(list, false);
                }
            }
        }
        return CodeCompletionResult.NONE;
    }

    private List<CompletionProposal> completeHtmlSelectors(String string, int n) {
        ArrayList<CompletionProposal> arrayList = new ArrayList<CompletionProposal>(20);
        for (String string2 : HtmlTags.getTags()) {
            if (!string2.startsWith(string.toLowerCase(Locale.ENGLISH))) continue;
            arrayList.add(new SelectorCompletionItem(new CssElement(string2), string2, CompletionItemKind.VALUE, n));
        }
        return arrayList;
    }

    private CodeCompletionResult wrapRAWValues(Collection<String> collection, CompletionItemKind completionItemKind, int n) {
        ArrayList<CssCompletionItem> arrayList = new ArrayList<CssCompletionItem>(collection.size());
        for (String string : collection) {
            CssElement cssElement = new CssElement(string);
            CssCompletionItem cssCompletionItem = this.createCompletionItem(cssElement, string, completionItemKind, n, false);
            arrayList.add(cssCompletionItem);
        }
        return new DefaultCompletionResult(arrayList, false);
    }

    private CodeCompletionResult wrapPropertyValues(Property property, Collection<PropertyModel.Element> collection, CompletionItemKind completionItemKind, int n, boolean bl) {
        ArrayList<CssCompletionItem> arrayList = new ArrayList<CssCompletionItem>(collection.size());
        for (PropertyModel.Element element : collection) {
            if (element instanceof PropertyModel.ValueElement && ((PropertyModel.ValueElement)element).isUnit()) continue;
            CssValueElement cssValueElement = new CssValueElement(property, element);
            CssCompletionItem cssCompletionItem = this.createValueCompletionItem(cssValueElement, element, completionItemKind, n, bl);
            arrayList.add(cssCompletionItem);
        }
        return new DefaultCompletionResult(arrayList, false);
    }

    private Collection<String> filterStrings(Collection<String> collection, String string) {
        string = string.toLowerCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : collection) {
            if (!string2.toLowerCase().startsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private Collection<PropertyModel.Element> filterElements(Collection<PropertyModel.Element> collection, String string) {
        string = string.toLowerCase();
        ArrayList<PropertyModel.Element> arrayList = new ArrayList<PropertyModel.Element>();
        for (PropertyModel.Element element : collection) {
            if (!element.toString().toLowerCase().startsWith(string)) continue;
            arrayList.add(element);
        }
        return arrayList;
    }

    private CodeCompletionResult wrapProperties(Collection<Property> collection, CompletionItemKind completionItemKind, int n) {
        ArrayList<CssCompletionItem> arrayList = new ArrayList<CssCompletionItem>(collection.size());
        for (Property property : collection) {
            if (property.name().startsWith("-")) continue;
            CssPropertyElement cssPropertyElement = new CssPropertyElement(property);
            CssCompletionItem cssCompletionItem = this.createPropertyNameCompletionItem(cssPropertyElement, property.name(), completionItemKind, n, false);
            arrayList.add(cssCompletionItem);
        }
        return new DefaultCompletionResult(arrayList, false);
    }

    private Collection<Property> filterProperties(Collection<Property> collection, String string) {
        string = string.toLowerCase();
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (Property property : collection) {
            if (!property.name().toLowerCase().startsWith(string)) continue;
            arrayList.add(property);
        }
        return arrayList;
    }

    public String document(ParserResult parserResult, ElementHandle elementHandle) {
        if (elementHandle instanceof CssValueElement) {
            CssValueElement cssValueElement = (CssValueElement)elementHandle;
            return CssHelpResolver.instance().getPropertyHelp(cssValueElement.property().name());
        }
        if (elementHandle instanceof CssPropertyElement) {
            CssPropertyElement cssPropertyElement = (CssPropertyElement)elementHandle;
            return CssHelpResolver.instance().getPropertyHelp(cssPropertyElement.property().name());
        }
        return null;
    }

    public ElementHandle resolveLink(String string, ElementHandle elementHandle) {
        return new ElementHandle.UrlHandle(CssHelpResolver.HELP_URL + string);
    }

    public String getPrefix(ParserResult parserResult, int n, boolean bl) {
        Token token;
        Document document = parserResult.getSnapshot().getSource().getDocument(false);
        if (document == null) {
            return null;
        }
        TokenSequence<CssTokenId> tokenSequence = LexerUtils.getCssTokenSequence(document, n);
        if (tokenSequence == null) {
            return null;
        }
        int n2 = tokenSequence.move(n);
        if (n2 == 0) {
            if (!tokenSequence.movePrevious()) {
                return "";
            }
        } else if (!tokenSequence.moveNext()) {
            return null;
        }
        if ((token = tokenSequence.token()).id() == CssTokenId.COLON) {
            return "";
        }
        return ((Object)token.text().subSequence(0, n2 == 0 ? token.text().length() : n2)).toString().trim();
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent jTextComponent, String string) {
        if (string == null || string.length() == 0) {
            return CodeCompletionHandler.QueryType.NONE;
        }
        char c = string.charAt(string.length() - 1);
        switch (c) {
            case '\n': 
            case ';': 
            case '}': {
                return CodeCompletionHandler.QueryType.STOP;
            }
            case ',': 
            case ':': {
                return CodeCompletionHandler.QueryType.COMPLETION;
            }
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String string, ParserResult parserResult, int n, String string2, Map map) {
        return "";
    }

    public Set<String> getApplicableTemplates(ParserResult parserResult, int n, int n2) {
        return Collections.emptySet();
    }

    public ParameterInfo parameters(ParserResult parserResult, int n, CompletionProposal completionProposal) {
        return ParameterInfo.NONE;
    }

    private CssCompletionItem createValueCompletionItem(CssValueElement cssValueElement, PropertyModel.Element element, CompletionItemKind completionItemKind, int n, boolean bl) {
        String string = element.origin();
        assert (string != null) : "Css value completion item has no origin!";
        if (string.startsWith("-")) {
            PropertyModel.Element element2 = element;
            while ((element2 = element2.parent()) != null) {
                if (element2.origin() == null || element2.origin().startsWith("-")) continue;
                string = element2.origin();
                break;
            }
        }
        if ("color".equals(string)) {
            return new ColorCompletionItem(cssValueElement, element.toString(), string, completionItemKind, n, bl);
        }
        return new ValueCompletionItem(cssValueElement, element.toString(), string, completionItemKind, n, bl);
    }

    private CssCompletionItem createPropertyNameCompletionItem(CssElement cssElement, String string, CompletionItemKind completionItemKind, int n, boolean bl) {
        return new PropertyCompletionItem(cssElement, string, completionItemKind, n, bl);
    }

    private CssCompletionItem createCompletionItem(CssElement cssElement, String string, CompletionItemKind completionItemKind, int n, boolean bl) {
        return new CssCompletionItem(cssElement, string, completionItemKind, n, bl);
    }

    private synchronized HashMap<String, String> colors() {
        if (this.colors.isEmpty()) {
            this.colors.put("red", "ff0000");
            this.colors.put("black", "000000");
            this.colors.put("green", "00ff00");
            this.colors.put("blue", "0000ff");
            this.colors.put("silver", "C0C0C0");
            this.colors.put("gray", "808080");
            this.colors.put("white", "ffffff");
            this.colors.put("maroon", "800000");
            this.colors.put("purple", "800080");
            this.colors.put("fuchsia", "ff00ff");
            this.colors.put("lime", "00ff00");
            this.colors.put("olive", "808000");
            this.colors.put("orange", "ffa500");
            this.colors.put("yellow", "ffff00");
            this.colors.put("navy", "000080");
            this.colors.put("teal", "008080");
            this.colors.put("aqua", "00ffff");
        }
        return this.colors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CssCompletionItem
    implements CompletionProposal {
        private static final String CSS_PROPERTY = "org/netbeans/modules/css/resources/methodPublic.png";
        private static final String CSS_VALUE = "org/netbeans/modules/css/resources/fieldPublic.png";
        private ImageIcon propertyIcon;
        private ImageIcon valueIcon;
        private int anchorOffset;
        private String value;
        protected CompletionItemKind kind;
        private CssElement element;
        protected boolean addSemicolon;

        private CssCompletionItem() {
        }

        private CssCompletionItem(CssElement cssElement, String string, CompletionItemKind completionItemKind, int n, boolean bl) {
            this.anchorOffset = n;
            this.value = string;
            this.kind = completionItemKind;
            this.element = cssElement;
            this.addSemicolon = bl;
        }

        public int getAnchorOffset() {
            return this.anchorOffset;
        }

        public String getName() {
            return this.value;
        }

        public String getInsertPrefix() {
            return this.getName();
        }

        public String getSortText() {
            return this.getName();
        }

        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        public ImageIcon getIcon() {
            if (this.kind == CompletionItemKind.PROPERTY) {
                if (this.propertyIcon == null) {
                    this.propertyIcon = ImageUtilities.loadImageIcon((String)CSS_PROPERTY, (boolean)false);
                }
                return this.propertyIcon;
            }
            if (this.kind == CompletionItemKind.VALUE) {
                if (this.valueIcon == null) {
                    this.valueIcon = ImageUtilities.loadImageIcon((String)CSS_VALUE, (boolean)false);
                }
                return this.valueIcon;
            }
            return null;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.appendText(this.getName());
            return htmlFormatter.getText();
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            return null;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public String toString() {
            return this.getName();
        }

        public boolean isSmart() {
            return false;
        }

        public String getCustomInsertTemplate() {
            return null;
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public int getSortPrioOverride() {
            return 0;
        }
    }

    private class SelectorCompletionItem
    extends CssCompletionItem {
        private SelectorCompletionItem(CssElement cssElement, String string, CompletionItemKind completionItemKind, int n) {
            super(cssElement, string, completionItemKind, n, false);
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.appendHtml("<b><font color=#007c00>" + this.getName() + "</font></b>");
            return htmlFormatter.getText();
        }

        public ImageIcon getIcon() {
            return null;
        }
    }

    private class PropertyCompletionItem
    extends CssCompletionItem {
        private PropertyCompletionItem(CssElement cssElement, String string, CompletionItemKind completionItemKind, int n, boolean bl) {
            super(cssElement, string, completionItemKind, n, bl);
        }

        public String getInsertPrefix() {
            return super.getInsertPrefix() + ":";
        }
    }

    private class ColorCompletionItem
    extends ValueCompletionItem {
        final byte COLOR_ICON_SIZE = 16;
        final byte COLOR_RECT_SIZE = 10;

        private ColorCompletionItem(CssElement cssElement, String string, String string2, CompletionItemKind completionItemKind, int n, boolean bl) {
            super(cssElement, string, string2, completionItemKind, n, bl);
            this.COLOR_ICON_SIZE = (byte)16;
            this.COLOR_RECT_SIZE = (byte)10;
        }

        public ImageIcon getIcon() {
            boolean bl;
            BufferedImage bufferedImage = new BufferedImage(16, 16, 6);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            String string = (String)CssCompletion.this.colors().get(this.getName());
            boolean bl2 = bl = string == null;
            if (bl) {
                string = (String)CssCompletion.this.colors().get("white");
            }
            Color color = new Color(0xFFFFFF, true);
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, 16, 16);
            graphics2D.setColor(Color.decode("0x" + string));
            graphics2D.fillRect(6, 5, 9, 9);
            graphics2D.setColor(Color.DARK_GRAY);
            graphics2D.drawRect(5, 4, 10, 10);
            if (bl) {
                graphics2D.drawLine(5, 14, 15, 4);
            }
            return new ImageIcon(bufferedImage);
        }
    }

    private class ValueCompletionItem
    extends CssCompletionItem {
        private String origin;

        private ValueCompletionItem(CssElement cssElement, String string, String string2, CompletionItemKind completionItemKind, int n, boolean bl) {
            super(cssElement, string, completionItemKind, n, bl);
            this.origin = string2;
        }

        public String getInsertPrefix() {
            return this.getName() + (this.addSemicolon ? ";" : "");
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            return "<font color=999999>" + this.origin + "</font>";
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            Property property = ((CssValueElement)this.getElement()).property();
            String string = property.initialValue();
            if (string != null && string.equals(this.getName())) {
                return "<i>" + super.getLhsHtml(htmlFormatter) + "</i>";
            }
            return super.getLhsHtml(htmlFormatter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CompletionItemKind {
        PROPERTY,
        VALUE;

    }
}

