/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.css.editor.CssPropertyValue;
import org.netbeans.modules.css.editor.Property;
import org.netbeans.modules.css.editor.PropertyModel;
import org.netbeans.modules.css.editor.properties.CustomErrorMessageProvider;
import org.netbeans.modules.css.gsf.CssGSFParser;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssAnalyser {
    private static final String UNKNOWN_PROPERTY = "unknown_property";
    private static final String INVALID_PROPERTY_VALUE = "invalid_property_value";
    private static final String INVALID_CONTENT = "invalid_content";
    private static final String INVALID_CONTENT_MSG = NbBundle.getMessage(CssAnalyser.class, (String)"invalid_content");

    public static List<Error> checkForErrors(final Snapshot snapshot, SimpleNode simpleNode) {
        final ArrayList<Error> arrayList = new ArrayList<Error>();
        final PropertyModel propertyModel = PropertyModel.instance();
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public void visit(SimpleNode simpleNode) {
                Error error;
                if (simpleNode.kind() == 29) {
                    SimpleNode simpleNode2 = SimpleNodeUtil.getChildByType(simpleNode, 18);
                    SimpleNode simpleNode3 = SimpleNodeUtil.getChildByType(simpleNode, 31);
                    if (simpleNode2 != null) {
                        CssPropertyValue cssPropertyValue;
                        String string;
                        String string2 = simpleNode2.image().trim();
                        Property property = propertyModel.getProperty(string2);
                        if (!CssGSFParser.containsGeneratedCode(string2) && !CssAnalyser.isVendorSpecificProperty(string2) && property == null) {
                            string = NbBundle.getMessage(CssAnalyser.class, (String)CssAnalyser.UNKNOWN_PROPERTY, (Object)string2);
                            cssPropertyValue = CssAnalyser.makeError(simpleNode2.startOffset(), simpleNode2.endOffset(), snapshot, CssAnalyser.UNKNOWN_PROPERTY, string, string, false, Severity.WARNING);
                            if (cssPropertyValue != null) {
                                arrayList.add(cssPropertyValue);
                            }
                        }
                        if (simpleNode3 != null && property != null && !CssGSFParser.containsGeneratedCode(string = simpleNode3.image().trim()) && !(cssPropertyValue = new CssPropertyValue(property, string)).success()) {
                            Error error2;
                            String string3 = null;
                            if (cssPropertyValue instanceof CustomErrorMessageProvider) {
                                string3 = ((CustomErrorMessageProvider)((Object)cssPropertyValue)).customErrorMessage();
                            }
                            String string4 = cssPropertyValue.left().get(cssPropertyValue.left().size() - 1);
                            if (string3 == null) {
                                string3 = NbBundle.getMessage(CssAnalyser.class, (String)CssAnalyser.INVALID_PROPERTY_VALUE, (Object)string4);
                            }
                            if ((error2 = CssAnalyser.makeError(simpleNode3.startOffset(), simpleNode3.endOffset(), snapshot, CssAnalyser.INVALID_PROPERTY_VALUE, string3, string3, false, Severity.WARNING)) != null) {
                                arrayList.add(error2);
                            }
                        }
                    }
                } else if (simpleNode.kind() == 41 && simpleNode.image().length() > 0 && (error = CssAnalyser.makeError(simpleNode.startOffset(), simpleNode.endOffset(), snapshot, CssAnalyser.INVALID_CONTENT, INVALID_CONTENT_MSG, INVALID_CONTENT_MSG, true, Severity.ERROR)) != null) {
                    arrayList.add(error);
                }
            }
        };
        if (simpleNode != null) {
            SimpleNodeUtil.visitChildren(simpleNode, nodeVisitor);
        }
        return arrayList;
    }

    private static Error makeError(int n, int n2, Snapshot snapshot, String string, String string2, String string3, boolean bl, Severity severity) {
        assert (n <= n2);
        int n3 = snapshot.getOriginalOffset(n);
        int n4 = snapshot.getOriginalOffset(n2);
        if (n3 == -1 || n4 == -1) {
            return null;
        }
        assert (n3 <= n4);
        return DefaultError.createDefaultError((String)string, (String)string2, (String)string3, (FileObject)snapshot.getSource().getFileObject(), (int)n3, (int)n4, (boolean)bl, (Severity)severity);
    }

    public static boolean isVendorSpecificProperty(String string) {
        return string.startsWith("_") || string.startsWith("-");
    }
}

