/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.model;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.css.editor.model.CssRule;
import org.netbeans.modules.css.editor.model.CssRuleItem;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.css.parser.Token;
import org.netbeans.modules.parsing.api.Snapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CssModel {
    private static final Logger LOGGER = Logger.getLogger(CssModel.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private final List<CssRule> rules = new ArrayList<CssRule>(10);
    private Snapshot snapshot;

    public static CssModel create(CssParserResult cssParserResult) {
        return new CssModel(cssParserResult.getSnapshot(), cssParserResult.root());
    }

    private CssModel(Snapshot snapshot, SimpleNode simpleNode) {
        this.snapshot = snapshot;
        if (simpleNode != null) {
            this.updateModel(snapshot, simpleNode);
        }
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public List<CssRule> rules() {
        return this.rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CssRule ruleForOffset(int n) {
        List<CssRule> list = this.rules;
        synchronized (list) {
            if (this.rules != null) {
                for (CssRule cssRule : this.rules()) {
                    if (cssRule.getRuleNameOffset() > n || cssRule.getRuleCloseBracketOffset() < n) continue;
                    return cssRule;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateModel(final Snapshot snapshot, SimpleNode simpleNode) {
        List<CssRule> list = this.rules;
        synchronized (list) {
            NodeVisitor nodeVisitor = new NodeVisitor(){

                public void visit(SimpleNode simpleNode) {
                    if (simpleNode.kind() == 19) {
                        Object object;
                        Token token = simpleNode.jjtGetFirstToken();
                        Token token2 = simpleNode.jjtGetLastToken();
                        int n = -1;
                        int n2 = -1;
                        ArrayList<Integer> arrayList = new ArrayList<Integer>();
                        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                        while (token != null && token.offset <= token2.offset) {
                            if (token.kind == 8) {
                                n = token.offset;
                            } else if (token.kind == 9) {
                                n2 = token.offset;
                            } else if (token.kind == 12) {
                                arrayList.add(token.offset);
                            } else if (token.kind == 13) {
                                arrayList2.add(token.offset);
                            }
                            token = token.next;
                        }
                        SimpleNode simpleNode2 = SimpleNodeUtil.getChildByType(simpleNode, 20);
                        SimpleNode[] simpleNodeArray = SimpleNodeUtil.getChildrenByType(simpleNode, 29);
                        ArrayList<CssRuleItem> arrayList3 = new ArrayList<CssRuleItem>(simpleNodeArray.length);
                        for (int i = 0; i < simpleNodeArray.length; ++i) {
                            object = simpleNodeArray[i];
                            SimpleNode simpleNode3 = SimpleNodeUtil.getChildByType((SimpleNode)object, 18);
                            SimpleNode simpleNode4 = SimpleNodeUtil.getChildByType((SimpleNode)object, 31);
                            if (simpleNode3 == null || simpleNode4 == null) {
                                return;
                            }
                            int n3 = i < arrayList.size() ? (Integer)arrayList.get(i) : -1;
                            int n4 = i < arrayList2.size() ? (Integer)arrayList2.get(i) : -1;
                            CssRuleItem cssRuleItem = new CssRuleItem(simpleNode3.image().trim(), simpleNode3.startOffset(), simpleNode4.image().trim(), simpleNode4.startOffset(), n4, n3);
                            arrayList3.add(cssRuleItem);
                        }
                        String string = simpleNode2.image().trim();
                        object = new CssRule(snapshot, string, simpleNode2.startOffset(), n, n2, arrayList3);
                        CssModel.this.rules.add(object);
                    }
                }
            };
            SimpleNodeUtil.visitChildren(simpleNode, nodeVisitor);
            if (LOG) {
                LOGGER.fine("CssModel parse tree:");
                simpleNode.dump("");
                LOGGER.fine("CssModel structure:");
                for (CssRule cssRule : this.rules) {
                    LOGGER.fine(cssRule.toString());
                }
            }
        }
    }
}

