/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.spi.indexing.support;

import java.io.IOException;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.impl.indexing.IndexFactoryImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexImpl;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.impl.indexing.SupportAccessor;
import org.netbeans.modules.parsing.impl.indexing.lucene.LuceneIndexFactory;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.openide.util.Parameters;

public final class IndexingSupport {
    private static final Logger LOG = Logger.getLogger(IndexingSupport.class.getName());
    private final IndexFactoryImpl spiFactory;
    private final IndexImpl spiIndex;

    private IndexingSupport(Context context) throws IOException {
        IndexFactoryImpl indexFactoryImpl = SPIAccessor.getInstance().getIndexFactory(context);
        if (indexFactoryImpl == null) {
            indexFactoryImpl = new LuceneIndexFactory();
        }
        assert (indexFactoryImpl != null);
        this.spiFactory = indexFactoryImpl;
        this.spiIndex = this.spiFactory.createIndex(context);
    }

    public static IndexingSupport getInstance(Context context) throws IOException {
        Parameters.notNull((CharSequence)"context", (Object)context);
        IndexingSupport indexingSupport = SPIAccessor.getInstance().context_getAttachedIndexingSupport(context);
        if (indexingSupport == null) {
            indexingSupport = new IndexingSupport(context);
            SPIAccessor.getInstance().context_attachIndexingSupport(context, indexingSupport);
        }
        return indexingSupport;
    }

    public IndexDocument createDocument(Indexable indexable) {
        Parameters.notNull((CharSequence)"indexable", (Object)indexable);
        return new IndexDocument(this.spiFactory.createDocument(indexable));
    }

    public void addDocument(IndexDocument indexDocument) {
        Parameters.notNull((CharSequence)"document", (Object)indexDocument.spi);
        this.spiIndex.addDocument(indexDocument.spi);
    }

    public void removeDocuments(Indexable indexable) {
        Parameters.notNull((CharSequence)"indexable", (Object)indexable);
        this.spiIndex.removeDocument(indexable.getRelativePath());
    }

    public void markDirtyDocuments(Indexable indexable) {
        Parameters.notNull((CharSequence)"indexable", (Object)indexable);
        this.spiIndex.fileModified(indexable.getRelativePath());
    }

    static {
        SupportAccessor.setInstance(new MyAccessor());
    }

    private static class MyAccessor
    extends SupportAccessor {
        private MyAccessor() {
        }

        public void store(IndexingSupport indexingSupport) throws IOException {
            assert (indexingSupport != null);
            indexingSupport.spiIndex.store();
        }
    }
}

