/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.lucene;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.parsing.impl.indexing.lucene.LuceneIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndexManager {
    private static LuceneIndexManager instance;
    private volatile boolean invalid;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<URL, LuceneIndex> indexes = new HashMap<URL, LuceneIndex>();

    private LuceneIndexManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R writeAccess(Action<R> action) throws IOException {
        assert (action != null);
        this.lock.writeLock().lock();
        try {
            R r = action.run();
            return r;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R readAccess(Action<R> action) throws IOException {
        assert (action != null);
        this.lock.readLock().lock();
        try {
            R r = action.run();
            return r;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static synchronized LuceneIndexManager getDefault() {
        if (instance == null) {
            instance = new LuceneIndexManager();
        }
        return instance;
    }

    public synchronized LuceneIndex getIndex(URL uRL, boolean bl) throws IOException {
        assert (uRL != null);
        if (this.invalid) {
            return null;
        }
        LuceneIndex luceneIndex = this.indexes.get(uRL);
        if (bl && luceneIndex == null) {
            luceneIndex = new LuceneIndex(uRL);
            this.indexes.put(uRL, luceneIndex);
        }
        return luceneIndex;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Action<R> {
        public R run() throws IOException;
    }
}

