/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.parsing.impl.indexing.CancelRequest;
import org.netbeans.modules.parsing.impl.indexing.Crawler;
import org.netbeans.modules.parsing.impl.indexing.FileObjectIndexable;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileObjectCrawler
extends Crawler {
    private static final Logger LOG = Logger.getLogger(FileObjectCrawler.class.getName());
    private final FileObject root;
    private final FileObject[] files;

    public FileObjectCrawler(FileObject fileObject, boolean bl, Set<String> set, CancelRequest cancelRequest) throws IOException {
        super(fileObject.getURL(), bl, set, cancelRequest);
        this.root = fileObject;
        this.files = null;
    }

    public FileObjectCrawler(FileObject fileObject, FileObject[] fileObjectArray, boolean bl, Set<String> set, CancelRequest cancelRequest) throws IOException {
        super(fileObject.getURL(), bl, set, cancelRequest);
        this.root = fileObject;
        this.files = fileObjectArray;
    }

    @Override
    protected boolean collectResources(Set<? extends String> set, Map<String, Collection<Indexable>> map) {
        long l = System.currentTimeMillis();
        Stats stats = LOG.isLoggable(Level.FINE) ? new Stats() : null;
        boolean bl = this.files != null ? this.collect(this.files, this.root, map, set, stats) : this.collect(this.root.getChildren(), this.root, map, set, stats);
        long l2 = System.currentTimeMillis();
        if (LOG.isLoggable(Level.FINE)) {
            try {
                LOG.log(Level.FINE, "Up-to-date check of {0} files under {1} took {2} ms", new Object[]{stats.filesCount, this.root.getURL(), l2 - l});
                LOG.log(Level.FINE, "File extensions histogram for {0}", this.root.getURL());
                for (String string : new TreeSet<String>(stats.extensions.keySet())) {
                    LOG.log(Level.FINE, "{0}: {1}", new Object[]{string, stats.extensions.get(string)});
                }
                LOG.fine("----");
                LOG.log(Level.FINE, "Mime types histogram for {0}", this.root.getURL());
                for (String string : new TreeSet<String>(stats.mimeTypes.keySet())) {
                    LOG.log(Level.FINE, "{0}: {1}", new Object[]{string, stats.mimeTypes.get(string)});
                }
                LOG.fine("----");
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return bl;
    }

    private boolean collect(FileObject[] fileObjectArray, FileObject fileObject, Map<String, Collection<Indexable>> map, Set<? extends String> set, Stats stats) {
        for (FileObject fileObject2 : fileObjectArray) {
            if (this.isCancelled()) {
                return false;
            }
            if (!fileObject2.isValid() || !VisibilityQuery.getDefault().isVisible(fileObject2)) continue;
            if (fileObject2.isFolder()) {
                if (this.collect(fileObject2.getChildren(), fileObject, map, set, stats)) continue;
                return false;
            }
            String string = fileObject2.getMIMEType();
            if (stats != null) {
                ++stats.filesCount;
                stats.inc(stats.extensions, fileObject2.getExt());
                stats.inc(stats.mimeTypes, string);
            }
            if (set != null && !set.contains(string)) continue;
            Collection<Indexable> collection = map.get(string);
            if (collection == null) {
                collection = new HashSet<Indexable>();
                map.put(string, collection);
            }
            if (this.isUpToDate(fileObject2)) continue;
            String string2 = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
            collection.add(SPIAccessor.getInstance().create(new FileObjectIndexable(fileObject, string2, string)));
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Stats {
        public int filesCount;
        public Map<String, Integer> extensions = new HashMap<String, Integer>();
        public Map<String, Integer> mimeTypes = new HashMap<String, Integer>();

        private Stats() {
        }

        public void inc(Map<String, Integer> map, String string) {
            Integer n = map.get(string);
            if (n == null) {
                map.put(string, 1);
            } else {
                map.put(string, n + 1);
            }
        }
    }
}

