/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.indexing.Util;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

public class SelectedNodesScheduler
extends Scheduler {
    private Source source;

    public SelectedNodesScheduler() {
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)new AListener());
    }

    private void refresh() {
        DataObject dataObject;
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray.length == 1 && (dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class)) != null && dataObject.isValid()) {
            FileObject fileObject = dataObject.getPrimaryFile();
            if (fileObject.isValid() && Util.canBeParsed(fileObject.getMIMEType())) {
                this.source = Source.create(fileObject);
            }
            if (this.source != null) {
                this.schedule(this.source, new SchedulerEvent(this){});
                return;
            }
        }
    }

    public String toString() {
        return "SelectedNodesScheduller";
    }

    protected SchedulerEvent createSchedulerEvent(SourceModificationEvent sourceModificationEvent) {
        if (sourceModificationEvent.getModifiedSource() == this.source) {
            return new SchedulerEvent(this){};
        }
        return null;
    }

    private class AListener
    implements PropertyChangeListener {
        private AListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == null || propertyChangeEvent.getPropertyName().equals("activatedNodes")) {
                SelectedNodesScheduler.this.refresh();
            }
        }
    }
}

