/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.db.h2;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.core.stack.storage.SQLStackStorage;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.impl.SQLDataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Util;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class H2DataStorage
extends SQLDataStorage
implements StackDataStorage {
    private static final String SQL_QUERY_DELIMETER = ";";
    private static final Logger logger;
    private static boolean driverLoaded;
    private static final AtomicInteger dbIndex;
    private SQLStackStorage stackStorage;
    private final Collection<DataStorageType> supportedStorageTypes = new ArrayList<DataStorageType>();
    private static final String tmpDir;
    private static final String url;
    private String dbURL;

    private void initStorageTypes() {
        this.supportedStorageTypes.add(DataStorageTypeFactory.getInstance().getDataStorageType("db:sql:h2"));
        this.supportedStorageTypes.add(DataStorageTypeFactory.getInstance().getDataStorageType("stack"));
        this.supportedStorageTypes.addAll(super.getStorageTypes());
    }

    H2DataStorage() throws SQLException {
        this(url + dbIndex.incrementAndGet() + "/dlight");
    }

    private H2DataStorage(String string) throws SQLException {
        super(string);
        this.dbURL = string;
        try {
            this.initStorageTypes();
            this.stackStorage = new SQLStackStorage((SQLDataStorage)this);
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, null, sQLException);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, null, iOException);
        }
    }

    public boolean shutdown() {
        boolean bl = this.stackStorage.shutdown() && super.shutdown();
        String string = this.dbURL.substring(this.dbURL.lastIndexOf(":") + 1, this.dbURL.lastIndexOf("/") + 1);
        bl = bl && Util.deleteLocalDirectory((File)new File(string));
        return bl;
    }

    public boolean createTablesImpl(List<DataTableMetadata> list) {
        for (DataTableMetadata dataTableMetadata : list) {
            if (dataTableMetadata.getName().equals("DtraceStack") || this.createTable(dataTableMetadata)) continue;
            return false;
        }
        return true;
    }

    public Collection<DataStorageType> getStorageTypes() {
        return this.supportedStorageTypes;
    }

    protected void connect(String string) throws SQLException {
        this.connection = DriverManager.getConnection(string, "admin", "");
    }

    public int putStack(List<CharSequence> list, long l) {
        return this.stackStorage.putStack(list, l);
    }

    public void flush() {
        try {
            this.stackStorage.flush();
        }
        catch (InterruptedException interruptedException) {
            logger.log(Level.SEVERE, null, interruptedException);
        }
    }

    public List<FunctionMetric> getMetricsList() {
        return this.stackStorage.getMetricsList();
    }

    public List<Long> getPeriodicStacks(long l, long l2, long l3) {
        try {
            return this.stackStorage.getPeriodicStacks(l, l2, l3);
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, null, sQLException);
            return null;
        }
    }

    public List<FunctionCall> getCallers(FunctionCall[] functionCallArray, boolean bl) {
        try {
            return this.stackStorage.getCallers(functionCallArray, bl);
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, null, sQLException);
            return new ArrayList<FunctionCall>();
        }
    }

    public List<FunctionCall> getCallees(FunctionCall[] functionCallArray, boolean bl) {
        try {
            return this.stackStorage.getCallees(functionCallArray, bl);
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, null, sQLException);
            return new ArrayList<FunctionCall>();
        }
    }

    public List<FunctionCall> getHotSpotFunctions(FunctionMetric functionMetric, int n) {
        return this.stackStorage.getHotSpotFunctions(functionMetric, n);
    }

    protected String getSQLQueriesDelimeter() {
        return SQL_QUERY_DELIMETER;
    }

    public List<FunctionCall> getFunctionsList(DataTableMetadata dataTableMetadata, List<DataTableMetadata.Column> list, FunctionDatatableDescription functionDatatableDescription) {
        return this.stackStorage.getFunctionsList(dataTableMetadata, list, functionDatatableDescription);
    }

    static {
        Object object;
        Object object2;
        logger = DLightLogger.getLogger(H2DataStorage.class);
        driverLoaded = false;
        dbIndex = new AtomicInteger();
        try {
            object2 = Class.forName("org.h2.Driver");
            logger.fine("Driver for H2DB (" + ((Class)object2).getName() + ") Loaded ");
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.SEVERE, null, classNotFoundException);
        }
        object2 = null;
        try {
            object = HostInfoUtils.getHostInfo((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
            object2 = object.getTempDir();
            if (object.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                object2 = WindowsSupport.getInstance().convertToWindowsPath((String)object2);
            }
        }
        catch (IOException iOException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        if (object2 == null) {
            object2 = System.getProperty("java.io.tmpdir");
        }
        url = "jdbc:h2:" + (String)object2 + "/h2_db_dlight";
        tmpDir = object2;
        object = new File((String)tmpDir);
        if (((File)object).exists()) {
            final File[] fileArray = ((File)object).listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return file.isDirectory() && string.startsWith("h2_db_dlight");
                }
            });
            int n = "h2_db_dlight".length();
            int n2 = 0;
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getName().substring(n);
                try {
                    n2 = Math.max(n2, Integer.valueOf(string));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            dbIndex.getAndSet(n2);
            DLightExecutorService.submit((Runnable)new Runnable(){

                public void run() {
                    for (File file : fileArray) {
                        Util.deleteLocalDirectory((File)file);
                    }
                }
            }, (String)"H2DataStorage removing old data bases");
        }
    }
}

