/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Dialog;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.wsitconf.spi.features.AdvancedSecurityFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ClientDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ServiceDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ValidatorsFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBase;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.SenderVouches;
import org.netbeans.modules.websvc.wsitconf.util.DefaultSettings;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wizard.SamlCallbackCreator;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;

public class SenderVouchesProfile
extends ProfileBase
implements SecureConversationFeature,
ClientDefaultsFeature,
ServiceDefaultsFeature,
ValidatorsFeature,
AdvancedSecurityFeature {
    private static final String PKGNAME = "samlcb";

    public int getId() {
        return 70;
    }

    public String getDisplayName() {
        return ComboConstants.PROF_SAMLSENDER;
    }

    public String getDescription() {
        return ComboConstants.PROF_SAMLSENDER_INFO;
    }

    public boolean isCurrentProfile(WSDLComponent wSDLComponent) {
        return this.getDisplayName().equals(ProfilesModelHelper.getWSITSecurityProfile(wSDLComponent));
    }

    public void displayConfig(WSDLComponent wSDLComponent, UndoManager undoManager) {
        UndoCounter undoCounter = new UndoCounter();
        WSDLModel wSDLModel = wSDLComponent.getModel();
        wSDLModel.addUndoableEditListener((UndoableEditListener)undoCounter);
        SenderVouches senderVouches = new SenderVouches(wSDLComponent, this);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)senderVouches, this.getDisplayName());
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!undoManager.canUndo()) continue;
                undoManager.undo();
            }
        }
        wSDLModel.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }

    public boolean isProfileSupported(Project project, WSDLComponent wSDLComponent, boolean bl) {
        ConfigVersion configVersion = PolicyModelHelper.getConfigVersion(wSDLComponent);
        return ConfigVersion.CONFIG_1_3.equals((Object)configVersion);
    }

    public void setClientDefaults(WSDLComponent wSDLComponent, WSDLComponent wSDLComponent2, Project project) {
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, false, true);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, true, true);
        ProprietarySecurityPolicyModelHelper.removeCallbackHandlerConfiguration((Binding)wSDLComponent);
        String string = ServerUtils.getStoreLocation(project, false, true);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, string, false, true);
        ProprietarySecurityPolicyModelHelper.setStoreType(wSDLComponent, "JKS", false, true);
        ProprietarySecurityPolicyModelHelper.setStorePassword(wSDLComponent, DefaultSettings.getDefaultPassword(project), false, true);
        String string2 = ServerUtils.getStoreLocation(project, true, true);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, string2, true, true);
        ProprietarySecurityPolicyModelHelper.setStoreType(wSDLComponent, "JKS", true, true);
        ProprietarySecurityPolicyModelHelper.setStorePassword(wSDLComponent, DefaultSettings.getDefaultPassword(project), true, true);
        ProprietarySecurityPolicyModelHelper.setKeyStoreAlias(wSDLComponent, "xws-security-client", true);
        ProprietarySecurityPolicyModelHelper.setTrustPeerAlias(wSDLComponent, "xws-security-server", true);
        FileObject fileObject = null;
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        if (sourceGroupArray != null && sourceGroupArray.length > 0) {
            fileObject = sourceGroupArray[0].getRootFolder();
        }
        SamlCallbackCreator samlCallbackCreator = new SamlCallbackCreator();
        String string3 = this.getSamlVersion((Binding)wSDLComponent2);
        String string4 = "SamlCallbackHandler";
        if (fileObject != null) {
            if (fileObject.getFileObject(PKGNAME) == null) {
                try {
                    fileObject = fileObject.createFolder(PKGNAME);
                }
                catch (IOException iOException) {
                    Logger.getLogger("global").log(Level.SEVERE, null, iOException);
                }
            } else {
                fileObject = fileObject.getFileObject(PKGNAME);
            }
            if (ComboConstants.SAML_V2011.equals(string3)) {
                string4 = "Saml20SVCallbackHandler";
                if (fileObject.getFileObject(string4, "java") == null) {
                    samlCallbackCreator.generateSamlCBHandler(fileObject, string4, "sv", "20");
                }
            } else {
                string4 = "Saml11SVCallbackHandler";
                if (fileObject.getFileObject(string4, "java") == null) {
                    samlCallbackCreator.generateSamlCBHandler(fileObject, string4, "sv", "11");
                }
            }
        }
        ProprietarySecurityPolicyModelHelper.setCallbackHandler((Binding)wSDLComponent, "samlHandler", "samlcb." + string4, null, true);
    }

    public void setServiceDefaults(WSDLComponent wSDLComponent, Project project) {
        ProprietarySecurityPolicyModelHelper.clearValidators(wSDLComponent);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, true, false);
        String string = ServerUtils.getStoreLocation(project, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, string, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreType(wSDLComponent, "JKS", false, false);
        ProprietarySecurityPolicyModelHelper.setStorePassword(wSDLComponent, DefaultSettings.getDefaultPassword(project), false, false);
        ProprietarySecurityPolicyModelHelper.setKeyStoreAlias(wSDLComponent, "xws-security-server", false);
    }

    public boolean isServiceDefaultSetupUsed(WSDLComponent wSDLComponent, Project project) {
        if (ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(wSDLComponent)) {
            return false;
        }
        String string = ProprietarySecurityPolicyModelHelper.getStoreAlias(wSDLComponent, false);
        String string2 = ProprietarySecurityPolicyModelHelper.getStoreLocation(wSDLComponent, false);
        String string3 = ProprietarySecurityPolicyModelHelper.getStorePassword(wSDLComponent, false);
        return Util.isEqual(DefaultSettings.getDefaultPassword(project), string3) && Util.isEqual(ServerUtils.getStoreLocation(project, false, false), string2) && Util.isEqual("xws-security-server", string);
    }

    public boolean isClientDefaultSetupUsed(WSDLComponent wSDLComponent, Binding binding, Project project) {
        if (ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(wSDLComponent)) {
            return false;
        }
        String string = this.getSamlVersion(binding);
        String string2 = null;
        string2 = ComboConstants.SAML_V2011.equals(string) ? "Saml20SVCallbackHandler" : "Saml11SVCallbackHandler";
        String string3 = ProprietarySecurityPolicyModelHelper.getStoreAlias(wSDLComponent, false);
        String string4 = ProprietarySecurityPolicyModelHelper.getStoreAlias(wSDLComponent, true);
        String string5 = ProprietarySecurityPolicyModelHelper.getStoreLocation(wSDLComponent, true);
        String string6 = ProprietarySecurityPolicyModelHelper.getStoreLocation(wSDLComponent, false);
        String string7 = ProprietarySecurityPolicyModelHelper.getStorePassword(wSDLComponent, false);
        String string8 = ProprietarySecurityPolicyModelHelper.getStorePassword(wSDLComponent, true);
        String string9 = ProprietarySecurityPolicyModelHelper.getCallbackHandler((Binding)wSDLComponent, "samlHandler");
        return Util.isEqual("samlcb." + string2, string9) && Util.isEqual("xws-security-client", string3) && Util.isEqual("xws-security-server", string4) && Util.isEqual(DefaultSettings.getDefaultPassword(project), string7) && Util.isEqual(DefaultSettings.getDefaultPassword(project), string8) && Util.isEqual(ServerUtils.getStoreLocation(project, true, true), string5) && Util.isEqual(ServerUtils.getStoreLocation(project, false, false), string6);
    }

    private String getSamlVersion(Binding binding) {
        WSDLComponent wSDLComponent;
        ConfigVersion configVersion = PolicyModelHelper.getConfigVersion((WSDLComponent)binding);
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement((WSDLComponent)binding);
        WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement, ProtectionToken.class);
        WSDLComponent wSDLComponent3 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent2);
        int n = 5;
        if (ConfigVersion.CONFIG_1_0.equals((Object)configVersion)) {
            n = 1;
        }
        WSDLComponent wSDLComponent4 = null;
        boolean bl = wSDLComponent3 instanceof SecureConversationToken;
        if (bl) {
            wSDLComponent = SecurityTokensModelHelper.getTokenElement(wSDLComponent3, BootstrapPolicy.class);
            Policy policy = (Policy)PolicyModelHelper.getTopLevelElement(wSDLComponent, Policy.class, false);
            wSDLComponent4 = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)policy, n);
        } else {
            wSDLComponent4 = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)binding, n);
        }
        wSDLComponent = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent4);
        return SecurityTokensModelHelper.getTokenProfileVersion(wSDLComponent);
    }

    public boolean isSecureConversation(WSDLComponent wSDLComponent) {
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
        WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement, ProtectionToken.class);
        WSDLComponent wSDLComponent3 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent2);
        return wSDLComponent3 instanceof SecureConversationToken;
    }

    public void enableSecureConversation(WSDLComponent wSDLComponent, boolean bl) {
        ProfilesModelHelper.getInstance(PolicyModelHelper.getConfigVersion(wSDLComponent)).setSecureConversation(wSDLComponent, bl);
    }
}

