/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.api;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.undo.UndoManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.wsitconf.WSITEditor;
import org.netbeans.modules.websvc.wsitconf.ui.client.ClientTopComponent;
import org.netbeans.modules.websvc.wsitconf.ui.service.ServiceTopComponent;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWsStackProvider;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSITConfigProvider {
    private static final Logger logger = Logger.getLogger(WSITEditor.class.getName());
    private static WSITConfigProvider instance;

    private WSITConfigProvider() {
    }

    public static synchronized WSITConfigProvider getDefault() {
        if (instance == null) {
            instance = new WSITConfigProvider();
        }
        return instance;
    }

    public final JComponent getWSITServiceConfig(WSDLModel wSDLModel, UndoManager undoManager, Collection<Binding> collection, Node node) {
        ServiceTopComponent serviceTopComponent = new ServiceTopComponent(wSDLModel, undoManager, collection, node);
        return serviceTopComponent;
    }

    public final JComponent getWSITClientConfig(org.netbeans.modules.xml.wsdl.model.Service service, WSDLModel wSDLModel, WSDLModel wSDLModel2, Node node) {
        ClientTopComponent clientTopComponent = new ClientTopComponent(service, wSDLModel, wSDLModel2, node);
        return clientTopComponent;
    }

    public final boolean isWsitSecurityEnabled(Node node, JaxWsModel jaxWsModel) {
        Client client = (Client)node.getLookup().lookup(Client.class);
        Service service = (Service)node.getLookup().lookup(Service.class);
        Project project = null;
        if (jaxWsModel != null) {
            project = FileOwnerQuery.getOwner((FileObject)jaxWsModel.getJaxWsFile());
        }
        if (project != null) {
            try {
                WSDLModel wSDLModel = WSITModelSupport.getModel(node, jaxWsModel, null, false, null);
                if (wSDLModel != null) {
                    if (client != null) {
                        JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)project.getProjectDirectory());
                        if (jAXWSClientSupport != null) {
                            WSDLModel wSDLModel2 = WSITModelSupport.getServiceModelForClient(jAXWSClientSupport, client);
                            Collection collection = wSDLModel2.getDefinitions().getBindings();
                            for (Binding binding : collection) {
                                if (!SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)binding)) continue;
                                return true;
                            }
                        }
                    } else if (service != null) {
                        Collection collection = wSDLModel.getDefinitions().getBindings();
                        for (Binding binding : collection) {
                            if (!SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)binding)) continue;
                            return true;
                        }
                    }
                }
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, null, exception);
            }
        }
        return false;
    }

    public final boolean isWsitEnabled(Node node, JaxWsModel jaxWsModel) {
        Project project = null;
        if (jaxWsModel != null) {
            project = FileOwnerQuery.getOwner((FileObject)jaxWsModel.getJaxWsFile());
        }
        if (project != null) {
            try {
                WSDLModel wSDLModel = WSITModelSupport.getModel(node, jaxWsModel, null, false, null);
                if (wSDLModel != null) {
                    return true;
                }
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, null, exception);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSStackVersion getHighestWSStackVersion(Project project) {
        WSStack wSStack;
        J2eePlatform j2eePlatform = ServerUtils.getJ2eePlatform(project);
        Object object = null;
        WSStack wSStack2 = wSStack = j2eePlatform == null ? null : JaxWsStackProvider.getJaxWsStack((J2eePlatform)j2eePlatform);
        if (wSStack != null) {
            object = wSStack.getVersion();
        }
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            ClassPath classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile");
            FileObject fileObject = classPath.findResource("com/sun/tools/ws/version.properties");
            if (fileObject != null && fileObject.isValid()) {
                String string;
                inputStream = fileObject.getInputStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string2 = null;
                String string3 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    string = string2.trim();
                    if (!string.startsWith("major-version=")) continue;
                    string3 = string.substring(14);
                    break;
                }
                string = WSStackFactory.createWSStackVersion(string3);
                if (object == null) {
                    object = string;
                } else if (string.compareTo(object) > 0) {
                    object = string;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Exceptions.printStackTrace((Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return object;
    }
}

