/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.netbeans.modules.xml.retriever.impl.ResourceRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileResourceRetriever
implements ResourceRetriever {
    long streamLength = 0L;

    @Override
    public boolean accept(String string, String string2) throws URISyntaxException {
        URI uRI;
        URI uRI2 = new URI(string2);
        if (uRI2.isAbsolute() && uRI2.getScheme().equalsIgnoreCase("file")) {
            return true;
        }
        if (!uRI2.isAbsolute() && string == null) {
            return true;
        }
        return string != null && !uRI2.isAbsolute() && (uRI = new URI(string)).getScheme().equalsIgnoreCase("file");
    }

    @Override
    public HashMap<String, InputStream> retrieveDocument(String string, String string2) throws IOException, URISyntaxException {
        URI uRI = new URI(this.getEffectiveAddress(string, string2));
        HashMap<String, InputStream> hashMap = null;
        File file = new File(uRI);
        if (file.isFile()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            hashMap = new HashMap<String, InputStream>();
            hashMap.put(file.toURI().toString(), fileInputStream);
            this.streamLength = file.length();
            return hashMap;
        }
        throw new IOException("File not found: " + file.toString());
    }

    @Override
    public long getStreamLength() {
        return this.streamLength;
    }

    @Override
    public String getEffectiveAddress(String string, String string2) throws IOException, URISyntaxException {
        URI uRI = new URI(string2);
        if (uRI.isAbsolute()) {
            return uRI.toString();
        }
        if (string != null) {
            URI uRI2 = new URI(string);
            return uRI2.resolve(uRI).toString();
        }
        return null;
    }
}

