/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.SyntaxElement;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxTree {
    static final String UNEXPECTED_TAG_KEY = "unexpected_tag";
    static final String UNRESOLVED_TAG_KEY = "unresolved_tag";
    static final String UNKNOWN_TAG_KEY = "unknown_tag";
    static final String UNKNOWN_ATTRIBUTE_KEY = "unknown_attribute";
    static final String FORBIDDEN_END_TAG = "forbidded_endtag";
    static final String UNMATCHED_TAG = "unmatched_tag";
    static final String MISSING_REQUIRED_END_TAG = "missing_required_end_tag";
    static final String MISSING_REQUIRED_ATTRIBUTES = "missing_required_attribute";

    public static AstNode makeTree(List<SyntaxElement> list, DTD dTD) {
        Object object;
        assert (list != null);
        assert (dTD != null);
        SyntaxElement syntaxElement = list.size() > 0 ? list.get(list.size() - 1) : null;
        int n = syntaxElement == null ? 0 : syntaxElement.offset() + syntaxElement.length();
        AstNode astNode = new AstNode("root", AstNode.NodeType.ROOT, 0, n);
        LinkedList<AstNode> linkedList = new LinkedList<AstNode>();
        linkedList.add(astNode);
        for (SyntaxElement object2 : list) {
            Object object3;
            Object object4;
            AstNode astNode2;
            Object bl;
            if (object2.type() == 4) {
                assert (object2 instanceof SyntaxElement.Tag);
                bl = (SyntaxElement.Tag)object2;
                object = ((SyntaxElement.Named)bl).getName();
                astNode2 = (AstNode)linkedList.getLast();
                object4 = dTD.getElement((String)object);
                if (object4 == null) {
                    AstNode i = new AstNode((String)object, AstNode.NodeType.UNKNOWN_TAG, ((SyntaxElement)bl).offset(), ((SyntaxElement)bl).offset() + ((SyntaxElement)bl).length());
                    if (!SyntaxTree.isIgnoredTagName((String)object)) {
                        object3 = NbBundle.getMessage(SyntaxTree.class, (String)"MSG_UNKNOWN_TAG", (Object[])new Object[]{object});
                        i.addDescriptionToNode(UNKNOWN_TAG_KEY, (String)object3, 1);
                    }
                    astNode2.addChild(i);
                    continue;
                }
                AstNode astNode6 = new AstNode((String)object, AstNode.NodeType.OPEN_TAG, ((SyntaxElement)bl).offset(), ((SyntaxElement)bl).offset() + ((SyntaxElement)bl).length(), (DTD.Element)object4, SyntaxTree.stack(linkedList));
                SyntaxTree.checkTagAttributes(astNode6, (SyntaxElement.Tag)bl, (DTD.Element)object4);
                SyntaxTree.setTagAttributes(astNode6, (SyntaxElement.Tag)bl);
                if (astNode2 != astNode && !astNode2.reduce((DTD.Element)object4)) {
                    if (!astNode2.isResolved()) {
                        object3 = SyntaxTree.elementsToString(astNode2.getAllPossibleElements());
                        astNode6.addDescriptionToNode(UNEXPECTED_TAG_KEY, NbBundle.getMessage(SyntaxTree.class, (String)"MSG_UNEXPECTED_TAG", (Object[])new Object[]{object4.getName(), object3}), 2);
                    } else {
                        object3 = dTD.getElement(astNode2.name());
                        assert (object3 != null);
                        if (!object3.hasOptionalEnd()) {
                            Collection<DTD.Element> astNode7 = astNode2.getAllPossibleElements();
                            if (astNode7.isEmpty()) {
                                astNode6.addDescriptionToNode(UNEXPECTED_TAG_KEY, NbBundle.getMessage(SyntaxTree.class, (String)"MSG_UNEXPECTED_TAG_NO_EXPECTED_CONTENT", (Object[])new Object[]{object4.getName()}), 2);
                            } else {
                                String string = SyntaxTree.elementsToString(astNode7);
                                astNode6.addDescriptionToNode(UNEXPECTED_TAG_KEY, NbBundle.getMessage(SyntaxTree.class, (String)"MSG_UNEXPECTED_TAG", (Object[])new Object[]{object4.getName(), string}), 2);
                            }
                        } else {
                            AstNode astNode3;
                            int n2;
                            int astNode8 = -1;
                            for (n2 = linkedList.size() - 1; n2 > 0; --n2) {
                                astNode3 = linkedList.get(n2);
                                if (!astNode3.reduce((DTD.Element)object4)) continue;
                                astNode8 = n2;
                                break;
                            }
                            if (astNode8 == -1) {
                                linkedList.remove(astNode2);
                                astNode2.setLogicalEndOffset(astNode6.startOffset());
                                astNode2 = linkedList.getLast();
                                astNode2.addChild(astNode6);
                                if (astNode2 != astNode) {
                                    astNode6.addDescriptionToNode(UNEXPECTED_TAG_KEY, NbBundle.getMessage(SyntaxTree.class, (String)"MSG_UNEXPECTED_TAG_NO_EXPECTED_CONTENT", (Object[])new Object[]{object4.getName()}), 2);
                                    continue;
                                }
                                linkedList.addLast(astNode6);
                                continue;
                            }
                            for (n2 = linkedList.size() - 1; n2 > astNode8 && SyntaxTree.hasOptionalEndTag(astNode3 = linkedList.get(n2)); --n2) {
                                astNode3.setLogicalEndOffset(astNode6.startOffset());
                                linkedList.remove(n2);
                            }
                            astNode2 = linkedList.getLast();
                        }
                    }
                }
                if (!((SyntaxElement.Tag)bl).isEmpty() && !object4.isEmpty()) {
                    linkedList.addLast(astNode6);
                }
                astNode2.addChild(astNode6);
                continue;
            }
            if (object2.type() == 5) {
                bl = ((SyntaxElement.Named)object2).getName();
                object = dTD.getElement((String)bl);
                if (object == null) {
                    astNode2 = new AstNode((String)bl, AstNode.NodeType.UNKNOWN_TAG, object2.offset(), object2.offset() + object2.length());
                    if (!SyntaxTree.isIgnoredTagName((String)bl)) {
                        object4 = NbBundle.getMessage(SyntaxTree.class, (String)"MSG_UNKNOWN_TAG", (Object[])new Object[]{bl});
                        astNode2.addDescriptionToNode(UNKNOWN_TAG_KEY, (String)object4, 1);
                    }
                    linkedList.getLast().addChild(astNode2);
                    continue;
                }
                astNode2 = new AstNode((String)bl, AstNode.NodeType.ENDTAG, object2.offset(), object2.offset() + object2.length(), (DTD.Element)object, SyntaxTree.stack(linkedList));
                int n3 = -1;
                for (int string = linkedList.size() - 1; string >= 0; --string) {
                    object3 = linkedList.get(string);
                    if (!((String)bl).equals(((AstNode)object3).name())) continue;
                    if (SyntaxTree.hasForbiddedEndTag((AstNode)object3)) {
                        astNode2.addDescriptionToNode(FORBIDDEN_END_TAG, NbBundle.getMessage(SyntaxTree.class, (String)"MSG_FORBIDDEN_ENDTAG"), 2);
                        continue;
                    }
                    n3 = string;
                    break;
                }
                assert (n3 != 0);
                if (n3 > 0) {
                    AstNode astNode4 = linkedList.get(n3);
                    if (n3 != linkedList.size() - 1) {
                        int string;
                        for (string = linkedList.size() - 1; string > n3; --string) {
                            String string2;
                            AstNode astNode5 = linkedList.get(string);
                            if (!astNode5.isResolved()) {
                                string2 = NbBundle.getMessage(SyntaxTree.class, (String)"MSG_UNRESOLVED_TAG", (Object[])new Object[]{SyntaxTree.elementsToString(astNode5.getAllPossibleElements())});
                                astNode5.addDescriptionToNode(UNRESOLVED_TAG_KEY, string2, 2);
                            }
                            if (SyntaxTree.hasOptionalEndTag(astNode5)) continue;
                            string2 = NbBundle.getMessage(SyntaxTree.class, (String)"MSG_MISSING_REQUIRED_END_TAG");
                            astNode5.addDescriptionToNode(MISSING_REQUIRED_END_TAG, string2, 2);
                        }
                        for (string = linkedList.size() - 1; string > n3; --string) {
                            AstNode astNode6 = linkedList.get(string);
                            astNode6.setLogicalEndOffset(astNode2.startOffset());
                            linkedList.remove(string);
                        }
                    }
                    if (!astNode4.isResolved()) {
                        String string = NbBundle.getMessage(SyntaxTree.class, (String)"MSG_UNRESOLVED_TAG", (Object[])new Object[]{SyntaxTree.elementsToString(astNode4.getAllPossibleElements())});
                        astNode4.addDescriptionToNode(UNRESOLVED_TAG_KEY, string, 2);
                    }
                    object3 = linkedList.get(n3 - 1);
                    ((AstNode)object3).addChild(astNode2);
                    astNode4.setMatchingNode(astNode2);
                    astNode4.setLogicalEndOffset(astNode2.endOffset());
                    astNode2.setMatchingNode(astNode4);
                    linkedList.removeLast();
                    continue;
                }
                if (!object.hasOptionalStart()) {
                    String string = NbBundle.getMessage(SyntaxTree.class, (String)"MSG_UNMATCHED_TAG");
                    astNode2.addDescriptionToNode(UNMATCHED_TAG, string, 1);
                }
                linkedList.getLast().addChild(astNode2);
                continue;
            }
            bl = SyntaxTree.intToNodeType(object2.type());
            object = new AstNode(null, (AstNode.NodeType)((Object)bl), object2.offset(), object2.offset() + object2.length());
            ((AstNode)linkedList.getLast()).addChild((AstNode)object);
        }
        for (int i = linkedList.size() - 1; i > 0; --i) {
            AstNode astNode7 = (AstNode)linkedList.get(i);
            boolean bl = true;
            if (!SyntaxTree.hasOptionalEndTag(astNode7)) {
                object = NbBundle.getMessage(SyntaxTree.class, (String)"MSG_UNMATCHED_TAG");
                astNode7.addDescriptionToNode(UNMATCHED_TAG, (String)object, 1);
                bl = false;
            }
            if (!astNode7.isResolved()) {
                object = NbBundle.getMessage(SyntaxTree.class, (String)"MSG_UNRESOLVED_TAG", (Object[])new Object[]{SyntaxTree.elementsToString(astNode7.getAllPossibleElements())});
                astNode7.addDescriptionToNode(UNRESOLVED_TAG_KEY, (String)object, 2);
                bl = false;
            }
            if (!bl) continue;
            astNode7.setLogicalEndOffset(n);
        }
        return astNode;
    }

    private static List<String> stack(LinkedList<AstNode> linkedList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AstNode astNode : linkedList) {
            arrayList.add(astNode.name());
        }
        return arrayList;
    }

    private static boolean hasForbiddedEndTag(AstNode astNode) {
        DTD.Element element = astNode.getDTDElement();
        assert (element != null);
        return element.isEmpty();
    }

    private static boolean hasOptionalEndTag(AstNode astNode) {
        DTD.Element element = astNode.getDTDElement();
        assert (element != null);
        return element.hasOptionalEnd();
    }

    private static boolean isIgnoredTagName(String string) {
        return string.contains(":");
    }

    private static boolean isIgnoredTagAttribute(String string) {
        return string.contains(":");
    }

    private static void checkTagAttributes(AstNode astNode, SyntaxElement.Tag tag, DTD.Element element) {
        DTD.Attribute attribute;
        List<SyntaxElement.TagAttribute> list = tag.getAttributes();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (SyntaxElement.TagAttribute object : list) {
            String string = object.getName().toLowerCase(Locale.ENGLISH);
            arrayList.add(object.getName().toLowerCase(Locale.ENGLISH));
            attribute = element.getAttribute(string);
            if (attribute != null || SyntaxTree.isIgnoredTagAttribute(object.getName())) continue;
            AstNode.Description description = AstNode.Description.create(UNKNOWN_ATTRIBUTE_KEY, NbBundle.getMessage(SyntaxTree.class, (String)"MSG_UNKNOWN_ATTRIBUTE", (Object[])new Object[]{object.getName(), tag.getName()}), 1, object.getNameOffset(), object.getNameOffset() + object.getName().length());
            astNode.addDescription(description);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : element.getAttributeList(null)) {
            attribute = (DTD.Attribute)((Object)string);
            if (!attribute.isRequired() || arrayList.contains(attribute.getName())) continue;
            stringBuffer.append(attribute.getName());
            stringBuffer.append(", ");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 2);
            astNode.addDescriptionToNode(MISSING_REQUIRED_ATTRIBUTES, NbBundle.getMessage(SyntaxTree.class, (String)"MSG_MISSING_REQUIRED_ATTRIBUTES", (Object[])new Object[]{stringBuffer.toString()}), 1);
        }
    }

    private static void setTagAttributes(AstNode astNode, SyntaxElement.Tag tag) {
        for (SyntaxElement.TagAttribute tagAttribute : tag.getAttributes()) {
            if (tagAttribute == null) continue;
            astNode.setAttribute(tagAttribute.getName(), tagAttribute.getValue());
        }
    }

    private static String elementsToString(Collection<DTD.Element> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        for (DTD.Element element : collection) {
            stringBuffer.append('<');
            stringBuffer.append(element.getName());
            stringBuffer.append('>');
            stringBuffer.append(", ");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        }
        return stringBuffer.toString();
    }

    private static AstNode.NodeType intToNodeType(int n) {
        switch (n) {
            case 0: {
                return AstNode.NodeType.COMMENT;
            }
            case 1: {
                return AstNode.NodeType.DECLARATION;
            }
            case 5: {
                return AstNode.NodeType.ENDTAG;
            }
            case 6: {
                return AstNode.NodeType.ENTITY_REFERENCE;
            }
            case 2: {
                return AstNode.NodeType.ERROR;
            }
            case 4: {
                return AstNode.NodeType.OPEN_TAG;
            }
            case 3: {
                return AstNode.NodeType.TEXT;
            }
        }
        return null;
    }
}

