/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.ext.html.parser.ParserSource;
import org.openide.ErrorManager;

public class SyntaxElement {
    public static final int TYPE_COMMENT = 0;
    public static final int TYPE_DECLARATION = 1;
    public static final int TYPE_ERROR = 2;
    public static final int TYPE_TEXT = 3;
    public static final int TYPE_TAG = 4;
    public static final int TYPE_ENDTAG = 5;
    public static final int TYPE_ENTITY_REFERENCE = 6;
    public static final String[] TYPE_NAMES = new String[]{"comment", "declaration", "error", "text", "tag", "endtag", "entity reference"};
    private ParserSource source;
    private int offset;
    private int length;
    private int type;

    SyntaxElement(ParserSource parserSource, int n, int n2, int n3) {
        this.offset = n;
        this.length = n2;
        this.type = n3;
        this.source = parserSource;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public int type() {
        return this.type;
    }

    public String text() {
        try {
            return ((Object)this.source.getText(this.offset(), this.length())).toString();
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(16, (Throwable)badLocationException);
            return null;
        }
    }

    public String toString() {
        String string = this.text();
        return "Element(" + TYPE_NAMES[this.type] + ")[" + this.offset + "," + (this.offset + this.length - 1) + "] \"" + string + "\"";
    }

    public static class TagAttribute {
        private String name;
        private String value;
        private int nameOffset;
        private int valueOffset;
        private int valueLength;

        TagAttribute(String string, String string2, int n, int n2, int n3) {
            this.name = string;
            this.value = string2;
            this.nameOffset = n;
            this.valueOffset = n2;
            this.valueLength = n3;
        }

        public String getName() {
            return this.name;
        }

        void setName(String string) {
            this.name = string;
        }

        public String getValue() {
            return this.value;
        }

        public int getValueLength() {
            return this.valueLength;
        }

        void setValue(String string) {
            this.value = string;
        }

        public int getNameOffset() {
            return this.nameOffset;
        }

        void setNameOffset(int n) {
            this.nameOffset = n;
        }

        public int getValueOffset() {
            return this.valueOffset;
        }

        void setValueOffset(int n) {
            this.valueOffset = n;
        }

        public String toString() {
            return "TagAttribute[name=" + this.getName() + "; value=" + this.getValue() + "; nameOffset=" + this.getNameOffset() + "; valueOffset=" + this.getValueOffset() + "]";
        }

        public boolean equals(Object object) {
            if (!(object instanceof TagAttribute)) {
                return false;
            }
            return this.getName().equals(((TagAttribute)object).getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tag
    extends Named {
        private List<TagAttribute> attribs;
        private boolean empty;
        private boolean openTag;

        public Tag(ParserSource parserSource, int n, int n2, String string, List list, boolean bl, boolean bl2) {
            super(parserSource, n, n2, bl ? 4 : 5, string);
            this.attribs = list;
            this.openTag = bl;
            this.empty = bl2;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public boolean isOpenTag() {
            return this.openTag;
        }

        public List<TagAttribute> getAttributes() {
            return this.attribs == null ? Collections.EMPTY_LIST : this.attribs;
        }

        public TagAttribute getAttribute(String string) {
            return this.getAttribute(string, true);
        }

        public TagAttribute getAttribute(String string, boolean bl) {
            for (TagAttribute tagAttribute : this.getAttributes()) {
                if (!tagAttribute.getName().equals(string)) continue;
                return tagAttribute;
            }
            return null;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(" - {");
            Iterator<TagAttribute> iterator = this.getAttributes().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                stringBuffer.append(", ");
            }
            stringBuffer.append("}");
            if (this.isEmpty()) {
                stringBuffer.append(" (EMPTY TAG)");
            }
            return stringBuffer.toString();
        }
    }

    public static class Named
    extends SyntaxElement {
        String name;

        public Named(ParserSource parserSource, int n, int n2, int n3, String string) {
            super(parserSource, n, n2, n3);
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return super.toString() + " - \"" + this.name + '\"';
        }
    }

    public static class Declaration
    extends SyntaxElement {
        private String root;
        private String publicID;
        private String file;

        public Declaration(ParserSource parserSource, int n, int n2, String string, String string2, String string3) {
            super(parserSource, n, n2, 1);
            this.root = string;
            this.publicID = string2;
            this.file = string3;
        }

        public String getRootElement() {
            return this.root;
        }

        public String getPublicIdentifier() {
            return this.publicID;
        }

        public String getDoctypeFile() {
            return this.file;
        }
    }
}

