/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.StringTokenizer;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeVisitor;

public class AstNodeUtils {
    private static final String INDENT = "   ";

    public static void dumpTree(AstNode astNode) {
        StringBuffer stringBuffer = new StringBuffer();
        AstNodeUtils.dumpTree(astNode, stringBuffer);
        System.out.println(stringBuffer.toString());
    }

    public static void dumpTree(AstNode astNode, StringBuffer stringBuffer) {
        AstNodeUtils.dump(astNode, "", stringBuffer);
    }

    private static void dump(AstNode astNode, String string, StringBuffer stringBuffer) {
        stringBuffer.append(string + astNode.toString());
        stringBuffer.append('\n');
        for (AstNode astNode2 : astNode.children()) {
            AstNodeUtils.dump(astNode2, string + INDENT, stringBuffer);
        }
    }

    public static AstNode getRoot(AstNode astNode) {
        while (astNode.parent() != null) {
            astNode = astNode.parent();
        }
        return astNode;
    }

    public static AstNode findDescendant(AstNode astNode, int n) {
        int[] nArray = astNode.getLogicalRange();
        int n2 = nArray[0];
        int n3 = nArray[1];
        if (n < n2 || n > n3) {
            return null;
        }
        if (n >= n2 && n < n3 && astNode.children().isEmpty()) {
            return astNode;
        }
        for (AstNode astNode2 : astNode.children()) {
            int[] nArray2 = astNode2.getLogicalRange();
            int n4 = nArray2[0];
            int n5 = nArray2[1];
            if (n < n4 || n >= n5) continue;
            return AstNodeUtils.findDescendant(astNode2, n);
        }
        return astNode;
    }

    public static AstNode getTagNode(AstNode astNode, int n) {
        if (astNode.type() == AstNode.NodeType.OPEN_TAG) {
            if (n >= astNode.startOffset() && n < astNode.endOffset()) {
                return astNode;
            }
            AstNode astNode2 = astNode.getMatchingTag();
            if (astNode2 != null && astNode2.type() == AstNode.NodeType.ENDTAG && n >= astNode2.startOffset() && n < astNode2.endOffset()) {
                return astNode2;
            }
            return null;
        }
        return astNode;
    }

    public static AstNode query(AstNode astNode, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        AstNode astNode2 = astNode;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(124);
            String string3 = n >= 0 ? string2.substring(0, n) : string2;
            String string4 = n >= 0 ? string2.substring(n + 1, string2.length()) : "0";
            int n2 = Integer.parseInt(string4);
            int n3 = 0;
            AstNode astNode3 = null;
            for (AstNode astNode4 : astNode2.children()) {
                if (astNode4.type() != AstNode.NodeType.OPEN_TAG || !astNode4.name().equals(string3) || n3++ != n2) continue;
                astNode3 = astNode4;
                break;
            }
            if (astNode3 != null) {
                astNode2 = astNode3;
                if (stringTokenizer.hasMoreTokens()) continue;
                assert (astNode2.name().equals(string3));
                return astNode2;
            }
            return null;
        }
        return null;
    }

    public static void visitChildren(AstNode astNode, AstNodeVisitor astNodeVisitor) {
        for (AstNode astNode2 : astNode.children()) {
            astNodeVisitor.visit(astNode2);
            AstNodeUtils.visitChildren(astNode2, astNodeVisitor);
        }
    }

    public static void visitAncestors(AstNode astNode, AstNodeVisitor astNodeVisitor) {
        AstNode astNode2 = astNode.parent();
        if (astNode2 != null) {
            astNodeVisitor.visit(astNode2);
            AstNodeUtils.visitAncestors(astNode2, astNodeVisitor);
        }
    }
}

