/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.javadoc;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.editor.ext.html.javadoc.SAXHelpHandler;
import org.netbeans.editor.ext.html.javadoc.TagHelpItem;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.xml.sax.helpers.DefaultHandler;

public class HelpManager {
    private static HelpManager manager = null;
    private Hashtable helpMap = null;
    private long lastChange = 0L;
    private String helpZipURL = null;
    private URL lastURL = null;

    private HelpManager() {
    }

    public static HelpManager getDefault() {
        if (manager == null) {
            manager = new HelpManager();
        }
        return manager;
    }

    private void init() {
        block7: {
            if (this.helpMap != null) {
                return;
            }
            String string = "";
            try {
                if (this.helpMap != null) break block7;
                InputStream inputStream = HelpManager.class.getClassLoader().getResourceAsStream("org/netbeans/editor/ext/html/javadoc/resources/HtmlHelp.xml");
                if (inputStream == null) {
                    this.helpMap = new Hashtable();
                    return;
                }
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                SAXHelpHandler sAXHelpHandler = new SAXHelpHandler();
                Date date = new Date();
                sAXParser.parse(inputStream, (DefaultHandler)sAXHelpHandler);
                inputStream.close();
                string = sAXHelpHandler.getHelpFile();
                if (string == null || string.equals("")) {
                    string = null;
                    this.helpMap = new Hashtable();
                    return;
                }
                this.helpMap = sAXHelpHandler.getMap();
                File file = InstalledFileLocator.getDefault().locate(string, null, false);
                if (file == null) break block7;
                try {
                    URL uRL = file.toURL();
                    uRL = FileUtil.getArchiveRoot((URL)uRL);
                    this.helpZipURL = new URI(uRL.getProtocol(), uRL.getFile(), uRL.getRef()).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)malformedURLException);
                    this.helpMap = new Hashtable();
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ErrorManager.getDefault().log(exception.toString());
            }
        }
    }

    public URL getRelativeHelpToLast(String string) {
        return this.getRelativeURL(this.lastURL, string);
    }

    public URL getRelativeURL(URL uRL, String string) {
        String string2 = uRL.toString();
        if (string.trim().charAt(0) == '#') {
            int n = string2.indexOf(35);
            if (n > -1) {
                string2 = string2.substring(0, string2.indexOf(35));
            }
            string2 = string2 + string;
        } else {
            int n = 0;
            string2 = string2.substring(0, string2.lastIndexOf(47));
            while ((n = string.indexOf("../", n)) > -1) {
                string2 = string2.substring(0, string2.lastIndexOf(47));
                string = string.substring(n + 3);
            }
            string2 = string2 + "/" + string;
        }
        URL uRL2 = null;
        try {
            uRL2 = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().log(malformedURLException.toString());
            return null;
        }
        return uRL2;
    }

    public String getHelp(String string) {
        if (string == null) {
            return null;
        }
        return this.getHelp(this.findHelpItem(string));
    }

    public String getHelp(TagHelpItem tagHelpItem) {
        URL uRL = this.getHelpURL(tagHelpItem);
        if (uRL == null) {
            return null;
        }
        this.lastURL = uRL;
        String string = this.getHelpText(uRL);
        int n = 0;
        if (string != null) {
            if (tagHelpItem.getStartText() != null && (n = string.indexOf(tagHelpItem.getStartText())) > 0) {
                string = string.substring(n += tagHelpItem.getStartTextOffset());
            }
            if (tagHelpItem.getEndText() != null && (n = string.indexOf(tagHelpItem.getEndText())) > 0) {
                string = string.substring(0, n += tagHelpItem.getEndTextOffset());
            }
        } else {
            string = "";
        }
        if (tagHelpItem.getTextBefore() != null) {
            string = tagHelpItem.getTextBefore() + string;
        }
        if (tagHelpItem.getTextAfter() != null) {
            string = string + tagHelpItem.getTextAfter();
        }
        return string;
    }

    public String getHelpText(URL uRL) {
        if (uRL == null) {
            return null;
        }
        try {
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[1000];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            do {
                if ((n = inputStream.read(byArray)) <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n);
            } while (n > 0);
            inputStream.close();
            String string = byteArrayOutputStream.toString();
            byteArrayOutputStream.close();
            return string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public URL getHelpURL(String string) {
        return this.getHelpURL(this.findHelpItem(string));
    }

    public URL getHelpURLForLink(String string) {
        URL uRL = null;
        if (string != null) {
            String string2 = this.helpZipURL + string;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().log(malformedURLException.toString());
                return null;
            }
        }
        return uRL;
    }

    public URL getHelpURL(TagHelpItem tagHelpItem) {
        URL uRL = null;
        if (tagHelpItem != null) {
            String string = this.helpZipURL + tagHelpItem.getFile();
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().log(malformedURLException.toString());
                return null;
            }
        }
        return uRL;
    }

    public TagHelpItem findHelpItem(String string) {
        if (string == null) {
            return null;
        }
        this.init();
        Object v = this.helpMap.get(string.toUpperCase());
        if (v != null) {
            TagHelpItem tagHelpItem = (TagHelpItem)v;
            if (tagHelpItem != null) {
                while (tagHelpItem != null && tagHelpItem.getIdentical() != null) {
                    tagHelpItem = (TagHelpItem)this.helpMap.get(tagHelpItem.getIdentical().toUpperCase());
                }
            }
            return tagHelpItem;
        }
        return null;
    }

    public String getHelpText(URL uRL, String string) {
        String string2 = "<a name=\"" + string + "\"";
        String string3 = this.getHelpText(uRL);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string3));
        String string4 = null;
        StringBuffer stringBuffer = null;
        int n = 0;
        try {
            while ((string4 = bufferedReader.readLine()) != null) {
                if (string4.indexOf(string2) != -1) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(string4.substring(string4.indexOf(string2)));
                    continue;
                }
                if (stringBuffer == null) continue;
                if (string4.indexOf("<pre") != -1) {
                    ++n;
                }
                if (string4.indexOf("</pre") != -1) {
                    --n;
                }
                stringBuffer.append(string4 + "\n");
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return stringBuffer == null ? null : "<html><body>" + (n < 0 ? "<pre>" : "") + stringBuffer.toString();
    }

    public String getAnchorText(URL uRL) {
        String string = uRL.toExternalForm();
        if (string.indexOf(35) != -1) {
            return string.substring(string.indexOf(35) + 1);
        }
        return null;
    }
}

