/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.html.SyntaxElement;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.dtd.InvalidateEvent;
import org.netbeans.editor.ext.html.dtd.InvalidateListener;
import org.netbeans.editor.ext.html.dtd.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlSyntaxSupport
extends ExtSyntaxSupport
implements InvalidateListener {
    private static final String FALLBACK_DOCTYPE = "-//W3C//DTD HTML 4.01 Transitional//EN";
    private DTD dtd;
    private String docType;

    public static synchronized HtmlSyntaxSupport get(Document document) {
        HtmlSyntaxSupport htmlSyntaxSupport = (HtmlSyntaxSupport)document.getProperty(HtmlSyntaxSupport.class);
        if (htmlSyntaxSupport == null) {
            htmlSyntaxSupport = new HtmlSyntaxSupport((BaseDocument)document);
            document.putProperty(HtmlSyntaxSupport.class, htmlSyntaxSupport);
        }
        return htmlSyntaxSupport;
    }

    private HtmlSyntaxSupport(BaseDocument baseDocument) {
        super(baseDocument);
    }

    @Override
    public void dtdInvalidated(InvalidateEvent invalidateEvent) {
        if (this.dtd != null && invalidateEvent.isInvalidatedIdentifier(this.docType)) {
            this.dtd = null;
        }
    }

    public DTD getDTD() {
        String string = this.getDocType();
        if (string == null) {
            string = FALLBACK_DOCTYPE;
        }
        if (this.dtd != null && string == this.docType) {
            return this.dtd;
        }
        this.docType = string;
        this.dtd = Registry.getDTD(this.docType, null);
        if (this.dtd == null) {
            this.dtd = Registry.getDTD(FALLBACK_DOCTYPE, null);
        }
        return this.dtd;
    }

    String getDocType() {
        try {
            SyntaxElement syntaxElement = this.getElementChain(0);
            if (syntaxElement == null) {
                return null;
            }
            int n = syntaxElement.getType();
            while (n != 1 && n != 4 && (syntaxElement = syntaxElement.getNext()) != null) {
                n = syntaxElement.getType();
            }
            if (n == 1) {
                return ((SyntaxElement.Declaration)syntaxElement).getPublicIdentifier();
            }
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkOpenCompletion(Document document, int n, String string) {
        BaseDocument baseDocument = (BaseDocument)document;
        switch (string.charAt(string.length() - 1)) {
            case '/': {
                if (n < 2) break;
                try {
                    String string2 = baseDocument.getText(n - 2, 2);
                    if (string2.equals("</")) {
                        return true;
                    }
                }
                catch (BadLocationException badLocationException) {}
                break;
            }
            case ' ': {
                baseDocument.readLock();
                try {
                    TokenSequence<HTMLTokenId> tokenSequence = HtmlSyntaxSupport.getJoinedHtmlSequence((Document)baseDocument);
                    if (tokenSequence == null) {
                        boolean bl = false;
                        return bl;
                    }
                    tokenSequence.move(n - 1);
                    if ((tokenSequence.moveNext() || tokenSequence.movePrevious()) && tokenSequence.token().id() == HTMLTokenId.WS) {
                        boolean bl = true;
                        return bl;
                    }
                    break;
                }
                finally {
                    baseDocument.readUnlock();
                }
            }
            case '&': 
            case '<': {
                return true;
            }
        }
        return false;
    }

    SyntaxElement getPreviousElement(int n) throws BadLocationException {
        return n == 0 ? null : this.getElementChain(n - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyntaxElement getElementChain(int n) throws BadLocationException {
        this.getDocument().readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.getDocument());
            TokenSequence<HTMLTokenId> tokenSequence = HtmlSyntaxSupport.getJoinedHtmlSequence((Document)this.getDocument());
            if (tokenSequence == null) {
                SyntaxElement syntaxElement = null;
                return syntaxElement;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                SyntaxElement syntaxElement = null;
                return syntaxElement;
            }
            Token token = tokenSequence.token();
            int n2 = tokenSequence.offset();
            if (n2 > n) {
                SyntaxElement syntaxElement = null;
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.CHARACTER) {
                do {
                    token = tokenSequence.token();
                    n2 = tokenSequence.offset();
                } while (token.id() == HTMLTokenId.CHARACTER && tokenSequence.movePrevious());
                if (token.id() != HTMLTokenId.VALUE && token.id() != HTMLTokenId.TEXT) {
                    SyntaxElement syntaxElement = this.getNextElement(n2);
                    return syntaxElement;
                }
            }
            if (token.id() == HTMLTokenId.WS || token.id() == HTMLTokenId.ARGUMENT || token.id() == HTMLTokenId.OPERATOR || token.id() == HTMLTokenId.VALUE) {
                while (tokenSequence.movePrevious() && !HtmlSyntaxSupport.isTagSymbol(token = tokenSequence.token())) {
                }
                SyntaxElement syntaxElement = this.getNextElement(token.offset(tokenHierarchy));
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.TEXT) {
                do {
                    n2 = tokenSequence.offset();
                } while (tokenSequence.movePrevious() && (tokenSequence.token().id() == HTMLTokenId.TEXT || tokenSequence.token().id() == HTMLTokenId.CHARACTER));
                SyntaxElement syntaxElement = this.getNextElement(n2);
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.SCRIPT) {
                SyntaxElement syntaxElement = this.getNextElement(tokenSequence.token().offset(tokenHierarchy));
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.STYLE) {
                SyntaxElement syntaxElement = this.getNextElement(tokenSequence.token().offset(tokenHierarchy));
                return syntaxElement;
            }
            if (HtmlSyntaxSupport.isTag(token)) {
                if (token.id() == HTMLTokenId.TAG_OPEN || token.id() == HTMLTokenId.TAG_OPEN_SYMBOL) {
                    SyntaxElement syntaxElement = this.getNextElement(token.offset(tokenHierarchy));
                    return syntaxElement;
                }
                do {
                    if (tokenSequence.movePrevious()) continue;
                    SyntaxElement syntaxElement = this.getNextElement(token.offset(tokenHierarchy));
                    return syntaxElement;
                } while ((token = tokenSequence.token()).id() != HTMLTokenId.TAG_OPEN_SYMBOL);
                SyntaxElement syntaxElement = this.getNextElement(token.offset(tokenHierarchy));
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.ERROR) {
                SyntaxElement syntaxElement = new SyntaxElement(this, token.offset(tokenHierarchy), HtmlSyntaxSupport.getTokenEnd(tokenHierarchy, token), 2);
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.BLOCK_COMMENT) {
                while (token.id() == HTMLTokenId.BLOCK_COMMENT && !((Object)token.text()).toString().startsWith("<!--") && tokenSequence.movePrevious()) {
                    token = tokenSequence.token();
                }
                SyntaxElement syntaxElement = this.getNextElement(token.offset(tokenHierarchy));
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.DECLARATION || token.id() == HTMLTokenId.SGML_COMMENT) {
                while ((token.id() != HTMLTokenId.DECLARATION || !((Object)token.text()).toString().startsWith("<!")) && tokenSequence.movePrevious()) {
                    token = tokenSequence.token();
                }
                SyntaxElement syntaxElement = this.getNextElement(token.offset(tokenHierarchy));
                return syntaxElement;
            }
        }
        finally {
            this.getDocument().readUnlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SyntaxElement getNextElement(int n) throws BadLocationException {
        this.getDocument().readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.getDocument());
            TokenSequence<HTMLTokenId> tokenSequence = HtmlSyntaxSupport.getJoinedHtmlSequence((Document)this.getDocument());
            if (tokenSequence == null) {
                SyntaxElement syntaxElement = null;
                return syntaxElement;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext()) {
                SyntaxElement syntaxElement = null;
                return syntaxElement;
            }
            Token token = tokenSequence.token();
            int n2 = HtmlSyntaxSupport.getTokenEnd(tokenHierarchy, token);
            if (token.id() == HTMLTokenId.BLOCK_COMMENT) {
                do {
                    n2 = HtmlSyntaxSupport.getTokenEnd(tokenHierarchy, tokenSequence.token());
                } while (tokenSequence.token().id() == HTMLTokenId.BLOCK_COMMENT && tokenSequence.moveNext());
                SyntaxElement syntaxElement = new SyntaxElement(this, n, n2, 0);
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.DECLARATION) {
                Object object;
                String string;
                StringBuffer stringBuffer = new StringBuffer(token.text());
                while (token.id() == HTMLTokenId.DECLARATION || token.id() == HTMLTokenId.SGML_COMMENT || token.id() == HTMLTokenId.WS) {
                    n2 = HtmlSyntaxSupport.getTokenEnd(tokenHierarchy, token);
                    if (!tokenSequence.moveNext()) break;
                    token = tokenSequence.token();
                    if (token.id() != HTMLTokenId.DECLARATION && token.id() != HTMLTokenId.WS) continue;
                    stringBuffer.append(((Object)token.text()).toString());
                }
                if (!(string = stringBuffer.toString()).startsWith("<!DOCTYPE")) {
                    SyntaxElement.Declaration declaration = new SyntaxElement.Declaration(this, n, n2, null, null, null);
                    return declaration;
                }
                int n3 = (string = string.substring(9).trim()).indexOf(32);
                if (n3 < 0) {
                    SyntaxElement.Declaration declaration = new SyntaxElement.Declaration(this, n, n2, null, null, null);
                    return declaration;
                }
                String string2 = string.substring(0, n3);
                if ((string = string.substring(n3).trim()).startsWith("PUBLIC")) {
                    stringBuffer = new StringBuffer(string = string.substring(6).trim());
                    object = HtmlSyntaxSupport.getQuotedString(stringBuffer);
                    if (object != null) {
                        String string3 = HtmlSyntaxSupport.getQuotedString(stringBuffer);
                        SyntaxElement.Declaration declaration = new SyntaxElement.Declaration(this, n, n2, string2, (String)object, string3);
                        return declaration;
                    }
                } else if (string.startsWith("SYSTEM") && (object = HtmlSyntaxSupport.getQuotedString(stringBuffer = new StringBuffer(string = string.substring(6).trim()))) != null) {
                    SyntaxElement.Declaration declaration = new SyntaxElement.Declaration(this, n, n2, string2, null, (String)object);
                    return declaration;
                }
                object = new SyntaxElement.Declaration(this, n, n2, null, null, null);
                return object;
            }
            if (token.id() == HTMLTokenId.ERROR) {
                SyntaxElement syntaxElement = new SyntaxElement(this, token.offset(tokenHierarchy), n2, 2);
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.TEXT || token.id() == HTMLTokenId.CHARACTER) {
                do {
                    n2 = HtmlSyntaxSupport.getTokenEnd(tokenHierarchy, token);
                    token = tokenSequence.token();
                } while (tokenSequence.moveNext() && (token.id() == HTMLTokenId.TEXT || token.id() == HTMLTokenId.CHARACTER));
                SyntaxElement syntaxElement = new SyntaxElement(this, n, n2, 3);
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.SCRIPT) {
                SyntaxElement syntaxElement = new SyntaxElement(this, n, HtmlSyntaxSupport.getTokenEnd(tokenHierarchy, token), 6);
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.STYLE) {
                SyntaxElement syntaxElement = new SyntaxElement(this, n, HtmlSyntaxSupport.getTokenEnd(tokenHierarchy, token), 7);
                return syntaxElement;
            }
            if (token.id() == HTMLTokenId.TAG_CLOSE || token.id() == HTMLTokenId.TAG_OPEN_SYMBOL && ((Object)token.text()).toString().equals("</")) {
                String string = ((Object)token.text()).toString();
                if (token.id() == HTMLTokenId.TAG_OPEN_SYMBOL) {
                    tokenSequence.moveNext();
                    string = ((Object)tokenSequence.token().text()).toString();
                }
                tokenSequence.moveNext();
                token = tokenSequence.token();
                do {
                    token = tokenSequence.token();
                    n2 = HtmlSyntaxSupport.getTokenEnd(tokenHierarchy, token);
                } while (token.id() == HTMLTokenId.WS && tokenSequence.moveNext());
                if (token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL) {
                    SyntaxElement.Named named = new SyntaxElement.Named(this, n, HtmlSyntaxSupport.getTokenEnd(tokenHierarchy, token), 5, string);
                    return named;
                }
                SyntaxElement.Named named = new SyntaxElement.Named(this, n, n2, 5, string);
                return named;
            }
            if (token.id() == HTMLTokenId.TAG_OPEN || token.id() == HTMLTokenId.TAG_OPEN_SYMBOL && !((Object)token.text()).toString().equals("</")) {
                Object object;
                String string = ((Object)token.text()).toString();
                ArrayList<SyntaxElement.TagAttribute> arrayList = new ArrayList<SyntaxElement.TagAttribute>();
                if (token.id() == HTMLTokenId.TAG_OPEN_SYMBOL) {
                    tokenSequence.moveNext();
                    string = ((Object)tokenSequence.token().text()).toString();
                }
                tokenSequence.moveNext();
                token = tokenSequence.token();
                Token token2 = null;
                do {
                    if ((token = tokenSequence.token()).id() == HTMLTokenId.ARGUMENT) {
                        token2 = token;
                    } else if (token.id() == HTMLTokenId.VALUE && token2 != null) {
                        object = new StringBuffer();
                        Token token3 = null;
                        do {
                            token3 = tokenSequence.token();
                            ((StringBuffer)object).append(((Object)token3.text()).toString());
                        } while (tokenSequence.moveNext() && (tokenSequence.token().id() == HTMLTokenId.VALUE || tokenSequence.token().id() == HTMLTokenId.CHARACTER));
                        SyntaxElement.TagAttribute tagAttribute = new SyntaxElement.TagAttribute(((Object)token2.text()).toString(), ((StringBuffer)object).toString(), token2.offset(tokenHierarchy), token.offset(tokenHierarchy));
                        arrayList.add(tagAttribute);
                        token2 = null;
                    }
                    n2 = HtmlSyntaxSupport.getTokenEnd(tokenHierarchy, token);
                } while ((token.id() == HTMLTokenId.WS || token.id() == HTMLTokenId.ARGUMENT || token.id() == HTMLTokenId.OPERATOR || token.id() == HTMLTokenId.VALUE || token.id() == HTMLTokenId.CHARACTER) && tokenSequence.moveNext());
                if (token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL) {
                    object = new SyntaxElement.Tag(this, n, HtmlSyntaxSupport.getTokenEnd(tokenHierarchy, token), string, arrayList, ((Object)token.text()).toString().equals("/>"));
                    return object;
                }
                object = new SyntaxElement.Tag(this, n, n2, string, arrayList);
                return object;
            }
        }
        finally {
            this.getDocument().readUnlock();
        }
        return null;
    }

    private static boolean isTagSymbol(Token token) {
        return token.id() == HTMLTokenId.TAG_OPEN_SYMBOL || token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL;
    }

    private static boolean isTag(Token token) {
        return token.id() == HTMLTokenId.TAG_OPEN || token.id() == HTMLTokenId.TAG_CLOSE || token.id() == HTMLTokenId.TAG_OPEN_SYMBOL || token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL;
    }

    private static int getTokenEnd(TokenHierarchy tokenHierarchy, Token token) {
        List list = token.joinedParts();
        if (list != null) {
            token = (Token)list.get(list.size() - 1);
        }
        return token.offset(tokenHierarchy) + token.text().length();
    }

    private static String getQuotedString(StringBuffer stringBuffer) {
        char c;
        int n = 0;
        if (stringBuffer == null || stringBuffer.length() == 0) {
            return null;
        }
        while (stringBuffer.charAt(n) == ' ') {
            ++n;
        }
        if ((c = stringBuffer.charAt(n++)) == '\"' || c == '\'') {
            for (int i = n; i < stringBuffer.length(); ++i) {
                if (stringBuffer.charAt(i) != c) continue;
                String string = stringBuffer.substring(n, i);
                stringBuffer.delete(0, i + 1);
                return string;
            }
        }
        return null;
    }

    private static LanguagePath findTopMostHtml(Document document) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        for (LanguagePath languagePath : tokenHierarchy.languagePaths()) {
            if (languagePath.innerLanguage() != HTMLTokenId.language()) continue;
            return languagePath;
        }
        return null;
    }

    public static TokenSequence<HTMLTokenId> getJoinedHtmlSequence(Document document) {
        LanguagePath languagePath = HtmlSyntaxSupport.findTopMostHtml(document);
        if (languagePath == null) {
            return null;
        }
        return HtmlSyntaxSupport.getJoinedHtmlSequence(document, languagePath);
    }

    private static TokenSequence<HTMLTokenId> getJoinedHtmlSequence(Document document, LanguagePath languagePath) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        List list = tokenHierarchy.tokenSequenceList(languagePath, 0, Integer.MAX_VALUE);
        if (list.isEmpty()) {
            return null;
        }
        TokenSequence tokenSequence = (TokenSequence)list.get(0);
        tokenSequence.moveStart();
        if (!tokenSequence.moveNext()) {
            return null;
        }
        List list2 = tokenHierarchy.embeddedTokenSequences(tokenSequence.offset(), false);
        TokenSequence tokenSequence2 = null;
        for (TokenSequence tokenSequence3 : list2) {
            if (tokenSequence3.language() == HTMLTokenId.language()) {
                if (tokenSequence2 == null) {
                    tokenSequence2 = tokenSequence3;
                    break;
                }
                tokenSequence2 = tokenSequence2.embeddedJoined(HTMLTokenId.language());
                assert (tokenSequence2 != null);
                break;
            }
            tokenSequence2 = tokenSequence3;
        }
        return tokenSequence2;
    }
}

