/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.views;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class VariablesViewButtons {
    public static final String PREFERENCES_NAME = "variables_view";
    public static final String SHOW_VALUE_AS_STRING = "show_value_as_string";
    private static final String SHOW_FORMATTERS_PROP_NAME = "org.netbeans.modules.debugger.jpda.ui.options.SHOW_FORMATTERS";
    private static JToggleButton showValueAsStringToggle = null;

    public static JButton createOpenOptionsButton() {
        JButton jButton = VariablesViewButtons.createButton("org/netbeans/modules/debugger/jpda/resources/formatters_options_16.png", NbBundle.getMessage(VariablesViewButtons.class, (String)"Hint_Open_Formatters"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.setProperty(VariablesViewButtons.SHOW_FORMATTERS_PROP_NAME, "true");
                OptionsDisplayer.getDefault().open("Advanced/org-netbeans-modules-debugger-jpda-ui-options-JavaDebuggerAdvancedOption");
            }
        });
        return jButton;
    }

    public static synchronized JToggleButton createShowValueAsStringButton() {
        if (showValueAsStringToggle != null) {
            return showValueAsStringToggle;
        }
        showValueAsStringToggle = VariablesViewButtons.createToggleButton(SHOW_VALUE_AS_STRING, "org/netbeans/modules/debugger/jpda/resources/show_variable_values_16.png", NbBundle.getMessage(VariablesViewButtons.class, (String)"Hint_Show_Value_As_String"));
        showValueAsStringToggle.addActionListener(new ShowValueAsStringActionListener(showValueAsStringToggle));
        return showValueAsStringToggle;
    }

    private static JButton createButton(String string, String string2) {
        ImageIcon imageIcon = ImageUtilities.loadImageIcon((String)string, (boolean)false);
        JButton jButton = new JButton(imageIcon);
        Dimension dimension = new Dimension(imageIcon.getIconWidth() + 8, imageIcon.getIconHeight() + 8);
        jButton.setPreferredSize(dimension);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        jButton.setToolTipText(string2);
        jButton.setFocusable(false);
        return jButton;
    }

    private static JToggleButton createToggleButton(String string, String string2, String string3) {
        ImageIcon imageIcon = ImageUtilities.loadImageIcon((String)string2, (boolean)false);
        boolean bl = VariablesViewButtons.isButtonSelected(string);
        JToggleButton jToggleButton = new JToggleButton(imageIcon, bl);
        Dimension dimension = new Dimension(imageIcon.getIconWidth() + 8, imageIcon.getIconHeight() + 8);
        jToggleButton.setPreferredSize(dimension);
        jToggleButton.setMargin(new Insets(1, 1, 1, 1));
        jToggleButton.setToolTipText(string3);
        jToggleButton.setFocusable(false);
        return jToggleButton;
    }

    public static boolean isShowValuesAsString() {
        Preferences preferences = NbPreferences.forModule(VariablesViewButtons.class).node(PREFERENCES_NAME);
        return preferences.getBoolean(SHOW_VALUE_AS_STRING, false);
    }

    private static boolean isButtonSelected(String string) {
        if (string.equals(SHOW_VALUE_AS_STRING)) {
            return VariablesViewButtons.isShowValuesAsString();
        }
        return false;
    }

    private static void setButtonSelected(String string, boolean bl) {
        Preferences preferences = NbPreferences.forModule(VariablesViewButtons.class).node(PREFERENCES_NAME);
        preferences.putBoolean(string, bl);
    }

    private static class ShowValueAsStringActionListener
    implements ActionListener {
        private JToggleButton button;

        ShowValueAsStringActionListener(JToggleButton jToggleButton) {
            this.button = jToggleButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = this.button.isSelected();
            VariablesViewButtons.setButtonSelected(VariablesViewButtons.SHOW_VALUE_AS_STRING, bl);
        }
    }
}

