/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.AbsentInformationException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.modules.debugger.jpda.ui.debugging.FiltersDescriptor;
import org.netbeans.modules.debugger.jpda.ui.models.CallStackActionsProvider;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingTreeModel;
import org.netbeans.modules.debugger.jpda.ui.models.MonitorModel;
import org.netbeans.modules.debugger.jpda.ui.models.ThreadsActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebuggingActionsProvider
implements NodeActionsProvider {
    private JPDADebugger debugger;
    private Session session;
    private RequestProcessor requestProcessor;
    private Action POP_TO_HERE_ACTION;
    private Action MAKE_CURRENT_ACTION;
    private Action SUSPEND_ACTION;
    private Action RESUME_ACTION;
    private Action INTERRUPT_ACTION;
    private Action COPY_TO_CLBD_ACTION;
    private Action LANGUAGE_SELECTION;
    static Action GO_TO_SOURCE_ACTION = Models.createAction((String)NbBundle.getBundle(DebuggingActionsProvider.class).getString("CTL_ThreadAction_GoToSource_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            if (!(object instanceof CallStackFrame)) {
                return false;
            }
            if (DebuggingTreeModel.isMethodInvoking(((CallStackFrame)object).getThread())) {
                return false;
            }
            return DebuggingActionsProvider.isGoToSourceSupported((CallStackFrame)object);
        }

        public void perform(Object[] objectArray) {
            DebuggingActionsProvider.goToSource((CallStackFrame)objectArray[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    public DebuggingActionsProvider(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.session = (Session)contextProvider.lookupFirst(null, Session.class);
        this.requestProcessor = (RequestProcessor)contextProvider.lookupFirst(null, RequestProcessor.class);
        this.MAKE_CURRENT_ACTION = this.createMAKE_CURRENT_ACTION(this.requestProcessor);
        this.SUSPEND_ACTION = this.createSUSPEND_ACTION(this.requestProcessor);
        this.RESUME_ACTION = this.createRESUME_ACTION(this.requestProcessor);
        this.INTERRUPT_ACTION = this.createINTERRUPT_ACTION(this.requestProcessor);
        this.COPY_TO_CLBD_ACTION = this.createCOPY_TO_CLBD_ACTION(this.requestProcessor);
        this.POP_TO_HERE_ACTION = DebuggingActionsProvider.createPOP_TO_HERE_ACTION(this.requestProcessor);
        this.LANGUAGE_SELECTION = new LanguageSelection(this.session);
    }

    private Action createMAKE_CURRENT_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(DebuggingActionsProvider.class).getString("CTL_ThreadAction_MakeCurrent_Label"), (Models.ActionPerformer)new LazyActionPerformer(requestProcessor){

            public boolean isEnabled(Object object) {
                if (object instanceof JPDAThread) {
                    return DebuggingActionsProvider.this.debugger.getCurrentThread() != object;
                }
                if (object instanceof CallStackFrame) {
                    CallStackFrame callStackFrame = (CallStackFrame)object;
                    return !DebuggingTreeModel.isMethodInvoking(callStackFrame.getThread()) && !callStackFrame.equals(DebuggingActionsProvider.this.debugger.getCurrentCallStackFrame());
                }
                return false;
            }

            public void run(Object[] objectArray) {
                if (objectArray.length == 0) {
                    return;
                }
                if (objectArray[0] instanceof JPDAThread) {
                    ((JPDAThread)objectArray[0]).makeCurrent();
                    DebuggingActionsProvider.goToSource((JPDAThread)objectArray[0]);
                }
                if (objectArray[0] instanceof CallStackFrame) {
                    CallStackFrame callStackFrame = (CallStackFrame)objectArray[0];
                    callStackFrame.getThread().makeCurrent();
                    callStackFrame.makeCurrent();
                    DebuggingActionsProvider.goToSource(callStackFrame);
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    private Action createCOPY_TO_CLBD_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(DebuggingActionsProvider.class).getString("CTL_CallstackAction_Copy2CLBD_Label"), (Models.ActionPerformer)new LazyActionPerformer(requestProcessor){

            public boolean isEnabled(Object object) {
                if (object instanceof JPDAThread) {
                    return !DebuggingTreeModel.isMethodInvoking((JPDAThread)object);
                }
                if (object instanceof CallStackFrame) {
                    return !DebuggingTreeModel.isMethodInvoking(((CallStackFrame)object).getThread());
                }
                return true;
            }

            public void run(Object[] objectArray) {
                ArrayList<JPDAThread> arrayList = new ArrayList<JPDAThread>(objectArray.length);
                for (Object object : objectArray) {
                    JPDAThread jPDAThread;
                    if (object instanceof JPDAThread) {
                        arrayList.add((JPDAThread)object);
                    }
                    if (!(object instanceof CallStackFrame) || arrayList.contains(jPDAThread = ((CallStackFrame)object).getThread())) continue;
                    arrayList.add(jPDAThread);
                }
                if (arrayList.isEmpty()) {
                    arrayList.add(DebuggingActionsProvider.this.debugger.getCurrentThread());
                }
                DebuggingActionsProvider.stackToCLBD(arrayList);
            }
        }, (int)Models.MULTISELECTION_TYPE_ANY);
    }

    static final Action createPOP_TO_HERE_ACTION(final RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(ThreadsActionsProvider.class).getString("CTL_CallstackAction_PopToHere_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object object) {
                if (object instanceof CallStackFrame) {
                    return !DebuggingTreeModel.isMethodInvoking(((CallStackFrame)object).getThread());
                }
                return true;
            }

            public void perform(final Object[] objectArray) {
                requestProcessor.post(new Runnable(){

                    public void run() {
                        DebuggingActionsProvider.popToHere((CallStackFrame)objectArray[0]);
                    }
                });
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    private Action createSUSPEND_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(DebuggingActionsProvider.class).getString("CTL_ThreadAction_Suspend_Label"), (Models.ActionPerformer)new LazyActionPerformer(requestProcessor){

            public boolean isEnabled(Object object) {
                if (object instanceof JPDAThread) {
                    return !((JPDAThread)object).isSuspended();
                }
                return object instanceof JPDAThreadGroup;
            }

            public void run(Object[] objectArray) {
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object object;
                    Object object2 = object = objectArray[i] instanceof MonitorModel.ThreadWithBordel ? ((MonitorModel.ThreadWithBordel)objectArray[i]).getOriginalThread() : objectArray[i];
                    if (object instanceof JPDAThread) {
                        ((JPDAThread)object).suspend();
                        continue;
                    }
                    ((JPDAThreadGroup)object).suspend();
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
    }

    private Action createRESUME_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(DebuggingActionsProvider.class).getString("CTL_ThreadAction_Resume_Label"), (Models.ActionPerformer)new LazyActionPerformer(requestProcessor){

            public boolean isEnabled(Object object) {
                if (object instanceof JPDAThread) {
                    return ((JPDAThread)object).isSuspended();
                }
                return object instanceof JPDAThreadGroup;
            }

            public void run(Object[] objectArray) {
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object object;
                    Object object2 = object = objectArray[i] instanceof MonitorModel.ThreadWithBordel ? ((MonitorModel.ThreadWithBordel)objectArray[i]).getOriginalThread() : objectArray[i];
                    if (object instanceof JPDAThread) {
                        ((JPDAThread)object).resume();
                        continue;
                    }
                    ((JPDAThreadGroup)object).resume();
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
    }

    private Action createINTERRUPT_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(DebuggingActionsProvider.class).getString("CTL_ThreadAction_Interrupt_Label"), (Models.ActionPerformer)new LazyActionPerformer(requestProcessor){

            public boolean isEnabled(Object object) {
                if (object instanceof MonitorModel.ThreadWithBordel) {
                    object = ((MonitorModel.ThreadWithBordel)object).getOriginalThread();
                }
                if (object instanceof JPDAThread) {
                    return !((JPDAThread)object).isSuspended();
                }
                return false;
            }

            public void run(Object[] objectArray) {
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object object;
                    Object object2 = object = objectArray[i] instanceof MonitorModel.ThreadWithBordel ? ((MonitorModel.ThreadWithBordel)objectArray[i]).getOriginalThread() : objectArray[i];
                    if (!(object instanceof JPDAThread)) continue;
                    ((JPDAThread)object).interrupt();
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object == "Root") {
            Action[] actionArray = this.getSessionActions();
            Action[] actionArray2 = FiltersDescriptor.getInstance().getFilterActions();
            Action[] actionArray3 = new Action[actionArray.length + 1 + actionArray2.length];
            System.arraycopy(actionArray, 0, actionArray3, 0, actionArray.length);
            actionArray3[actionArray.length] = null;
            System.arraycopy(actionArray2, 0, actionArray3, actionArray.length + 1, actionArray2.length);
            return actionArray3;
        }
        if (object instanceof JPDAThreadGroup) {
            return new Action[]{this.RESUME_ACTION, this.SUSPEND_ACTION};
        }
        if (object instanceof JPDAThread) {
            JPDAThread jPDAThread = (JPDAThread)object;
            boolean bl = jPDAThread.isSuspended();
            Action action = null;
            action = bl ? this.RESUME_ACTION : this.SUSPEND_ACTION;
            return new Action[]{this.MAKE_CURRENT_ACTION, action, this.INTERRUPT_ACTION};
        }
        if (object instanceof CallStackFrame) {
            boolean bl = this.debugger.canPopFrames();
            if (bl) {
                return new Action[]{this.MAKE_CURRENT_ACTION, this.POP_TO_HERE_ACTION, GO_TO_SOURCE_ACTION, this.COPY_TO_CLBD_ACTION};
            }
            return new Action[]{this.MAKE_CURRENT_ACTION, GO_TO_SOURCE_ACTION, this.COPY_TO_CLBD_ACTION};
        }
        throw new UnknownTypeException(object);
    }

    private Action[] getSessionActions() {
        return new Action[]{this.LANGUAGE_SELECTION};
    }

    public void performDefaultAction(final Object object) throws UnknownTypeException {
        if (object == "Root") {
            return;
        }
        if (object instanceof JPDAThread || object instanceof CallStackFrame) {
            this.requestProcessor.post(new Runnable(){

                public void run() {
                    if (object instanceof JPDAThread) {
                        ((JPDAThread)object).makeCurrent();
                    } else if (object instanceof CallStackFrame) {
                        CallStackFrame callStackFrame = (CallStackFrame)object;
                        callStackFrame.getThread().makeCurrent();
                        callStackFrame.makeCurrent();
                        DebuggingActionsProvider.goToSource(callStackFrame);
                    }
                }
            });
            return;
        }
        if (object instanceof JPDAThreadGroup) {
            return;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    private static void popToHere(CallStackFrame callStackFrame) {
        try {
            JPDAThread jPDAThread = callStackFrame.getThread();
            CallStackFrame[] callStackFrameArray = jPDAThread.getCallStack();
            int n = callStackFrameArray.length;
            if (n < 2) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                if (!callStackFrameArray[i].equals(callStackFrame)) continue;
                if (i > 0) {
                    callStackFrameArray[i - 1].popFrame();
                }
                return;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
    }

    static void appendStackInfo(StringBuffer stringBuffer, JPDAThread jPDAThread) {
        CallStackFrame[] callStackFrameArray;
        try {
            callStackFrameArray = jPDAThread.getCallStack();
        }
        catch (AbsentInformationException absentInformationException) {
            stringBuffer.append(NbBundle.getMessage(CallStackActionsProvider.class, (String)"MSG_NoSourceInfo"));
            callStackFrameArray = null;
        }
        if (callStackFrameArray != null) {
            int n = callStackFrameArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(callStackFrameArray[i].getClassName());
                stringBuffer.append(".");
                stringBuffer.append(callStackFrameArray[i].getMethodName());
                try {
                    String string = callStackFrameArray[i].getSourceName(null);
                    stringBuffer.append("(");
                    stringBuffer.append(string);
                    int n2 = callStackFrameArray[i].getLineNumber(null);
                    if (n2 > 0) {
                        stringBuffer.append(":");
                        stringBuffer.append(n2);
                    }
                    stringBuffer.append(")");
                }
                catch (AbsentInformationException absentInformationException) {
                    // empty catch block
                }
                if (i == n - 1) continue;
                stringBuffer.append('\n');
            }
        }
    }

    static void stackToCLBD(List<JPDAThread> list) {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer(512);
        for (Object object2 : list) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append("\"");
            stringBuffer.append(object2.getName());
            stringBuffer.append("\"\n");
            DebuggingActionsProvider.appendStackInfo(stringBuffer, object2);
        }
        Clipboard clipboard = DebuggingActionsProvider.getClipboard();
        object2 = new StringSelection(stringBuffer.toString());
        clipboard.setContents((Transferable)object2, null);
    }

    static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    private static boolean isGoToSourceSupported(CallStackFrame callStackFrame) {
        String string = DebuggerManager.getDebuggerManager().getCurrentSession().getCurrentLanguage();
        SourcePath sourcePath = (SourcePath)DebuggerManager.getDebuggerManager().getCurrentEngine().lookupFirst(null, SourcePath.class);
        return sourcePath.sourceAvailable(callStackFrame, string);
    }

    private static void goToSource(final CallStackFrame callStackFrame) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
                if (session == null) {
                    return;
                }
                String string = session.getCurrentLanguage();
                DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
                if (debuggerEngine == null) {
                    return;
                }
                SourcePath sourcePath = (SourcePath)debuggerEngine.lookupFirst(null, SourcePath.class);
                sourcePath.showSource(callStackFrame, string);
            }
        });
    }

    private static void goToSource(final JPDAThread jPDAThread) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
                if (session == null) {
                    return;
                }
                String string = session.getCurrentLanguage();
                DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
                if (debuggerEngine == null) {
                    return;
                }
                SourcePath sourcePath = (SourcePath)debuggerEngine.lookupFirst(null, SourcePath.class);
                sourcePath.showSource(jPDAThread, string);
            }
        });
    }

    private static class LanguageSelection
    extends AbstractAction
    implements Presenter.Popup {
        private Session session;

        public LanguageSelection(Session session) {
            this.session = session;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public JMenuItem getPopupPresenter() {
            JMenu jMenu = new JMenu(NbBundle.getMessage(DebuggingActionsProvider.class, (String)"CTL_Session_Popup_Language"));
            String[] stringArray = this.session.getSupportedLanguages();
            String string = this.session.getCurrentLanguage();
            for (int i = 0; i < stringArray.length; ++i) {
                final String string2 = stringArray[i];
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new AbstractAction(string2){

                    public void actionPerformed(ActionEvent actionEvent) {
                        LanguageSelection.this.session.setCurrentLanguage(string2);
                    }
                });
                if (string.equals(string2)) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                jMenu.add(jRadioButtonMenuItem);
            }
            return jMenu;
        }
    }

    static abstract class LazyActionPerformer
    implements Models.ActionPerformer {
        private RequestProcessor rp;

        public LazyActionPerformer(RequestProcessor requestProcessor) {
            this.rp = requestProcessor;
        }

        public abstract boolean isEnabled(Object var1);

        public final void perform(final Object[] objectArray) {
            this.rp.post(new Runnable(){

                public void run() {
                    LazyActionPerformer.this.run(objectArray);
                }
            });
        }

        public abstract void run(Object[] var1);
    }
}

