/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.util.LogSupport;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

class ServerLog
extends Thread {
    private final InputOutput io;
    private final OutputWriter writer;
    private final OutputWriter errorWriter;
    private final BufferedReader inReader;
    private final BufferedReader errReader;
    private final boolean autoFlush;
    private final boolean takeFocus;
    private volatile boolean done = false;
    private final ServerLogSupport logSupport;
    private final TomcatManager tomcatManager;

    public ServerLog(TomcatManager tomcatManager, String string, Reader reader, Reader reader2, boolean bl, boolean bl2) {
        super(string + " ServerLog - Thread");
        this.setDaemon(true);
        this.inReader = new BufferedReader(reader);
        this.errReader = new BufferedReader(reader2);
        this.autoFlush = bl;
        this.takeFocus = bl2;
        this.tomcatManager = tomcatManager;
        this.io = UISupport.getServerIO((String)tomcatManager.getUri());
        try {
            this.io.getOut().reset();
        }
        catch (IOException iOException) {
            Logger.getLogger(ServerLog.class.getName()).log(Level.INFO, null, iOException);
        }
        this.writer = this.io.getOut();
        this.errorWriter = this.io.getErr();
        this.io.select();
        this.logSupport = new ServerLogSupport();
    }

    private void processLine(String string) {
        LogSupport.LineInfo lineInfo = this.logSupport.analyzeLine(string);
        if (lineInfo.isError()) {
            if (lineInfo.isAccessible()) {
                try {
                    this.errorWriter.println(string, (OutputListener)this.logSupport.getLink(lineInfo.message(), lineInfo.path(), lineInfo.line()));
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            } else {
                this.errorWriter.println(string);
            }
        } else {
            this.writer.println(string);
            if (string.startsWith("SEVERE: WSSERVLET11: failed to parse runtime descriptor: java.lang.LinkageError:")) {
                File file = InstalledFileLocator.getDefault().locate("modules/ext/jaxws21/api/jaxws-api.jar", null, false);
                File file2 = InstalledFileLocator.getDefault().locate("modules/ext/jaxb/api/jaxb-api.jar", null, false);
                File file3 = this.tomcatManager.getTomcatProperties().getJavaEndorsedDir();
                if (file != null && file2 != null) {
                    this.writer.println(NbBundle.getMessage(ServerLog.class, (String)"MSG_WSSERVLET11", (Object)file.getParent(), (Object)file2.getParent(), (Object)file3));
                } else {
                    this.writer.println(NbBundle.getMessage(ServerLog.class, (String)"MSG_WSSERVLET11_NOJAR", (Object)file3));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.done) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                int n = 0;
                while (((bl = this.inReader.ready()) || (bl2 = this.errReader.ready())) && n++ < 1024) {
                    String string;
                    if (this.done) {
                        return;
                    }
                    bl3 = true;
                    if (bl) {
                        string = this.inReader.readLine();
                        if (string == null) {
                            return;
                        }
                        this.processLine(string);
                    }
                    if (!bl2) continue;
                    string = this.errReader.readLine();
                    if (string == null) {
                        return;
                    }
                    this.processLine(string);
                }
                if (bl3) {
                    if (this.autoFlush) {
                        this.writer.flush();
                        this.errorWriter.flush();
                    }
                    if (this.takeFocus) {
                        this.io.select();
                    }
                }
                ServerLog.sleep(100L);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(ServerLog.class.getName()).log(Level.INFO, null, iOException);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.logSupport.detachAnnotation();
        }
    }

    public boolean isRunning() {
        return !this.done;
    }

    public void takeFocus() {
        this.io.select();
    }

    public void interrupt() {
        super.interrupt();
        this.done = true;
    }

    static class ServerLogSupport
    extends LogSupport {
        private String prevMessage;
        private GlobalPathRegistry globalPathRegistry = GlobalPathRegistry.getDefault();

        ServerLogSupport() {
        }

        public LogSupport.LineInfo analyzeLine(String string) {
            String string2 = null;
            int n = -1;
            String string3 = null;
            boolean bl = false;
            boolean bl2 = false;
            string = string.trim();
            int n2 = string.length();
            if (string.startsWith("/")) {
                bl = true;
                int n3 = string.indexOf(58);
                if (n3 > -1) {
                    int n4;
                    string2 = string.substring(0, n3);
                    bl2 = true;
                    if (n2 > n3 && (n4 = string.indexOf(58, n3 + 1)) > -1) {
                        String string4 = string.substring(n3 + 1, n4);
                        try {
                            n = Integer.valueOf(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Logger.getLogger(ServerLog.class.getName()).log(Level.INFO, null, numberFormatException);
                        }
                        if (n2 > n4) {
                            string3 = string.substring(n4 + 1, n2);
                        }
                    }
                }
            } else if (n2 > 3 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':' && string.charAt(2) == '\\') {
                bl = true;
                int n5 = string.indexOf(58, 2);
                if (n5 > -1) {
                    int n6;
                    string2 = string.substring(0, n5);
                    bl2 = true;
                    if (n2 > n5 && (n6 = string.indexOf(58, n5 + 1)) > -1) {
                        String string5 = string.substring(n5 + 1, n6);
                        try {
                            n = Integer.valueOf(string5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Logger.getLogger(ServerLog.class.getName()).log(Level.INFO, null, numberFormatException);
                        }
                        if (n2 > n6) {
                            string3 = string.substring(n6 + 1, n2);
                        }
                    }
                }
            } else if (string.startsWith("at ") && n2 > 3) {
                String string6;
                int n7;
                bl = true;
                int n8 = string.indexOf(40);
                if (n8 > -1 && (n7 = (string6 = string.substring(3, n8)).lastIndexOf(46)) > -1) {
                    int n9;
                    int n10 = string.lastIndexOf(41);
                    int n11 = string.lastIndexOf(58);
                    if (n10 > -1 && n11 > -1) {
                        String string7 = string.substring(n11 + 1, n10);
                        try {
                            n = Integer.valueOf(string7);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Logger.getLogger(ServerLog.class.getName()).log(Level.INFO, null, numberFormatException);
                        }
                        string3 = this.prevMessage;
                    }
                    String string8 = string6.substring(0, (n9 = string6.indexOf(36)) > -1 ? n9 : n7);
                    string2 = string8.replace('.', '/') + ".java";
                    bl2 = this.globalPathRegistry.findResource(string2) != null;
                }
            } else {
                this.prevMessage = string;
            }
            return new LogSupport.LineInfo(string2, n, string3, bl, bl2);
        }
    }
}

