/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.ExecSupport;
import org.netbeans.modules.derby.StartAction;
import org.netbeans.modules.derby.Util;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.netbeans.spi.db.explorer.DatabaseRuntime;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class RegisterDerby
implements DatabaseRuntime {
    private static final Logger LOGGER = Logger.getLogger(RegisterDerby.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final int START_TIMEOUT = 5;
    private static RegisterDerby reg = null;
    static Process process = null;

    private RegisterDerby() {
    }

    public static synchronized RegisterDerby getDefault() {
        if (reg == null) {
            reg = new RegisterDerby();
        }
        return reg;
    }

    public boolean acceptsDatabaseURL(String string) {
        return string.trim().startsWith("jdbc:derby://localhost");
    }

    public boolean isRunning() {
        if (process != null) {
            try {
                int n = process.exitValue();
                process = null;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
        return process != null;
    }

    public String getJDBCDriverClass() {
        return "org.apache.derby.jdbc.ClientDriver";
    }

    public boolean canStart() {
        return DerbyOptions.getDefault().getLocation().length() > 0;
    }

    public void start() {
        this.start(5);
    }

    private String getNetworkServerClasspath() {
        return Util.getDerbyFile("lib/derby.jar").getAbsolutePath() + File.pathSeparator + Util.getDerbyFile("lib/derbytools.jar").getAbsolutePath() + File.pathSeparator + Util.getDerbyFile("lib/derbynet.jar").getAbsolutePath();
    }

    private JDBCDriver getRegisteredDerbyDriver() {
        JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers("org.apache.derby.jdbc.ClientDriver");
        if (jDBCDriverArray.length > 0) {
            return jDBCDriverArray[0];
        }
        return null;
    }

    public int getPort() {
        return 1527;
    }

    void postCreateNewDatabase(final String string, final String string2, final String string3) throws Exception {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (!RegisterDerby.this.ensureStarted(true)) {
                        return;
                    }
                    ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RegisterDerby.class, (String)"MSG_CreatingDBProgressLabel", (Object)string));
                    progressHandle.start();
                    try {
                        DerbyDatabases.createDatabase(string, string2, string3);
                    }
                    finally {
                        progressHandle.finish();
                    }
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, null, exception);
                    String string4 = NbBundle.getMessage(RegisterDerby.class, (String)"ERR_CreateDatabase", (Object)exception.getMessage());
                    Util.showInformation(string4);
                }
            }
        });
    }

    private String getDerbySystemHome() {
        return DerbyOptions.getDefault().getSystemHome();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDerbyPropertiesFile() {
        File file = new File(this.getDerbySystemHome(), "derby.properties");
        if (file.exists()) {
            return;
        }
        Properties properties = new Properties();
        if (Utilities.isMac()) {
            properties.setProperty("derby.storage.fileSyncTransactionLog", "true");
        }
        OutputStream outputStream = null;
        try {
            File file2 = file.getParentFile();
            file2.mkdirs();
            outputStream = new FileOutputStream(file);
            properties.store(outputStream, NbBundle.getMessage(RegisterDerby.class, (String)"MSG_DerbyPropsFile"));
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, null, iOException);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, null, iOException);
                }
            }
        }
    }

    private File getInstallLocation() {
        String string = DerbyOptions.getDefault().getLocation();
        if (string.equals("")) {
            return null;
        }
        return new File(string);
    }

    private String[] getEnvironment() {
        String string = DerbyOptions.getDefault().getLocation();
        if (string.equals("")) {
            return null;
        }
        return new String[]{"DERBY_INSTALL=" + string};
    }

    private JavaPlatform getJavaPlatform() {
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        return javaPlatformManager.getDefaultPlatform();
    }

    private boolean start(int n) {
        if (process != null) {
            this.stop();
        }
        if (!Util.checkInstallLocation()) {
            return false;
        }
        try {
            ExecSupport execSupport = new ExecSupport();
            execSupport.setStringToLookFor("" + this.getPort());
            FileObject fileObject = this.getJavaPlatform().findTool("java");
            if (fileObject == null) {
                throw new Exception(NbBundle.getMessage(RegisterDerby.class, (String)"EXC_JavaExecutableNotFound"));
            }
            String string = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
            this.createDerbyPropertiesFile();
            NbProcessDescriptor nbProcessDescriptor = new NbProcessDescriptor(string, "-Dderby.system.home=\"" + this.getDerbySystemHome() + "\" " + "-classpath \"" + this.getNetworkServerClasspath() + "\"" + " org.apache.derby.drda.NetworkServerControl start");
            if (LOG) {
                LOGGER.log(Level.FINE, "Running " + nbProcessDescriptor.getProcessName() + " " + nbProcessDescriptor.getArguments());
            }
            process = nbProcessDescriptor.exec(null, this.getEnvironment(), true, this.getInstallLocation());
            execSupport.displayProcessOutputs(process, NbBundle.getMessage(StartAction.class, (String)"LBL_outputtab"));
            if (n > 0) {
                boolean bl = this.waitStart(execSupport, n);
                if (!bl) {
                    this.stop();
                }
                return bl;
            }
            return false;
        }
        catch (Exception exception) {
            Util.showInformation(exception.getLocalizedMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitStart(ExecSupport execSupport, int n) {
        boolean bl = false;
        String string = NbBundle.getMessage(RegisterDerby.class, (String)"MSG_StartingDerby");
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string);
        progressHandle.start();
        try {
            while (!bl) {
                bl = execSupport.waitForMessage(n * 1000);
                if (bl) continue;
                String string2 = NbBundle.getMessage(RegisterDerby.class, (String)"LBL_DerbyDatabase");
                String string3 = NbBundle.getMessage(RegisterDerby.class, (String)"MSG_WaitStart", (Object)n);
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string3, string2, 0);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.YES_OPTION) continue;
                break;
            }
            if (!bl) {
                LOGGER.log(Level.WARNING, "Derby server failed to start");
            }
        }
        finally {
            progressHandle.finish();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            if (process == null) {
                return;
            }
            String string = FileUtil.toFile((FileObject)this.getJavaPlatform().findTool("java")).getAbsolutePath();
            if (string == null) {
                throw new Exception(NbBundle.getMessage(RegisterDerby.class, (String)"EXC_JavaExecutableNotFound"));
            }
            NbProcessDescriptor nbProcessDescriptor = new NbProcessDescriptor(string, "-Dderby.system.home=\"" + this.getDerbySystemHome() + "\" " + "-classpath \"" + this.getNetworkServerClasspath() + "\"" + " org.apache.derby.drda.NetworkServerControl shutdown");
            if (LOG) {
                LOGGER.log(Level.FINE, "Running " + nbProcessDescriptor.getProcessName() + " " + nbProcessDescriptor.getArguments());
            }
            Process process = nbProcessDescriptor.exec(null, this.getEnvironment(), true, this.getInstallLocation());
            process.waitFor();
            RegisterDerby.process.destroy();
            this.disconnectAllDerbyConnections();
        }
        catch (Exception exception) {
            Util.showInformation(exception.getMessage());
        }
        finally {
            process = null;
        }
    }

    private void disconnectAllDerbyConnections() {
        DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < databaseConnectionArray.length; ++i) {
            if (!RegisterDerby.getDefault().acceptsDatabaseURL(databaseConnectionArray[i].getDatabaseURL())) continue;
            ConnectionManager.getDefault().disconnect(databaseConnectionArray[i]);
        }
    }

    public boolean ensureStarted(boolean bl) {
        if (this.isRunning()) {
            return true;
        }
        if (!this.canStart()) {
            return false;
        }
        if (bl) {
            return this.start(5);
        }
        this.start(0);
        return false;
    }
}

