/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class WebSources
implements Sources,
PropertyChangeListener,
ChangeListener {
    private static final String BUILD_DIR_PROP = "${build.dir}";
    private static final String DIST_DIR_PROP = "${dist.dir}";
    private final Project project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private Sources delegate;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private boolean dirty;

    WebSources(Project project, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2) {
        this.project = project;
        this.helper = antProjectHelper;
        this.evaluator = propertyEvaluator;
        this.sourceRoots = sourceRoots;
        this.testRoots = sourceRoots2;
        this.sourceRoots.addPropertyChangeListener((PropertyChangeListener)this);
        this.testRoots.addPropertyChangeListener((PropertyChangeListener)this);
        this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
        this.delegate = this.initSources();
    }

    public SourceGroup[] getSourceGroups(final String string) {
        return (SourceGroup[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SourceGroup[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SourceGroup[] run() {
                Sources sources;
                WebSources webSources = WebSources.this;
                synchronized (webSources) {
                    if (WebSources.this.dirty) {
                        WebSources.this.delegate.removeChangeListener((ChangeListener)WebSources.this);
                        WebSources.this.delegate = WebSources.this.initSources();
                        WebSources.this.delegate.addChangeListener((ChangeListener)WebSources.this);
                        WebSources.this.dirty = false;
                    }
                    sources = WebSources.this.delegate;
                }
                return sources.getSourceGroups(string);
            }
        });
    }

    private Sources initSources() {
        SourcesHelper sourcesHelper = new SourcesHelper(this.project, this.helper, this.evaluator);
        this.register(sourcesHelper, this.sourceRoots);
        this.register(sourcesHelper, this.testRoots);
        String string = NbBundle.getMessage(WebSources.class, (String)"LBL_Node_WebModule");
        String string2 = NbBundle.getMessage(WebSources.class, (String)"LBL_Node_DocBase");
        String string3 = NbBundle.getMessage(WebSources.class, (String)"LBL_Node_WebInf");
        String string4 = "${includes}";
        String string5 = "${excludes}";
        sourcesHelper.addPrincipalSourceRoot("${source.root}", string, null, null);
        sourcesHelper.addPrincipalSourceRoot("${web.docbase.dir}", string4, string5, string2, null, null);
        sourcesHelper.addTypedSourceRoot("${web.docbase.dir}", string4, string5, "doc_root", string2, null, null);
        sourcesHelper.addTypedSourceRoot("${webinf.dir}", "web_inf", string3, null, null);
        sourcesHelper.addNonSourceRoot(BUILD_DIR_PROP);
        sourcesHelper.addNonSourceRoot(DIST_DIR_PROP);
        sourcesHelper.registerExternalRoots(0);
        return sourcesHelper.createSources();
    }

    private void register(SourcesHelper sourcesHelper, SourceRoots sourceRoots) {
        String[] stringArray = sourceRoots.getRootProperties();
        String[] stringArray2 = sourceRoots.getRootNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = sourceRoots.getRootDisplayName(stringArray2[i], string);
            String string3 = "${" + string + "}";
            String string4 = "${includes}";
            String string5 = "${excludes}";
            sourcesHelper.addPrincipalSourceRoot(string3, string4, string5, string2, null, null);
            sourcesHelper.addTypedSourceRoot(string3, string4, string5, "java", string2, null, null);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        WebSources webSources = this;
        synchronized (webSources) {
            this.dirty = true;
        }
        this.changeSupport.fireChange();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (SourceRoots.PROP_ROOT_PROPERTIES.equals(string) || "build.dir".equals(string) || "dist.dir".equals(string)) {
            this.fireChange();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChange();
    }
}

