/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.AbstractMap;
import java.util.HashMap;

class MyFontMetrics {
    public int width;
    public int height;
    public int ascent;
    public int leading;
    public FontMetrics fm;
    private WidthCache cwidth_cache;

    public MyFontMetrics(Component component, Font font) {
        this.fm = component.getFontMetrics(font);
        this.width = this.fm.charWidth('a');
        this.height = this.fm.getHeight();
        this.ascent = this.fm.getAscent();
        this.leading = this.fm.getLeading();
        this.height -= this.leading;
        this.leading = 0;
        this.cwidth_cache = CacheFactory.cacheForFontMetrics(this.fm);
    }

    protected void finalize() {
        CacheFactory.disposeBy(this.fm);
    }

    public boolean isMultiCell() {
        return this.cwidth_cache.isMultiCell();
    }

    public int wcwidth(char c) {
        int n = this.cwidth_cache.cache[c];
        if (n == 0) {
            int n2 = this.fm.charWidth(c);
            if (n2 == this.width) {
                n = 1;
            } else if (n2 == 0) {
                n = 1;
            } else {
                int n3 = n2 % this.width;
                int n4 = n2;
                if (n3 != 0) {
                    n4 = n2 + (this.width - n3);
                }
                if ((n = n4 / this.width) == 0) {
                    n = 1;
                }
                this.cwidth_cache.setMultiCell(true);
            }
            this.cwidth_cache.cache[c] = (byte)n;
        }
        return n;
    }

    void checkForMultiCell(char c) {
        this.wcwidth(c);
    }

    private static final class CacheFactory {
        private static AbstractMap<FontMetrics, WidthCache> map = new HashMap<FontMetrics, WidthCache>();

        private CacheFactory() {
        }

        static synchronized WidthCache cacheForFontMetrics(FontMetrics fontMetrics) {
            WidthCache widthCache = map.get(fontMetrics);
            if (widthCache == null) {
                widthCache = new WidthCache();
                map.put(fontMetrics, widthCache);
            } else {
                widthCache.up();
            }
            return widthCache;
        }

        static synchronized void disposeBy(FontMetrics fontMetrics) {
            WidthCache widthCache = map.get(fontMetrics);
            if (widthCache != null) {
                widthCache.down();
            }
        }
    }

    static class WidthCache {
        byte[] cache = new byte[65536];
        int reference_count = 1;
        private boolean multiCell = false;

        WidthCache() {
        }

        public void up() {
            ++this.reference_count;
            if (this.reference_count == 1) {
                this.cache = new byte[65536];
            }
        }

        public void down() {
            if (this.reference_count == 0) {
                return;
            }
            --this.reference_count;
            if (this.reference_count == 0) {
                this.cache = null;
            }
        }

        public boolean isMultiCell() {
            return this.multiCell;
        }

        public void setMultiCell(boolean bl) {
            this.multiCell = bl;
        }
    }
}

