/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.ruby.railsprojects.ui.FoldersListSettings;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectEvent;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectListener;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceRoots {
    public static final String PROP_ROOT_PROPERTIES = "rootProperties";
    public static final String PROP_ROOTS = "roots";
    public static final String DEFAULT_SOURCE_LABEL = NbBundle.getMessage(SourceRoots.class, (String)"NAME_src.dir");
    public static final String DEFAULT_TEST_LABEL = NbBundle.getMessage(SourceRoots.class, (String)"NAME_test.src.dir");
    private boolean showRSpec;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper refHelper;
    private final String elementName;
    private final String newRootNameTemplate;
    private List<String> sourceRootProperties;
    private List<String> sourceRootNames;
    private List<FileObject> sourceRoots;
    private List<FileObject> plainFiles;
    private List<URL> sourceRootURLs;
    private final PropertyChangeSupport support;
    private final ProjectMetadataListener listener;
    private final boolean isTest;
    private final File projectDir;
    private static final String DEFAULT_IGNORED_FILES = "^(CVS|SCCS|vssver.?\\.scc|#.*#|%.*%|_svn)$|~$|^\\.(?!htaccess$).*$";

    SourceRoots(UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, String string, boolean bl, String string2) {
        assert (updateHelper != null && propertyEvaluator != null && referenceHelper != null && string != null && string2 != null);
        this.helper = updateHelper;
        this.evaluator = propertyEvaluator;
        this.refHelper = referenceHelper;
        this.elementName = string;
        this.isTest = bl;
        this.newRootNameTemplate = string2;
        this.projectDir = FileUtil.toFile((FileObject)this.helper.getRakeProjectHelper().getProjectDirectory());
        this.support = new PropertyChangeSupport(this);
        this.listener = new ProjectMetadataListener();
        this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.evaluator));
        this.helper.getRakeProjectHelper().addRakeProjectListener((RakeProjectListener)WeakListeners.create(RakeProjectListener.class, (EventListener)this.listener, (Object)this.helper));
        this.showRSpec = true;
    }

    private String getNodeDescription(String string) {
        return NbBundle.getMessage(SourceRoots.class, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRoots() {
        SourceRoots sourceRoots = this;
        synchronized (sourceRoots) {
            if (this.sourceRoots == null) {
                if (FoldersListSettings.getDefault().getLogicalView()) {
                    this.initializeRootsLogical();
                } else {
                    this.initializeRootsFiles();
                }
            }
        }
    }

    private void initializeRootsLogical() {
        List<String> list;
        AbstractCollection abstractCollection;
        FileObject fileObject;
        this.plainFiles = new ArrayList<FileObject>(20);
        FileObject fileObject2 = this.helper.getRakeProjectHelper().getProjectDirectory();
        FileObject fileObject3 = fileObject2.getFileObject("Rakefile");
        if (fileObject3 != null) {
            this.plainFiles.add(fileObject3);
        }
        if ((fileObject = fileObject2.getFileObject("README")) != null) {
            this.plainFiles.add(fileObject);
        }
        this.sourceRootNames = new ArrayList<String>(20);
        this.sourceRootProperties = new ArrayList<String>(20);
        this.sourceRootNames.add(this.getNodeDescription("app_controllers"));
        this.sourceRootNames.add(this.getNodeDescription("app_helpers"));
        this.sourceRootNames.add(this.getNodeDescription("app_models"));
        this.sourceRootNames.add(this.getNodeDescription("app_views"));
        this.sourceRootProperties.add("app/controllers");
        this.sourceRootProperties.add("app/helpers");
        this.sourceRootProperties.add("app/models");
        this.sourceRootProperties.add("app/views");
        FileObject fileObject4 = fileObject2.getFileObject("app");
        if (fileObject4 != null) {
            abstractCollection = new HashSet<String>();
            abstractCollection.add("controllers");
            abstractCollection.add("helpers");
            abstractCollection.add("models");
            abstractCollection.add("views");
            list = SourceRoots.findUnknownFolders(fileObject4, abstractCollection);
            if (list != null) {
                for (String string3 : list) {
                    String string2 = "app/" + string3;
                    this.sourceRootNames.add(string2);
                    this.sourceRootProperties.add(string2);
                }
            }
        }
        this.sourceRootNames.add(this.getNodeDescription("components"));
        this.sourceRootProperties.add("components");
        this.sourceRootNames.add(this.getNodeDescription("config"));
        this.sourceRootProperties.add("config");
        this.sourceRootNames.add(this.getNodeDescription("db"));
        this.sourceRootProperties.add("db");
        this.sourceRootNames.add(this.getNodeDescription("lib"));
        this.sourceRootProperties.add("lib");
        this.sourceRootNames.add(this.getNodeDescription("log"));
        this.sourceRootProperties.add("log");
        this.sourceRootNames.add(this.getNodeDescription("public"));
        this.sourceRootProperties.add("public");
        if (this.showRSpec) {
            this.sourceRootNames.add(this.getNodeDescription("rspec"));
            this.sourceRootProperties.add("spec");
        }
        this.sourceRootNames.add(this.getNodeDescription("test"));
        this.sourceRootProperties.add("test");
        this.sourceRootNames.add(this.getNodeDescription("script"));
        this.sourceRootProperties.add("script");
        this.sourceRootNames.add(this.getNodeDescription("doc"));
        this.sourceRootProperties.add("doc");
        this.sourceRootNames.add(this.getNodeDescription("vendor"));
        this.sourceRootProperties.add("vendor");
        if (fileObject2 != null) {
            abstractCollection = new HashSet();
            abstractCollection.add((String)"nbproject");
            abstractCollection.add((String)"tmp");
            abstractCollection.add("app");
            abstractCollection.add("components");
            abstractCollection.add("config");
            abstractCollection.add("db");
            abstractCollection.add("lib");
            abstractCollection.add("log");
            abstractCollection.add("public");
            abstractCollection.add("spec");
            abstractCollection.add("lib");
            abstractCollection.add("test");
            abstractCollection.add("doc");
            abstractCollection.add("script");
            abstractCollection.add("vendor");
            list = SourceRoots.findUnknownFolders(fileObject2, (Set<String>)((Object)abstractCollection));
            if (list != null) {
                for (String string3 : list) {
                    this.sourceRootNames.add(string3);
                    this.sourceRootProperties.add(string3);
                }
            }
        }
        assert (this.sourceRoots == null);
        abstractCollection = new ArrayList();
        for (String string : this.sourceRootProperties) {
            String string3;
            string3 = this.helper.getRakeProjectHelper().resolveFileObject(string);
            if (string3 == null) continue;
            if (FileUtil.isArchiveFile((FileObject)string3)) {
                string3 = FileUtil.getArchiveRoot((FileObject)string3);
            }
            abstractCollection.add(string3);
        }
        this.sourceRoots = Collections.unmodifiableList(abstractCollection);
    }

    private static List<String> findUnknownFolders(FileObject fileObject, Set<String> set) {
        ArrayList<String> arrayList = null;
        for (FileObject fileObject2 : fileObject.getChildren()) {
            String string;
            if (!fileObject2.isFolder() || set.contains(string = fileObject2.getNameExt()) || !SourceRoots.isVisible(fileObject2)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(string);
        }
        if (arrayList != null) {
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    private static boolean isVisible(FileObject fileObject) {
        return !fileObject.getNameExt().matches(DEFAULT_IGNORED_FILES);
    }

    private void initializeRootsFiles() {
        FileObject fileObject = this.helper.getRakeProjectHelper().getProjectDirectory();
        if (fileObject == null) {
            this.initializeRootsLogical();
            return;
        }
        assert (this.sourceRoots == null);
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(20);
        this.sourceRootNames = new ArrayList<String>(20);
        this.sourceRootProperties = new ArrayList<String>(20);
        this.plainFiles = new ArrayList<FileObject>(20);
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (FileObject fileObject2 : fileObjectArray) {
            if (!VisibilityQuery.getDefault().isVisible(fileObject2)) continue;
            if (FileUtil.isArchiveFile((FileObject)fileObject2)) {
                fileObject2 = FileUtil.getArchiveRoot((FileObject)fileObject2);
            }
            if (fileObject2.isFolder()) {
                String string = fileObject2.getName();
                if (string.equals("nbproject") || string.equals("tmp")) continue;
                arrayList.add(fileObject2);
                continue;
            }
            this.plainFiles.add(fileObject2);
        }
        Collections.sort(arrayList, new Comparator<FileObject>(){

            @Override
            public int compare(FileObject fileObject, FileObject fileObject2) {
                return fileObject.getNameExt().compareTo(fileObject2.getNameExt());
            }
        });
        for (FileObject fileObject3 : arrayList) {
            String string = fileObject3.getNameExt();
            this.sourceRootNames.add(string);
            this.sourceRootProperties.add(string);
        }
        this.sourceRoots = Collections.unmodifiableList(arrayList);
    }

    public String[] getRootNames() {
        return (String[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (SourceRoots.this.sourceRootNames == null) {
                        SourceRoots.this.initializeRoots();
                    }
                    assert (SourceRoots.this.sourceRootNames != null);
                    return SourceRoots.this.sourceRootNames.toArray(new String[SourceRoots.this.sourceRootNames.size()]);
                }
            }
        });
    }

    public String[] getRootProperties() {
        return (String[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (SourceRoots.this.sourceRootProperties == null) {
                        SourceRoots.this.initializeRoots();
                    }
                    assert (SourceRoots.this.sourceRootProperties != null);
                    return SourceRoots.this.sourceRootProperties.toArray(new String[SourceRoots.this.sourceRootProperties.size()]);
                }
            }
        });
    }

    public FileObject[] getRoots() {
        return (FileObject[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    SourceRoots.this.initializeRoots();
                    assert (SourceRoots.this.sourceRoots != null);
                    return SourceRoots.this.sourceRoots.toArray(new FileObject[SourceRoots.this.sourceRoots.size()]);
                }
            }
        });
    }

    public FileObject[] getExtraFiles() {
        return (FileObject[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    SourceRoots.this.initializeRoots();
                    assert (SourceRoots.this.plainFiles != null);
                    return SourceRoots.this.plainFiles.toArray(new FileObject[SourceRoots.this.plainFiles.size()]);
                }
            }
        });
    }

    public URL[] getRootURLs() {
        return (URL[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<URL[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public URL[] run() {
                6 var1_1 = this;
                synchronized (var1_1) {
                    if (SourceRoots.this.sourceRootURLs == null) {
                        String[] stringArray = SourceRoots.this.getRootProperties();
                        ArrayList<URL> arrayList = new ArrayList<URL>();
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string = stringArray[i];
                            if (string == null) continue;
                            File file = SourceRoots.this.helper.getRakeProjectHelper().resolveFile(string);
                            try {
                                URL uRL = file.toURI().toURL();
                                if (!file.exists()) {
                                    uRL = new URL(uRL.toExternalForm() + "/");
                                }
                                arrayList.add(uRL);
                                continue;
                            }
                            catch (MalformedURLException malformedURLException) {
                                ErrorManager.getDefault().notify((Throwable)malformedURLException);
                            }
                        }
                        SourceRoots.this.sourceRootURLs = Collections.unmodifiableList(arrayList);
                    }
                }
                return SourceRoots.this.sourceRootURLs.toArray(new URL[SourceRoots.this.sourceRootURLs.size()]);
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public String getRootDisplayName(String string, String string2) {
        if (string == null || string.length() == 0) {
            String string3 = this.evaluator.getProperty(string2);
            File file = string3 == null ? null : this.helper.getRakeProjectHelper().resolveFile(string3);
            string = this.createInitialDisplayName(file);
        }
        return string;
    }

    public String createInitialDisplayName(File file) {
        String string;
        String string2;
        String string3 = file != null ? ((string2 = file.getAbsolutePath()).startsWith(string = this.projectDir.getAbsolutePath() + File.separatorChar) ? string2.substring(string.length()) : file.getAbsolutePath()) : (this.isTest ? DEFAULT_TEST_LABEL : DEFAULT_SOURCE_LABEL);
        return string3;
    }

    public boolean isTest() {
        return this.isTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache(boolean bl, String string) {
        boolean bl2 = false;
        SourceRoots sourceRoots = this;
        synchronized (sourceRoots) {
            if (bl) {
                this.sourceRootProperties = null;
                this.sourceRootNames = null;
                this.sourceRoots = null;
                this.sourceRootURLs = null;
                bl2 = true;
            } else if (string == null || this.sourceRootProperties != null && this.sourceRootProperties.contains(string)) {
                this.sourceRoots = null;
                this.sourceRootURLs = null;
                bl2 = true;
            }
        }
        if (bl2) {
            if (bl) {
                this.support.firePropertyChange(PROP_ROOT_PROPERTIES, null, null);
            }
            this.support.firePropertyChange(PROP_ROOTS, null, null);
        }
    }

    private class ProjectMetadataListener
    implements PropertyChangeListener,
    RakeProjectListener {
        private ProjectMetadataListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SourceRoots.this.resetCache(false, propertyChangeEvent.getPropertyName());
        }

        public void configurationXmlChanged(RakeProjectEvent rakeProjectEvent) {
            SourceRoots.this.resetCache(true, null);
        }

        public void propertiesChanged(RakeProjectEvent rakeProjectEvent) {
        }
    }
}

