/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.platform.execution.DirectoryFileLocator;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.RailsProjectCreateData;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.netbeans.modules.ruby.railsprojects.server.ServerRegistry;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.modules.ruby.railsprojects.ui.customizer.RailsProjectProperties;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.spi.project.support.rake.EditableProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.ProjectGenerator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RailsProjectGenerator {
    private static final Logger LOGGER = Logger.getLogger(RailsProjectGenerator.class.getName());
    static final Pattern RAILS_GENERATOR_PATTERN = Pattern.compile("^   (   create|    force|identical|     skip)\\s+([\\w|/]+\\.\\S+)\\s*$");

    private RailsProjectGenerator() {
    }

    public static RakeProjectHelper createProject(RailsProjectCreateData railsProjectCreateData) throws IOException {
        Object object;
        File file;
        String string;
        FileObject fileObject = FileUtil.createFolder((File)railsProjectCreateData.getDir());
        RubyPlatform rubyPlatform = railsProjectCreateData.getPlatform();
        RailsDatabaseConfiguration railsDatabaseConfiguration = railsProjectCreateData.getDatabase();
        if (railsProjectCreateData.isCreate()) {
            File file2;
            string = rubyPlatform.getRails();
            file = new File(string);
            object = FileUtil.toFileObject((File)file);
            boolean bl = object != null ? RubyUtils.isRubyFile((FileObject)object) : false;
            RubyExecutionDescriptor rubyExecutionDescriptor = null;
            String string2 = NbBundle.getMessage(RailsProjectGenerator.class, (String)"GenerateRails");
            String string3 = railsDatabaseConfiguration.railsGenerationParam() == null ? null : "--database=" + railsDatabaseConfiguration.railsGenerationParam();
            String string4 = railsProjectCreateData.getRailsVersion() == null ? null : "_" + railsProjectCreateData.getRailsVersion() + "_";
            File file3 = railsProjectCreateData.getDir().getParentFile();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (string4 != null) {
                arrayList.add(string4);
            }
            if (bl) {
                arrayList.add(railsProjectCreateData.getName());
            }
            if (string3 != null) {
                arrayList.add(string3);
            }
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            if (bl) {
                rubyExecutionDescriptor = new RubyExecutionDescriptor(rubyPlatform, string2, file3, string);
                rubyExecutionDescriptor.additionalArgs(stringArray);
            } else {
                rubyExecutionDescriptor = new RubyExecutionDescriptor(rubyPlatform, string2, file3, railsProjectCreateData.getName());
                rubyExecutionDescriptor.additionalArgs(stringArray);
                rubyExecutionDescriptor.cmd(file);
            }
            rubyExecutionDescriptor.runThroughRuby(bl);
            rubyExecutionDescriptor.fileLocator((LineConvertors.FileLocator)new DirectoryFileLocator(fileObject));
            LineConvertor lineConvertor = LineConvertors.filePattern((LineConvertors.FileLocator)rubyExecutionDescriptor.getFileLocator(), (Pattern)RAILS_GENERATOR_PATTERN, null, (int)2, (int)-1);
            rubyExecutionDescriptor.addStandardRecognizers();
            rubyExecutionDescriptor.addErrConvertor(lineConvertor);
            rubyExecutionDescriptor.addOutConvertor(lineConvertor);
            RubyProcessCreator rubyProcessCreator = new RubyProcessCreator(rubyExecutionDescriptor);
            ExecutionService executionService = ExecutionService.newService((Callable)rubyProcessCreator, (ExecutionDescriptor)rubyExecutionDescriptor.toExecutionDescriptor(), (String)string2);
            try {
                executionService.run().get();
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                Exceptions.printStackTrace((Throwable)executionException);
            }
            if (rubyPlatform.getGemManager().getLatestVersion("rspec") != null && !(file2 = new File(railsProjectCreateData.getDir(), "spec")).exists()) {
                file2.mkdirs();
            }
            fileObject.getFileSystem().refresh(true);
        }
        string = RailsProjectGenerator.createProject(fileObject, rubyPlatform, railsProjectCreateData);
        file = ProjectManager.getDefault().findProject(fileObject);
        railsDatabaseConfiguration.editConfig((RailsProject)((Object)file));
        ProjectManager.getDefault().saveProject((Project)file);
        if (railsProjectCreateData.isDeploy()) {
            RailsProjectGenerator.runWarblePluginize(rubyPlatform, (Project)file);
        }
        RakeSupport.refreshTasks((Project)file);
        object = railsProjectCreateData.getRailsVersion() != null ? railsProjectCreateData.getRailsVersion() : rubyPlatform.getGemManager().getLatestVersion("rails");
        Util.logUsage(RailsProjectGenerator.class, (String)"USG_PROJECT_CREATE_RAILS", (Object[])new Object[]{rubyPlatform.getInfo().getKind(), rubyPlatform.getInfo().getPlatformVersion(), rubyPlatform.getInfo().getGemVersion(), RailsProjectGenerator.getServerIdForLogging(railsProjectCreateData.getServerInstanceId(), rubyPlatform), railsProjectCreateData.getDatabase().getDisplayName(), object});
        return string;
    }

    private static String getServerIdForLogging(String string, RubyPlatform rubyPlatform) {
        RubyInstance rubyInstance = ServerRegistry.getDefault().getServer(string, rubyPlatform);
        return rubyInstance != null ? rubyInstance.getDisplayName() : "";
    }

    private static void runWarblePluginize(RubyPlatform rubyPlatform, Project project) {
        String string = rubyPlatform.findExecutable("warble");
        if (string == null) {
            LOGGER.warning("Could not find warble executable, platform: " + rubyPlatform);
            return;
        }
        RubyExecutionDescriptor rubyExecutionDescriptor = new RubyExecutionDescriptor(rubyPlatform, NbBundle.getMessage(RailsProjectGenerator.class, (String)"WarblePluginize"), FileUtil.toFile((FileObject)project.getProjectDirectory()), new File(string).getAbsolutePath());
        rubyExecutionDescriptor.additionalArgs(new String[]{"pluginize"});
        RubyProcessCreator rubyProcessCreator = new RubyProcessCreator(rubyExecutionDescriptor);
        rubyExecutionDescriptor.addStandardRecognizers();
        ExecutionService.newService((Callable)rubyProcessCreator, (ExecutionDescriptor)rubyExecutionDescriptor.toExecutionDescriptor(), (String)NbBundle.getMessage(RailsProjectGenerator.class, (String)"WarblePluginize")).run();
    }

    private static RakeProjectHelper createProject(FileObject fileObject, RubyPlatform rubyPlatform, RailsProjectCreateData railsProjectCreateData) throws IOException {
        RakeProjectHelper rakeProjectHelper = ProjectGenerator.createProject((FileObject)fileObject, (String)"org.netbeans.modules.ruby.railsprojects");
        Element element = rakeProjectHelper.getPrimaryConfigurationData(true);
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://www.netbeans.org/ns/rails-project/1", "name");
        element2.appendChild(document.createTextNode(railsProjectCreateData.getName()));
        element.appendChild(element2);
        EditableProperties editableProperties = rakeProjectHelper.getProperties("nbproject/private/private.properties");
        editableProperties.put("rails.servertype", railsProjectCreateData.getServerInstanceId());
        EditableProperties editableProperties2 = rakeProjectHelper.getProperties("nbproject/project.properties");
        RubyInstance rubyInstance = ServerRegistry.getDefault().getServer(railsProjectCreateData.getServerInstanceId(), rubyPlatform);
        int n = rubyInstance != null ? rubyInstance.getRailsPort() : 3000;
        editableProperties2.setProperty("rails.port", String.valueOf(n));
        Charset charset = FileEncodingQuery.getDefaultEncoding();
        editableProperties2.setProperty("source.encoding", charset.name());
        rakeProjectHelper.putPrimaryConfigurationData(element, true);
        RailsProjectProperties.storePlatform((EditableProperties)editableProperties2, (RubyPlatform)rubyPlatform);
        rakeProjectHelper.putProperties("nbproject/private/private.properties", editableProperties);
        rakeProjectHelper.putProperties("nbproject/project.properties", editableProperties2);
        return rakeProjectHelper;
    }
}

