/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.ui.SourcesFolderProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class RunAsScript
extends RunAsPanel.InsidePanel {
    private static final long serialVersionUID = -5593481225914071L;
    private final String displayName;
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final JLabel[] labels;
    private final JTextField[] textFields;
    private final String[] propertyNames;
    private final SourcesFolderProvider sourcesFolderProvider;
    private JButton configureButton;
    private JButton indexFileBrowseButton;
    private JLabel indexFileLabel;
    private JTextField indexFileTextField;
    private JLabel interpreterLabel;
    private JTextField interpreterTextField;
    private JComboBox runAsCombo;
    private JLabel runAsLabel;

    public RunAsScript(ConfigManager configManager, SourcesFolderProvider sourcesFolderProvider) {
        this(configManager, sourcesFolderProvider, NbBundle.getMessage(RunAsScript.class, (String)"LBL_ConfigScript"));
    }

    private RunAsScript(ConfigManager configManager, SourcesFolderProvider sourcesFolderProvider, String string) {
        super(configManager);
        this.displayName = string;
        this.sourcesFolderProvider = sourcesFolderProvider;
        this.initComponents();
        this.addListeners();
        this.labels = new JLabel[]{this.indexFileLabel};
        this.textFields = new JTextField[]{this.indexFileTextField};
        this.propertyNames = new String[]{"indexFile"};
        assert (this.labels.length == this.textFields.length && this.labels.length == this.propertyNames.length);
        for (int i = 0; i < this.textFields.length; ++i) {
            FieldUpdater fieldUpdater = new FieldUpdater(this.propertyNames[i], this.labels[i], this.textFields[i]);
            this.textFields[i].getDocument().addDocumentListener(fieldUpdater);
        }
    }

    private void addListeners() {
        this.interpreterTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            private void processUpdate() {
                RunAsScript.this.changeSupport.fireChange();
            }
        });
        this.runAsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsScript.this.changeSupport.fireChange();
            }
        });
    }

    public void loadPhpInterpreter() {
        String string = PhpOptions.getInstance().getPhpInterpreter();
        this.interpreterTextField.setText(string != null ? string : "");
    }

    protected PhpProjectProperties.RunAsType getRunAsType() {
        return PhpProjectProperties.RunAsType.SCRIPT;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    protected JLabel getRunAsLabel() {
        return this.runAsLabel;
    }

    public JComboBox getRunAsCombo() {
        return this.runAsCombo;
    }

    protected void loadFields() {
        this.loadPhpInterpreter();
    }

    protected void validateFields() {
        this.changeSupport.fireChange();
    }

    public void addRunAsScriptListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeRunAsScriptListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public String getIndexFile() {
        return this.indexFileTextField.getText().trim();
    }

    public void setIndexFile(String string) {
        this.indexFileTextField.setText(string);
    }

    public void hideIndexFile() {
        this.indexFileLabel.setVisible(false);
        this.indexFileTextField.setVisible(false);
        this.indexFileBrowseButton.setVisible(false);
    }

    private void initComponents() {
        this.interpreterLabel = new JLabel();
        this.interpreterTextField = new JTextField();
        this.runAsLabel = new JLabel();
        this.runAsCombo = new JComboBox();
        this.configureButton = new JButton();
        this.indexFileLabel = new JLabel();
        this.indexFileTextField = new JTextField();
        this.indexFileBrowseButton = new JButton();
        this.setFocusTraversalPolicy(null);
        this.interpreterLabel.setLabelFor(this.interpreterTextField);
        Mnemonics.setLocalizedText((JLabel)this.interpreterLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_PhpInterpreter"));
        this.interpreterTextField.setEditable(false);
        this.runAsLabel.setLabelFor(this.runAsCombo);
        Mnemonics.setLocalizedText((JLabel)this.runAsLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_RunAs"));
        Mnemonics.setLocalizedText((AbstractButton)this.configureButton, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_Configure"));
        this.configureButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsScript.this.configureButtonActionPerformed(actionEvent);
            }
        });
        this.indexFileLabel.setLabelFor(this.indexFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.indexFileLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_IndexFile"));
        Mnemonics.setLocalizedText((AbstractButton)this.indexFileBrowseButton, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_BrowseIndex"));
        this.indexFileBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsScript.this.indexFileBrowseButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.runAsLabel).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.interpreterLabel).add((Component)this.indexFileLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.runAsCombo, 0, 222, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.indexFileTextField, -1, 111, Short.MAX_VALUE).add((Component)this.interpreterTextField, -1, 111, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.configureButton).add(2, (Component)this.indexFileBrowseButton)))).add(0, 0, 0)));
        groupLayout.linkSize(new Component[]{this.configureButton, this.indexFileBrowseButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.runAsLabel).add((Component)this.runAsCombo, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.interpreterLabel).add((Component)this.interpreterTextField, -2, -1, -2).add((Component)this.configureButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.indexFileLabel).add((Component)this.indexFileBrowseButton).add((Component)this.indexFileTextField, -2, -1, -2))));
        this.interpreterLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterLabel.AccessibleContext.accessibleName"));
        this.interpreterLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterLabel.AccessibleContext.accessibleDescription"));
        this.interpreterTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterTextField.AccessibleContext.accessibleName"));
        this.interpreterTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterTextField.AccessibleContext.accessibleDescription"));
        this.runAsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.runAsLabel.AccessibleContext.accessibleName"));
        this.runAsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.runAsLabel.AccessibleContext.accessibleDescription"));
        this.runAsCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.runAsCombo.AccessibleContext.accessibleName"));
        this.runAsCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.runAsCombo.AccessibleContext.accessibleDescription"));
        this.configureButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.configureButton.AccessibleContext.accessibleName"));
        this.configureButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.configureButton.AccessibleContext.accessibleDescription"));
        this.indexFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileLabel.AccessibleContext.accessibleName"));
        this.indexFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileLabel.AccessibleContext.accessibleDescription"));
        this.indexFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileTextField.AccessibleContext.accessibleName"));
        this.indexFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileTextField.AccessibleContext.accessibleDescription"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileBrowseButton.AccessibleContext.accessibleName"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileBrowseButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.AccessibleContext.accessibleDescription"));
    }

    private void configureButtonActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory");
    }

    private void indexFileBrowseButtonActionPerformed(ActionEvent actionEvent) {
        Utils.browseFolderFile(this.sourcesFolderProvider.getSourcesFolder(), this.indexFileTextField);
    }

    public String getPhpInterpreter() {
        return this.interpreterTextField.getText().trim();
    }

    private class FieldUpdater
    extends RunAsPanel.InsidePanel.TextFieldUpdater {
        public FieldUpdater(String string, JLabel jLabel, JTextField jTextField) {
            super(string, jLabel, jTextField);
        }

        protected final String getDefaultValue() {
            return RunAsScript.this.getDefaultValue(this.getPropName());
        }
    }
}

