/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.ui.LastUsedFolders;
import org.netbeans.modules.php.project.ui.ProjectNameProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class ProjectFolder
extends JPanel
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 7976754658427748L;
    private static final Font BOLD_FONT = new JTextArea().getFont().deriveFont(1);
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final ProjectNameProvider projectNameProvider;
    private JButton projectFolderBrowseButton;
    private JCheckBox projectFolderCheckBox;
    private JLabel projectFolderLabel;
    private JScrollPane projectFolderScrollPane;
    private JTextArea projectFolderTextArea;
    private JTextField projectFolderTextField;

    public ProjectFolder(ProjectNameProvider projectNameProvider) {
        this.projectNameProvider = projectNameProvider;
        this.initComponents();
        this.init();
        this.projectFolderTextArea.setFont(BOLD_FONT);
        this.setWarning(false);
    }

    private void init() {
        this.projectFolderCheckBox.addActionListener(this);
        this.projectFolderTextField.getDocument().addDocumentListener(this);
    }

    void addProjectFolderListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    void removeProjectFolderListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    boolean isProjectFolderUsed() {
        return this.projectFolderCheckBox.isSelected();
    }

    void setProjectFolderUsed(boolean bl) {
        this.projectFolderCheckBox.setSelected(bl);
        this.setState(bl);
    }

    String getProjectFolder() {
        return this.projectFolderTextField.getText().trim();
    }

    void setProjectFolder(String string) {
        this.projectFolderTextField.setText(string);
    }

    void setState(boolean bl) {
        this.projectFolderLabel.setEnabled(bl);
        this.projectFolderTextField.setEnabled(bl);
        this.projectFolderBrowseButton.setEnabled(bl);
        this.setWarning(bl);
    }

    private void setWarning(boolean bl) {
        if (bl) {
            this.projectFolderScrollPane.getViewport().add(this.projectFolderTextArea);
        } else {
            this.projectFolderScrollPane.getViewport().remove(this.projectFolderTextArea);
        }
        this.projectFolderScrollPane.repaint();
    }

    private void initComponents() {
        this.projectFolderCheckBox = new JCheckBox();
        this.projectFolderLabel = new JLabel();
        this.projectFolderTextField = new JTextField();
        this.projectFolderBrowseButton = new JButton();
        this.projectFolderScrollPane = new JScrollPane();
        this.projectFolderTextArea = new JTextArea();
        this.setFocusTraversalPolicy(null);
        Mnemonics.setLocalizedText((AbstractButton)this.projectFolderCheckBox, (String)NbBundle.getMessage(ProjectFolder.class, (String)"LBL_SeparateProjectFolder"));
        this.projectFolderLabel.setLabelFor(this.projectFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectFolderLabel, (String)NbBundle.getMessage(ProjectFolder.class, (String)"LBL_MetadataFolder"));
        this.projectFolderLabel.setEnabled(false);
        this.projectFolderTextField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.projectFolderBrowseButton, (String)NbBundle.getMessage(ProjectFolder.class, (String)"LBL_BrowseProject"));
        this.projectFolderBrowseButton.setEnabled(false);
        this.projectFolderBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectFolder.this.projectFolderBrowseButtonActionPerformed(actionEvent);
            }
        });
        this.projectFolderScrollPane.setBorder(null);
        this.projectFolderTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.projectFolderTextArea.setEditable(false);
        this.projectFolderTextArea.setLineWrap(true);
        this.projectFolderTextArea.setText(NbBundle.getMessage(ProjectFolder.class, (String)"TXT_MetadataInfo"));
        this.projectFolderTextArea.setToolTipText(NbBundle.getMessage(ProjectFolder.class, (String)"TXT_MetadataInfo"));
        this.projectFolderTextArea.setWrapStyleWord(true);
        this.projectFolderTextArea.setBorder(null);
        this.projectFolderTextArea.setDisabledTextColor(UIManager.getDefaults().getColor("nb.warningForeground"));
        this.projectFolderTextArea.setEnabled(false);
        this.projectFolderScrollPane.setViewportView(this.projectFolderTextArea);
        this.projectFolderTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderTextArea.AccessibleContext.accessibleName"));
        this.projectFolderTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderTextArea.AccessibleContext.accessibleDescription"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.projectFolderScrollPane).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectFolderCheckBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.projectFolderLabel).addPreferredGap(0).add((Component)this.projectFolderTextField, -1, 249, Short.MAX_VALUE))).addPreferredGap(0).add((Component)this.projectFolderBrowseButton))).add(0, 0, 0)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.projectFolderCheckBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectFolderTextField, -2, -1, -2).add((Component)this.projectFolderLabel).add((Component)this.projectFolderBrowseButton)).addPreferredGap(0).add((Component)this.projectFolderScrollPane, -2, 85, -2)));
        this.projectFolderCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderCheckBox.AccessibleContext.accessibleName"));
        this.projectFolderCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderCheckBox.AccessibleContext.accessibleDescription"));
        this.projectFolderLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderLabel.AccessibleContext.accessibleName"));
        this.projectFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderLabel.AccessibleContext.accessibleDescription"));
        this.projectFolderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderTextField.AccessibleContext.accessibleName"));
        this.projectFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderTextField.AccessibleContext.accessibleDescription"));
        this.projectFolderBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderBrowseButton.AccessibleContext.accessibleName"));
        this.projectFolderBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderBrowseButton.AccessibleContext.accessibleDescription"));
        this.projectFolderScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderScrollPane.AccessibleContext.accessibleName"));
        this.projectFolderScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderScrollPane.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.AccessibleContext.accessibleDescription"));
    }

    private void projectFolderBrowseButtonActionPerformed(ActionEvent actionEvent) {
        File file = Utils.browseLocationAction(this, LastUsedFolders.getProject(), NbBundle.getMessage(ProjectFolder.class, (String)"LBL_SelectProjectFolder"));
        if (file != null) {
            this.setProjectFolder(new File(file, this.projectNameProvider.getProjectName()).getAbsolutePath());
            LastUsedFolders.setProject(file);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setState(this.projectFolderCheckBox.isSelected());
        this.changeSupport.fireChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.processUpdate();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.processUpdate();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.processUpdate();
    }

    private void processUpdate() {
        this.changeSupport.fireChange();
    }
}

