/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.php.project.PhpPreferences;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.ftp.FtpConnectionProvider;
import org.netbeans.modules.php.project.connections.sftp.SftpConnectionProvider;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.spi.RemoteConfigurationPanel;
import org.netbeans.modules.php.project.connections.spi.RemoteConnectionProvider;
import org.netbeans.modules.php.project.connections.ui.RemoteConnectionsPanel;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoteConnections {
    static final Logger LOGGER = Logger.getLogger(RemoteConnections.class.getName());
    private static final String PREFERENCES_PATH = "RemoteConnections";
    private static final RemoteConfiguration UNKNOWN_REMOTE_CONFIGURATION = new RemoteConfiguration.Empty("unknown-config", NbBundle.getMessage(RemoteConnections.class, (String)"LBL_UnknownRemoteConfiguration"));
    private final ConfigManager configManager;
    private final ConfigManager.ConfigProvider configProvider = new DefaultConfigProvider();
    RemoteConnectionsPanel panel = null;

    public static RemoteConnections get() {
        return new RemoteConnections();
    }

    private RemoteConnections() {
        this.configManager = new ConfigManager(this.configProvider);
    }

    private void initPanel() {
        if (this.panel != null) {
            return;
        }
        this.panel = new RemoteConnectionsPanel(this, this.configManager);
        this.panel.setConfigurations(this.getConfigurations());
    }

    private static Preferences getPreferences() {
        return PhpPreferences.getPreferences(true).node(PREFERENCES_PATH);
    }

    public boolean openManager() {
        return this.openManager(null);
    }

    public boolean openManager(RemoteConfiguration remoteConfiguration) {
        this.initPanel();
        assert (this.panel != null);
        boolean bl = this.panel.open(remoteConfiguration);
        if (bl) {
            this.saveRemoteConnections();
        }
        return bl;
    }

    List<RemoteConnectionProvider> getConnectionProviders() {
        return Arrays.asList(FtpConnectionProvider.get(), SftpConnectionProvider.get());
    }

    public List<String> getRemoteConnectionTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (RemoteConnectionProvider remoteConnectionProvider : this.getConnectionProviders()) {
            arrayList.add(remoteConnectionProvider.getDisplayName());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public RemoteConfiguration getRemoteConfiguration(ConfigManager.Configuration configuration) {
        for (RemoteConnectionProvider remoteConnectionProvider : this.getConnectionProviders()) {
            RemoteConfiguration remoteConfiguration = remoteConnectionProvider.getRemoteConfiguration(configuration);
            if (remoteConfiguration == null) continue;
            return remoteConfiguration;
        }
        return null;
    }

    public RemoteConfigurationPanel getConfigurationPanel(ConfigManager.Configuration configuration) {
        for (RemoteConnectionProvider remoteConnectionProvider : this.getConnectionProviders()) {
            RemoteConfigurationPanel remoteConfigurationPanel = remoteConnectionProvider.getRemoteConfigurationPanel(configuration);
            if (remoteConfigurationPanel == null) continue;
            return remoteConfigurationPanel;
        }
        return null;
    }

    public String getConfigurationType(ConfigManager.Configuration configuration) {
        for (RemoteConnectionProvider remoteConnectionProvider : this.getConnectionProviders()) {
            RemoteConfigurationPanel remoteConfigurationPanel = remoteConnectionProvider.getRemoteConfigurationPanel(configuration);
            if (remoteConfigurationPanel == null) continue;
            return remoteConnectionProvider.getDisplayName();
        }
        return null;
    }

    public List<RemoteConfiguration> getRemoteConfigurations() {
        List<ConfigManager.Configuration> list = this.getConfigurations();
        ArrayList<RemoteConfiguration> arrayList = new ArrayList<RemoteConfiguration>(list.size());
        for (ConfigManager.Configuration configuration : list) {
            RemoteConfiguration remoteConfiguration = this.getRemoteConfiguration(configuration);
            if (remoteConfiguration == null) {
                remoteConfiguration = UNKNOWN_REMOTE_CONFIGURATION;
            }
            arrayList.add(remoteConfiguration);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public RemoteConfiguration remoteConfigurationForName(String string) {
        assert (string != null);
        for (RemoteConfiguration remoteConfiguration : this.getRemoteConfigurations()) {
            if (!remoteConfiguration.getName().equals(string)) continue;
            return remoteConfiguration;
        }
        return null;
    }

    public RemoteConfiguration createRemoteConfiguration(String string, ConfigManager.Configuration configuration) {
        assert (string != null);
        for (RemoteConnectionProvider remoteConnectionProvider : this.getConnectionProviders()) {
            if (!string.equals(remoteConnectionProvider.getDisplayName())) continue;
            RemoteConfiguration remoteConfiguration = remoteConnectionProvider.createRemoteConfiguration(configuration);
            assert (remoteConfiguration != null) : "Remote configuration must be provided for " + string;
            return remoteConfiguration;
        }
        return null;
    }

    private List<ConfigManager.Configuration> getConfigurations() {
        Collection<String> collection = this.configManager.configurationNames();
        ArrayList<ConfigManager.Configuration> arrayList = new ArrayList<ConfigManager.Configuration>(collection.size() - 1);
        for (String string : collection) {
            ConfigManager.Configuration configuration;
            if (string == null || (configuration = this.configManager.configurationFor(string)) == null) continue;
            arrayList.add(configuration);
        }
        Collections.sort(arrayList, ConfigManager.getConfigurationComparator());
        return arrayList;
    }

    private void saveRemoteConnections() {
        Preferences preferences = RemoteConnections.getPreferences();
        for (Map.Entry<String, Map<String, String>> entry : this.configProvider.getConfigs().entrySet()) {
            String string = entry.getKey();
            if (string == null) continue;
            Map<String, String> map = entry.getValue();
            if (map == null) {
                try {
                    preferences.node(string).removeNode();
                }
                catch (BackingStoreException backingStoreException) {
                    LOGGER.log(Level.INFO, "Error while removing unused remote connection: " + string, backingStoreException);
                }
                continue;
            }
            Preferences preferences2 = preferences.node(string);
            for (Map.Entry<String, String> entry2 : map.entrySet()) {
                preferences2.put(entry2.getKey(), entry2.getValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultConfigProvider
    implements ConfigManager.ConfigProvider {
        final Map<String, Map<String, String>> configs = ConfigManager.createEmptyConfigs();

        public DefaultConfigProvider() {
            this.readConfigs();
        }

        @Override
        public String[] getConfigProperties() {
            HashSet<String> hashSet = new HashSet<String>();
            for (RemoteConnectionProvider remoteConnectionProvider : RemoteConnections.this.getConnectionProviders()) {
                hashSet.addAll(remoteConnectionProvider.getPropertyNames());
            }
            return hashSet.toArray(new String[hashSet.size()]);
        }

        @Override
        public Map<String, Map<String, String>> getConfigs() {
            return this.configs;
        }

        @Override
        public String getActiveConfig() {
            return null;
        }

        @Override
        public void setActiveConfig(String string) {
        }

        private void readConfigs() {
            Preferences preferences = RemoteConnections.getPreferences();
            try {
                for (String string : preferences.childrenNames()) {
                    Preferences preferences2 = preferences.node(string);
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    for (String string2 : preferences2.keys()) {
                        treeMap.put(string2, preferences2.get(string2, null));
                    }
                    this.configs.put(string, treeMap);
                }
            }
            catch (BackingStoreException backingStoreException) {
                LOGGER.log(Level.INFO, "Error while reading existing remote connections", backingStoreException);
            }
        }
    }
}

